/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.WSProfileJob;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSProfileCLIDeleteProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("delete", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIDeleteProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIDeleteProfileInvoker.class.getName();

    public WSProfileCLIDeleteProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIDeleteProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIDeleteProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIDeleteProfileInvoker.failureMessage";
    }

    @Override
    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.exiting(this.getClass().getName(), "getModeFlag");
        return "delete";
    }

    @Override
    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    @Override
    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    @Override
    public boolean isPublicMode() {
        return this.fIsPublic;
    }

    @Override
    public String getRegistryName() {
        return "deleteRegistry.xml";
    }

    @Override
    public Map<String, List> generateJobArgs(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack, int nJobNumber) {
        LOGGER.entering(this.getClass().getName(), "generateJobArgs");
        Map<String, List> mBrokenDownArgs = WSProfileUtils.cloneMap(mJobGroupArgs);
        if (nJobNumber > 0) {
            mBrokenDownArgs.remove("delete");
            mBrokenDownArgs.put("unaugment", new Vector());
        }
        LOGGER.exiting(this.getClass().getName(), "generateJobArgs");
        return super.generateJobArgs(mBrokenDownArgs, lwsptTemplateStack, nJobNumber);
    }

    @Override
    public List<WSProfileJob> generateJobsForMode(Map<String, List> mJobGroupArgs, List<WSProfileTemplate> lwsptTemplateStack) {
        LOGGER.entering(this.getClass().getName(), "generateJobsForMode");
        Vector<WSProfileJob> lwspjFromGroup = new Vector<WSProfileJob>();
        for (int i = lwsptTemplateStack.size() - 1; i >= 0; --i) {
            lwspjFromGroup.add(new WSProfileJob(this.generateJobArgs(mJobGroupArgs, lwsptTemplateStack, i)));
        }
        LOGGER.exiting(this.getClass().getName(), "generateJobsForMode");
        return lwspjFromGroup;
    }

    @Override
    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        int nReturnCode = 1;
        try {
            nReturnCode = WSProfile.delete(sProfileName, CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    @Override
    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sProfileName = this.getArgumentValue("profileName");
        if (sProfileName != null) {
            try {
                String sTemplatePath = WSProfile.getProfile(sProfileName, this.getProfileRegistryPath()).getWSProfileTemplate().getProfileTemplatePath().getAbsolutePath();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sTemplatePath, "deleteRegistry.xml").getAbsolutePath());
                List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sTemplatePath));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
            }
            catch (WSProfileException e) {
                LogUtils.logException(LOGGER, e);
            }
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    @Override
    protected Vector getListOfOptionalCommandLineArguments() {
        return new Vector();
    }
}

