/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.cli;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.profile.cli.CommandLineArgument;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.utils.DisabledActionsUtil;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import com.ibm.wsspi.profile.registry.Profile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLIAugmentProfileInvoker
extends WSProfileCLIModeInvoker {
    private boolean fIsPublic = true;
    private static final CommandLineArgument[] ACLA_RESERVED_REQUIRED_ARGUMENTS = new CommandLineArgument[]{new CommandLineArgument("augment", V_EMPTY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("profileName", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle"), new CommandLineArgument("templatePath", V_SINGLE_ENTRY_VECTOR, true, "com.ibm.ws.profile.resourcebundle.WSProfileResourceBundle")};
    private static final CommandLineArgument[] ACLA_RESERVED_OPTIONAL_ARGUMENTS = new CommandLineArgument[0];
    private static final String S_INVALID_PROFILE_AUGMENTATION_TEMPLATE = "WSProfile.WSProfileCLIAugmentProfileInvoker.invalidProfileCreationTemplate";
    private static final Logger LOGGER = LoggerFactory.createLogger(WSProfileCLIAugmentProfileInvoker.class);
    private static final String S_CLASS_NAME = WSProfileCLIAugmentProfileInvoker.class.getName();

    public WSProfileCLIAugmentProfileInvoker() {
        this.S_SUCCESS_KEY = "WSProfile.WSProfileCLIAugmentProfileInvoker.successMessage";
        this.S_PARTIAL_SUCCESS_KEY = "WSProfile.WSProfileCLIAugmentProfileInvoker.partialSuccessMessage";
        this.S_FAILURE_KEY = "WSProfile.WSProfileCLIAugmentProfileInvoker.failureMessage";
    }

    public String getModeFlag() {
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        LOGGER.entering(this.getClass().getName(), "getModeFlag");
        return "augment";
    }

    public boolean isTemplateStackRequired() {
        LOGGER.entering(this.getClass().getName(), "isTemplateStackRequired");
        LOGGER.exiting(this.getClass().getName(), "isTemplateStackRequired");
        return true;
    }

    public boolean isValidationAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isValidationAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isValidationAllowed");
        return true;
    }

    public boolean isDefaultingAllowed() {
        LOGGER.entering(S_CLASS_NAME, "isDefaultingAllowed");
        LOGGER.exiting(S_CLASS_NAME, "isDefaultingAllowed");
        return true;
    }

    public String getRegistryName() {
        return "actionRegistry.xml";
    }

    protected int executeWSProfileAccordingToMode() {
        LOGGER.entering(this.getClass().getName(), "invokeWSProfile");
        String sProfileName = this.getArgumentValue("profileName");
        String sTemplatePath = this.getArgumentValue("templatePath");
        int nReturnCode = 1;
        try {
            nReturnCode = WSProfile.augment(sProfileName, new File(sTemplatePath).getAbsoluteFile(), CommandLineArgument.convertCommandLineArgumentListToMap(this.getIncomingCommandLineArguments()), this.getProfileRegistryPath());
        }
        catch (WSProfileException e) {
            LogUtils.logException(LOGGER, e);
            nReturnCode = 1;
        }
        if (nReturnCode == 1) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_FAILURE_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 2) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_PARTIAL_SUCCESS_KEY, LoggerFactoryConstants.getGlobalLogFilePath()));
        }
        if (nReturnCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeWSProfileAccordingToMode", ResourceBundleUtils.getLocaleString(this.S_SUCCESS_KEY));
        }
        LOGGER.exiting(this.getClass().getName(), "invokeWSProfile");
        return nReturnCode;
    }

    protected Vector getListOfRequiredCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_REQUIRED_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        String sIncomingProfileName = this.getArgumentValue("profileName");
        if (sIncomingProfileTemplatePath != null && sIncomingProfileName != null) {
            Vector<WSProfileTemplate> v_wsptProfileTemplates = new Vector<WSProfileTemplate>();
            v_wsptProfileTemplates.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackAugment(sIncomingProfileTemplatePath, sIncomingProfileName));
            DisabledActionsUtil dau = new DisabledActionsUtil();
            v_wsptProfileTemplates = dau.decorateProfileTemplatesWithDisabledActions(v_wsptProfileTemplates);
            for (int i = 0; i < v_wsptProfileTemplates.size(); ++i) {
                File fileThisTemplate = v_wsptProfileTemplates.get(i).getProfileTemplatePath();
                Vector<String> v_disabledActions = v_wsptProfileTemplates.get(i).getDisabledActions();
                Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(fileThisTemplate.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                String disabledActions = dau.buildDisabledActionsProperty(v_disabledActions);
                if (disabledActions != null) {
                    System.setProperty("WS_CMT_DISABLED_ACTIONS", disabledActions);
                }
                List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(fileThisTemplate.getAbsolutePath()));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
                this.resetJavaSystemProperties(propertiesCurrentSystem);
            }
        } else if (sIncomingProfileTemplatePath != null) {
            System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sIncomingProfileTemplatePath, "actionRegistry.xml").getAbsolutePath());
            List listclaRequired = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getRequiredArgumentsList(sIncomingProfileTemplatePath));
            vclaRet = this.mergeCommandLineArgs(vclaRet, listclaRequired);
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfRequiredCommandLineArguments");
        return vclaRet;
    }

    protected Vector getListOfOptionalCommandLineArguments() {
        LOGGER.entering(this.getClass().getName(), "getListOfOptionalCommandLineArguments");
        Vector vclaRet = new Vector(Arrays.asList(ACLA_RESERVED_OPTIONAL_ARGUMENTS));
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        String sIncomingProfileName = this.getArgumentValue("profileName");
        if (sIncomingProfileTemplatePath != null && sIncomingProfileName != null) {
            Vector<WSProfileTemplate> v_wsptProfileTemplates = new Vector<WSProfileTemplate>();
            v_wsptProfileTemplates.addAll(PrereqTemplateUtils.getListOfTemplatePathsForStackAugment(sIncomingProfileTemplatePath, sIncomingProfileName));
            for (int i = 0; i < v_wsptProfileTemplates.size(); ++i) {
                File fileThisTemplate = ((WSProfileTemplate)v_wsptProfileTemplates.get(i)).getProfileTemplatePath();
                Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
                System.setProperty("WS_CMT_ACTION_REGISTRY", new File(fileThisTemplate.getAbsoluteFile(), "actionRegistry.xml").getAbsolutePath());
                List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(fileThisTemplate.getAbsolutePath()));
                vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
                this.resetJavaSystemProperties(propertiesCurrentSystem);
            }
        } else if (sIncomingProfileTemplatePath != null) {
            Properties propertiesCurrentSystem = this.setJavaSystemPropertiesForConfigManagerArgumentRetrieval();
            System.setProperty("WS_CMT_ACTION_REGISTRY", new File(sIncomingProfileTemplatePath, "actionRegistry.xml").getAbsolutePath());
            List listclaOptional = CommandLineArgument.convertActionArgumentListToCommandLineArgumentList(ConfigManager.getOptionalArgumentsList(sIncomingProfileTemplatePath));
            vclaRet = this.mergeCommandLineArgs(vclaRet, listclaOptional);
            this.resetJavaSystemProperties(propertiesCurrentSystem);
        }
        LOGGER.exiting(this.getClass().getName(), "getListOfOptionalCommandLineArgumetns");
        return vclaRet;
    }

    protected void doHelp() {
        LOGGER.entering(WSProfileCLIAugmentProfileInvoker.class.getName(), "doHelp");
        String sIncomingProfileTemplatePath = this.getArgumentValue("templatePath");
        String sIncomingProfileName = this.getArgumentValue("profileName");
        if (sIncomingProfileTemplatePath != null && sIncomingProfileName != null) {
            try {
                WSProfileTemplate wsptThis = new WSProfileTemplate(sIncomingProfileTemplatePath);
                Profile profileThis = WSProfile.getProfile(sIncomingProfileName);
                Vector v_wsptPrereqs = (Vector)PrereqTemplateUtils.getTemplatesForStackAugmentation(wsptThis, profileThis);
                PrereqTemplateUtils.validateListForAugmentation(v_wsptPrereqs, profileThis);
                super.doHelp();
            }
            catch (WSProfileException e) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "doHelp", "Could not build a list of prerequisite profile templates for profile template " + sIncomingProfileTemplatePath);
                OutputStreamHandler.println(ResourceBundleUtils.getLocaleString(S_INVALID_PROFILE_AUGMENTATION_TEMPLATE, sIncomingProfileTemplatePath));
            }
        } else {
            super.doHelp();
        }
        LOGGER.exiting(WSProfileCLIAugmentProfileInvoker.class.getName(), "doHelp");
    }

    public boolean isPublicMode() {
        return this.fIsPublic;
    }
}

