/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.bootstrap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WSProfileProperties {
    private Properties m_properties = null;
    private static final String S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH = "properties/wasprofile.properties";
    private static final Pattern PATTERN_MACRO_VARIABLE = Pattern.compile("^(.*)\\$\\{(.*?)\\}(.*)$");
    private static final String S_CHARS_TO_ESCAPE = "\\[]{}().*+^$&?|!<>";
    private static final String S_BACK_SLASH = "\\";
    private static final int N_MACRO_VARIABLE_EXTRA_GROUP_1_ID = 1;
    private static final int N_MACRO_VARIABLE_GROUP_ID = 2;
    private static final int N_MACRO_VARIABLE_EXTRA_GROUP_2_ID = 3;
    private static final String S_WASPROFILE_PROPERTIES_FILE_NOT_FOUND = "File wasprofile.properties could not be located.";

    public WSProfileProperties() throws FileNotFoundException, IOException {
        this.parsePropertiesFile();
    }

    public String getProperty(String sPropertyName) {
        String sPropertyValueUnparsed;
        if (this.m_properties == null) {
            return null;
        }
        String sPropertyValueParsed = sPropertyValueUnparsed = this.m_properties.getProperty(sPropertyName);
        Matcher matcher = PATTERN_MACRO_VARIABLE.matcher(sPropertyValueParsed);
        while (matcher.matches()) {
            String sPropertyValue = System.getProperty(matcher.group(2));
            String sPropertyValueRESafe = this.escapeSpecialRECharacters(sPropertyValue);
            sPropertyValueParsed = matcher.group(1) + matcher.replaceFirst(sPropertyValueRESafe) + matcher.group(3);
            matcher = PATTERN_MACRO_VARIABLE.matcher(sPropertyValueParsed);
        }
        return sPropertyValueParsed;
    }

    private void parsePropertiesFile() throws FileNotFoundException, IOException {
        File fileProperties = this.getPropertiesFile();
        this.m_properties = new Properties();
        this.m_properties.load(new FileInputStream(fileProperties));
    }

    private File getPropertiesFile() throws FileNotFoundException {
        File fileRet = this.getPropertiesFile("WAS_HOME");
        if (fileRet != null) {
            return fileRet;
        }
        fileRet = this.getPropertiesFile("was.install.root");
        if (fileRet == null) {
            throw new FileNotFoundException(S_WASPROFILE_PROPERTIES_FILE_NOT_FOUND);
        }
        return fileRet;
    }

    private File getPropertiesFile(String sVariableName) {
        String sDirRoot = System.getProperty(sVariableName);
        if (sDirRoot == null) {
            return null;
        }
        if (!new File(sDirRoot, S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH).exists()) {
            return null;
        }
        return new File(sDirRoot, S_WSPROFILE_PROPERTIES_FILE_RELATIVE_PATH);
    }

    private String escapeSpecialRECharacters(String sIn) {
        String sRet = "";
        for (int i = 0; i < sIn.length(); ++i) {
            char cThis = sIn.charAt(i);
            sRet = S_CHARS_TO_ESCAPE.indexOf(cThis) != -1 ? sRet + S_BACK_SLASH + cThis : sRet + cThis;
        }
        return sRet;
    }
}

