/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.profile.utils.PortResolutionUtils;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PortResolverRecommendedValues
extends Task {
    private String m_sTemplatePath;
    private String m_sPortKeyValuePairs;
    private String m_sErrorMessage;
    private File m_WAS_HOME;
    private File m_fileReservedPortsFile = null;
    private String m_sBasePortsFile = null;
    private static final String S_EMPTY = "";
    private static final String S_EQUAL = "=";
    private static final String S_MISSING_PORT_KEYS_PARAMETER = "The Port Key Value Pairs parameter is missing.";
    private static final String S_TEMPLATE_PATH_MISSING_PARAMETER = "The template path parameter is missing";
    private static final String S_TEMPLATE_PATH_DOES_NOT_EXIST = "The specified template path does not exist or is not a template directory.";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortResolverRecommendedValues.class);
    private static final String S_CLASS_NAME = PortResolverRecommendedValues.class.getName();

    public void init() throws BuildException {
        super.init();
    }

    public void execute() throws BuildException {
        super.execute();
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "execute");
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        try {
            Hashtable hPortMappings = new Hashtable();
            int[] reservedPorts = this.determineReservedPorts();
            String sBasePortFile = this.determineBasePortFile();
            hPortMappings = PortResolutionUtils.determineRecommendedPorts(this.m_sTemplatePath, new String[]{sBasePortFile}, reservedPorts);
            Properties propBasePortMappings = (Properties)hPortMappings.get(sBasePortFile);
            if (propBasePortMappings != null) {
                this.setEnvironmentWithPortMappings(propBasePortMappings);
            } else {
                this.setEnvironmentWithPortMappings(new Properties());
            }
        }
        catch (WSProfileException wspe) {
            LogUtils.logException(LOGGER, wspe);
            throw new BuildException(wspe);
        }
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "execute");
    }

    public void setWAS_HOME(File WAS_HOME) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setWAS_HOME");
        this.m_WAS_HOME = WAS_HOME;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setWAS_HOME");
    }

    public void setTemplatePath(String sTemplatePath) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setTemplatePath");
        this.m_sTemplatePath = sTemplatePath;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setTemplatePath");
    }

    public void setPortKeyValuePairs(String sPortKeyValuePairs) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setPortKeyValuePairs");
        this.m_sPortKeyValuePairs = sPortKeyValuePairs;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setPortKeyValuePairs");
    }

    public void setReservedPortsFile(File reservedPortsFile) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setReservedPortsFile", "The reserved ports file is: " + reservedPortsFile.toString());
        this.m_fileReservedPortsFile = reservedPortsFile;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setReservedPortsFile");
    }

    public void setBasePortsFile(String basePortsFile) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setBasePortsFile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setBasePortsFile", "The name of the base ports file is: " + basePortsFile);
        this.m_sBasePortsFile = basePortsFile;
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setBasePortsFile");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sPortKeyValuePairs == null || this.m_sPortKeyValuePairs.equals(S_EMPTY)) {
            this.m_sErrorMessage = S_MISSING_PORT_KEYS_PARAMETER;
            return false;
        }
        if (this.m_sTemplatePath == null || this.m_sTemplatePath.trim().equals(S_EMPTY)) {
            this.m_sErrorMessage = S_TEMPLATE_PATH_MISSING_PARAMETER;
            return false;
        }
        File fileTemplateDir = new File(this.m_sTemplatePath);
        if (!fileTemplateDir.exists() || !fileTemplateDir.isDirectory()) {
            this.m_sErrorMessage = S_TEMPLATE_PATH_DOES_NOT_EXIST;
            return false;
        }
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }

    private void setEnvironmentWithPortMappings(Hashtable hPortMappings) {
        LOGGER.entering(PortResolverRecommendedValues.class.getName(), "setEnvironmentWithPortMappings");
        StringBuffer keyValuePairs = new StringBuffer();
        Enumeration enumPortKeys = hPortMappings.keys();
        while (enumPortKeys.hasMoreElements()) {
            String sPortKey = enumPortKeys.nextElement().toString();
            String sPortValue = hPortMappings.get(sPortKey).toString();
            keyValuePairs.append(sPortKey + S_EQUAL + sPortValue + "\n");
        }
        this.getProject().setNewProperty(this.m_sPortKeyValuePairs, keyValuePairs.toString());
        System.setProperty(this.m_sPortKeyValuePairs, keyValuePairs.toString());
        LOGGER.exiting(PortResolverRecommendedValues.class.getName(), "setEnvironmentWithPortMappings");
    }

    private int[] determineReservedPorts() throws WSProfileException {
        if (this.m_fileReservedPortsFile == null || !this.m_fileReservedPortsFile.exists()) {
            return new int[0];
        }
        Properties propsReservedPorts = new Properties();
        try {
            propsReservedPorts.load(new FileInputStream(this.m_fileReservedPortsFile));
        }
        catch (FileNotFoundException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            throw new WSProfileException(e.getMessage(), e.getLocalizedMessage());
        }
        String[] ports = propsReservedPorts.values().toArray(new String[0]);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineReservedPorts", "Reserved Ports: " + ArrayUtils.join(",", ports));
        int[] iaReservedPorts = new int[ports.length];
        for (int i = 0; i < ports.length; ++i) {
            iaReservedPorts[i] = Integer.parseInt(ports[i]);
        }
        return iaReservedPorts;
    }

    private String determineBasePortFile() {
        if (this.m_sBasePortsFile != null && !this.m_sBasePortsFile.equals(S_EMPTY)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineBasePortFile", "Determined Base Ports file to be: " + this.m_sBasePortsFile);
            return this.m_sBasePortsFile;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineBasePortFile", "Determined Base Ports file to be: portdef.props");
        return "portdef.props";
    }
}

