/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.anttasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ChangeFileEncoding
extends Task {
    private boolean verbose = false;
    private String pathname = null;
    private String currentEncoding = null;
    private String newEncoding = null;
    private File file = null;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.println("Setting verbose to TRUE");
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.println("Setting pathname to " + pathname);
    }

    public void setCurrentEncoding(String currentEncoding) {
        this.currentEncoding = currentEncoding;
        this.println("Setting current encoding to " + currentEncoding);
    }

    public void setNewEncoding(String newEncoding) {
        this.newEncoding = newEncoding;
        this.println("Setting new encoding to " + newEncoding);
    }

    public void execute() throws BuildException {
        this.println("Converting encoding for file " + this.pathname + " from " + this.currentEncoding + " to " + this.newEncoding);
        this.println("JVM file encoding: " + System.getProperty("file.encoding"));
        try {
            this.validatePathname();
            this.convertEncoding();
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            throw new BuildException(t);
        }
        this.println("exiting execute");
    }

    private void validatePathname() throws Exception {
        this.println("Validating pathname: " + this.pathname);
        if (this.pathname == null) {
            throw new Exception("ERROR - pathname not specified");
        }
        this.file = new File(this.pathname);
        if (!this.file.exists() || !this.file.isFile()) {
            throw new Exception("ERROR - File " + this.file + " is not a valid file.");
        }
        this.println("Done validating pathname");
    }

    private void convertEncoding() throws Exception {
        Vector<String> fileLines = new Vector<String>();
        this.println("Begin reading file: " + this.file);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.file), this.currentEncoding);
        BufferedReader in = new BufferedReader(isr);
        String line = null;
        while ((line = in.readLine()) != null) {
            this.println("read line: " + line);
            fileLines.add(line);
        }
        this.println("Done reading file.");
        in.close();
        this.println("Begin deleting file");
        this.file.delete();
        this.println("Done deleting file");
        this.println("Begin writing file. ");
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.newEncoding);
        BufferedWriter out = new BufferedWriter(osr);
        for (int i = 0; i < fileLines.size(); ++i) {
            line = ((String)fileLines.elementAt(i)).toString();
            this.println("writing line: " + line);
            out.write(line + "\n");
        }
        out.close();
        this.println("Done writing file.");
    }

    private void println(String s) {
        if (this.verbose) {
            System.out.println("-> " + s);
        }
    }
}

