/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.profile.bootstrap.LogInitializer;
import com.ibm.ws.profile.utils.DefaultValueManagerUtils;
import com.ibm.ws.profile.utils.ValidationManagerUtils;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfileCLI;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSConfigCreator {
    private static Map<String, String> m_commandLineData = null;
    private static String m_mode = "";
    private static Logger LOGGER = null;
    private static String S_CLASS_NAME = WSConfigCreator.class.getName();
    private static List<String> wsProfileCommandDataDmgr = null;
    private static List<String> wsProfileCommandDataNode = null;
    private static int argCounter = 0;
    private static int returnCodeDmgr = -1;
    private static int returnCodeNode = -1;
    private static int returnCode = -1;
    private static final String S_DASH = "-";
    private static final String S_SPACE = " ";
    private static final String S_EMPTY = "";
    public static final String S_SERVICE_CHECK_ARG = "winserviceCheck";
    public static final String S_SERVICE_TYPE_ARG = "winserviceAccountType";
    public static final String S_SERVICE_STARTUP_TYPE_ARG = "winserviceStartupType";
    public static final String S_SERVICE_USER_NAME_ARG = "winserviceUserName";
    public static final String S_SERVICE_PASSWORD_ARG = "winservicePassword";
    private static Properties m_propertiesInitSysProps;

    public static void main(String[] args) {
        WSConfigCreator.initLogger(args);
        LOGGER.entering(S_CLASS_NAME, "main");
        if (!WSConfigCreator.isCellTemplate(args)) {
            WSConfigCreator.installServiceCheck();
            String[] newArgs = WSConfigCreator.recreateArgs();
            WSProfileCLI.main(newArgs);
            LOGGER.exiting(S_CLASS_NAME, "main");
            return;
        }
        WSConfigCreator.installServiceCheck();
        WSConfigCreator.buildCommandData();
        WSConfigCreator.runWSProfile();
        LOGGER.exiting(S_CLASS_NAME, "main");
        System.exit(returnCode);
    }

    public static int mainForInProcessCalls(String[] args) {
        m_propertiesInitSysProps = (Properties)System.getProperties().clone();
        LoggerContext lcSwitcher = new LoggerContext();
        lcSwitcher.saveAndSwitchCurrentContext();
        WSConfigCreator.initLogger(args);
        LOGGER.entering(S_CLASS_NAME, "mainForInProcessCalls");
        if (WSConfigCreator.isCellTemplate(args)) {
            WSConfigCreator.installServiceCheck();
            WSConfigCreator.buildCommandData();
            WSConfigCreator.runWSProfile();
        } else {
            WSConfigCreator.installServiceCheck();
            String[] newArgs = WSConfigCreator.recreateArgs();
            returnCode = WSProfileCLI.mainForInProcessCalls(newArgs);
        }
        lcSwitcher.restoreSavedContext();
        if (m_propertiesInitSysProps != null) {
            System.setProperties(m_propertiesInitSysProps);
        }
        LOGGER.exiting(S_CLASS_NAME, "mainForInProcessCalls");
        return returnCode;
    }

    private static void installServiceCheck() {
        LOGGER.entering(WSConfigCreator.class.getName(), "installServiceCheck");
        if (!PlatformConstants.isCurrentPlatformWindows()) {
            return;
        }
        if (WSConfigCreator.hasServiceCheck() && !WSConfigCreator.canRunService()) {
            WSConfigCreator.removeServiceCheckArg();
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "installServiceCheck");
    }

    private static boolean hasServiceCheck() {
        LOGGER.entering(WSConfigCreator.class.getName(), "hasServiceCheck");
        if (m_commandLineData.containsKey(S_SERVICE_CHECK_ARG)) {
            LOGGER.exiting(WSConfigCreator.class.getName(), "hasServiceCheck");
            return true;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "hasServiceCheck");
        return false;
    }

    private static boolean canRunService() {
        boolean serviceCreationAcceptable = false;
        String serviceCheckValue = m_commandLineData.get(S_SERVICE_CHECK_ARG);
        String serviceUserNameValue = null;
        if (Boolean.valueOf(serviceCheckValue).booleanValue()) {
            String dv;
            String[] serviceCheckArgs = new String[]{"-winserviceCheck", serviceCheckValue};
            Hashtable<String, String> serviceCheckHash = new Hashtable<String, String>();
            serviceCheckHash.put(S_SERVICE_CHECK_ARG, serviceCheckValue);
            if (!m_commandLineData.containsKey(S_SERVICE_TYPE_ARG)) {
                dv = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_TYPE_ARG, serviceCheckArgs);
                if (dv != null) {
                    serviceCheckHash.put(S_SERVICE_TYPE_ARG, dv);
                    m_commandLineData.put(S_SERVICE_TYPE_ARG, dv);
                }
            } else {
                serviceCheckHash.put(S_SERVICE_TYPE_ARG, m_commandLineData.get(S_SERVICE_TYPE_ARG));
            }
            if (!m_commandLineData.containsKey(S_SERVICE_STARTUP_TYPE_ARG)) {
                dv = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_STARTUP_TYPE_ARG, serviceCheckArgs);
                if (dv != null) {
                    serviceCheckHash.put(S_SERVICE_STARTUP_TYPE_ARG, dv);
                    m_commandLineData.put(S_SERVICE_STARTUP_TYPE_ARG, dv);
                }
            } else {
                serviceCheckHash.put(S_SERVICE_STARTUP_TYPE_ARG, m_commandLineData.get(S_SERVICE_STARTUP_TYPE_ARG));
            }
            if (!m_commandLineData.containsKey(S_SERVICE_USER_NAME_ARG) && (dv = DefaultValueManagerUtils.getDefaultValue(S_SERVICE_USER_NAME_ARG, serviceCheckArgs)) != null) {
                m_commandLineData.put(S_SERVICE_USER_NAME_ARG, dv);
            }
            if (m_commandLineData.containsKey(S_SERVICE_PASSWORD_ARG)) {
                serviceCheckHash.put(S_SERVICE_PASSWORD_ARG, m_commandLineData.get(S_SERVICE_PASSWORD_ARG));
            }
            if ((serviceUserNameValue = m_commandLineData.get(S_SERVICE_USER_NAME_ARG)) == null) {
                serviceUserNameValue = S_EMPTY;
            }
            ValidationManagerUtils.reinitialize();
            serviceCreationAcceptable = ValidationManagerUtils.isArgumentValueValid(S_SERVICE_USER_NAME_ARG, serviceUserNameValue, serviceCheckHash);
            if (!serviceCreationAcceptable) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "canRunService", "User does not have permission to create service.  Removing service check parameters");
                m_commandLineData.remove(S_SERVICE_CHECK_ARG);
                m_commandLineData.remove(S_SERVICE_TYPE_ARG);
                m_commandLineData.remove(S_SERVICE_STARTUP_TYPE_ARG);
                m_commandLineData.remove(S_SERVICE_USER_NAME_ARG);
                m_commandLineData.remove(S_SERVICE_PASSWORD_ARG);
            }
        }
        return serviceCreationAcceptable;
    }

    private static void removeServiceCheckArg() {
        LOGGER.entering(WSConfigCreator.class.getName(), "removeRunServiceArgs");
        m_commandLineData.remove(S_SERVICE_CHECK_ARG);
        LOGGER.exiting(WSConfigCreator.class.getName(), "removeRunServiceArgs");
    }

    private static String[] recreateArgs() {
        Vector<String> commandData = new Vector<String>();
        for (String key : m_commandLineData.keySet()) {
            commandData.add(S_DASH + key);
            if (m_commandLineData.get(key).equals(S_EMPTY)) continue;
            commandData.add(m_commandLineData.get(key));
        }
        int size = commandData.size();
        String[] WSProfileCommandData = new String[size];
        for (int i = 0; i < size; ++i) {
            WSProfileCommandData[i] = (String)commandData.get(i);
        }
        return WSProfileCommandData;
    }

    private static boolean isCellTemplate(String[] args) {
        LOGGER.entering(WSConfigCreator.class.getName(), "isCellTemplate");
        m_commandLineData = WSConfigCreator.convertIncomingCommandLineToCommandLineArguments(args);
        if (!m_commandLineData.containsKey("templatePath")) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "No template type detected, passing through.");
            LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
            return false;
        }
        String templatePath = m_commandLineData.get("templatePath");
        WSProfileTemplate wspt = null;
        try {
            wspt = new WSProfileTemplate(templatePath);
        }
        catch (WSProfileException wspe) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Could not determine template path");
            LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
            return false;
        }
        m_mode = WSConfigCreator.getMode(m_commandLineData);
        if (wspt.getType().equalsIgnoreCase("cell")) {
            WSConfigCreator.setupEnvironment(templatePath + File.separator + "dmgr");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Cell template type detected");
            LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
            return true;
        }
        WSConfigCreator.setupEnvironment(templatePath);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "isCellTemplate", "Cell template type not detected, passing through.");
        LOGGER.exiting(WSConfigCreator.class.getName(), "isCellTemplate");
        return false;
    }

    private static String getMode(Map args) {
        if (args.containsKey("create")) {
            return "create";
        }
        if (args.containsKey("augment")) {
            return "augment";
        }
        return S_EMPTY;
    }

    private static void setupEnvironment(String templatePath) {
        System.setProperty("templatePath", templatePath);
        System.setProperty("WS_CMT_CONF_DIR", templatePath);
        System.setProperty("WS_CMT_ACTION_REGISTRY", templatePath + File.separator + "actionRegistry.xml");
        if (m_mode != null && !m_mode.equals(S_EMPTY)) {
            System.setProperty(m_mode, S_EMPTY);
        }
    }

    private static void buildCommandData() {
        String dv;
        LOGGER.entering(WSConfigCreator.class.getName(), "buildCommandData");
        wsProfileCommandDataDmgr = new Vector<String>();
        wsProfileCommandDataNode = new Vector<String>();
        String dmgrPropertiesLocation = null;
        String nodeProfilePath = null;
        String dmgrProfilePath = null;
        DefaultValueManagerUtils.reinitialize();
        String[] asArgs = new String[]{"-hostName", DefaultValueManagerUtils.getDefaultValue("hostName")};
        if (!m_commandLineData.containsKey("nodeName")) {
            dv = DefaultValueManagerUtils.getDefaultValue("nodeName", asArgs);
            m_commandLineData.put("nodeName", dv);
        }
        if (!m_commandLineData.containsKey("appServerNodeName")) {
            dv = DefaultValueManagerUtils.getDefaultValue("appServerNodeName", asArgs);
            m_commandLineData.put("appServerNodeName", dv);
        }
        if (!m_commandLineData.containsKey("cellName")) {
            dv = DefaultValueManagerUtils.getDefaultValue("cellName", asArgs);
            m_commandLineData.put("cellName", dv);
        }
        if (!m_commandLineData.containsKey("dmgrProfileName")) {
            dv = DefaultValueManagerUtils.getDefaultValue("profileName");
            m_commandLineData.put("dmgrProfileName", dv);
        }
        if (!m_commandLineData.containsKey("profilePath")) {
            Hashtable<String, String> profileNameHash = new Hashtable<String, String>();
            profileNameHash.put("profileName", m_commandLineData.get("dmgrProfileName"));
            dmgrProfilePath = DefaultValueManagerUtils.getDefaultValue("profilePath", profileNameHash);
        }
        String templatePath = m_commandLineData.get("templatePath");
        WSConfigCreator.setupEnvironment(templatePath + File.separator + "default");
        DefaultValueManagerUtils.reinitialize();
        if (!m_commandLineData.containsKey("appServerProfileName")) {
            String dv2 = DefaultValueManagerUtils.getDefaultValue("profileName");
            m_commandLineData.put("appServerProfileName", dv2);
        }
        if (!m_commandLineData.containsKey("profilePath")) {
            Hashtable<String, String> profileNameHash = new Hashtable<String, String>();
            profileNameHash.put("profileName", m_commandLineData.get("appServerProfileName"));
            nodeProfilePath = DefaultValueManagerUtils.getDefaultValue("profilePath", profileNameHash);
        }
        WSConfigCreator.setupEnvironment(templatePath + File.separator + "dmgr");
        DefaultValueManagerUtils.reinitialize();
        for (String key : m_commandLineData.keySet()) {
            if (key.equalsIgnoreCase("templatePath")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key) + File.separator + "dmgr");
                wsProfileCommandDataNode.add(S_DASH + key);
                wsProfileCommandDataNode.add(m_commandLineData.get(key) + File.separator + "default");
                continue;
            }
            if (key.equalsIgnoreCase("profilePath")) {
                dmgrProfilePath = m_commandLineData.get(key) + File.separator + m_commandLineData.get("dmgrProfileName");
                nodeProfilePath = m_commandLineData.get(key) + File.separator + m_commandLineData.get("appServerProfileName");
                continue;
            }
            if (key.equalsIgnoreCase("dmgrProfileName")) {
                wsProfileCommandDataDmgr.add("-profileName");
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("appServerProfileName")) {
                wsProfileCommandDataNode.add("-profileName");
                wsProfileCommandDataNode.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("omitAction")) {
                wsProfileCommandDataDmgr.add("-omitAction");
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("nodeOmitAction")) {
                wsProfileCommandDataNode.add("-omitAction");
                wsProfileCommandDataNode.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("isDefault")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                continue;
            }
            if (key.equalsIgnoreCase("defaultPorts")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("validatePorts")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("startingPort")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("nodeStartingPort")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("portsFile")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("nodePortsFile")) {
                wsProfileCommandDataDmgr.add(S_DASH + key);
                wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
                continue;
            }
            wsProfileCommandDataDmgr.add(S_DASH + key);
            wsProfileCommandDataNode.add(S_DASH + key);
            if (m_commandLineData.get(key).equals(S_EMPTY)) continue;
            wsProfileCommandDataDmgr.add(m_commandLineData.get(key));
            wsProfileCommandDataNode.add(m_commandLineData.get(key));
        }
        dmgrPropertiesLocation = dmgrProfilePath + File.separator + "properties";
        wsProfileCommandDataDmgr.add("-profilePath");
        wsProfileCommandDataDmgr.add(dmgrProfilePath);
        wsProfileCommandDataNode.add("-profilePath");
        wsProfileCommandDataNode.add(nodeProfilePath);
        wsProfileCommandDataDmgr.add("-nodeProfilePath");
        wsProfileCommandDataDmgr.add(nodeProfilePath);
        wsProfileCommandDataNode.add("-dmgrProfilePath");
        wsProfileCommandDataNode.add(dmgrProfilePath);
        String portDefLocation = dmgrPropertiesLocation + File.separator + "portdef.props";
        String nodePortDefLocation = dmgrPropertiesLocation + File.separator + "nodeportdef.props";
        wsProfileCommandDataNode.add("-portsFile");
        wsProfileCommandDataNode.add(portDefLocation);
        wsProfileCommandDataNode.add("-nodePortsFile");
        wsProfileCommandDataNode.add(nodePortDefLocation);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildCommandData", "Generated Command data Dmgr: " + LogUtils.getArrayAsALoggableString(WSProfileUtils.hidePasswordArgs(wsProfileCommandDataDmgr)));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildCommandData", "Generated Command data Node: " + LogUtils.getArrayAsALoggableString(WSProfileUtils.hidePasswordArgs(wsProfileCommandDataNode)));
        LOGGER.exiting(WSConfigCreator.class.getName(), "buildCommandData");
    }

    private static Map<String, String> convertIncomingCommandLineToCommandLineArguments(String[] asArgs) {
        LOGGER.entering(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        if (asArgs.length == 0) {
            return new Hashtable<String, String>();
        }
        if (!asArgs[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "buildCommandData", "Invalid incoming command line");
            LOGGER.exiting(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return new Hashtable<String, String>();
        }
        Hashtable<String, String> commandLine = new Hashtable<String, String>();
        int nCounter = 0;
        while (nCounter < asArgs.length) {
            String sArgumentKey = asArgs[nCounter].substring(S_DASH.length());
            String sArgumentValues = WSConfigCreator.getArgumentValues(asArgs, nCounter);
            commandLine.put(sArgumentKey, sArgumentValues);
            nCounter = nCounter + argCounter + 1;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return commandLine;
    }

    private static String getArgumentValues(String[] asArgs, int nCounter) {
        String sArgThis;
        LOGGER.entering(WSConfigCreator.class.getName(), "getArgumentValues");
        String sRet = S_EMPTY;
        argCounter = 0;
        for (int i = nCounter + 1; i < asArgs.length && !(sArgThis = asArgs[i]).startsWith(S_DASH); ++i) {
            sRet = sRet + sArgThis + S_SPACE;
            ++argCounter;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "getArgumentValues");
        return sRet.trim();
    }

    private static void runWSProfile() {
        int i;
        LOGGER.entering(WSConfigCreator.class.getName(), "runWSProfile");
        int dmgrCommandSize = wsProfileCommandDataDmgr.size();
        int nodeCommandSize = wsProfileCommandDataNode.size();
        String[] WSProfileCommandDmgr = new String[dmgrCommandSize];
        String[] WSProfileCommandNode = new String[nodeCommandSize];
        int rNodeTemplatePath = wsProfileCommandDataNode.indexOf("-templatePath");
        for (i = 0; i < dmgrCommandSize; ++i) {
            WSProfileCommandDmgr[i] = wsProfileCommandDataDmgr.get(i);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Generated WSProfileCommand Dmgr: " + WSProfileCommandDmgr.toString());
        for (i = 0; i < nodeCommandSize; ++i) {
            WSProfileCommandNode[i] = wsProfileCommandDataNode.get(i);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Generated WSProfileCommand Node: " + WSProfileCommandNode.toString());
        returnCodeDmgr = WSProfileCLI.mainForInProcessCalls(WSProfileCommandDmgr);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Return code for Cell dmgr operation: " + returnCodeDmgr);
        WSConfigCreator.setupEnvironment(wsProfileCommandDataNode.get(rNodeTemplatePath + 1));
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Reinitializing DVM for cell-node creation");
        DefaultValueManagerUtils.reinitialize();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Reinitializing ValidationManager for cell-node creation");
        ValidationManagerUtils.reinitialize();
        returnCodeNode = WSProfileCLI.mainForInProcessCalls(WSProfileCommandNode);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "Return code for Cell node operation: " + returnCodeNode);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "WSProfile Command Execution return code DMGR: " + returnCodeDmgr);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runWSProfile", "WSProfile Command Execution return code NODE: " + returnCodeNode);
        if (returnCodeDmgr == 1 || returnCodeNode == 1) {
            returnCode = 1;
        } else if (returnCodeDmgr == 2 || returnCodeNode == 2) {
            returnCode = 2;
        } else if (returnCodeDmgr == 0 && returnCodeNode == 0) {
            returnCode = 0;
        }
        LOGGER.exiting(WSConfigCreator.class.getName(), "runWSProfile");
    }

    private static void initLogger(String[] args) {
        try {
            LOGGER = new LogInitializer(args).initCMTLoggerFactory(WSConfigCreator.class);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }
}

