/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.core.impl.BaseURLImpl;
import com.ibm.ws.portletcontainer.core.util.RuntimeOptionHelper;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.portlet.PortletUtils;
import com.ibm.ws.portletcontainer.service.information.InformationProviderAccess;
import com.ibm.ws.portletcontainer.util.CustomPropertyHelper;
import com.ibm.wsspi.portletcontainer.services.information.InformationProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.BaseURL;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.VariableInfo;

public abstract class BasicURLTag
extends TagSupport {
    private static final String CLASS_NAME = BasicURLTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.resources.Messages");
    private static Boolean ESCAPE_XML_GLOBAL = null;
    private InformationProvider provider;
    protected String portletMode;
    protected String secure;
    protected Boolean secureBoolean;
    protected String windowState;
    protected BaseURL url;
    protected String var;
    protected Boolean copyCurrentRenderParameters;
    private List<String> deletedParams = null;
    protected Boolean escapeXml;

    protected abstract BaseURL createURL(PortletResponse var1);

    public int doStartTag() throws JspException {
        PortletResponse response;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doStartTag", new Object[]{this.portletMode, this.windowState, this.secure, this.var, this.copyCurrentRenderParameters, this.escapeXml});
        }
        if (this.var != null) {
            this.pageContext.removeAttribute(this.var, 1);
        }
        if ((response = (PortletResponse)this.pageContext.getRequest().getAttribute("javax.portlet.response")) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Creating url for response " + response);
            }
            this.url = this.createURL(response);
            if (this.portletMode != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding portlet mode " + this.portletMode + " to url");
                    }
                    ((PortletURL)this.url).setPortletMode(TEI.getPortletMode(this.portletMode));
                }
                catch (PortletModeException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"43", (Object)this);
                    throw new JspException(e);
                }
            }
            if (this.windowState != null) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding window state " + this.windowState + " to url");
                    }
                    ((PortletURL)this.url).setWindowState(TEI.getWindowState(this.windowState));
                }
                catch (WindowStateException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"55", (Object)this);
                    throw new JspException(e);
                }
            }
            if (this.secure != null) {
                try {
                    boolean secure = this.getSecureBoolean();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag", "Adding security " + secure + " to url");
                    }
                    this.url.setSecure(secure);
                }
                catch (PortletSecurityException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doStartTag", (String)"67", (Object)this);
                    throw new JspException(e);
                }
            }
            if (this.escapeXml == null) {
                PortletWindow portletWindow = PortletUtils.getPortletWindow((PortletResponse)response);
                this.setEscapeXml(this.getEscapeXmlDefault(portletWindow.getPortletDefinition()));
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doStartTag", new Object[]{this.url});
        }
        return 6;
    }

    public int doEndTag() throws JspException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "doEndTag", new Object[]{this.var, this.url, this.portletMode, this.windowState, this.secure, this.secureBoolean, this.copyCurrentRenderParameters, this.escapeXml});
        }
        try {
            if (Boolean.TRUE.equals(this.copyCurrentRenderParameters)) {
                this.addCopiedParameters();
            }
            this.url.setProperty("com.ibm.ws.portletcontainer.url.force-write", "true");
            if (this.var == null) {
                JspWriter writer = this.pageContext.getOut();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "doEndTag", "Using JspWriter " + writer);
                }
                this.url.write(writer, this.escapeXml);
            } else {
                StringWriter stringWriter = new StringWriter();
                this.url.write(stringWriter, this.escapeXml);
                String urlVar = stringWriter.toString();
                this.pageContext.setAttribute(this.var, urlVar, 1);
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.portletcontainer.tags.BasicURLTag.doEndTag", (String)"131", (Object)this);
            throw new JspException("URL Tag Exception: cannot write to the output writer.", ioe);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "doEndTag");
        }
        return 6;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public String getSecure() {
        return this.secure;
    }

    public boolean getSecureBoolean() {
        return this.secureBoolean;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public BaseURL getUrl() {
        return this.url;
    }

    public String getVar() {
        return this.var;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public void setSecure(String secure) {
        this.secure = secure;
        this.secureBoolean = Boolean.valueOf(secure);
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public void setUrl(PortletURL url) {
        this.url = url;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Boolean getCopyCurrentRenderParameters() {
        return this.copyCurrentRenderParameters;
    }

    public void setCopyCurrentRenderParameters(Boolean copyCurrentRenderParameters) {
        this.copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public Boolean getEscapeXml() {
        return this.escapeXml;
    }

    public void setEscapeXml(Boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public void addProperty(String name, String value) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addProperty", new Object[]{name, value});
        }
        this.url.addProperty(name, value);
        logger.exiting(CLASS_NAME, "addProperty");
    }

    public void addParameter(String name, String value) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addParameter", new Object[]{name, value});
        }
        if (value == null || value.length() == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "addParameter", "deleting: " + name);
            }
            this.url.setParameter(name, (String)null);
            if (Boolean.TRUE.equals(this.copyCurrentRenderParameters)) {
                if (this.deletedParams == null) {
                    this.deletedParams = new ArrayList<String>(5);
                }
                this.deletedParams.add(name);
            }
        } else {
            String[] existingValues = this.url.getParameterMap().get(name);
            if (existingValues == null || existingValues.length == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addParameter", "first value: " + value);
                }
                this.url.setParameter(name, value);
            } else if (value != null) {
                Object[] newValues = new String[existingValues.length + 1];
                for (int i = 0; i < existingValues.length; ++i) {
                    newValues[i] = existingValues[i];
                }
                newValues[existingValues.length] = value;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addParameter", "accumulated values: " + Arrays.deepToString(newValues));
                }
                this.setURLParameter(name, (String[])newValues);
            }
        }
        logger.exiting(CLASS_NAME, "addParameter");
    }

    private void addCopiedParameters() {
        PortletRequest request = (PortletRequest)this.pageContext.getRequest().getAttribute("javax.portlet.request");
        if (request != null) {
            Map<String, String[]> copiedParameterMap = request.getPrivateParameterMap();
            Map<String, String[]> urlParameterMap = this.url.getParameterMap();
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCopiedParameters", "Old parameterMap: " + copiedParameterMap);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCopiedParameters", "deleted parameters: " + this.deletedParams);
            }
            for (Map.Entry<String, String[]> copiedParam : copiedParameterMap.entrySet()) {
                Object[] newValues;
                String name = copiedParam.getKey();
                if (this.deletedParams != null && this.deletedParams.contains(name)) continue;
                Object[] copiedValues = copiedParam.getValue();
                String[] setValues = urlParameterMap.get(name);
                if (setValues == null) {
                    newValues = copiedValues;
                } else {
                    int i;
                    newValues = new String[setValues.length + copiedValues.length];
                    for (i = 0; i < setValues.length; ++i) {
                        newValues[i] = setValues[i];
                    }
                    i = 0;
                    int d = setValues.length;
                    while (i < copiedValues.length) {
                        newValues[d] = copiedValues[i];
                        ++i;
                        ++d;
                    }
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "addCopiedParameters", "set " + name + "to: " + Arrays.deepToString(newValues));
                }
                this.setURLParameter(name, (String[])newValues);
            }
        }
    }

    private void setURLParameter(String name, String[] newValues) {
        if (this.url instanceof BaseURLImpl) {
            ((BaseURLImpl)this.url).setParameterInternal(name, newValues);
        } else {
            this.url.setParameter(name, newValues);
        }
    }

    private boolean getEscapeXmlDefault(PortletDefinition portlet) {
        if (portlet.getPortletApplicationDefinition().isJSR168()) {
            if (!BasicURLTag.getGlobalEscapeXMLSetting()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getEscapeXmlDefault", "custom property found, setting escapeXml to false");
                }
                return false;
            }
        } else {
            String[] values = RuntimeOptionHelper.getContainerRuntimeOption((PortletDefinition)portlet, (String)"javax.portlet.escapeXml");
            if (values != null && values.length > 0) {
                String value = values[0];
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getEscapeXmlDefault", "Container Option javax.portlet.escapeXml found, setting escapeXml to " + value);
                }
                return Boolean.valueOf(value);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEscapeXmlDefault", "Returning default XML escaping value of true");
        }
        return true;
    }

    private static boolean getGlobalEscapeXMLSetting() {
        if (ESCAPE_XML_GLOBAL == null) {
            ESCAPE_XML_GLOBAL = CustomPropertyHelper.isEnabled((String)"javax.portlet.escapeXml", (boolean)true);
        }
        return ESCAPE_XML_GLOBAL;
    }

    protected InformationProvider _getInformationProvider() {
        if (this.provider == null) {
            this.provider = InformationProviderAccess.getProvider();
        }
        return this.provider;
    }

    public static class TEI
    extends TagExtraInfo {
        private static final String HELP_NAME = PortletMode.HELP.toString();
        private static final String EDIT_NAME = PortletMode.EDIT.toString();
        private static final String VIEW_NAME = PortletMode.VIEW.toString();
        private static final String NORMAL_NAME = WindowState.NORMAL.toString();
        private static final String MINIMIZED_NAME = WindowState.MINIMIZED.toString();
        private static final String MAXIMIZED_NAME = WindowState.MAXIMIZED.toString();

        public static PortletMode getPortletMode(String mode) {
            if (mode == null) {
                return null;
            }
            if (mode.equalsIgnoreCase(VIEW_NAME)) {
                return PortletMode.VIEW;
            }
            if (mode.equalsIgnoreCase(EDIT_NAME)) {
                return PortletMode.EDIT;
            }
            if (mode.equalsIgnoreCase(HELP_NAME)) {
                return PortletMode.HELP;
            }
            return new PortletMode(mode);
        }

        public static WindowState getWindowState(String state) {
            if (state == null) {
                return null;
            }
            if (state.equals(NORMAL_NAME)) {
                return WindowState.NORMAL;
            }
            if (state.equals(MAXIMIZED_NAME)) {
                return WindowState.MAXIMIZED;
            }
            if (state.equals(MINIMIZED_NAME)) {
                return WindowState.MINIMIZED;
            }
            return new WindowState(state);
        }

        public VariableInfo[] getVariableInfo(TagData tagData) {
            VariableInfo[] vi = null;
            String var = tagData.getAttributeString("var");
            if (var != null) {
                vi = new VariableInfo[]{new VariableInfo(var, "java.lang.String", true, 2)};
            }
            return vi;
        }
    }
}

