/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.aggregation.tags.InsertRespWrapper;
import com.ibm.ws.portletcontainer.aggregation.tags.PortletStateHashtable;
import com.ibm.ws.portletcontainer.aggregation.tags.Utils;
import com.ibm.ws.portletcontainer.portletserving.core.PortletWindowIdentifier;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import com.ibm.wsspi.portletcontainer.util.FilterRequestHelper;
import com.ibm.wsspi.portletcontainer.util.PortletURLHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class InitTag
extends TagSupport {
    private static final long serialVersionUID = 7824534969503650886L;
    private static final String CLASS_NAME = InitTag.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private String portletURLPrefix;
    private String portletURLSuffix;
    private String portletURLQueryParams;
    private String context;
    private String portletName;
    private String windowId;
    private String requestURI;
    private String modeValue;
    private String stateValue;
    private String targetUrlWithoutContext;
    private boolean isAction;
    private Map rparams;
    private String version;

    public InitTag() {
        this.init();
    }

    private void init() {
        this.portletURLQueryParams = null;
        this.portletURLSuffix = null;
        this.portletURLPrefix = null;
        this.initUrlVars();
    }

    private void initUrlVars() {
        this.targetUrlWithoutContext = null;
        this.stateValue = null;
        this.modeValue = null;
        this.requestURI = null;
        this.windowId = null;
        this.portletName = null;
        this.context = null;
        this.rparams = null;
        this.isAction = false;
    }

    public int doStartTag() throws JspException {
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException("Non-HTTP request not allowed.");
        }
        if (this.pageContext.getSession() == null) {
            throw new JspTagException("No session found. Aggregation Tag Library requires a session.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "Enter InitTag.doStartTag()");
        }
        this.pageContext.getRequest().setAttribute("com.ibm.ws.portletcontainer.aggregation_taglib", Boolean.TRUE);
        this.getUrlParts();
        try {
            if (this.context != null && this.portletName != null && this.windowId != null) {
                String temporaryContext = this.context;
                if (!temporaryContext.startsWith("/")) {
                    temporaryContext = "/" + temporaryContext;
                }
                PortletWindowIdentifier sourcePWI = Utils.createPortletWindowIdentifier(temporaryContext, this.portletName, this.windowId);
                Utils.updatePublicRenderParameter(sourcePWI, this.rparams, this.pageContext.getRequest());
            }
        }
        catch (InvalidPortletWindowIdentifierException e1) {
            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.doStartTag", (String)"114", (Object)this);
            throw new JspException(e1);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "isAction: [" + this.isAction + "]");
        }
        if (this.isAction) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "inside isAction block...");
                logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "context: [" + this.context + "] portletName: [" + this.portletName + "]");
            }
            if (this.context != null && this.portletName != null) {
                InsertRespWrapper insertRespWrapper = null;
                try {
                    FilterRequestHelper.setRedirect(this.pageContext.getRequest());
                    insertRespWrapper = new InsertRespWrapper((HttpServletResponse)this.pageContext.getResponse());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doStartTag()", "about to call getResponseAsString");
                    }
                    if (!this.context.startsWith("/")) {
                        this.context = "/" + this.context;
                    }
                    Utils.getResponseAsString(this.pageContext, this.context, this.targetUrlWithoutContext, this.portletURLPrefix, this.portletURLSuffix, this.portletURLQueryParams, this.windowId, this.windowId, insertRespWrapper);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.doStartTag", (String)"72", (Object)this);
                    throw new JspTagException(e.toString(), e);
                }
                if (insertRespWrapper != null) {
                    HttpServletResponse orgServletResponse = (HttpServletResponse)insertRespWrapper.getResponse();
                    Map cookies = insertRespWrapper.getCookies();
                    for (Cookie cookie : cookies.values()) {
                        orgServletResponse.addCookie(cookie);
                    }
                    try {
                        orgServletResponse.sendRedirect(insertRespWrapper.getLocation());
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.doStartTag", (String)"89", (Object)this);
                        throw new JspTagException(e.toString(), e);
                    }
                }
                return 0;
            }
        }
        return 1;
    }

    private void getUrlParts() throws JspTagException {
        int inx;
        String reqPathInfo;
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException("non-HTTP request not allowed.");
        }
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "Enter InitTag.getUrlParts()  req: [" + req + "]");
        }
        if ((reqPathInfo = (String)req.getAttribute("javax.servlet.forward.path_info")) != null && reqPathInfo.length() > 1) {
            this.requestURI = reqPathInfo;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "request was forwarded.");
            }
            this.logURLReqInfo(req, true);
        } else {
            this.requestURI = req.getPathInfo();
            this.logURLReqInfo(req, false);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "requestURI: [" + this.requestURI + "]");
        }
        if (this.requestURI != null && this.portletURLSuffix != null && (inx = this.requestURI.indexOf(this.portletURLSuffix)) > 0) {
            this.requestURI = this.requestURI.substring(0, inx);
        }
        try {
            if (this.requestURI != null && this.requestURI.length() > 1) {
                PortletURLHelper portletURLHelper = null;
                this.context = null;
                this.portletName = null;
                if (req.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope") != null) {
                    Map portalScope = (Map)req.getAttribute("com.ibm.ws.portletcontainer.portletserving.portal_scope");
                    Set registeredURLs = portalScope.keySet();
                    String currentURL = null;
                    int longestMatch = -1;
                    for (String tempURL : registeredURLs) {
                        if (!this.requestURI.startsWith(tempURL) || longestMatch >= tempURL.length()) continue;
                        currentURL = tempURL;
                        longestMatch = tempURL.length();
                    }
                    Map scopeValues = (Map)portalScope.get(currentURL);
                    if (scopeValues != null) {
                        this.context = (String)scopeValues.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.context");
                        this.portletName = (String)scopeValues.get("com.ibm.ws.portletcontainer.portletserving.portal_scope.portletname");
                        this.targetUrlWithoutContext = this.requestURI.substring(this.context.length());
                        portletURLHelper = new PortletURLHelper(this.context, this.portletName, this.requestURI.substring(currentURL.length()));
                    } else {
                        portletURLHelper = new PortletURLHelper(this.requestURI);
                    }
                } else {
                    portletURLHelper = new PortletURLHelper(this.requestURI);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "portletURLHelper: [" + portletURLHelper + "]");
                }
                if (this.context == null) {
                    this.context = portletURLHelper.getContext();
                }
                if (this.portletName == null) {
                    this.portletName = portletURLHelper.getPortletName();
                }
                if (this.targetUrlWithoutContext == null) {
                    this.targetUrlWithoutContext = this.requestURI;
                    if (this.targetUrlWithoutContext.startsWith("/")) {
                        this.targetUrlWithoutContext = this.targetUrlWithoutContext.substring(1);
                    }
                    this.targetUrlWithoutContext = this.targetUrlWithoutContext.substring(this.targetUrlWithoutContext.indexOf(47));
                }
                this.windowId = portletURLHelper.getPortletWindowId();
                this.version = portletURLHelper.getVersion();
                this.rparams = portletURLHelper.getRenderParameters();
                this.modeValue = portletURLHelper.getPortletMode();
                this.stateValue = portletURLHelper.getWindowState();
                this.isAction = portletURLHelper.isAction();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getUrlParts()", "context: [" + this.context + "] portletName: [" + this.portletName + "] windowId: [" + this.windowId + "] targetUrlWithoutContext: [" + this.targetUrlWithoutContext + "] rparams: [" + this.rparams + "] modeValue: [" + this.modeValue + "] stateValue: [" + this.stateValue + "] isAction: [" + this.isAction + "] ");
                }
                String key = PortletStateHashtable.createKey(this.context, this.portletName, this.windowId);
                this.pageContext.getSession().removeAttribute(key);
                this.pageContext.getSession().setAttribute(key, PortletStateHashtable.createStateHashtable(this.modeValue, this.stateValue, this.rparams));
            }
        }
        catch (InvalidURLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.portletcontainer.aggregation.tags.InitTag.getUrlParts", (String)"137", (Object)this);
            e.printStackTrace();
        }
    }

    private void logURLReqInfo(HttpServletRequest req, boolean isForward) {
        if (logger.isLoggable(Level.FINE)) {
            if (!isForward) {
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getScheme(): [" + req.getScheme() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServerName(): [" + req.getServerName() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServerPort(): [" + req.getServerPort() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getContextPath(): [" + req.getContextPath() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getServletPath(): [" + req.getServletPath() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getPathInfo(): [" + req.getPathInfo() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getQueryString(): [" + req.getQueryString() + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "req.getRequestURI()(): [" + req.getRequestURI() + "]");
            } else {
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.servlet_path: [" + req.getAttribute("javax.servlet.forward.servlet_path") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.request_uri: [" + req.getAttribute("javax.servlet.forward.request_uri") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.context_path: [" + req.getAttribute("javax.servlet.forward.context_path") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.path_info: [" + req.getAttribute("javax.servlet.forward.path_info") + "]");
                logger.logp(Level.FINE, CLASS_NAME, "logURLReqInfo()", "javax.servlet.forward.query_string: [" + req.getAttribute("javax.servlet.forward.query_string") + "]");
            }
        }
    }

    public int doEndTag() throws JspException {
        this.init();
        return 6;
    }

    public void release() {
        this.init();
    }

    public void setPortletURLPrefix(String portletURLPrefixArg) {
        this.portletURLPrefix = portletURLPrefixArg;
    }

    public void setPortletURLSuffix(String portletURLSuffixArg) {
        this.portletURLSuffix = portletURLSuffixArg;
    }

    public void setPortletURLQueryParams(String portletURLQueryParamsArg) {
        this.portletURLQueryParams = portletURLQueryParamsArg;
    }

    public String toString() {
        String separatorString = System.getProperty("line.separator");
        String retString = null;
        retString = separatorString + "portletURLPrefix =                [" + this.portletURLPrefix + "]" + separatorString + "portletURLSuffix =                [" + this.portletURLSuffix + "]" + separatorString + "portletURLQueryParams=            [" + this.portletURLQueryParams + "]";
        return retString;
    }

    protected String getPortletURLPrefix() {
        return this.portletURLPrefix;
    }

    protected String getPortletURLQueryParams() {
        return this.portletURLQueryParams;
    }

    protected String getPortletURLSuffix() {
        return this.portletURLSuffix;
    }

    protected String getWindowState() {
        return this.stateValue;
    }

    protected String getPortletMode() {
        return this.modeValue;
    }

    protected String getTargetWindowId() {
        return this.windowId;
    }

    protected String getURLVersion() {
        return this.version;
    }
}

