/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.portletcontainer.aggregation.tags;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AggregationLibValidator
extends TagLibraryValidator {
    private static final String CLASS_NAME = AggregationLibValidator.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.runtime.resources.Messages");
    private ResourceBundle bundle = logger.getResourceBundle();
    private final String INIT = "init";
    private final String STATE = "state";
    private final String URLPARAM = "urlParam";
    private final String INSERT = "insert";
    private final String JSP_TEXT = "jsp:text";
    protected static final int TYPE_PORTLET = 3;
    protected static final String VAR = "var";
    protected static final String SCOPE = "scope";
    protected String uri;
    protected String prefix;
    protected Vector<ValidationMessage> messageVector;
    protected Map config;
    protected boolean failed;
    protected String lastElementId;
    private boolean enabled = true;

    public AggregationLibValidator() {
        this.init();
    }

    private void init() {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setInitParameters(Map map) {
        Boolean value = new Boolean((String)map.get("enabled"));
        this.setEnabled(value);
    }

    public void release() {
        super.release();
        this.init();
    }

    static ValidationMessage[] validationMessageFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    static ValidationMessage[] validationMessageFromVector(Vector v) {
        ValidationMessage[] vm = new ValidationMessage[v.size()];
        for (int i = 0; i < vm.length; ++i) {
            vm[i] = (ValidationMessage)v.get(i);
        }
        return vm;
    }

    protected boolean isTag(String tagUri, String tagLn, String matchUri, String matchLn) {
        if (tagUri == null || tagLn == null || matchUri == null || matchLn == null) {
            return false;
        }
        if (tagUri.length() > matchUri.length()) {
            return tagUri.startsWith(matchUri) && tagLn.equals(matchLn);
        }
        return matchUri.startsWith(tagUri) && tagLn.equals(matchLn);
    }

    private boolean isTag(int type, String tagUri, String tagLn, String target) {
        return 3 == type && this.isTag(tagUri, tagLn, this.uri, target);
    }

    protected boolean isPortletTag(String tagUri, String tagLn, String target) {
        return this.isTag(3, tagUri, tagLn, target);
    }

    protected void fail(String message, String elementId) {
        this.failed = true;
        this.messageVector.add(new ValidationMessage(elementId, message));
    }

    protected String getLocalPart(String qname) {
        int colon = qname.indexOf(":");
        if (colon == -1) {
            return qname;
        }
        return qname.substring(colon + 1);
    }

    public synchronized ValidationMessage[] validate(String prefixArg, String uriArg, PageData page) {
        if (this.enabled) {
            try {
                this.uri = uriArg;
                this.messageVector = new Vector();
                this.prefix = prefixArg;
                Handler h = new Handler();
                SAXParserFactory f = SAXParserFactory.newInstance();
                f.setValidating(false);
                f.setNamespaceAware(true);
                SAXParser p = f.newSAXParser();
                p.parse(page.getInputStream(), (DefaultHandler)h);
                if (this.messageVector.size() == 0) {
                    return null;
                }
                return AggregationLibValidator.validationMessageFromVector(this.messageVector);
            }
            catch (SAXException ex) {
                return AggregationLibValidator.validationMessageFromString(ex.toString());
            }
            catch (ParserConfigurationException ex) {
                return AggregationLibValidator.validationMessageFromString(ex.toString());
            }
            catch (IOException ex) {
                return AggregationLibValidator.validationMessageFromString(ex.toString());
            }
        }
        return null;
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack<Integer> initTagDepths = new Stack();
        private int initTagCount = 0;
        private Stack<Integer> stateTagDepths = new Stack();
        private Stack<Integer> urlParamTagDepths = new Stack();
        private Stack<Integer> insertDepths = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        public void startElement(String nameSpaceURI, String localName, String qualifiedName, Attributes attrs) {
            String elementId = attrs.getValue("http://java.sun.com/JSP/Page", "id");
            if (localName == null) {
                localName = AggregationLibValidator.this.getLocalPart(qualifiedName);
            }
            if (qualifiedName.equals("jsp:text")) {
                return;
            }
            if (this.bodyIllegal) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.illegal") + " " + qualifiedName, elementId);
            }
            if ((AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "insert") || AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "state")) && this.initTagDepths.empty() && this.stateTagDepths.empty()) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.init.tag") + " " + qualifiedName, elementId);
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "urlParam") && this.stateTagDepths.empty()) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.tag.must.be.nested.in.state.tag") + " " + qualifiedName, elementId);
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "init")) {
                this.initTagDepths.push(new Integer(this.depth));
                ++this.initTagCount;
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "init") && this.initTagCount > 1) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.one.init.tag.allowed") + " " + qualifiedName, elementId);
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "insert")) {
                this.insertDepths.push(new Integer(this.depth));
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "state")) {
                this.stateTagDepths.push(new Integer(this.depth));
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "urlParam")) {
                this.urlParamTagDepths.push(new Integer(this.depth));
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "init")) {
                this.bodyNecessary = true;
            }
            if (AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "insert") || AggregationLibValidator.this.isPortletTag(nameSpaceURI, localName, "urlParam")) {
                this.bodyIllegal = true;
            }
            this.lastElementName = qualifiedName;
            AggregationLibValidator.this.lastElementId = attrs.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.illegal") + " " + this.lastElementName, AggregationLibValidator.this.lastElementId);
            }
        }

        public void endElement(String ns, String ln, String qn) {
            if (qn.equals("jsp:text")) {
                return;
            }
            if (this.bodyNecessary) {
                AggregationLibValidator.this.fail(AggregationLibValidator.this.bundle.getString("aggregation.taglib.body.mandatory") + " " + this.lastElementName, AggregationLibValidator.this.lastElementId);
            }
            this.bodyIllegal = false;
            if (AggregationLibValidator.this.isPortletTag(ns, ln, "init")) {
                this.initTagDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(ns, ln, "insert")) {
                this.insertDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(ns, ln, "state")) {
                this.stateTagDepths.pop();
            }
            if (AggregationLibValidator.this.isPortletTag(ns, ln, "urlParam")) {
                this.urlParamTagDepths.pop();
            }
            --this.depth;
        }
    }
}

