/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiConstants;
import java.io.Serializable;

public class DataDescriptor
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = -5571274779240562143L;
    String[] dataPath = null;
    int[] dataIds = null;
    int type = -1;
    final int SUBMODULE_INDEX = 2;

    public DataDescriptor() {
    }

    public DataDescriptor(String[] stringArray) {
        this.init(stringArray, -3);
    }

    public DataDescriptor(String[] stringArray, int n) {
        this.init(stringArray, n);
    }

    public DataDescriptor(String[] stringArray, int[] nArray) {
        this.init(stringArray, nArray);
    }

    public DataDescriptor(DataDescriptor dataDescriptor, String string) {
        if (dataDescriptor == null || dataDescriptor.getType() == -1 || dataDescriptor.getType() == 18) {
            this.type = -1;
        } else {
            String[] stringArray = dataDescriptor.getPath();
            if (stringArray.length == 1 && stringArray[0].equals("pmi")) {
                this.init(new String[]{string}, -3);
            } else {
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray2.length - 1] = string;
                this.init(stringArray2, -3);
            }
        }
    }

    public DataDescriptor(DataDescriptor dataDescriptor, int n) {
        if (dataDescriptor == null || dataDescriptor.getType() == -1 || dataDescriptor.getType() == 18) {
            this.type = -1;
        } else {
            this.init(dataDescriptor.getPath(), n);
        }
    }

    public DataDescriptor(DataDescriptor dataDescriptor, int[] nArray) {
        if (dataDescriptor == null || dataDescriptor.getType() == -1 || dataDescriptor.getType() == 18) {
            this.type = -1;
        } else {
            this.init(dataDescriptor.getPath(), nArray);
        }
    }

    private void init(String[] stringArray, int n) {
        if (n == -3) {
            this.init(stringArray, null);
        } else {
            this.init(stringArray, new int[]{n});
        }
    }

    private void init(String[] stringArray, int[] nArray) {
        this.dataPath = stringArray;
        this.dataIds = nArray;
        if (this.dataPath.length > 2) {
            if (this.dataPath[2].equals("methods")) {
                this.dataPath[2] = "beanModule.methods";
            } else if (this.dataPath[2].equals("servlets")) {
                this.dataPath[2] = "webAppModule.servlets";
            }
        }
        if (this.dataPath == null || this.dataPath.length == 0) {
            this.type = -1;
            if (this.dataPath == null) {
                this.dataPath = new String[0];
            }
        } else {
            for (int i = 0; i < this.dataPath.length; ++i) {
                if (this.dataPath[i] != null) continue;
                this.type = -1;
                return;
            }
            if (nArray != null) {
                this.type = 18;
            } else {
                if (this.dataPath.length == 1 && this.dataPath[0].equals("pmi")) {
                    this.type = 12;
                }
                this.type = this.dataPath.length == 1 ? 13 : 17;
            }
        }
    }

    public String[] getPath() {
        return this.dataPath;
    }

    public int getType() {
        return this.type;
    }

    public int getType(int n) {
        if (this.type == -1 || this.dataPath == null || n >= this.dataPath.length) {
            return -1;
        }
        if (n == 1) {
            return 13;
        }
        return 17;
    }

    public String getModuleName() {
        if (this.type == -1) {
            return null;
        }
        return this.dataPath[0];
    }

    public String getName() {
        if (this.type == -1) {
            return null;
        }
        return this.dataPath[this.dataPath.length - 1];
    }

    public int getDataId() {
        if (this.dataIds == null) {
            return -3;
        }
        return this.dataIds[0];
    }

    public int[] getDataIds() {
        return this.dataIds;
    }

    public boolean isSamePath(DataDescriptor dataDescriptor) {
        if (dataDescriptor == null) {
            return false;
        }
        if (this.type == -1 || dataDescriptor.getType() == -1) {
            return false;
        }
        if (this.type != dataDescriptor.getType()) {
            return false;
        }
        if (this.dataPath == null || dataDescriptor.getPath() == null) {
            return false;
        }
        String[] stringArray = dataDescriptor.getPath();
        if (this.dataPath.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < this.dataPath.length; ++i) {
            if (this.dataPath[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDescendant(DataDescriptor dataDescriptor) {
        if (dataDescriptor == null) {
            return false;
        }
        if (this.type == -1 || dataDescriptor.getType() == -1) {
            return false;
        }
        String[] stringArray = dataDescriptor.getPath();
        if (stringArray.length >= this.dataPath.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dataPath[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public DataDescriptor parentDescriptor() {
        if (this.type == -1) {
            return null;
        }
        if (this.dataIds != null) {
            return new DataDescriptor(this.dataPath);
        }
        if (this.dataPath.length == 1) {
            return null;
        }
        String[] stringArray = new String[this.dataPath.length - 1];
        System.arraycopy(this.dataPath, 0, stringArray, 0, stringArray.length);
        return new DataDescriptor(stringArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dataPath.length; ++i) {
            stringBuffer.append(this.dataPath[i]).append("/");
        }
        if (this.dataIds != null) {
            stringBuffer.append(this.dataIds[0]);
        }
        return stringBuffer.toString();
    }
}

