/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.csi.ResRefListImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ejb.jar.bnd.EjbRefType;
import com.ibm.ws.ejb.jar.bnd.InterceptorType;
import com.ibm.ws.ejb.jar.bnd.MessageDestinationRefType;
import com.ibm.ws.ejb.jar.bnd.ResourceEnvRefType;
import com.ibm.ws.ejb.jar.bnd.ResourceRefType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ejb.EJBInterceptorBinding;
import com.ibm.ws.metadata.ejb.InterceptorMethodKind;
import com.ibm.ws.util.WCCMHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ejb.ApplicationException;
import javax.interceptor.InvocationContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.common.LifecycleCallbackType;
import org.eclipse.jst.j2ee.ejb.AroundInvokeMethod;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Interceptor;
import org.eclipse.jst.j2ee.ejb.InterceptorBinding;
import org.eclipse.jst.j2ee.ejb.InterceptorOrder;
import org.eclipse.jst.j2ee.ejb.Interceptors;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MethodParams;
import org.eclipse.jst.j2ee.ejb.NamedMethod;
import org.eclipse.jst.j2ee.ejb.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMetaDataHelper {
    private static final String CLASS_NAME = InterceptorMetaDataHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJB3Interceptors", "com.ibm.ejs.container.container");
    private static final Class[] PARM_TYPES = new Class[]{InvocationContext.class};
    private static final Class[] NO_PARMS = new Class[0];

    public static void populateInterceptorBindingMap(List<InterceptorBinding> bindingList, Map<String, List<EJBInterceptorBinding>> map) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateInterceptorBindingMap");
        }
        for (InterceptorBinding ib : bindingList) {
            EJBInterceptorBinding binding;
            EList classes;
            String ejbName = ib.getEjbName();
            List<EJBInterceptorBinding> ejbList = map.get(ejbName);
            NamedMethod nm = ib.getMethod();
            MethodParams parms = null;
            if (nm != null) {
                parms = nm.getMethodParams();
            }
            InterceptorOrder order = ib.getInterceptorOrder();
            List<String> interceptorClassNameList = null;
            List<String> interceptorOrderList = null;
            if (order == null) {
                classes = ib.getInterceptorClass();
                String[] interceptorClassNames = WCCMHelper.getJavaClassNames(classes);
                interceptorClassNameList = Arrays.asList(interceptorClassNames);
            } else {
                classes = order.getInterceptorClass();
                String[] interceptorOrderNames = WCCMHelper.getJavaClassNames(classes);
                interceptorOrderList = Arrays.asList(interceptorOrderNames);
            }
            if (ejbName.equals("*")) {
                if (nm != null) {
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0239E: The method-name element is not valid in an interceptor-binding when EJB name is \"*\"");
                    Tr.error(tc, "METHOD_NAME_INVALID_FOR_DEFAULT_CNTR0239E");
                    throw ecex;
                }
                binding = new EJBInterceptorBinding(interceptorClassNameList, interceptorOrderList);
            } else if (nm == null) {
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList);
            } else if (parms == null) {
                String methodName = nm.getMethodName();
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList, methodName, null);
            } else {
                EList parmList = parms.getMethodParam();
                String methodName = nm.getMethodName();
                binding = new EJBInterceptorBinding(ejbName, interceptorClassNameList, interceptorOrderList, methodName, parmList);
            }
            if (ib.isSetExcludeDefaultInterceptors()) {
                binding.setExcludeDefaultInterceptors(ib.isExcludeDefaultInterceptors());
            }
            if (ib.isSetExcludeClassInterceptors()) {
                binding.setExcludeClassLevelInterceptors(ib.isExcludeClassInterceptors());
            }
            if (ejbList != null) {
                ejbList.add(binding);
            } else {
                ejbList = new LinkedList<EJBInterceptorBinding>();
                ejbList.add(binding);
                map.put(ejbName, ejbList);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            binding.dump();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateInterceptorBindingMap");
        }
    }

    public static Map<String, Interceptor> populateInterceptorsMap(ClassLoader classLoader, Interceptors interceptors, IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> interceptorsMap, HashMap<String, Boolean> appExceptionMap) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateInterceptorsMap");
        }
        EList interceptorList = interceptors.getInterceptorList();
        HashMap<String, Interceptor> interceptorMap = new HashMap<String, Interceptor>(interceptorList.size());
        for (Interceptor interceptor : interceptorList) {
            EList preDestroyList;
            EList prePassivateList;
            EList postActivateList;
            EList postConstructList;
            Class<?> c;
            JavaClass jClass = interceptor.getInterceptorClass();
            String className = jClass.getQualifiedName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Loading EJB 3.0 Interceptor class: " + className);
            }
            try {
                c = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".initializeInterceptorMD"), (String)"5352");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Load of EJB 3.0 Interceptor class failed: " + className, ex);
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0237E: The user-provided EJB 3.0 interceptor class \"" + className + "\" could not be found or loaded.", ex);
                Tr.error(tc, "INTERCEPTOR_CLASS_NOT_FOUND_CNTR0237E", new Object[]{className});
                throw ecex;
            }
            interceptorMap.put(className, interceptor);
            LinkedList<Class<?>> lifoClasses = InterceptorMetaDataHelper.getLIFOSuperClassesList(c);
            EnumMap<InterceptorMethodKind, LinkedList<Method>> methodMap = new EnumMap<InterceptorMethodKind, LinkedList<Method>>(InterceptorMethodKind.class);
            EList aroundList = interceptor.getAroundInvoke();
            if (aroundList != null && !aroundList.isEmpty()) {
                LinkedList<Method> methodList = new LinkedList<Method>();
                for (AroundInvokeMethod a : aroundList) {
                    String methodName = a.getMethodName();
                    Method m = InterceptorMetaDataHelper.findMethod(c, methodName, PARM_TYPES);
                    if (m != null) {
                        InterceptorMetaDataHelper.validateAroundInvokeSignature(m);
                        methodList.add(m);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                    }
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a around-invoke method of EJB interceptor class " + className);
                    Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "around-invoke", className});
                    throw ecex;
                }
                LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
                methodMap.put(InterceptorMethodKind.AROUND_INVOKE, lifo);
            }
            if ((postConstructList = interceptor.getPostConstruct()) != null && !postConstructList.isEmpty()) {
                LinkedList<Method> methodList = new LinkedList<Method>();
                for (LifecycleCallbackType pc : postConstructList) {
                    String methodName = pc.getMethodName();
                    Method m = InterceptorMetaDataHelper.findMethod(c, methodName, PARM_TYPES);
                    if (m != null) {
                        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("post-construct", m, appExceptionMap);
                        methodList.add(m);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                    }
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a post-construct method of EJB interceptor class " + className);
                    Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "post-construct", className});
                    throw ecex;
                }
                LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
                methodMap.put(InterceptorMethodKind.POST_CONSTRUCT, lifo);
            }
            if ((postActivateList = interceptor.getPostActivate()) != null && !postActivateList.isEmpty()) {
                LinkedList<Method> methodList = new LinkedList<Method>();
                for (LifecycleCallbackType pa : postActivateList) {
                    String methodName = pa.getMethodName();
                    Method m = InterceptorMetaDataHelper.findMethod(c, methodName, PARM_TYPES);
                    if (m != null) {
                        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("post-activate", m, appExceptionMap);
                        methodList.add(m);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                    }
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a post-activate method of EJB interceptor class " + className);
                    Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "post-activate", className});
                    throw ecex;
                }
                LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
                methodMap.put(InterceptorMethodKind.POST_ACTIVATE, lifo);
            }
            if ((prePassivateList = interceptor.getPrePassivate()) != null && !prePassivateList.isEmpty()) {
                LinkedList<Method> methodList = new LinkedList<Method>();
                for (LifecycleCallbackType pp : prePassivateList) {
                    String methodName = pp.getMethodName();
                    Method m = InterceptorMetaDataHelper.findMethod(c, methodName, PARM_TYPES);
                    if (m != null) {
                        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("pre-passivate", m, appExceptionMap);
                        methodList.add(m);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                    }
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a pre-passivate method of EJB interceptor class " + className);
                    Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "pre-passivate", className});
                    throw ecex;
                }
                LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
                methodMap.put(InterceptorMethodKind.PRE_PASSIVATE, lifo);
            }
            if ((preDestroyList = interceptor.getPreDestroy()) != null && !preDestroyList.isEmpty()) {
                LinkedList<Method> methodList = new LinkedList<Method>();
                for (LifecycleCallbackType pd : preDestroyList) {
                    String methodName = pd.getMethodName();
                    Method m = InterceptorMetaDataHelper.findMethod(c, methodName, PARM_TYPES);
                    if (m != null) {
                        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("post-destroy", m, appExceptionMap);
                        methodList.add(m);
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                    }
                    EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a pre-passivate method of EJB interceptor class " + className);
                    Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "pre-destroy", className});
                    throw ecex;
                }
                LinkedList<Method> lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
                methodMap.put(InterceptorMethodKind.PRE_DESTROY, lifo);
            }
            interceptorsMap.put(c, methodMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateInterceptorsMap");
        }
        return interceptorMap;
    }

    public static EnumMap<InterceptorMethodKind, List<Method>> getEJBInterceptorMethods(Class<?> ejbClass, EnterpriseBean bean, LinkedList<Class<?>> lifoClasses, HashMap<String, Boolean> appExceptionMap) throws EJBConfigurationException {
        LinkedList<Method> lifo;
        Method m;
        String methodName;
        LinkedList<Method> methodList;
        EList preDestroyList;
        EList postConstructList;
        EList aroundList;
        String className = ejbClass.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBInterceptorMethods for EJB class: " + className);
        }
        EnumMap<InterceptorMethodKind, List<Method>> methodMap = new EnumMap<InterceptorMethodKind, List<Method>>(InterceptorMethodKind.class);
        EList postActivateList = null;
        EList prePassivateList = null;
        if (bean.isSession()) {
            Session sb = (Session)bean;
            aroundList = sb.getAroundInvoke();
            postConstructList = sb.getPostConstruct();
            postActivateList = sb.getPostActivate();
            prePassivateList = sb.getPrePassivate();
            preDestroyList = sb.getPreDestroy();
        } else {
            MessageDriven mdb = (MessageDriven)bean;
            aroundList = mdb.getAroundInvoke();
            postConstructList = mdb.getPostConstruct();
            preDestroyList = mdb.getPreDestroy();
        }
        if (aroundList != null && !aroundList.isEmpty()) {
            methodList = new LinkedList<Method>();
            for (AroundInvokeMethod a : aroundList) {
                methodName = a.getMethodName();
                m = InterceptorMetaDataHelper.findMethod(ejbClass, methodName, PARM_TYPES);
                if (m != null) {
                    InterceptorMetaDataHelper.validateAroundInvokeSignature(m);
                    methodList.add(m);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a around-invoke method of EJB interceptor class " + className);
                Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "around-invoke", className});
                throw ecex;
            }
            lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
            methodMap.put(InterceptorMethodKind.AROUND_INVOKE, lifo);
        }
        if (postConstructList != null && !postConstructList.isEmpty()) {
            methodList = new LinkedList();
            for (LifecycleCallbackType pc : postConstructList) {
                methodName = pc.getMethodName();
                m = InterceptorMetaDataHelper.findEJBLifeCycleCallbackMethod(ejbClass, methodName);
                if (m != null) {
                    InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("post-construct", m, appExceptionMap);
                    methodList.add(m);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a post-construct method of EJB interceptor class " + className);
                Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "post-construct", className});
                throw ecex;
            }
            lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
            methodMap.put(InterceptorMethodKind.POST_CONSTRUCT, lifo);
        }
        if (postActivateList != null && !postActivateList.isEmpty()) {
            methodList = new LinkedList();
            for (LifecycleCallbackType pa : postActivateList) {
                methodName = pa.getMethodName();
                m = InterceptorMetaDataHelper.findEJBLifeCycleCallbackMethod(ejbClass, methodName);
                if (m != null) {
                    InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("post-activate", m, appExceptionMap);
                    methodList.add(m);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a post-activate method of EJB interceptor class " + className);
                Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "post-activate", className});
                throw ecex;
            }
            lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
            methodMap.put(InterceptorMethodKind.POST_ACTIVATE, lifo);
        }
        if (prePassivateList != null && !prePassivateList.isEmpty()) {
            methodList = new LinkedList();
            for (LifecycleCallbackType pp : prePassivateList) {
                methodName = pp.getMethodName();
                m = InterceptorMetaDataHelper.findEJBLifeCycleCallbackMethod(ejbClass, methodName);
                if (m != null) {
                    InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("pre-passivate", m, appExceptionMap);
                    methodList.add(m);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a pre-passivate method of EJB interceptor class " + className);
                Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "pre-passivate", className});
                throw ecex;
            }
            lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
            methodMap.put(InterceptorMethodKind.PRE_PASSIVATE, lifo);
        }
        if (preDestroyList != null && !preDestroyList.isEmpty()) {
            methodList = new LinkedList();
            for (LifecycleCallbackType pd : preDestroyList) {
                methodName = pd.getMethodName();
                m = InterceptorMetaDataHelper.findEJBLifeCycleCallbackMethod(ejbClass, methodName);
                if (m != null) {
                    InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters("pre-destroy", m, appExceptionMap);
                    methodList.add(m);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, methodName + " not found in " + className + " or in any of it's super classes");
                }
                EJBConfigurationException ecex = new EJBConfigurationException("CNTR0238E: " + methodName + " is not a pre-destroy method of EJB interceptor class " + className);
                Tr.error(tc, "INTERCEPTOR_METHOD_NOT_FOUND_CNTR0238E", new Object[]{methodName, "pre-destroy", className});
                throw ecex;
            }
            lifo = InterceptorMetaDataHelper.getLIFOMethodList(methodList, lifoClasses);
            methodMap.put(InterceptorMethodKind.PRE_DESTROY, lifo);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBInterceptorMethods: " + methodMap);
        }
        return methodMap;
    }

    public static LinkedList<Method> getLIFOMethodList(List<Method> methodList, LinkedList<Class<?>> lifoSuperClassesList) {
        LinkedList<Method> sortedList = new LinkedList<Method>();
        for (Class clazz : lifoSuperClassesList) {
            if (methodList.isEmpty()) break;
            Iterator<Method> it = methodList.iterator();
            while (it.hasNext()) {
                Method m = it.next();
                if (m.getDeclaringClass() != clazz) continue;
                sortedList.addFirst(m);
                it.remove();
            }
        }
        return sortedList;
    }

    public static Method findMethod(Class<?> c, String methodName, Class<?>[] parmTypes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findMethod", new Object[]{c, methodName, parmTypes});
        }
        Class<?> classObject = c;
        Method m = null;
        while (classObject != null && m == null) {
            try {
                m = classObject.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException e) {
                classObject = classObject.getSuperclass();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                if (classObject != null && classObject != Object.class) {
                    Tr.debug(tc, "searching superclass: " + classObject.getName());
                    continue;
                }
                Tr.debug(tc, methodName + " was not found");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findMethod returning: " + m);
        }
        return m;
    }

    public static Method findEJBLifeCycleCallbackMethod(Class<?> ejbClass, String methodName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findEJBLifeCycleCallbackMethod", new Object[]{ejbClass, methodName});
        }
        Class<?> classObject = ejbClass;
        Method m = null;
        Class[] parmTypes = NO_PARMS;
        while (classObject != null && m == null) {
            try {
                m = classObject.getDeclaredMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException e) {
                classObject = classObject.getSuperclass();
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                if (classObject != null && classObject != Object.class) {
                    Tr.debug(tc, "searching superclass: " + classObject.getName());
                    continue;
                }
                Tr.debug(tc, methodName + " was not found");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findEJBLifeCycleCallbackMethod returning: " + m);
        }
        return m;
    }

    public static LinkedList<Class<?>> getLIFOSuperClassesList(Class<?> interceptorClass) {
        LinkedList supers = new LinkedList();
        supers.addFirst(interceptorClass);
        for (Class<?> interceptorSuperClass = interceptorClass.getSuperclass(); interceptorSuperClass != null && interceptorSuperClass != Object.class; interceptorSuperClass = interceptorSuperClass.getSuperclass()) {
            supers.addFirst(interceptorSuperClass);
        }
        return supers;
    }

    public static void validateAroundInvokeSignature(Method m) throws EJBConfigurationException {
        int mod = m.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method};
            Tr.error(tc, "INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", data);
            throw new EJBConfigurationException("Around invoke interceptor \"" + method + "\" must not be declared as final or static.");
        }
        Class<?>[] parmTypes = m.getParameterTypes();
        if (parmTypes.length != 1 || !parmTypes[0].equals(InvocationContext.class)) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method};
            Tr.error(tc, "INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", data);
            throw new EJBConfigurationException("Around invoke interceptor \"" + method + "\" must have a single parameter of type javax.interceptors.InvocationContext.");
        }
        Class<?> returnType = m.getReturnType();
        if (!Object.class.isAssignableFrom(returnType)) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method};
            Tr.error(tc, "INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", data);
            throw new EJBConfigurationException("Around invoke interceptor \"" + method + "\" must have a return value of type java.lang.Object.");
        }
        Class<?>[] exceptionTypes = m.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            for (Class<?> ex : exceptionTypes) {
                if (Exception.class.isAssignableFrom(ex)) continue;
                String method = m.toGenericString();
                Object[] data = new Object[]{method};
                Tr.error(tc, "INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", data);
                throw new EJBConfigurationException("Around invoke interceptor \"" + method + "\" must throw java.lang.Exception.");
            }
        } else {
            String method = m.toGenericString();
            Object[] data = new Object[]{method};
            Tr.error(tc, "INVALID_AROUND_INVOKE_SIGNATURE_CNTR0230E", data);
            throw new EJBConfigurationException("Around invoke interceptor \"" + method + "\" must throw java.lang.Exception.");
        }
    }

    public static void validateLifeCycleSignatureExceptParameters(String lifeCycle, Method m, HashMap<String, Boolean> appExceptionMap) throws EJBConfigurationException {
        int mod = m.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method};
            Tr.error(tc, "INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", data);
            throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must not be declared as final or static.");
        }
        Class<?> returnType = m.getReturnType();
        if (returnType != Void.TYPE) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method, lifeCycle};
            Tr.error(tc, "INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", data);
            throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have void as return type.");
        }
        Class<?>[] exceptionTypes = m.getExceptionTypes();
        if (exceptionTypes.length != 0) {
            for (Class<?> c : exceptionTypes) {
                if (!InterceptorMetaDataHelper.isApplicationException(c, appExceptionMap)) continue;
                String method = m.toGenericString();
                Object[] data = new Object[]{lifeCycle, method};
                Tr.error(tc, "INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", data);
                throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must not throw application exceptions.");
            }
        }
    }

    private static boolean isApplicationException(Class<?> c, HashMap<String, Boolean> appExceptionMap) {
        if (RuntimeException.class.isAssignableFrom(c)) {
            if (appExceptionMap.containsKey(c.getName())) {
                return true;
            }
            return c.getAnnotation(ApplicationException.class) != null;
        }
        return Exception.class.isAssignableFrom(c);
    }

    public static void validateLifeCycleSignature(String lifeCycle, Method m, boolean ejbClass, HashMap<String, Boolean> appExceptionMap) throws EJBConfigurationException {
        InterceptorMetaDataHelper.validateLifeCycleSignatureExceptParameters(lifeCycle, m, appExceptionMap);
        Class<?>[] parmTypes = m.getParameterTypes();
        if (ejbClass) {
            if (parmTypes.length != 0) {
                String method = m.toGenericString();
                Object[] data = new Object[]{lifeCycle, method};
                Tr.error(tc, "INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", data);
                throw new EJBConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have zero parameters.");
            }
        } else if (parmTypes.length != 1 || !parmTypes[0].equals(InvocationContext.class)) {
            String method = m.toGenericString();
            Object[] data = new Object[]{method, lifeCycle};
            Tr.error(tc, "INVALID_LIFECYCLE_SIGNATURE_CNTR0232E", data);
            throw new EJBConfigurationException("CNTR0232E: The \"" + method + "\" method does not have the required method signature for a \"" + lifeCycle + "\" method of a interceptor class.");
        }
    }

    public static boolean isMethodOverridden(Method m, LinkedList<Class<?>> supers) {
        int startIndex;
        int methodModifier = m.getModifiers();
        if (!Modifier.isPrivate(methodModifier) && (startIndex = supers.indexOf(m.getDeclaringClass()) + 1) < supers.size()) {
            String name = m.getName();
            Class<?>[] pTypes = m.getParameterTypes();
            ListIterator<Class<?>> lit = supers.listIterator(startIndex);
            while (lit.hasNext()) {
                Class<?> subClass = lit.next();
                try {
                    subClass.getDeclaredMethod(name, pTypes);
                    return true;
                }
                catch (NoSuchMethodException e) {
                }
            }
        }
        return false;
    }

    public static void populateBindingMapsWithInterceptorBindings(Class<?>[] interceptorClasses, Map<String, InterceptorType> interceptorTypeMap, Map<String, String> ejbRefMap, Map<String, String> messageDestinationRefMap, Map<String, String> resourceRefMap, Map<String, String> resourceEnvRefMap, String ejbName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateBindingMapsWithInterceptorBindings");
        }
        for (Class<?> interceptorClass : interceptorClasses) {
            List<Object> refList;
            String name = interceptorClass.getName();
            InterceptorType interceptorType = interceptorTypeMap.get(name);
            if (interceptorType == null || (refList = interceptorType.getEjbRefOrResourceRefOrResourceEnvRef()) == null || refList.isEmpty()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "populating binding maps for interceptor class: " + name);
            }
            for (Object refType : refList) {
                String old;
                String value;
                String key;
                Object ref;
                if (refType instanceof EjbRefType) {
                    ref = (EjbRefType)refType;
                    key = ((EjbRefType)ref).getName();
                    old = ejbRefMap.put(key, value = ((EjbRefType)ref).getBindingName());
                    if (old == null || old.equals(value)) continue;
                    Tr.warning(tc, "DUPLICATE_REF_STANZA_CNTR0184W", new Object[]{moduleName, "ejb-ref", key, name, ejbName});
                    continue;
                }
                if (refType instanceof ResourceRefType) {
                    ref = (ResourceRefType)refType;
                    key = ((ResourceRefType)ref).getName();
                    old = resourceRefMap.put(key, value = ((ResourceRefType)ref).getBindingName());
                    if (old == null || old.equals(value)) continue;
                    Tr.warning(tc, "DUPLICATE_REF_STANZA_CNTR0184W", new Object[]{moduleName, "resource-ref", key, name, ejbName});
                    continue;
                }
                if (refType instanceof ResourceEnvRefType) {
                    ref = (ResourceEnvRefType)refType;
                    key = ((ResourceEnvRefType)ref).getName();
                    old = resourceEnvRefMap.put(key, value = ((ResourceEnvRefType)ref).getBindingName());
                    if (old == null || old.equals(value)) continue;
                    Tr.warning(tc, "DUPLICATE_REF_STANZA_CNTR0184W", new Object[]{moduleName, "resource-env-ref", key, name, ejbName});
                    continue;
                }
                if (!(refType instanceof MessageDestinationRefType) || (old = messageDestinationRefMap.put(key = ((MessageDestinationRefType)(ref = (MessageDestinationRefType)refType)).getName(), value = ((MessageDestinationRefType)ref).getBindingName())) == null || old.equals(value)) continue;
                Tr.warning(tc, "DUPLICATE_REF_STANZA_CNTR0184W", new Object[]{moduleName, "message-destination-ref", key, name, ejbName});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateBindingMapsWithInterceptorBindings");
        }
    }

    public static void updateListWithInterceptorResRefBindingData(J2EEName j2eeName, Class<?>[] interceptorClasses, Map<String, InterceptorType> interceptorTypeMap, ResRefListImpl resRefList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateListWithInterceptorResRefBindingData");
        }
        for (Class<?> interceptorClass : interceptorClasses) {
            List<ResourceRefType> rrtList;
            List<Object> refList;
            String name = interceptorClass.getName();
            InterceptorType interceptorType = interceptorTypeMap.get(name);
            if (interceptorType == null || (refList = interceptorType.getEjbRefOrResourceRefOrResourceEnvRef()) == null || refList.isEmpty() || (rrtList = InterceptorMetaDataHelper.getResourceRefTypeList(refList)).isEmpty()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "updating ResRefListImpl for EJB: " + j2eeName + ", with ResourceRefType data from interceptor class: " + name);
            }
            resRefList.addEjbResourceRefType(rrtList);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateListWithInterceptorResRefBindingData");
        }
    }

    private static List<ResourceRefType> getResourceRefTypeList(List<Object> refTypeList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceRefTypeList");
        }
        ArrayList<ResourceRefType> result = new ArrayList<ResourceRefType>();
        if (refTypeList != null) {
            for (Object refType : refTypeList) {
                if (!(refType instanceof ResourceRefType)) continue;
                ResourceRefType ref = (ResourceRefType)refType;
                result.add(ref);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceRefTypeList returning: " + result);
        }
        return result;
    }
}

