/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.interceptors.InterceptorMetaData;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.metadata.ejb.EJBInterceptorBinding;
import com.ibm.ws.metadata.ejb.InterceptorMetaDataHelper;
import com.ibm.ws.metadata.ejb.InterceptorMethodKind;
import com.ibm.ws.util.WCCMHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.SessionBean;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMetaDataFactory {
    private static final String CLASS_NAME = InterceptorMetaDataFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJB3Interceptors", "com.ibm.ejs.container.container");
    private static final List<String> EMPTY_LIST = new LinkedList<String>();
    private final BeanMetaData ivBmd;
    private final Class<?> ivEjbClass;
    private final J2EEName ivJ2EEName;
    private final String ivEjbName;
    private final ClassLoader ivClassLoader;
    private EJBModuleMetaDataImpl ivEJBModuleMetaDataImpl;
    private Method[] ivAllMethodsOfEJB;
    private final ArrayList<String> ivClassInterceptorNames = new ArrayList();
    private final ArrayList<String> ivDefaultInterceptorNames = new ArrayList();
    private final HashMap<String, Class<?>> ivInterceptorNameToClassMap = new HashMap();
    private List<EJBInterceptorBinding> ivInterceptorBinding;
    private EJBInterceptorBinding ivModuleInterceptorBinding;
    private EJBInterceptorBinding ivClassInterceptorBinding;
    private boolean ivExcludeDefaultFromClassLevel;
    private final ArrayList<Class<?>> ivInterceptorClasses = new ArrayList();
    private final ArrayList<InterceptorProxy> ivAroundInvokeList = new ArrayList();
    private final ArrayList<InterceptorProxy> ivPostConstructList = new ArrayList();
    private final ArrayList<InterceptorProxy> ivPostActivateList = new ArrayList();
    private final ArrayList<InterceptorProxy> ivPrePassivateList = new ArrayList();
    private final ArrayList<InterceptorProxy> ivPreDestroyList = new ArrayList();
    private Map<Method, ArrayList<EJBMethodInfoImpl>> ivEJBMethodInfoMap;
    private final HashMap<String, EJBInterceptorBinding> ivStyle3InterceptorBindingMap = new HashMap();
    private final HashMap<String, EJBInterceptorBinding> ivStyle4InterceptorBindingMap = new HashMap();
    private boolean ivHasInterceptorMethods;
    private boolean ivHasComponentInterface;
    private boolean ivMDB;
    private boolean ivSLSB;
    private boolean ivSFSB;
    private EnumSet<InterceptorKind> ivClassLevelSet = EnumSet.noneOf(InterceptorKind.class);
    private boolean ivMetadataComplete;

    public static InterceptorMetaData createInterceptorMetaData(BeanMetaData bmd, Map<Method, ArrayList<EJBMethodInfoImpl>> methodInfoMap) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createInterceptorMetaData");
        }
        EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)bmd.getModuleMetaData();
        InterceptorMetaDataFactory factory = new InterceptorMetaDataFactory(mmd, bmd);
        factory.ivEJBMethodInfoMap = methodInfoMap;
        if (factory.ivInterceptorBinding != null) {
            factory.validateInterceptorBindings();
        }
        factory.setExcludeDefaultInterceptors();
        factory.addDefaultInterceptors();
        factory.addClassLevelInterceptors();
        ArrayList<String> orderedList = factory.orderClassLevelInterceptors();
        factory.updateInterceptorProxyLists(orderedList);
        factory.updateEJBMethodInfoInterceptorProxies();
        InterceptorMetaData imd = factory.getInterceptorMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createInterceptorMetaData returning: " + imd);
        }
        return imd;
    }

    private void validateInterceptorBindings() throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateInterceptorBindings");
        }
        for (EJBInterceptorBinding binding : this.ivInterceptorBinding) {
            String methodName;
            String ejbName = binding.getEJBName();
            EJBInterceptorBinding.BindingStyle bindingStyle = binding.getBindingStyle();
            if (ejbName.equals("*")) {
                if (this.ivModuleInterceptorBinding == null) {
                    this.ivModuleInterceptorBinding = binding;
                    continue;
                }
                J2EEName j2eeName = this.ivEJBModuleMetaDataImpl.getJ2EEName();
                String message = "The " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application has more than one style 1 interceptor-binding in the deployment" + " deployment descriptor. Only one style 1 interceptor-binding is allowed";
                Tr.error(tc, "DUPLICATE_STYLE_1_INTERCEPTOR_BINDING_CNTR0245E", new Object[]{j2eeName.getModule(), j2eeName.getApplication()});
                throw new EJBConfigurationException(message);
            }
            if (!ejbName.equals(this.ivEjbName)) continue;
            if (bindingStyle == EJBInterceptorBinding.BindingStyle.STYLE2) {
                if (this.ivClassInterceptorBinding == null) {
                    this.ivClassInterceptorBinding = binding;
                    continue;
                }
                EJBInterceptorBinding binding1 = this.ivClassInterceptorBinding;
                this.ivClassInterceptorBinding = this.validateAndMergeStyle2Bindings(binding1, binding);
                continue;
            }
            if (bindingStyle == EJBInterceptorBinding.BindingStyle.STYLE3) {
                methodName = binding.getMethodName();
                EJBInterceptorBinding oldBinding = this.ivStyle3InterceptorBindingMap.put(methodName, binding);
                if (oldBinding != null) {
                    EJBInterceptorBinding merged = this.validateAndMergeStyle3Or4Bindings(methodName, null, oldBinding, binding);
                    this.ivStyle3InterceptorBindingMap.put(methodName, merged);
                    continue;
                }
                boolean notFound = true;
                Set<Method> businessMethodSet = this.ivEJBMethodInfoMap.keySet();
                for (Method m : businessMethodSet) {
                    if (!m.getName().equals(methodName)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "method not found for interceptor binding");
                    binding.dump();
                }
                String j2eeName = ((Object)this.ivJ2EEName).toString();
                Tr.error(tc, "BUSINESS_METHOD_NOT_FOUND_FOR_INTERCEPTOR_BINDING_CNTR0244E", new Object[]{methodName, j2eeName, "3"});
                String message = "The " + methodName + " method name is not found " + " in one of the business interfaces of the " + j2eeName + " enterprise bean. A style 3 interceptor-binding element requires" + " the method to be a business method of the enterprise bean";
                throw new EJBConfigurationException(message);
            }
            if (bindingStyle != EJBInterceptorBinding.BindingStyle.STYLE4) continue;
            methodName = binding.getMethodName();
            List<String> methodParms = binding.getMethodParms();
            String signature = WCCMHelper.methodSignature(methodName, methodParms);
            EJBInterceptorBinding oldBinding = this.ivStyle4InterceptorBindingMap.put(signature = WCCMHelper.normalizeSignature(signature.trim()), binding);
            if (oldBinding != null) {
                EJBInterceptorBinding merged = this.validateAndMergeStyle3Or4Bindings(methodName, signature, oldBinding, binding);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "replaced style 4 for method signature: " + signature);
                }
                this.ivStyle4InterceptorBindingMap.put(signature, merged);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added style 4 for method signature: " + signature);
            }
            boolean notFound = true;
            Set<Method> businessMethodSet = this.ivEJBMethodInfoMap.keySet();
            for (Method m : businessMethodSet) {
                String methodSignature;
                if (!m.getName().equals(methodName) || !signature.equals(methodSignature = MethodAttribUtils.methodSignature(m))) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "method not found for interceptor binding");
                binding.dump();
            }
            String j2eeName = ((Object)this.ivJ2EEName).toString();
            Tr.error(tc, "BUSINESS_METHOD_NOT_FOUND_FOR_INTERCEPTOR_BINDING_CNTR0244E", new Object[]{methodName, j2eeName, "4"});
            String message = "The " + methodName + " method name is not found " + " in one of the business interfaces of the " + j2eeName + " enterprise bean. A style 4 interceptor-binding element requires" + " the method to be a business method of the enterprise bean";
            throw new EJBConfigurationException(message);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInterceptorBindings");
        }
    }

    private EJBInterceptorBinding validateAndMergeStyle2Bindings(EJBInterceptorBinding binding1, EJBInterceptorBinding binding2) throws EJBConfigurationException {
        ArrayList<String> interceptorNames = binding1.ivInterceptorClassNames;
        if (!binding2.ivInterceptorClassNames.isEmpty()) {
            interceptorNames.addAll(binding2.ivInterceptorClassNames);
        }
        ArrayList<String> interceptorOrder = binding1.ivInterceptorOrder;
        if (!binding2.ivInterceptorOrder.isEmpty()) {
            interceptorOrder.addAll(binding2.ivInterceptorOrder);
        }
        Boolean excludeDefault = binding1.ivExcludeDefaultLevelInterceptors;
        if (binding2.ivExcludeDefaultLevelInterceptors != null) {
            excludeDefault = binding2.ivExcludeDefaultLevelInterceptors;
        }
        EJBInterceptorBinding mergedBinding = new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder);
        if (excludeDefault != null) {
            mergedBinding.setExcludeDefaultInterceptors(excludeDefault);
        }
        return mergedBinding;
    }

    private EJBInterceptorBinding validateAndMergeStyle3Or4Bindings(String methodName, String signature, EJBInterceptorBinding binding1, EJBInterceptorBinding binding2) throws EJBConfigurationException {
        ArrayList<String> interceptorNames = binding1.ivInterceptorClassNames;
        if (!binding2.ivInterceptorClassNames.isEmpty()) {
            interceptorNames.addAll(binding2.ivInterceptorClassNames);
        }
        ArrayList<String> interceptorOrder = binding1.ivInterceptorOrder;
        if (!binding2.ivInterceptorOrder.isEmpty()) {
            interceptorOrder.addAll(binding2.ivInterceptorOrder);
        }
        Boolean excludeDefault = binding1.ivExcludeDefaultLevelInterceptors;
        if (binding2.ivExcludeDefaultLevelInterceptors != null) {
            excludeDefault = binding2.ivExcludeDefaultLevelInterceptors;
        }
        Boolean excludeClass = binding1.ivExcludeClassLevelInterceptors;
        if (binding2.ivExcludeClassLevelInterceptors != null) {
            excludeClass = binding2.ivExcludeClassLevelInterceptors;
        }
        EJBInterceptorBinding mergedBinding = signature == null ? new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder, methodName, null) : new EJBInterceptorBinding(binding1.ivEjbName, interceptorNames, interceptorOrder, methodName, binding1.ivMethodParms);
        if (excludeClass != null) {
            mergedBinding.setExcludeClassLevelInterceptors(excludeClass);
        }
        if (excludeDefault != null) {
            mergedBinding.setExcludeDefaultInterceptors(excludeDefault);
        }
        return mergedBinding;
    }

    private InterceptorMetaDataFactory(EJBModuleMetaDataImpl mmd, BeanMetaData bmd) throws EJBConfigurationException {
        this.ivBmd = bmd;
        this.ivMetadataComplete = bmd.metadataComplete;
        this.ivEjbClass = bmd.enterpriseBeanClass;
        this.ivJ2EEName = bmd.getJ2EEName();
        this.ivEjbName = bmd.enterpriseBeanName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "InterceptorMetaDataFactory for J2EEName = " + this.ivJ2EEName);
        }
        this.ivClassLoader = bmd.classLoader;
        this.ivEJBModuleMetaDataImpl = mmd;
        this.ivHasComponentInterface = false;
        this.ivMDB = false;
        this.ivSLSB = false;
        this.ivSFSB = false;
        if (bmd.type == 6) {
            this.ivMDB = true;
            this.ivHasComponentInterface = MessageDriven.class.isAssignableFrom(this.ivEjbClass);
        } else if (bmd.type == 2) {
            this.ivSLSB = true;
            this.ivHasComponentInterface = SessionBean.class.isAssignableFrom(this.ivEjbClass);
        } else {
            this.ivSFSB = true;
            this.ivHasComponentInterface = SessionBean.class.isAssignableFrom(this.ivEjbClass);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ivHasComponentInterface = " + this.ivHasComponentInterface + " for bmd.enterpriseBeanClass = " + this.ivEjbClass.getName());
        }
        this.ivAllMethodsOfEJB = this.ivEjbClass.getMethods();
        if (this.ivEJBModuleMetaDataImpl.ivInterceptorBindingMap != null) {
            List<EJBInterceptorBinding> list = this.ivEJBModuleMetaDataImpl.getEJBInterceptorBindings("*");
            if (list != null && list.size() > 0) {
                if (list.size() == 1) {
                    this.ivModuleInterceptorBinding = list.get(0);
                } else {
                    J2EEName j2eeName = this.ivEJBModuleMetaDataImpl.getJ2EEName();
                    String message = "The " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application has more than one style 1 interceptor-binding in the deployment" + " deployment descriptor. Only one style 1 interceptor-binding is allowed";
                    Tr.error(tc, "DUPLICATE_STYLE_1_INTERCEPTOR_BINDING_CNTR0245E", new Object[]{j2eeName.getModule(), j2eeName.getApplication()});
                    throw new EJBConfigurationException(message);
                }
            }
            this.ivInterceptorBinding = this.ivEJBModuleMetaDataImpl.removeEJBInterceptorBindings(this.ivEjbName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "InterceptorMetaDataFactory for EJBName = " + this.ivEjbName + ", metadata-complete = " + this.ivMetadataComplete);
        }
    }

    private InterceptorMetaDataFactory() {
        throw new UnsupportedOperationException();
    }

    private void setExcludeDefaultInterceptors() {
        EJBInterceptorBinding binding = this.ivClassInterceptorBinding;
        boolean useAnnotation = false;
        if (binding == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else {
            Boolean exclude = binding.ivExcludeDefaultLevelInterceptors;
            if (exclude == null) {
                useAnnotation = !this.ivMetadataComplete;
            } else {
                this.ivExcludeDefaultFromClassLevel = exclude == Boolean.TRUE;
            }
        }
        if (useAnnotation) {
            ExcludeDefaultInterceptors a = this.ivEjbClass.getAnnotation(ExcludeDefaultInterceptors.class);
            this.ivExcludeDefaultFromClassLevel = a != null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setExcludeDefaultInterceptors: " + this.ivExcludeDefaultFromClassLevel);
        }
    }

    private InterceptorMetaData getInterceptorMetaData() {
        if (this.ivHasInterceptorMethods) {
            Class[] classes = this.ivInterceptorClasses.toArray(new Class[0]);
            InterceptorProxy[] temp = new InterceptorProxy[]{};
            InterceptorMetaData imd = new InterceptorMetaData(classes, this.ivAroundInvokeList.toArray(temp), this.ivPostConstructList.toArray(temp), this.ivPostActivateList.toArray(temp), this.ivPrePassivateList.toArray(temp), this.ivPreDestroyList.toArray(temp));
            return imd;
        }
        return null;
    }

    private void addDefaultInterceptors() throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addDefaultInterceptorNames");
        }
        AbstractList names = new LinkedList();
        if (this.ivModuleInterceptorBinding != null) {
            if (!this.ivModuleInterceptorBinding.ivInterceptorClassNames.isEmpty()) {
                names = this.ivModuleInterceptorBinding.ivInterceptorClassNames;
            } else if (!this.ivModuleInterceptorBinding.ivInterceptorOrder.isEmpty()) {
                names = this.ivModuleInterceptorBinding.ivInterceptorOrder;
            }
        }
        if (names.size() > 0) {
            String classNameToLoad = null;
            try {
                for (String name : names) {
                    Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                    if (interceptorClass == null) {
                        classNameToLoad = name;
                        interceptorClass = this.ivClassLoader.loadClass(name);
                        this.ivInterceptorNameToClassMap.put(name, interceptorClass);
                    }
                    this.ivInterceptorClasses.add(interceptorClass);
                }
                this.ivDefaultInterceptorNames.addAll(names);
            }
            catch (ClassNotFoundException ex) {
                EJBConfigurationException cex = new EJBConfigurationException(classNameToLoad + " could not be found or loaded", ex);
                Tr.error(tc, "BEANCLASS_NOT_FOUND_CNTR0075E", classNameToLoad);
                throw cex;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addDefaultInterceptorNames: " + this.ivDefaultInterceptorNames);
        }
    }

    private void addClassLevelInterceptors() throws EJBConfigurationException {
        Interceptors cli;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addClassLevelInterceptors for EJB name: " + this.ivEjbName);
        }
        if (!this.ivMetadataComplete && (cli = this.ivEjbClass.getAnnotation(Interceptors.class)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "processing @Interceptor annotation for EJB name");
            }
            Class[] classes = cli.value();
            ArrayList<String> names = new ArrayList<String>();
            for (Class interceptorClass : classes) {
                String name = interceptorClass.getName();
                names.add(name);
                Class<?> oldClass = this.ivInterceptorNameToClassMap.get(name);
                if (oldClass == null) {
                    this.ivInterceptorNameToClassMap.put(name, interceptorClass);
                }
                this.ivInterceptorClasses.add(interceptorClass);
            }
            this.ivClassInterceptorNames.addAll(names);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, names + " were annotated with @Interceptor annotation at class level");
            }
        }
        if (this.ivClassInterceptorBinding != null) {
            ArrayList<String> classInterceptorNames = this.ivClassInterceptorBinding.ivInterceptorClassNames;
            ArrayList<String> interceptorOrder = this.ivClassInterceptorBinding.ivInterceptorOrder;
            if (!classInterceptorNames.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updating class level list with InterceptorBinding list: " + classInterceptorNames);
                }
                this.updateNamesToClassMap(classInterceptorNames);
                this.ivClassInterceptorNames.addAll(classInterceptorNames);
            } else if (!interceptorOrder.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "updating class level list with InterceptorBinding order list: " + interceptorOrder);
                }
                HashSet<String> set = new HashSet<String>(interceptorOrder);
                set.removeAll(this.ivDefaultInterceptorNames);
                set.removeAll(this.ivClassInterceptorNames);
                if (!set.isEmpty()) {
                    this.updateNamesToClassMap(set);
                    this.ivClassInterceptorNames.addAll(set);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addClassLevelInterceptors returning: " + this.ivClassInterceptorNames + " for EJB name: " + this.ivEjbName);
        }
    }

    private void updateNamesToClassMap(Collection<String> classInterceptorNames) throws EJBConfigurationException {
        String classNameToLoad = null;
        try {
            for (String name : classInterceptorNames) {
                Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                if (interceptorClass == null) {
                    classNameToLoad = name;
                    interceptorClass = this.ivClassLoader.loadClass(name);
                    this.ivInterceptorNameToClassMap.put(name, interceptorClass);
                }
                this.ivInterceptorClasses.add(interceptorClass);
            }
        }
        catch (ClassNotFoundException ex) {
            Tr.error(tc, "BEANCLASS_NOT_FOUND_CNTR0075E", classNameToLoad);
            EJBConfigurationException cex = new EJBConfigurationException(classNameToLoad + " could not be found or loaded", ex);
            throw cex;
        }
    }

    private ArrayList<String> addMethodLevelInterceptors(Method method, EJBInterceptorBinding methodBinding) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addMethodLevelInterceptors method: " + method.getName());
        }
        ArrayList<String> interceptorNames = new ArrayList<String>();
        if (!this.ivMetadataComplete) {
            Interceptors methodLevelInterceptors = method.getAnnotation(Interceptors.class);
            String methodName = method.getName();
            if (methodLevelInterceptors != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing @Interceptor annotation for method: " + methodName + ", EJB name: " + this.ivEjbName);
                }
                Class[] classes = methodLevelInterceptors.value();
                ArrayList<String> names = new ArrayList<String>();
                for (Class c : classes) {
                    names.add(c.getName());
                }
                for (Class interceptorClass : classes) {
                    String name = interceptorClass.getName();
                    if (!this.ivInterceptorNameToClassMap.containsKey(name)) {
                        this.ivInterceptorNameToClassMap.put(name, interceptorClass);
                    }
                    this.ivInterceptorClasses.add(interceptorClass);
                }
                interceptorNames.addAll(names);
            }
        }
        if (methodBinding != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "processing interceptor binding for method: " + method);
            }
            ArrayList<String> names = methodBinding.ivInterceptorClassNames;
            String classNameToLoad = null;
            try {
                for (String name : names) {
                    Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                    if (interceptorClass == null) {
                        classNameToLoad = name;
                        interceptorClass = this.ivClassLoader.loadClass(name);
                        this.ivInterceptorNameToClassMap.put(name, interceptorClass);
                    }
                    this.ivInterceptorClasses.add(interceptorClass);
                }
                interceptorNames.addAll(names);
            }
            catch (ClassNotFoundException ex) {
                Tr.error(tc, "BEANCLASS_NOT_FOUND_CNTR0075E", classNameToLoad);
                EJBConfigurationException cex = new EJBConfigurationException(classNameToLoad + " could not be found or loaded", ex);
                throw cex;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addMethodLevelInterceptors: " + interceptorNames);
        }
        return interceptorNames;
    }

    private void updateEJBMethodInfoInterceptorProxies() throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateEJBMethodInfoInterceptorProxies: " + this.ivEjbName);
        }
        for (Method m : this.ivAllMethodsOfEJB) {
            EJBInterceptorBinding binding = this.findInterceptorBindingForMethod(m);
            boolean excludeClassInterceptors = this.isClassInterceptorsExcluded(m, binding);
            boolean excludeDefaultInterceptors = this.isDefaultInterceptorsExcluded(m, binding);
            ArrayList<String> interceptors = this.addMethodLevelInterceptors(m, binding);
            List<String> order = binding != null ? binding.ivInterceptorOrder : EMPTY_LIST;
            String methodName = m.getName();
            InterceptorProxy[] proxies = this.getMethodLevelAroundInvoke(methodName, interceptors, excludeClassInterceptors, excludeDefaultInterceptors, order);
            if (proxies == null) continue;
            this.ivHasInterceptorMethods = true;
            this.updateEJBMethodInfo(m, proxies);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEJBMethodInfoInterceptorProxies: " + this.ivJ2EEName);
        }
    }

    private InterceptorProxy[] getMethodLevelAroundInvoke(String methodName, ArrayList<String> methodLevelInterceptors, boolean excludeClassInterceptors, boolean excludeDefaultInterceptors, List<String> order) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMethodLevelAroundInvoke: " + methodName);
        }
        EnumSet<InterceptorKind> methodSet = EnumSet.noneOf(InterceptorKind.class);
        ArrayList<String> interceptors = new ArrayList<String>();
        if (!(excludeDefaultInterceptors || this.ivExcludeDefaultFromClassLevel || this.ivDefaultInterceptorNames.isEmpty())) {
            interceptors.addAll(this.ivDefaultInterceptorNames);
            methodSet.add(InterceptorKind.DEFAULT);
        }
        if (!excludeClassInterceptors && !this.ivClassInterceptorNames.isEmpty()) {
            interceptors.addAll(this.ivClassInterceptorNames);
            methodSet.add(InterceptorKind.CLASS_LEVEL);
        }
        if (methodLevelInterceptors.size() > 0) {
            interceptors.addAll(methodLevelInterceptors);
            methodSet.add(InterceptorKind.METHOD_LEVEL);
        }
        InterceptorProxy[] proxies = null;
        if (methodSet.isEmpty()) {
            ArrayList<InterceptorProxy> aroundInvoke;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no default, class-level, or method-level interceptors.");
            }
            if ((aroundInvoke = this.buildAroundInvokeProxies(new ArrayList<String>())).size() > 0) {
                proxies = aroundInvoke.toArray(new InterceptorProxy[0]);
            }
        } else if (order.size() > 0) {
            ArrayList<String> orderedList;
            ArrayList<InterceptorProxy> aroundInvoke;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Atleast 1 default, class-level, or method-level interceptors and interceptor-order specified.");
            }
            if ((aroundInvoke = this.buildAroundInvokeProxies(orderedList = this.orderMethodLevelInterceptors(methodName, methodSet, interceptors, order))).size() > 0) {
                proxies = aroundInvoke.toArray(new InterceptorProxy[0]);
            }
        } else if (methodSet.equals(this.ivClassLevelSet)) {
            if (this.ivAroundInvokeList.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "default list for all methods of class used.");
                }
                proxies = this.ivAroundInvokeList.toArray(new InterceptorProxy[0]);
            }
        } else {
            ArrayList<InterceptorProxy> aroundInvoke = this.buildAroundInvokeProxies(interceptors);
            if (aroundInvoke.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "unique interceptor list for the method: " + interceptors);
                }
                proxies = aroundInvoke.toArray(new InterceptorProxy[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (proxies != null) {
                Tr.exit(tc, "getMethodLevelAroundInvoke returning proxy list for method: " + methodName);
            } else {
                Tr.exit(tc, "getMethodLevelAroundInvoke returning null proxy list for method: " + methodName);
            }
        }
        return proxies;
    }

    private void updateEJBMethodInfo(Method method, InterceptorProxy[] proxies) {
        ArrayList<EJBMethodInfoImpl> list = this.ivEJBMethodInfoMap.get(method);
        if (list != null) {
            for (EJBMethodInfoImpl info : list) {
                info.setAroundInvokeInterceptorProxies(proxies);
            }
        }
    }

    private boolean isDefaultInterceptorsExcluded(Method m, EJBInterceptorBinding binding) {
        Boolean exclude = Boolean.FALSE;
        boolean useAnnotation = false;
        if (this.ivExcludeDefaultFromClassLevel) {
            exclude = Boolean.TRUE;
        } else if (binding == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else if (binding.ivExcludeDefaultLevelInterceptors == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else {
            exclude = binding.ivExcludeDefaultLevelInterceptors;
        }
        if (useAnnotation) {
            exclude = m.getAnnotation(ExcludeDefaultInterceptors.class) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isDefaultInterceptorsExcluded for " + m.getDeclaringClass() + "." + m.getName() + " returning: " + exclude);
        }
        return exclude;
    }

    private boolean isClassInterceptorsExcluded(Method m, EJBInterceptorBinding binding) {
        Boolean exclude = Boolean.FALSE;
        boolean useAnnotation = false;
        if (binding == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else if (binding.ivExcludeClassLevelInterceptors == null) {
            useAnnotation = !this.ivMetadataComplete;
        } else {
            exclude = binding.ivExcludeClassLevelInterceptors;
        }
        if (useAnnotation) {
            exclude = m.getAnnotation(ExcludeClassInterceptors.class) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "isClassInterceptorsExcluded for " + m.getDeclaringClass() + "." + m.getName() + " returning: " + exclude);
        }
        return exclude;
    }

    private void updateInterceptorProxyLists(ArrayList<String> orderedList) throws EJBConfigurationException {
        int n;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateInterceptorProxyLists: " + this.ivEjbName);
        }
        if ((n = orderedList.size()) > 0) {
            for (String name : orderedList) {
                Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                int interceptorIndex = this.ivInterceptorClasses.indexOf(interceptorClass);
                this.addInterceptorProxies(interceptorClass, interceptorIndex);
            }
        }
        this.addInterceptorProxies(this.ivEjbClass, -1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateInterceptorProxyLists: " + this.ivEjbName);
        }
    }

    private void addInterceptorProxies(Class<?> interceptorOrEjbClass, int index) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addInterceptorProxies: " + interceptorOrEjbClass.getName());
        }
        LinkedList<Class<?>> supers = InterceptorMetaDataHelper.getLIFOSuperClassesList(interceptorOrEjbClass);
        EnumMap<InterceptorMethodKind, List<Method>> enumMap = null;
        if (interceptorOrEjbClass == this.ivEjbClass) {
            EnterpriseBean bean = this.ivBmd.wccm.enterpriseBean;
            if (bean != null) {
                enumMap = InterceptorMetaDataHelper.getEJBInterceptorMethods(this.ivEjbClass, bean, supers, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
            }
        } else {
            IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> interceptorsMap = this.ivEJBModuleMetaDataImpl.ivInterceptorsMap;
            if (interceptorsMap != null) {
                enumMap = interceptorsMap.get(interceptorOrEjbClass);
            }
        }
        for (Class clazz : supers) {
            Method[] methods;
            boolean ejbCallbackMethodRequired;
            boolean ejbClass = index < 0;
            boolean bl = ejbCallbackMethodRequired = ejbClass && this.ivHasComponentInterface;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && ejbClass) {
                Tr.debug(tc, "processing EJB class, ivHasComponentInterface = " + this.ivHasComponentInterface);
            }
            InterceptorProxy aroundInvokeProxy = null;
            InterceptorProxy postActivateProxy = null;
            InterceptorProxy postConstructProxy = null;
            InterceptorProxy prePassivateProxy = null;
            InterceptorProxy preDestroyProxy = null;
            if (enumMap != null) {
                Object[] data;
                List<Method> methodList = enumMap.get((Object)InterceptorMethodKind.AROUND_INVOKE);
                if (methodList != null) {
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers) || m.getDeclaringClass() != clazz) continue;
                        if (aroundInvokeProxy == null) {
                            aroundInvokeProxy = new InterceptorProxy(m, index);
                            this.ivAroundInvokeList.add(aroundInvokeProxy);
                            this.ivHasInterceptorMethods = true;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "addInterceptorProxies adding around invoke: " + aroundInvokeProxy);
                            continue;
                        }
                        String className = clazz.getName();
                        data = new Object[]{className, "around-invoke"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("Only one around-invoke interceptor method is allowed in class " + className);
                    }
                }
                if ((methodList = enumMap.get((Object)InterceptorMethodKind.POST_CONSTRUCT)) != null) {
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (ejbCallbackMethodRequired) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.POST_CONSTRUCT, m, false);
                        }
                        if (m.getDeclaringClass() != clazz) continue;
                        if (postConstructProxy == null) {
                            postConstructProxy = new InterceptorProxy(m, index);
                            this.ivPostConstructList.add(postConstructProxy);
                            this.ivHasInterceptorMethods = true;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "addInterceptorProxies adding post construct: " + postConstructProxy);
                            continue;
                        }
                        String className = clazz.getName();
                        data = new Object[]{className, "post-construct"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("Only one post-construct interceptor method is allowed in class " + className);
                    }
                }
                if ((methodList = enumMap.get((Object)InterceptorMethodKind.POST_ACTIVATE)) != null) {
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (ejbCallbackMethodRequired && this.ivSFSB) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.POST_ACTIVATE, m, false);
                        }
                        if (m.getDeclaringClass() != clazz) continue;
                        if (postActivateProxy == null) {
                            postActivateProxy = new InterceptorProxy(m, index);
                            this.ivPostActivateList.add(postActivateProxy);
                            this.ivHasInterceptorMethods = true;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "addInterceptorProxies adding post activate: " + postActivateProxy);
                            continue;
                        }
                        String className = clazz.getName();
                        data = new Object[]{className, "post-activate"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("Only one post-construct interceptor method is allowed in class " + className);
                    }
                }
                if ((methodList = enumMap.get((Object)InterceptorMethodKind.PRE_PASSIVATE)) != null) {
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (ejbCallbackMethodRequired && this.ivSFSB) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.PRE_PASSIVATE, m, false);
                        }
                        if (m.getDeclaringClass() != clazz) continue;
                        if (prePassivateProxy == null) {
                            prePassivateProxy = new InterceptorProxy(m, index);
                            this.ivPrePassivateList.add(prePassivateProxy);
                            this.ivHasInterceptorMethods = true;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "addInterceptorProxies adding pre passivate: " + prePassivateProxy);
                            continue;
                        }
                        String className = clazz.getName();
                        data = new Object[]{className, "pre-passivate"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("PrePassivate can only be applied to ejbPassivate method of class " + className);
                    }
                }
                if ((methodList = enumMap.get((Object)InterceptorMethodKind.PRE_DESTROY)) != null) {
                    for (Method m : methodList) {
                        if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                        if (ejbCallbackMethodRequired) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.PRE_DESTROY, m, false);
                        }
                        if (m.getDeclaringClass() != clazz) continue;
                        if (preDestroyProxy == null) {
                            preDestroyProxy = new InterceptorProxy(m, index);
                            this.ivPreDestroyList.add(preDestroyProxy);
                            this.ivHasInterceptorMethods = true;
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "addInterceptorProxies adding pre destroy: " + preDestroyProxy);
                            continue;
                        }
                        String className = clazz.getName();
                        data = new Object[]{className, "pre-destroy"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("Only one pre-destroy interceptor method is allowed in class " + className);
                    }
                }
            }
            if (this.ivMetadataComplete) continue;
            for (Method m : methods = clazz.getDeclaredMethods()) {
                PreDestroy pd;
                String className;
                PrePassivate pp;
                Object[] data;
                PostActivate pa;
                PostConstruct pc;
                AroundInvoke ai = m.getAnnotation(AroundInvoke.class);
                if (ai != null && !InterceptorMetaDataHelper.isMethodOverridden(m, supers)) {
                    InterceptorMetaDataHelper.validateAroundInvokeSignature(m);
                    if (aroundInvokeProxy == null) {
                        aroundInvokeProxy = new InterceptorProxy(m, index);
                        this.ivAroundInvokeList.add(aroundInvokeProxy);
                        this.ivHasInterceptorMethods = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "addInterceptorProxies adding around invoke: " + aroundInvokeProxy);
                        }
                    } else if (!m.equals(aroundInvokeProxy.ivInterceptorMethod)) {
                        String className4 = clazz.getName();
                        Object[] data3 = new Object[]{className4, "around-invoke"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data3);
                        throw new EJBConfigurationException("Only one around-invoke interceptor method is allowed in class " + className4);
                    }
                }
                if ((pc = m.getAnnotation(PostConstruct.class)) != null) {
                    if (!InterceptorMetaDataHelper.isMethodOverridden(m, supers)) {
                        if (ejbCallbackMethodRequired) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.POST_CONSTRUCT, m, true);
                        }
                        InterceptorMetaDataHelper.validateLifeCycleSignature("PostConstruct", m, ejbClass, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
                        if (postConstructProxy == null) {
                            postConstructProxy = new InterceptorProxy(m, index);
                            this.ivPostConstructList.add(postConstructProxy);
                            this.ivHasInterceptorMethods = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "addInterceptorProxies adding post construct: " + postConstructProxy);
                            }
                        } else if (!m.equals(postConstructProxy.ivInterceptorMethod)) {
                            String className3 = clazz.getName();
                            Object[] data2 = new Object[]{className3, "post-construct"};
                            Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data2);
                            throw new EJBConfigurationException("Only one post-construct interceptor method is allowed in class " + className3);
                        }
                    }
                } else if (ejbCallbackMethodRequired && (this.ivSLSB || this.ivMDB) && m.getName().equals("ejbCreate") && m.getParameterTypes().length == 0 && m.getReturnType() == Void.TYPE) {
                    if (postConstructProxy == null) {
                        postConstructProxy = new InterceptorProxy(m, index);
                        this.ivPostConstructList.add(postConstructProxy);
                        this.ivHasInterceptorMethods = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "addInterceptorProxies adding a post construct: " + postConstructProxy);
                        }
                    } else if (!m.equals(postConstructProxy.ivInterceptorMethod)) {
                        String className2 = clazz.getName();
                        Object[] data2 = new Object[]{className2, "post-construct"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data2);
                        throw new EJBConfigurationException("PostConstruct can only be applied to ejbCreate method of class " + className2);
                    }
                }
                if ((pa = m.getAnnotation(PostActivate.class)) != null) {
                    if (!InterceptorMetaDataHelper.isMethodOverridden(m, supers)) {
                        if (ejbCallbackMethodRequired && this.ivSFSB) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.POST_ACTIVATE, m, true);
                        }
                        InterceptorMetaDataHelper.validateLifeCycleSignature("PostActivate", m, ejbClass, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
                        if (postActivateProxy == null) {
                            postActivateProxy = new InterceptorProxy(m, index);
                            this.ivPostActivateList.add(postActivateProxy);
                            this.ivHasInterceptorMethods = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "addInterceptorProxies adding post activate: " + postActivateProxy);
                            }
                        } else if (!m.equals(postActivateProxy.ivInterceptorMethod)) {
                            String className2 = clazz.getName();
                            data = new Object[]{className2, "post-activate"};
                            Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                            throw new EJBConfigurationException("Only one post-construct interceptor method is allowed in class " + className2);
                        }
                    }
                } else if (ejbCallbackMethodRequired && this.ivSFSB && m.getName().equals("ejbActivate") && m.getParameterTypes().length == 0 && m.getReturnType() == Void.TYPE) {
                    if (postActivateProxy == null) {
                        postActivateProxy = new InterceptorProxy(m, index);
                        this.ivPostActivateList.add(postActivateProxy);
                        this.ivHasInterceptorMethods = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "addInterceptorProxies adding post activate: " + postActivateProxy);
                        }
                    } else if (!m.equals(postActivateProxy.ivInterceptorMethod)) {
                        String className3 = clazz.getName();
                        data = new Object[]{className3, "post-activate"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                        throw new EJBConfigurationException("PostActivate can only be applied to ejbActivate method of class " + className3);
                    }
                }
                if ((pp = m.getAnnotation(PrePassivate.class)) != null) {
                    if (!InterceptorMetaDataHelper.isMethodOverridden(m, supers)) {
                        if (ejbCallbackMethodRequired && this.ivSFSB) {
                            this.validateEJBCallbackMethod(InterceptorMethodKind.PRE_PASSIVATE, m, true);
                        }
                        InterceptorMetaDataHelper.validateLifeCycleSignature("PrePassivate", m, ejbClass, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
                        if (prePassivateProxy == null) {
                            prePassivateProxy = new InterceptorProxy(m, index);
                            this.ivPrePassivateList.add(prePassivateProxy);
                            this.ivHasInterceptorMethods = true;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "addInterceptorProxies adding pre passivate: " + prePassivateProxy);
                            }
                        } else if (!m.equals(prePassivateProxy.ivInterceptorMethod)) {
                            className = clazz.getName();
                            Object[] data4 = new Object[]{className, "pre-passivate"};
                            Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data4);
                            throw new EJBConfigurationException("Only one pre-passivate interceptor method is allowed in class " + className);
                        }
                    }
                } else if (ejbCallbackMethodRequired && this.ivSFSB && m.getName().equals("ejbPassivate") && m.getParameterTypes().length == 0 && m.getReturnType() == Void.TYPE) {
                    if (prePassivateProxy == null) {
                        prePassivateProxy = new InterceptorProxy(m, index);
                        this.ivPrePassivateList.add(prePassivateProxy);
                        this.ivHasInterceptorMethods = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "addInterceptorProxies adding pre passivate: " + prePassivateProxy);
                        }
                    } else if (!m.equals(prePassivateProxy.ivInterceptorMethod)) {
                        className = clazz.getName();
                        Object[] data5 = new Object[]{className, "pre-passivate"};
                        Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data5);
                        throw new EJBConfigurationException("PrePassivate can only be applied to ejbPassivate method of class " + className);
                    }
                }
                if ((pd = m.getAnnotation(PreDestroy.class)) != null) {
                    if (InterceptorMetaDataHelper.isMethodOverridden(m, supers)) continue;
                    if (ejbCallbackMethodRequired) {
                        this.validateEJBCallbackMethod(InterceptorMethodKind.PRE_DESTROY, m, true);
                    }
                    InterceptorMetaDataHelper.validateLifeCycleSignature("PreDestroy", m, ejbClass, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
                    if (preDestroyProxy == null) {
                        preDestroyProxy = new InterceptorProxy(m, index);
                        this.ivPreDestroyList.add(preDestroyProxy);
                        this.ivHasInterceptorMethods = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "addInterceptorProxies adding pre destroy: " + preDestroyProxy);
                        continue;
                    }
                    if (m.equals(preDestroyProxy.ivInterceptorMethod)) continue;
                    String className5 = clazz.getName();
                    Object[] data6 = new Object[]{className5, "pre-destroy"};
                    Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data6);
                    throw new EJBConfigurationException("Only one pre-destroy interceptor method is allowed in class " + className5);
                }
                if (!ejbCallbackMethodRequired || !m.getName().equals("ejbRemove") || m.getParameterTypes().length != 0 || m.getReturnType() != Void.TYPE) continue;
                if (preDestroyProxy == null) {
                    preDestroyProxy = new InterceptorProxy(m, index);
                    this.ivPreDestroyList.add(preDestroyProxy);
                    this.ivHasInterceptorMethods = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "addInterceptorProxies adding pre destroy: " + preDestroyProxy);
                    continue;
                }
                if (m.equals(preDestroyProxy.ivInterceptorMethod)) continue;
                String className6 = clazz.getName();
                Object[] data7 = new Object[]{className6, "pre-destroy"};
                Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data7);
                throw new EJBConfigurationException("PreDestroy can only be applied to ejbRemove method of class " + className6);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addInterceptorProxies: " + interceptorOrEjbClass.getName());
        }
    }

    private void validateEJBCallbackMethod(InterceptorMethodKind actualKind, Method m, boolean annotation) throws EJBConfigurationException {
        String methodName = m.getName();
        InterceptorMethodKind requiredKind = this.mapEjbCallbackName(methodName);
        if (requiredKind != null && actualKind != requiredKind) {
            String ejbClassName = this.ivEjbClass.getName();
            String required = this.mapInterceptorMethodKind(requiredKind, true, annotation);
            String actual = this.mapInterceptorMethodKind(actualKind, false, annotation);
            StringBuilder sb = new StringBuilder();
            if (this.ivMDB) {
                sb.append("CNTR0243E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the javax.ejb.MessageDriven interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error(tc, "INVALID_MDB_CALLBACK_METHOD_CNTR0243E", new Object[]{ejbClassName, methodName, required, actual});
            } else if (this.ivSLSB) {
                sb.append("CNTR0241E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the javax.ejb.SessionBean interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error(tc, "INVALID_SLSB_CALLBACK_METHOD_CNTR0241E", new Object[]{ejbClassName, methodName, required, actual});
            } else {
                sb.append("CNTR0242E: Because the ").append(ejbClassName);
                sb.append(" enterprise bean implements the javax.ejb.SessionBean interface, the ");
                sb.append(methodName).append(" method must be a ").append(required);
                sb.append(" method and not a ").append(actual).append(" method.");
                Tr.error(tc, "INVALID_SFSB_CALLBACK_METHOD_CNTR0242E", new Object[]{ejbClassName, methodName, required, actual});
            }
            throw new EJBConfigurationException(sb.toString());
        }
    }

    private InterceptorMethodKind mapEjbCallbackName(String methodName) {
        if (methodName.equals("ejbCreate")) {
            return InterceptorMethodKind.POST_CONSTRUCT;
        }
        if (methodName.equals("ejbRemove")) {
            return InterceptorMethodKind.PRE_DESTROY;
        }
        if (methodName.equals("ejbActivate")) {
            return InterceptorMethodKind.POST_ACTIVATE;
        }
        if (methodName.equals("ejbPassivate")) {
            return InterceptorMethodKind.PRE_PASSIVATE;
        }
        return null;
    }

    private String mapInterceptorMethodKind(InterceptorMethodKind kind, boolean honorSFSBMapping, boolean annotation) {
        if (kind == InterceptorMethodKind.POST_CONSTRUCT) {
            if (this.ivSFSB && honorSFSBMapping) {
                if (annotation) {
                    return "@Init";
                }
                return "init-method";
            }
            if (annotation) {
                return "@PostConstruct";
            }
            return "post-construct";
        }
        if (kind == InterceptorMethodKind.PRE_DESTROY) {
            if (annotation) {
                return "@PreDestroy";
            }
            return "pre-destroy";
        }
        if (kind == InterceptorMethodKind.POST_ACTIVATE) {
            if (annotation) {
                return "@PostActivate";
            }
            return "post-activate";
        }
        if (kind == InterceptorMethodKind.PRE_PASSIVATE) {
            if (annotation) {
                return "@PrePassivate";
            }
            return "pre-passivate";
        }
        return "";
    }

    private ArrayList<InterceptorProxy> buildAroundInvokeProxies(List<String> orderedList) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAroundInvokeProxies: orderList = " + orderedList);
        }
        ArrayList<InterceptorProxy> aroundInvoke = new ArrayList<InterceptorProxy>();
        int n = orderedList.size();
        if (n > 0) {
            for (String name : orderedList) {
                Class<?> interceptorClass = this.ivInterceptorNameToClassMap.get(name);
                int interceptorIndex = this.ivInterceptorClasses.indexOf(interceptorClass);
                this.updateAroundInvokeList(aroundInvoke, interceptorClass, interceptorIndex);
            }
        }
        this.updateAroundInvokeList(aroundInvoke, this.ivEjbClass, -1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAroundInvokeProxies: " + this.ivEjbName);
        }
        return aroundInvoke;
    }

    private void updateAroundInvokeList(ArrayList<InterceptorProxy> aroundInvoke, Class<?> interceptorOrEjbClass, int interceptorIndex) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAroundInvokeList: " + interceptorOrEjbClass.getName());
        }
        LinkedList<Class<?>> supers = InterceptorMetaDataHelper.getLIFOSuperClassesList(interceptorOrEjbClass);
        EnumMap<InterceptorMethodKind, List<Method>> enumMap = null;
        if (interceptorOrEjbClass == this.ivEjbClass) {
            EnterpriseBean bean = this.ivBmd.wccm.enterpriseBean;
            if (bean != null) {
                enumMap = InterceptorMetaDataHelper.getEJBInterceptorMethods(this.ivEjbClass, bean, supers, this.ivEJBModuleMetaDataImpl.ivApplicationExceptionMap);
            }
        } else {
            IdentityHashMap<Class<?>, EnumMap<InterceptorMethodKind, List<Method>>> interceptorsMap = this.ivEJBModuleMetaDataImpl.ivInterceptorsMap;
            if (interceptorsMap != null) {
                enumMap = interceptorsMap.get(interceptorOrEjbClass);
            }
        }
        for (Class clazz : supers) {
            Method[] methods;
            List<Method> methodList;
            InterceptorProxy aroundInvokeProxy = null;
            if (enumMap != null && (methodList = enumMap.get((Object)InterceptorMethodKind.AROUND_INVOKE)) != null) {
                for (Method m : methodList) {
                    Object[] data;
                    if (m.getDeclaringClass() != clazz) continue;
                    int mod = m.getModifiers();
                    if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                        String method = m.toGenericString();
                        data = new Object[]{method};
                        Tr.error(tc, "INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", data);
                        throw new EJBConfigurationException(method + " must not be declared as final or static.");
                    }
                    if (aroundInvokeProxy == null) {
                        aroundInvokeProxy = new InterceptorProxy(m, interceptorIndex);
                        aroundInvoke.add(aroundInvokeProxy);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "updateAroundInvokeList adding: " + aroundInvokeProxy);
                        continue;
                    }
                    String className = clazz.getName();
                    data = new Object[]{className, "around-invoke"};
                    Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                    throw new EJBConfigurationException("Only one around-invoke interceptor method is allowed in class " + className);
                }
            }
            if (this.ivMetadataComplete) continue;
            for (Method m : methods = clazz.getDeclaredMethods()) {
                AroundInvoke ai = m.getAnnotation(AroundInvoke.class);
                if (ai == null) continue;
                int mod = m.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                    String method = m.toGenericString();
                    Object[] data = new Object[]{method};
                    Tr.error(tc, "INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", data);
                    throw new EJBConfigurationException(method + " must not be declared as final or static.");
                }
                if (aroundInvokeProxy == null) {
                    aroundInvokeProxy = new InterceptorProxy(m, interceptorIndex);
                    aroundInvoke.add(aroundInvokeProxy);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "updateAroundInvokeList adding: " + aroundInvokeProxy);
                    continue;
                }
                if (m.equals(aroundInvokeProxy.ivInterceptorMethod)) continue;
                String className = clazz.getName();
                Object[] data = new Object[]{className, "around-invoke"};
                Tr.error(tc, "DUPLICATE_INTERCEPTOR_METHOD_CNTR0223E", data);
                throw new EJBConfigurationException("Only one around-invoke interceptor method is allowed in class " + className);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAroundInvokeList: " + interceptorOrEjbClass.getName());
        }
    }

    private EJBInterceptorBinding findInterceptorBindingForMethod(Method method) {
        EJBInterceptorBinding binding;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findInterceptorBindingForMethod: " + method.toString());
        }
        String methodSignature = MethodAttribUtils.methodSignature(method);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lookup style 4 for method signature: " + methodSignature);
        }
        if ((binding = this.ivStyle4InterceptorBindingMap.get(methodSignature)) == null) {
            String methodName = method.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "lookup style 3 for method: " + methodName);
            }
            binding = this.ivStyle3InterceptorBindingMap.get(methodName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (binding != null) {
                Tr.exit(tc, "findInterceptorBindingForMethod found: ");
                binding.dump();
            } else {
                Tr.exit(tc, "findInterceptorBindingForMethod, interceptor-binding not found");
            }
        }
        return binding;
    }

    private ArrayList<String> orderClassLevelInterceptors() throws EJBConfigurationException {
        ArrayList<String> order;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "orderClassLevelInterceptors");
        }
        ArrayList<String> orderedList = new ArrayList<String>();
        if (!this.ivExcludeDefaultFromClassLevel && this.ivDefaultInterceptorNames.size() > 0) {
            orderedList.addAll(this.ivDefaultInterceptorNames);
            this.ivClassLevelSet.add(InterceptorKind.DEFAULT);
        }
        if (this.ivClassInterceptorNames.size() > 0) {
            orderedList.addAll(this.ivClassInterceptorNames);
            this.ivClassLevelSet.add(InterceptorKind.CLASS_LEVEL);
        }
        if (this.ivClassInterceptorBinding != null && !(order = this.ivClassInterceptorBinding.ivInterceptorOrder).isEmpty()) {
            ArrayList<String> interceptorOrder = new ArrayList<String>(order);
            if (interceptorOrder.containsAll(orderedList)) {
                orderedList = interceptorOrder;
            } else {
                ArrayList<String> missingList;
                if (interceptorOrder.size() < orderedList.size()) {
                    orderedList.removeAll(interceptorOrder);
                    missingList = orderedList;
                } else {
                    interceptorOrder.removeAll(orderedList);
                    missingList = interceptorOrder;
                }
                String ejbName = ((Object)this.ivJ2EEName).toString();
                Object[] data = new Object[]{ejbName, order, missingList};
                Tr.warning(tc, "PARTIAL_CLASS_INTERCEPTOR_ORDER_CNTR0227E", data);
                throw new EJBConfigurationException(order + " is not a total ordering of class-level interceptors for EJB " + ejbName + ". It is missing interceptor names: " + missingList);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "orderClassLevelInterceptors: " + orderedList);
        }
        return orderedList;
    }

    private ArrayList<String> orderMethodLevelInterceptors(String methodName, EnumSet<InterceptorKind> methodSet, ArrayList<String> interceptors, List<String> order) throws EJBConfigurationException {
        ArrayList<String> orderedList = new ArrayList<String>();
        if (methodSet.contains((Object)InterceptorKind.DEFAULT)) {
            orderedList.addAll(this.ivDefaultInterceptorNames);
        }
        if (methodSet.contains((Object)InterceptorKind.CLASS_LEVEL)) {
            orderedList.addAll(this.ivClassInterceptorNames);
        }
        if (methodSet.contains((Object)InterceptorKind.METHOD_LEVEL)) {
            orderedList.addAll(interceptors);
        }
        if (order != null) {
            ArrayList<String> interceptorOrder = new ArrayList<String>(order);
            if (interceptorOrder.containsAll(orderedList)) {
                orderedList = interceptorOrder;
            } else {
                ArrayList<String> missingList;
                if (interceptorOrder.size() < orderedList.size()) {
                    orderedList.removeAll(interceptorOrder);
                    missingList = orderedList;
                } else {
                    interceptorOrder.removeAll(orderedList);
                    missingList = interceptorOrder;
                }
                String ejbName = ((Object)this.ivJ2EEName).toString();
                Object[] data = new Object[]{ejbName, methodName, order, missingList};
                Tr.warning(tc, "PARTIAL_METHOD_INTERCEPTOR_ORDER_CNTR0228E", data);
                throw new EJBConfigurationException(order + " is not a total ordering of method-level interceptors for method " + methodName + " of EJB " + ejbName + ". It is missing interceptor names: " + missingList);
            }
        }
        return orderedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InterceptorKind {
        DEFAULT,
        CLASS_LEVEL,
        METHOD_LEVEL;

    }
}

