/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.bindings;

import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.ResourceRefBindingImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPResAuthType;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.ws.ejb.jar.bnd.AuthTypeType;
import com.ibm.ws.ejb.jar.bnd.AuthenticationAliasType;
import com.ibm.ws.ejb.jar.bnd.CmpConnectionFactoryType;
import com.ibm.ws.ejb.jar.bnd.CustomLoginConfigurationType;
import com.ibm.ws.ejb.jar.bnd.EjbJarBndType;
import com.ibm.ws.ejb.jar.bnd.EjbRefType;
import com.ibm.ws.ejb.jar.bnd.EntityType;
import com.ibm.ws.ejb.jar.bnd.InterceptorType;
import com.ibm.ws.ejb.jar.bnd.JcaAdapterType;
import com.ibm.ws.ejb.jar.bnd.ListenerPortType;
import com.ibm.ws.ejb.jar.bnd.MessageDestinationRefType;
import com.ibm.ws.ejb.jar.bnd.MessageDestinationType;
import com.ibm.ws.ejb.jar.bnd.MessageDrivenType;
import com.ibm.ws.ejb.jar.bnd.ObjectFactory;
import com.ibm.ws.ejb.jar.bnd.PropertyType;
import com.ibm.ws.ejb.jar.bnd.ResourceEnvRefType;
import com.ibm.ws.ejb.jar.bnd.ResourceRefType;
import com.ibm.ws.ejb.jar.bnd.SessionType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WCCMHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBModuleHelper {
    private static final String CLASS_NAME = EJBModuleHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String AUTHENICATION_ALIAS_LOGIN_NAME = "DefaultPrincipalMapping";
    private static final String AUTHENICATION_ALIAS_PROPERTY = "com.ibm.mapping.authDataAlias";
    private String ivCurrentBackendId;
    private CmpConnectionFactoryType ivDefaultCmpConnectionFactory;
    private ResourceRefType ivDefaultDataSourceRef;
    private final HashMap<String, SessionType> ivSessionTypeMap = new HashMap();
    private final HashMap<String, EntityType> ivEntityTypeMap = new HashMap();
    private final HashMap<String, MessageDrivenType> ivMessageDrivenTypeMap = new HashMap();
    private final ObjectFactory ivJaxbFactory = new ObjectFactory();
    private EJBJarBinding ivEJBJarBinding;
    private HashMap<String, EnterpriseBeanBinding> ivEnterpriseBeanBindingMap;
    private HashMap<String, InterceptorType> ivInterceptorTypeMap = new HashMap();
    private HashMap<String, String> ivMessageDestinationMap = new HashMap();

    public String getCurrentBackendId() {
        return this.ivCurrentBackendId;
    }

    public CmpConnectionFactoryType getDefaultCmpConnectionFactory() {
        return this.ivDefaultCmpConnectionFactory;
    }

    public ResourceRefType getDefaultDataSourceRef() {
        return this.ivDefaultDataSourceRef;
    }

    public Map<String, SessionType> getSessionTypeMap() {
        return this.ivSessionTypeMap;
    }

    public Map<String, EntityType> getEntityTypeMap() {
        return this.ivEntityTypeMap;
    }

    public Map<String, InterceptorType> getInterceptorTypeMap() {
        return this.ivInterceptorTypeMap;
    }

    public Map<String, String> getMessageDestinationMap() {
        return this.ivMessageDestinationMap;
    }

    public Map<String, MessageDrivenType> getMessageDrivenTypeMap() {
        return this.ivMessageDrivenTypeMap;
    }

    public void processBindingsFile(EJBModuleRef ejbModRef) {
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "processBindingsFile(EJBJarFile)");
            }
            InputStream jaxbInputStream = null;
            String fileName = "";
            EJBJarFile archive = (EJBJarFile)ejbModRef.getModuleFile();
            String moduleName = archive.getName();
            EJBJar ejbJarDD = WCCMHelper.getDeploymentDescriptor(archive, false);
            try {
                ModuleExtension modExt;
                fileName = archive.getBindingsUri();
                int moduleVersionId = ejbJarDD.getVersionID();
                if (moduleVersionId < 30) {
                    EJBJarBinding ejbJarBinding = ejbModRef.getEJBJarBinding();
                    if (ejbJarBinding != null) {
                        this.populateMaps(ejbJarBinding);
                    }
                    break block24;
                }
                String altBindingURI = null;
                EARFile earFile = (EARFile)ejbModRef.getEarFile();
                ApplicationExtension appExt = earFile.getExtensions();
                if (appExt != null && (modExt = appExt.getModuleExtension(ejbModRef.getModule())) != null && (altBindingURI = modExt.getAltBindings()) != null && !altBindingURI.equals("")) {
                    fileName = altBindingURI;
                }
                if (altBindingURI != null) {
                    if (earFile.containsFile(altBindingURI)) {
                        fileName = altBindingURI;
                        jaxbInputStream = ejbModRef.getResourceInputStream(altBindingURI);
                    }
                } else {
                    try {
                        jaxbInputStream = ejbModRef.getResourceInputStream(fileName);
                    }
                    catch (FileNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (jaxbInputStream != null) {
                    this.populateMaps(jaxbInputStream);
                    InputStream temp = jaxbInputStream;
                    jaxbInputStream = null;
                    temp.close();
                    this.buildEJBJarBinding();
                }
            }
            catch (MetaDataException ex) {
                throw ex;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".processBindingsFile"), (String)"199", (Object)this, (Object[])new Object[]{archive, jaxbInputStream});
                Throwable root = t instanceof SAXParseException ? t : this.findRootCause(t);
                MetaDataException ex = null;
                if (root instanceof SAXParseException) {
                    SAXParseException saxEx = (SAXParseException)root;
                    int line = saxEx.getLineNumber();
                    int column = saxEx.getColumnNumber();
                    Tr.error(tc, "BINDINGS_FILE_CONFIG_ERROR_CNTR0146E", new Object[]{fileName, moduleName, line, column});
                    ex = new MetaDataException("CNTR0146E: The " + fileName + " bindings file contained in the " + moduleName + " module has a configuration error at line number: " + line + ", column number: " + column + ".", saxEx);
                } else {
                    Tr.error(tc, "UNKNOWN_BINDINGS_FILE_CONFIG_ERROR_CNTR0147E", new Object[]{fileName, moduleName});
                    ex = new MetaDataException("CNTR0147E: The " + fileName + " bindings file contained in the " + moduleName + " module has a configuration error.", t);
                }
                throw ex;
            }
            finally {
                if (jaxbInputStream != null) {
                    try {
                        jaxbInputStream.close();
                    }
                    catch (Throwable t2) {}
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingsFile(EJBJarFile)");
        }
    }

    private void populateMaps(InputStream input) throws JAXBException, SAXException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(InputStream) using JAXB");
        }
        ClassLoader cl = this.getClass().getClassLoader();
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.ws.ejb.jar.bnd", (ClassLoader)cl);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String fileSeperator = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("file.separator", "\n"));
        String schemaFileDir = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("was.install.root", "\n"));
        schemaFileDir = schemaFileDir + fileSeperator + "properties" + fileSeperator + "schemas";
        Schema schema = schemaFactory.newSchema(new File(schemaFileDir + fileSeperator + "ibm-ejb-jar-bnd_1_0.xsd"));
        unmarshaller.setSchema(schema);
        JAXBElement el = (JAXBElement)unmarshaller.unmarshal(input);
        EjbJarBndType bindings = (EjbJarBndType)el.getValue();
        List<Object> list = bindings.getSessionOrMessageDrivenOrInterceptor();
        for (Object obj : list) {
            Object bean;
            if (obj instanceof SessionType) {
                bean = (SessionType)obj;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding SessionType to map for name = " + ((SessionType)bean).getName());
                }
                this.ivSessionTypeMap.put(((SessionType)bean).getName(), (SessionType)bean);
                continue;
            }
            if (obj instanceof MessageDrivenType) {
                bean = (MessageDrivenType)obj;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding MessageDrivenType to map for name = " + ((MessageDrivenType)bean).getName());
                }
                this.ivMessageDrivenTypeMap.put(((MessageDrivenType)bean).getName(), (MessageDrivenType)bean);
                continue;
            }
            if (obj instanceof EntityType) {
                bean = (EntityType)obj;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding EntityType to map for name = " + ((EntityType)bean).getName());
                }
                this.ivEntityTypeMap.put(((EntityType)bean).getName(), (EntityType)bean);
                continue;
            }
            if (obj instanceof InterceptorType) {
                InterceptorType interceptorType = (InterceptorType)obj;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding InterceptorType to map for class = " + interceptorType.getClazz());
                }
                this.ivInterceptorTypeMap.put(interceptorType.getClazz(), interceptorType);
                continue;
            }
            if (!(obj instanceof MessageDestinationType)) continue;
            MessageDestinationType destinationType = (MessageDestinationType)obj;
            String name = destinationType.getName();
            String bindingName = destinationType.getBindingName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "adding MessageDestinationType for name = " + name + ", binding-name = " + bindingName);
            }
            this.ivMessageDestinationMap.put(name, bindingName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(InputStream)");
        }
    }

    private void populateMaps(EJBJarBinding ejbJarBinding) {
        EList ejbBindings;
        ResourceRefBinding rrBinding;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(EJBJarBinding) using WCCM");
        }
        this.ivEJBJarBinding = ejbJarBinding;
        this.ivCurrentBackendId = ejbJarBinding.getCurrentBackendId();
        CMPConnectionFactoryBinding defaultFactory = ejbJarBinding.getDefaultCMPConnectionFactory();
        if (defaultFactory != null) {
            this.ivDefaultCmpConnectionFactory = this.createCmpConnectionFactoryType(defaultFactory);
        }
        if ((rrBinding = ejbJarBinding.getDefaultDatasource()) != null) {
            this.ivDefaultDataSourceRef = this.createResourceRefType(rrBinding);
        }
        if ((ejbBindings = ejbJarBinding.getEjbBindings()) != null) {
            int size = ejbBindings.size();
            int initialSize = size > 0 ? (int)((double)ejbBindings.size() * 1.5) : 11;
            this.ivEnterpriseBeanBindingMap = new HashMap(initialSize);
            for (EnterpriseBeanBinding ejbBinding : ejbBindings) {
                EnterpriseBean eb = ejbBinding.getEnterpriseBean();
                if (eb == null) {
                    Tr.warning(tc, "INCOMPLETE_EJB_BINDING_CNTR0142W", ejbBinding.getJndiName());
                    continue;
                }
                String ejbName = eb.getName();
                if (ejbName == null || ejbName.equals("")) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EJB name is null or is empty string");
                    continue;
                }
                EnterpriseBeanBinding firstBinding = this.ivEnterpriseBeanBindingMap.get(ejbName);
                if (firstBinding == null) {
                    this.createNewBinding(ejbBinding, eb);
                    continue;
                }
                this.updateExistingBinding(firstBinding, ejbBinding, eb);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(EJBJarBinding)");
        }
    }

    private void updateExistingBinding(EnterpriseBeanBinding firstBinding, EnterpriseBeanBinding ejbBinding, EnterpriseBean eb) {
        String ejbName = eb.getName();
        String displayName = this.getEJBDisplayName(eb);
        String jndiName = firstBinding.getJndiName();
        String newJndiName = ejbBinding.getJndiName();
        if (this.isNullOrEmpty(jndiName)) {
            if (!this.isNullOrEmpty(newJndiName)) {
                jndiName = newJndiName;
                firstBinding.setJndiName(jndiName);
            }
        } else if (!this.isNullOrEmpty(newJndiName) && !jndiName.equals(newJndiName) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String[] names = new String[]{jndiName, newJndiName};
            Tr.debug(tc, "More than one ejbBinding for EJB name = " + ejbName + ", only JNDI name of first binding being used: " + Arrays.asList(names));
        }
        if (eb.isSession()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updating binding in Session map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            SessionType st = this.ivSessionTypeMap.get(ejbName);
            st.setSimpleBindingName(jndiName);
            this.updateSessionType(st, ejbBinding, displayName);
        } else if (eb.isEntity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updating binding in Entity map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            EntityType et = this.ivEntityTypeMap.get(ejbName);
            et.setSimpleBindingName(jndiName);
            this.updateEntityType(et, ejbBinding, displayName);
        } else if (eb.isMessageDriven()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updating binding in MDB map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            MessageDrivenBeanBinding mdbBinding = (MessageDrivenBeanBinding)ejbBinding;
            MessageDrivenType mdt = this.ivMessageDrivenTypeMap.get(ejbName);
            this.updateMessageDrivenType(mdt, mdbBinding, displayName);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "binding not unpdated in map, invalid type for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
        }
    }

    private void createNewBinding(EnterpriseBeanBinding ejbBinding, EnterpriseBean eb) {
        String ejbName = eb.getName();
        this.ivEnterpriseBeanBindingMap.put(ejbName, ejbBinding);
        String displayName = this.getEJBDisplayName(eb);
        if (eb.isSession()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "adding binding in Session map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            SessionType st = this.ivJaxbFactory.createSessionType();
            st.setName(eb.getName());
            st.setSimpleBindingName(ejbBinding.getJndiName());
            this.ivSessionTypeMap.put(ejbName, st);
            this.updateSessionType(st, ejbBinding, displayName);
        } else if (eb.isEntity()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "adding binding in Entity map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            EntityType et = new EntityType();
            et.setName(eb.getName());
            et.setSimpleBindingName(ejbBinding.getJndiName());
            this.ivEntityTypeMap.put(ejbName, et);
            this.updateEntityType(et, ejbBinding, displayName);
        } else if (eb.isMessageDriven()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "adding binding in MDB map for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
            }
            MessageDrivenBeanBinding mdbBinding = (MessageDrivenBeanBinding)ejbBinding;
            MessageDrivenType mdt = this.ivJaxbFactory.createMessageDrivenType();
            mdt.setName(eb.getName());
            this.ivMessageDrivenTypeMap.put(ejbName, mdt);
            this.updateMessageDrivenType(mdt, mdbBinding, displayName);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "binding not unpdated in map, invalid type for EJB name = " + ejbName + ", ejb class = " + eb.getEjbClassName());
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }

    private void updateMessageDrivenType(MessageDrivenType mdt, MessageDrivenBeanBinding mdbBinding, String displayName) {
        EList mdList;
        EList rerList;
        EList rrList;
        String listenerPort;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageDrivenType for EJB name = " + displayName);
        }
        if (mdbBinding.isSetActivationSpecJndiName()) {
            JcaAdapterType jca = this.ivJaxbFactory.createJcaAdapterType();
            if (mdbBinding.isSetActivationSpecAuthAlias()) {
                jca.setActivationSpecAuthAlias(mdbBinding.getActivationSpecAuthAlias());
            }
            if (mdbBinding.isSetActivationSpecJndiName()) {
                jca.setActivationSpecBindingName(mdbBinding.getActivationSpecJndiName());
            }
            if (mdbBinding.isSetDestinationJndiName()) {
                jca.setDestinationBindingName(mdbBinding.getDestinationJndiName());
            }
            mdt.setJcaAdapter(jca);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added JcaAdapterType: , activation-spec-auth-alias = " + jca.getActivationSpecAuthAlias() + ", activation-spec-binding-name = " + jca.getActivationSpecBindingName() + ", destination-binding-name = " + jca.getDestinationBindingName());
            }
        }
        if ((listenerPort = mdbBinding.getListenerInputPortName()) != null) {
            ListenerPortType lpt = this.ivJaxbFactory.createListenerPortType();
            lpt.setName(listenerPort);
            mdt.setListenerPort(lpt);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "message listerner port = " + mdt.getListenerPort());
            }
        }
        EList list = mdbBinding.getEjbRefBindings();
        List<Object> refTypeList = mdt.getEjbRefOrResourceRefOrResourceEnvRef();
        if (!list.isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMEjbRefBindings(refTypeList, list, displayName);
        }
        if (!(rrList = mdbBinding.getResRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceRefBindings(refTypeList, rrList, displayName);
        }
        if (!(rerList = mdbBinding.getResourceEnvRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceEnvRefBindings(refTypeList, rerList, displayName);
        }
        if (!(mdList = mdbBinding.getMessageDestinationRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMMessageDestinationRefBindings(refTypeList, mdList, displayName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageDrivenType");
        }
    }

    private void updateEntityType(EntityType et, EnterpriseBeanBinding ejbBinding, String displayName) {
        EList mdList;
        EList rerList;
        EList rrList;
        CMPConnectionFactoryBinding cmpBinding;
        ResourceRefBinding rrBinding;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateEntityType for EJB name = " + displayName);
        }
        if ((rrBinding = ejbBinding.getDatasource()) != null) {
            ResourceRefType rrt = this.createResourceRefType(rrBinding);
            et.setDatasource(rrt);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added datasource ResourceRef binding with jndiName = " + rrt.getBindingName());
            }
        }
        if ((cmpBinding = ejbBinding.getCmpConnectionFactory()) != null) {
            CmpConnectionFactoryType factory = this.createCmpConnectionFactoryType(cmpBinding);
            et.setCmpConnectionFactory(factory);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "set CMP connection factory binding name = " + factory.getBindingName());
            }
        }
        List<Object> refTypeList = et.getEjbRefOrResourceRefOrResourceEnvRef();
        EList list = ejbBinding.getEjbRefBindings();
        if (!list.isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMEjbRefBindings(refTypeList, list, displayName);
        }
        if (!(rrList = ejbBinding.getResRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceRefBindings(refTypeList, rrList, displayName);
        }
        if (!(rerList = ejbBinding.getResourceEnvRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceEnvRefBindings(refTypeList, rerList, displayName);
        }
        if (!(mdList = ejbBinding.getMessageDestinationRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMMessageDestinationRefBindings(refTypeList, mdList, displayName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntityType");
        }
    }

    private CmpConnectionFactoryType createCmpConnectionFactoryType(CMPConnectionFactoryBinding binding) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCmpConnectionFactoryType for JNDI name = " + binding.getJndiName());
        }
        CmpConnectionFactoryType factory = new CmpConnectionFactoryType();
        factory.setBindingName(binding.getJndiName());
        if (binding.getResAuth().getValue() == 1) {
            factory.setAuthType(AuthTypeType.CONTAINER);
        } else {
            factory.setAuthType(AuthTypeType.PER_CONNECTION_FACTORY);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "CmpConnectionFactoryType resource authenication type = " + (Object)((Object)factory.getAuthType()));
        }
        if (binding.isSetLoginConfigurationName()) {
            String aliasName = null;
            CustomLoginConfigurationType login = this.ivJaxbFactory.createCustomLoginConfigurationType();
            String loginName = binding.getLoginConfigurationName();
            login.setName(loginName);
            List<PropertyType> newPropList = login.getProperty();
            EList wccmPropList = binding.getProperties();
            boolean isAuthenticationAlias = AUTHENICATION_ALIAS_LOGIN_NAME.equals(loginName) && wccmPropList.size() == 1;
            for (Property property : wccmPropList) {
                PropertyType p = this.ivJaxbFactory.createPropertyType();
                String propName = property.getName();
                String propValue = property.getValue();
                p.setName(propName);
                p.setValue(propValue);
                newPropList.add(p);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "CmpConnectionFactoryType CustomLoginConfiguration property name = " + propName + ", property value = " + propValue);
                }
                if (!isAuthenticationAlias || !propName.equals(AUTHENICATION_ALIAS_PROPERTY)) continue;
                aliasName = propValue;
            }
            if (aliasName != null) {
                AuthenticationAliasType alias = this.ivJaxbFactory.createAuthenticationAliasType();
                alias.setName(aliasName);
                factory.setAuthenticationAlias(alias);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "AuthenicationAlias set using alias = " + aliasName);
                }
            } else {
                factory.setCustomLoginConfiguration(login);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "CustomLoginConfiguration set for login name = " + loginName);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createCmpConnectionFactoryType");
        }
        return factory;
    }

    private void updateSessionType(SessionType st, EnterpriseBeanBinding ejbBinding, String displayName) {
        EList mdList;
        EList rerList;
        EList rrList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSessionType for EJB name = " + displayName);
        }
        List<Object> refTypeList = st.getEjbRefOrResourceRefOrResourceEnvRef();
        EList list = ejbBinding.getEjbRefBindings();
        if (!list.isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMEjbRefBindings(refTypeList, list, displayName);
        }
        if (!(rrList = ejbBinding.getResRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceRefBindings(refTypeList, rrList, displayName);
        }
        if (!(rerList = ejbBinding.getResourceEnvRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMResourceEnvRefBindings(refTypeList, rerList, displayName);
        }
        if (!(mdList = ejbBinding.getMessageDestinationRefBindings()).isEmpty()) {
            this.updateJAXBRefTypeListWithWCCMMessageDestinationRefBindings(refTypeList, mdList, displayName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSessionType");
        }
    }

    private ResourceRefType createResourceRefType(ResourceRefBinding rrBinding) {
        String loginName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRefType for JNDI name = " + rrBinding.getJndiName());
        }
        ResourceRefType rrType = this.ivJaxbFactory.createResourceRefType();
        ResourceRef rr = rrBinding.getBindingResourceRef();
        if (rr != null) {
            rrType.setName(rr.getName());
        }
        rrType.setBindingName(rrBinding.getJndiName());
        AbstractAuthData ad = rrBinding.getDefaultAuth();
        if (ad != null) {
            ResourceRefType.DefaultAuth da = new ResourceRefType.DefaultAuth();
            BasicAuthData bd = (BasicAuthData)ad;
            da.setUserid(bd.getUserId());
            da.setPassword(bd.getPassword());
            rrType.setDefaultAuth(da);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug(tc, "ResourceRefType default authenication type = " + rrType.getDefaultAuth());
            }
        }
        if ((loginName = rrBinding.getLoginConfigurationName()) != null) {
            String aliasName = null;
            CustomLoginConfigurationType login = this.ivJaxbFactory.createCustomLoginConfigurationType();
            login.setName(loginName);
            List<PropertyType> newPropList = login.getProperty();
            EList wccmPropList = rrBinding.getProperties();
            boolean isAuthenticationAlias = AUTHENICATION_ALIAS_LOGIN_NAME.equals(loginName) && wccmPropList.size() == 1;
            for (Property property : wccmPropList) {
                PropertyType p = this.ivJaxbFactory.createPropertyType();
                String propName = property.getName();
                String propValue = property.getValue();
                p.setName(propName);
                p.setValue(propValue);
                newPropList.add(p);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType CustomLoginConfiguration property name = " + propName + ", property value = " + propValue);
                }
                if (!isAuthenticationAlias || !propName.equals(AUTHENICATION_ALIAS_PROPERTY)) continue;
                aliasName = propValue;
            }
            if (aliasName != null) {
                AuthenticationAliasType alias = this.ivJaxbFactory.createAuthenticationAliasType();
                alias.setName(aliasName);
                rrType.setAuthenticationAlias(alias);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType authentication alias = " + aliasName);
                }
            } else {
                rrType.setCustomLoginConfiguration(login);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "ResourceRefType CustomLoginConfiguration set for login name = " + loginName);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRefType");
        }
        return rrType;
    }

    public static Map<String, String> getEjbRefMap(List<Object> list) {
        int listSize;
        HashMap<String, String> map = null;
        int n = listSize = list != null ? list.size() : 0;
        if (listSize > 0) {
            map = new HashMap((int)((double)listSize * 1.5));
            for (Object refType : list) {
                if (!(refType instanceof EjbRefType)) continue;
                EjbRefType ref = (EjbRefType)refType;
                String key = ref.getName();
                String value = ref.getBindingName();
                map.put(key, value);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getEjbRefMap returning map entry (key, value): ( " + key + ", " + value + " )");
            }
        } else {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public static Map<String, String> getResourceRefMap(List<Object> list) {
        int listSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceRefMap");
        }
        HashMap<String, String> map = null;
        int n = listSize = list != null ? list.size() : 0;
        if (listSize > 0) {
            map = new HashMap((int)((double)listSize * 1.5));
            for (Object refType : list) {
                if (!(refType instanceof ResourceRefType)) continue;
                ResourceRefType ref = (ResourceRefType)refType;
                String key = ref.getName();
                String value = ref.getBindingName();
                map.put(key, value);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getResourceRefMap returning map entry (key, value): ( " + key + ", " + value + " )");
            }
        } else {
            map = new HashMap<String, String>();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceRefMap");
        }
        return map;
    }

    public static Map<String, String> getResourceEnvRefMap(List<Object> list) {
        int listSize;
        HashMap<String, String> map = null;
        int n = listSize = list != null ? list.size() : 0;
        if (listSize > 0) {
            map = new HashMap((int)((double)listSize * 1.5));
            for (Object refType : list) {
                if (!(refType instanceof ResourceEnvRefType)) continue;
                ResourceEnvRefType ref = (ResourceEnvRefType)refType;
                String key = ref.getName();
                String value = ref.getBindingName();
                map.put(key, value);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getResourceEnvRefMap returning map entry (key, value): ( " + key + ", " + value + " )");
            }
        } else {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public static Map<String, String> getMessageDestinationRefMap(List<Object> list) {
        int listSize;
        HashMap<String, String> map = null;
        int n = listSize = list != null ? list.size() : 0;
        if (listSize > 0) {
            map = new HashMap((int)((double)listSize * 1.5));
            for (Object refType : list) {
                if (!(refType instanceof MessageDestinationRefType)) continue;
                MessageDestinationRefType ref = (MessageDestinationRefType)refType;
                String key = ref.getName();
                String value = ref.getBindingName();
                map.put(key, value);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getMessageDestinationRefBindings returning map entry (key, value): ( " + key + ", " + value + " )");
            }
        } else {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public EJBJarBinding getEJBJarBinding() {
        EJBJarBinding binding = this.ivEJBJarBinding;
        this.ivEJBJarBinding = null;
        return binding;
    }

    public Map<String, EnterpriseBeanBinding> getEnterpriseBeanBindingMap() {
        return this.ivEnterpriseBeanBindingMap;
    }

    private void buildEJBJarBinding() {
        ArrayList<MessageDestinationRefType> mdrList;
        ArrayList<ResourceEnvRefType> rerList;
        ArrayList<ResourceRefType> rrt;
        ArrayList<EjbRefType> ejbRefList;
        List<Object> refTypeList;
        EjbbndFactory factory = EjbbndFactory.eINSTANCE;
        this.ivEJBJarBinding = factory.createEJBJarBinding();
        this.ivEJBJarBinding.setCurrentBackendId(this.ivCurrentBackendId);
        if (this.ivDefaultCmpConnectionFactory != null) {
            CMPConnectionFactoryBinding dcmpf = this.createCMPConnectionFactoryBinding(this.ivDefaultCmpConnectionFactory);
            this.ivEJBJarBinding.setDefaultCMPConnectionFactory(dcmpf);
        }
        if (this.ivDefaultDataSourceRef != null) {
            ResourceRefBinding dds = this.createResourceRefBinding(this.ivDefaultDataSourceRef);
            this.ivEJBJarBinding.setDefaultDatasource(dds);
        }
        EList ejbBindings = this.ivEJBJarBinding.getEjbBindings();
        int initialSize = (int)((double)ejbBindings.size() * 1.5);
        this.ivEnterpriseBeanBindingMap = new HashMap(initialSize);
        Set<Map.Entry<String, SessionType>> entrySet = this.ivSessionTypeMap.entrySet();
        for (Map.Entry<String, SessionType> entry : entrySet) {
            String key = entry.getKey();
            SessionType st = entry.getValue();
            EnterpriseBeanBinding ejbBinding = factory.createEnterpriseBeanBinding();
            this.ivEnterpriseBeanBindingMap.put(key, ejbBinding);
            ejbBinding.setEjbName(key);
            ejbBinding.setModuleBinding(this.ivEJBJarBinding);
            String jndiName = st.getSimpleBindingName();
            if (jndiName == null && (jndiName = st.getLocalHomeBindingName()) == null) {
                jndiName = st.getRemoteHomeBindingName();
            }
            ejbBinding.setJndiName(jndiName);
            List<Object> refTypeList2 = st.getEjbRefOrResourceRefOrResourceEnvRef();
            ArrayList<EjbRefType> ejbRefList2 = new ArrayList<EjbRefType>();
            ArrayList<ResourceRefType> rrt2 = new ArrayList<ResourceRefType>();
            ArrayList<ResourceEnvRefType> rerList2 = new ArrayList<ResourceEnvRefType>();
            ArrayList<MessageDestinationRefType> mdrList2 = new ArrayList<MessageDestinationRefType>();
            for (Object refType : refTypeList2) {
                if (refType instanceof EjbRefType) {
                    ejbRefList2.add((EjbRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceRefType) {
                    rrt2.add((ResourceRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceEnvRefType) {
                    rerList2.add((ResourceEnvRefType)refType);
                    continue;
                }
                if (!(refType instanceof MessageDestinationRefType)) continue;
                mdrList2.add((MessageDestinationRefType)refType);
            }
            if (!ejbRefList2.isEmpty()) {
                this.createEJBRefBindings(ejbBinding, ejbRefList2);
            }
            if (!rrt2.isEmpty()) {
                this.createResourceRefBindings(ejbBinding, rrt2);
            }
            if (!rerList2.isEmpty()) {
                this.createResourceEnvRefBindings(ejbBinding, rerList2);
            }
            if (mdrList2.isEmpty()) continue;
            this.createMessageDestinationRefBindings(ejbBinding, mdrList2);
        }
        Set<Map.Entry<String, EntityType>> entitySet = this.ivEntityTypeMap.entrySet();
        for (Map.Entry<String, EntityType> etEntry : entitySet) {
            CmpConnectionFactoryType cmpft;
            String key = etEntry.getKey();
            EntityType et = etEntry.getValue();
            EnterpriseBeanBinding ejbBinding = factory.createEnterpriseBeanBinding();
            this.ivEnterpriseBeanBindingMap.put(key, ejbBinding);
            ejbBinding.setEjbName(key);
            ejbBinding.setModuleBinding(this.ivEJBJarBinding);
            String jndiName = et.getSimpleBindingName();
            if (jndiName == null && (jndiName = et.getLocalHomeBindingName()) == null) {
                jndiName = et.getRemoteHomeBindingName();
            }
            ejbBinding.setJndiName(jndiName);
            refTypeList = et.getEjbRefOrResourceRefOrResourceEnvRef();
            ejbRefList = new ArrayList<EjbRefType>();
            rrt = new ArrayList<ResourceRefType>();
            rerList = new ArrayList<ResourceEnvRefType>();
            mdrList = new ArrayList<MessageDestinationRefType>();
            for (Object refType : refTypeList) {
                if (refType instanceof EjbRefType) {
                    ejbRefList.add((EjbRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceRefType) {
                    rrt.add((ResourceRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceEnvRefType) {
                    rerList.add((ResourceEnvRefType)refType);
                    continue;
                }
                if (!(refType instanceof MessageDestinationRefType)) continue;
                mdrList.add((MessageDestinationRefType)refType);
            }
            if (!ejbRefList.isEmpty()) {
                this.createEJBRefBindings(ejbBinding, ejbRefList);
            }
            if (!rrt.isEmpty()) {
                this.createResourceRefBindings(ejbBinding, rrt);
            }
            if (!rerList.isEmpty()) {
                this.createResourceEnvRefBindings(ejbBinding, rerList);
            }
            if (!mdrList.isEmpty()) {
                this.createMessageDestinationRefBindings(ejbBinding, mdrList);
            }
            if ((cmpft = et.getCmpConnectionFactory()) == null) continue;
            CMPConnectionFactoryBinding cmpb = this.createCMPConnectionFactoryBinding(cmpft);
            ejbBinding.setCmpConnectionFactory(cmpb);
        }
        Set<Map.Entry<String, MessageDrivenType>> mdbSet = this.ivMessageDrivenTypeMap.entrySet();
        for (Map.Entry<String, MessageDrivenType> entry : mdbSet) {
            String key = entry.getKey();
            MessageDrivenType mdt = entry.getValue();
            EnterpriseBeanBinding ejbBinding = factory.createEnterpriseBeanBinding();
            this.ivEnterpriseBeanBindingMap.put(key, ejbBinding);
            ejbBinding.setEjbName(key);
            ejbBinding.setModuleBinding(this.ivEJBJarBinding);
            refTypeList = mdt.getEjbRefOrResourceRefOrResourceEnvRef();
            ejbRefList = new ArrayList();
            rrt = new ArrayList();
            rerList = new ArrayList();
            mdrList = new ArrayList();
            for (Object refType : refTypeList) {
                if (refType instanceof EjbRefType) {
                    ejbRefList.add((EjbRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceRefType) {
                    rrt.add((ResourceRefType)refType);
                    continue;
                }
                if (refType instanceof ResourceEnvRefType) {
                    rerList.add((ResourceEnvRefType)refType);
                    continue;
                }
                if (!(refType instanceof MessageDestinationRefType)) continue;
                mdrList.add((MessageDestinationRefType)refType);
            }
            if (!ejbRefList.isEmpty()) {
                this.createEJBRefBindings(ejbBinding, ejbRefList);
            }
            if (!rrt.isEmpty()) {
                this.createResourceRefBindings(ejbBinding, rrt);
            }
            if (!rerList.isEmpty()) {
                this.createResourceEnvRefBindings(ejbBinding, rerList);
            }
            if (mdrList.isEmpty()) continue;
            this.createMessageDestinationRefBindings(ejbBinding, mdrList);
        }
    }

    private void createEJBRefBindings(EnterpriseBeanBinding ejbBinding, List<EjbRefType> ejbRefList) {
        EList wccmList = ejbBinding.getEjbRefBindings();
        for (EjbRefType ref : ejbRefList) {
            EjbRefBinding binding = this.createEjbRefBinding(ref);
            wccmList.add(binding);
        }
    }

    private EjbRefBinding createEjbRefBinding(EjbRefType ref) {
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        EjbRefBinding binding = commonBndFactory.createEjbRefBinding();
        binding.setJndiName(ref.getBindingName());
        EjbRef wccmRef = commonFactory.createEjbRef();
        wccmRef.setName(ref.getName());
        binding.setBindingEjbRef(wccmRef);
        return binding;
    }

    private void createResourceEnvRefBindings(EnterpriseBeanBinding ejbBinding, List<ResourceEnvRefType> rerList) {
        EList wccmList = ejbBinding.getResourceEnvRefBindings();
        for (ResourceEnvRefType ref : rerList) {
            ResourceEnvRefBinding binding = this.createResourceEnvRefBinding(ref);
            wccmList.add(binding);
        }
    }

    private ResourceEnvRefBinding createResourceEnvRefBinding(ResourceEnvRefType ref) {
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        ResourceEnvRefBinding binding = commonBndFactory.createResourceEnvRefBinding();
        binding.setJndiName(ref.getBindingName());
        ResourceEnvRef wccmRef = commonFactory.createResourceEnvRef();
        wccmRef.setName(ref.getName());
        binding.setBindingResourceEnvRef(wccmRef);
        return binding;
    }

    private void createMessageDestinationRefBindings(EnterpriseBeanBinding ejbBinding, List<MessageDestinationRefType> mdrList) {
        EList wccmList = ejbBinding.getMessageDestinationRefBindings();
        for (MessageDestinationRefType ref : mdrList) {
            MessageDestinationRefBinding binding = this.createMessageDestinationRefBinding(ref);
            wccmList.add(binding);
        }
    }

    private MessageDestinationRefBinding createMessageDestinationRefBinding(MessageDestinationRefType ref) {
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        MessageDestinationRefBinding binding = commonBndFactory.createMessageDestinationRefBinding();
        binding.setJndiName(ref.getBindingName());
        MessageDestinationRef wccmRef = commonFactory.createMessageDestinationRef();
        wccmRef.setName(ref.getName());
        binding.setBindingMessageDestinationRef(wccmRef);
        return binding;
    }

    private void createResourceRefBindings(EnterpriseBeanBinding ejbBinding, List<ResourceRefType> rrtList) {
        EList wccmList = ejbBinding.getResRefBindings();
        for (ResourceRefType ref : rrtList) {
            ResourceRefBinding rr = this.createResourceRefBinding(ref);
            wccmList.add(rr);
        }
    }

    private CMPConnectionFactoryBinding createCMPConnectionFactoryBinding(CmpConnectionFactoryType binding) {
        EjbbndFactory factory = EjbbndFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        CMPConnectionFactoryBinding cmpf = factory.createCMPConnectionFactoryBinding();
        cmpf.setJndiName(binding.getBindingName());
        if (binding.getAuthType() == AuthTypeType.CONTAINER) {
            cmpf.setResAuth(CMPResAuthType.CONTAINER_LITERAL);
        } else {
            cmpf.setResAuth(CMPResAuthType.PER_CONNECTION_FACTORY_LITERAL);
        }
        CustomLoginConfigurationType login = binding.getCustomLoginConfiguration();
        if (login != null) {
            cmpf.setLoginConfigurationName(login.getName());
            EList wccmPropList = cmpf.getProperties();
            List<PropertyType> pList = login.getProperty();
            for (PropertyType pt : pList) {
                Property p = commonBndFactory.createProperty();
                String propName = pt.getName();
                String propValue = pt.getValue();
                p.setName(propName);
                p.setValue(propValue);
                wccmPropList.add(p);
            }
        }
        return cmpf;
    }

    private ResourceRefBinding createResourceRefBinding(ResourceRefType rrt) {
        CustomLoginConfigurationType cct;
        CommonFactory commonFactory = CommonFactory.eINSTANCE;
        CommonbndFactory commonBndFactory = CommonbndFactory.eINSTANCE;
        ResourceRefBindingImpl dds = (ResourceRefBindingImpl)commonBndFactory.createResourceRefBinding();
        ResourceRef rr = commonFactory.createResourceRef();
        rr.setName(rrt.getName());
        dds.setBindingResourceRef(rr);
        dds.setJndiName(rrt.getBindingName());
        ResourceRefType.DefaultAuth da = rrt.getDefaultAuth();
        if (da != null) {
            BasicAuthData ba = commonBndFactory.createBasicAuthData();
            ba.setUserId(da.getUserid());
            ba.setPassword(da.getPassword());
            dds.setDefaultAuth(ba);
        }
        if ((cct = rrt.getCustomLoginConfiguration()) != null) {
            dds.setLoginConfigurationName(cct.getName());
            EList wccmPropList = dds.getProperties();
            List<PropertyType> pList = cct.getProperty();
            for (PropertyType pt : pList) {
                Property p = commonBndFactory.createProperty();
                String propName = pt.getName();
                String propValue = pt.getValue();
                p.setName(propName);
                p.setValue(propValue);
                wccmPropList.add(p);
            }
        } else {
            AuthenticationAliasType alias = rrt.getAuthenticationAlias();
            if (alias != null) {
                dds.setLoginConfigurationName(AUTHENICATION_ALIAS_LOGIN_NAME);
                EList wccmPropList = dds.getProperties();
                Property p = commonBndFactory.createProperty();
                p.setName(AUTHENICATION_ALIAS_PROPERTY);
                p.setValue(alias.getName());
                wccmPropList.add(p);
            }
        }
        return dds;
    }

    private Throwable findRootCause(Throwable t) {
        Throwable root = t;
        Throwable cause = root.getCause();
        while (cause != null) {
            root = cause;
            cause = root.getCause();
        }
        return root;
    }

    private void updateJAXBRefTypeListWithWCCMEjbRefBindings(List<Object> refTypeList, List<EjbRefBinding> list, String displayName) {
        for (EjbRefBinding binding : list) {
            String refName;
            String jndiName = binding.getJndiName();
            EjbRef ref = binding.getBindingEjbRef();
            String string = refName = ref != null ? ref.getName() : null;
            if (refName == null) {
                Tr.warning(tc, "MISSING_EJBREF_BINDING_CNTR0063W", displayName + " : ejbRefBindings jndiName=\"" + jndiName + "\"");
                continue;
            }
            EjbRefType ejbRef = this.ivJaxbFactory.createEjbRefType();
            ejbRef.setName(refName);
            ejbRef.setBindingName(jndiName);
            refTypeList.add(ejbRef);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added EjbRef binding for name = " + refName + ", binding name = " + jndiName);
        }
    }

    private void updateJAXBRefTypeListWithWCCMResourceRefBindings(List<Object> refTypeList, List<ResourceRefBinding> rrList, String displayName) {
        for (ResourceRefBinding binding : rrList) {
            ResourceRef ref = binding.getBindingResourceRef();
            String refName = ref != null ? ref.getName() : null;
            String jndiName = binding.getJndiName();
            if (refName == null) {
                Tr.warning(tc, "MISSING_RESREF_BINDING_CNTR0076W", displayName + " : resRefBindings jndiName=\"" + jndiName + "\"");
                continue;
            }
            ResourceRefType rrt = this.createResourceRefType(binding);
            refTypeList.add(rrt);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added ResourceRef binding for name = " + refName + ", binding name = " + jndiName);
        }
    }

    private void updateJAXBRefTypeListWithWCCMResourceEnvRefBindings(List<Object> refTypeList, List<ResourceEnvRefBinding> rerList, String displayName) {
        for (ResourceEnvRefBinding binding : rerList) {
            String refName;
            String jndiName = binding.getJndiName();
            ResourceEnvRef ref = binding.getBindingResourceEnvRef();
            String string = refName = ref != null ? ref.getName() : null;
            if (refName == null) {
                Tr.warning(tc, "MISSING_RESENVREF_BINDING_CNTR0077W", displayName + " : resourceEnvRefBindings jndiName=\"" + jndiName + "\"");
                continue;
            }
            ResourceEnvRefType rer = this.ivJaxbFactory.createResourceEnvRefType();
            rer.setName(refName);
            rer.setBindingName(jndiName);
            refTypeList.add(rer);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added ResourceEnvRef binding for name = " + refName + ", binding name = " + jndiName);
        }
    }

    private void updateJAXBRefTypeListWithWCCMMessageDestinationRefBindings(List<Object> refTypeList, List<MessageDestinationRefBinding> mdList, String displayName) {
        for (MessageDestinationRefBinding binding : mdList) {
            MessageDestinationRef ref = binding.getBindingMessageDestinationRef();
            String refName = ref != null ? ref.getName() : null;
            String jndiName = binding.getJndiName();
            if (refName == null) {
                Tr.warning(tc, "MISSING_MSGDESTREF_BINDING_CNTR0091W", displayName + " : messageDestinationRefBindings jndiName=\"" + jndiName + "\"");
                continue;
            }
            MessageDestinationRefType mdr = this.ivJaxbFactory.createMessageDestinationRefType();
            mdr.setName(refName);
            mdr.setBindingName(jndiName);
            refTypeList.add(mdr);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "added MessageDestinationRef binding for name = " + refName + ", binding name = " + jndiName);
        }
    }

    private String getEJBDisplayName(EnterpriseBean eb) {
        String displayName;
        if (eb == null) {
            displayName = "Unknown";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM EnterpriseBeanBinding did not resolve to a WCCM EnterpriseBean, using \"Unknown\" as the display name");
            }
        } else if (eb.eIsProxy()) {
            displayName = ((EObjectImpl)((Object)eb)).eProxyURI().toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "WCCM EnterpriseBeanBinding did not resolve to a WCCM EnterpriseBean, using WCCM eProxyURI for the EnterpriseBean as the display name");
            }
        } else {
            displayName = eb.getDisplayName();
            if (displayName == null || displayName.equals("")) {
                displayName = eb.getName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WCCM EnterpriseBean display name is null, using EJB name as the display name");
                }
            }
        }
        return displayName;
    }
}

