/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.bindings;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.MetaDataException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientModuleHelper {
    private static final String CLASS_NAME = AppClientModuleHelper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String OLD_BINDINGS_FILE = "ibm-application-client-bnd.xmi";
    private HashMap<String, String> ivEjbRefMap = new HashMap();
    private HashMap<String, String> ivResourceRefMap = new HashMap();
    private HashMap<String, String> ivResourceEnvRefMap = new HashMap();
    private HashMap<String, String> ivMdRefMap = new HashMap();

    public final Map<String, String> getEjbRefBindings() {
        return this.ivEjbRefMap;
    }

    public final Map<String, String> getResourceRefBindings() {
        return this.ivResourceRefMap;
    }

    public final Map<String, String> getResourceEnvRefBindings() {
        return this.ivResourceEnvRefMap;
    }

    public final Map<String, String> getMessageDestinationRefBindings() {
        return this.ivMdRefMap;
    }

    public void processBindingsFile(ClientModuleRef clientModRef) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processBindingsFile(ApplicationClientFile)");
        }
        Object jaxbInputStream = null;
        String fileName = "";
        ApplicationClientFile archive = (ApplicationClientFile)clientModRef.getModuleFile();
        String moduleName = archive.getName();
        try {
            String altDDLocation = clientModRef.getModule().getAltDD();
            boolean altDD = altDDLocation != null && altDDLocation.trim().length() > 0;
            ApplicationClientBinding ac = (ApplicationClientBinding)clientModRef.getBindings();
            if (ac != null) {
                fileName = altDD ? "ALT-INF/" + moduleName + "/" + OLD_BINDINGS_FILE : "META-INF/ibm-application-client-bnd.xmi";
                this.populateMaps(ac);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".processBindingsFile"), (String)"202", (Object)this, (Object[])new Object[]{archive, jaxbInputStream});
            Tr.error(tc, "UNKNOWN_BINDINGS_FILE_CONFIG_ERROR_CNTR0147E", new Object[]{fileName, moduleName});
            MetaDataException ex = new MetaDataException("CNTR0147E: The " + fileName + " bindings file contained in the " + moduleName + " module has a configuration error.", t);
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processBindingsFile(ApplicationClientFile)");
        }
    }

    private void populateMaps(ApplicationClientBinding ac) {
        EList mdrBindingList;
        EList rerBindingList;
        EList rrBindingList;
        EList bindings;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMaps(ApplicationClientBinding) using WCCM");
        }
        if ((bindings = ac.getEjbRefs()) != null) {
            for (EjbRefBinding binding : bindings) {
                EjbRef ref = binding.getBindingEjbRef();
                String bindingName = binding.getJndiName();
                if (ac.hasEjbRefBinding(ref)) {
                    String key = ref.getName();
                    String old = this.ivEjbRefMap.put(key, bindingName);
                    if (old != null) {
                        throw new MetaDataException("duplicate binding for EJBRef name = " + key);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added EJBRef binding for (" + key + "," + bindingName + ")");
                    continue;
                }
                throw new MetaDataException("unresolved EJBRefBinding for binding name = " + bindingName);
            }
        }
        if ((rrBindingList = ac.getResourceRefs()) != null) {
            for (ResourceRefBinding binding : rrBindingList) {
                ResourceRef ref = binding.getBindingResourceRef();
                String bindingName = binding.getJndiName();
                if (ac.hasResourceRefBinding(ref)) {
                    String key = ref.getName();
                    String old = this.ivResourceRefMap.put(key, bindingName);
                    if (old != null) {
                        throw new MetaDataException("duplicate binding for ResourceRef name = " + key);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added ResourceRef binding for (" + key + "," + bindingName + ")");
                    continue;
                }
                throw new MetaDataException("unresolved ResourceRefBinding for binding name = " + bindingName);
            }
        }
        if ((rerBindingList = ac.getResourceEnvRefBindings()) != null) {
            for (ResourceEnvRefBinding binding : rerBindingList) {
                ResourceEnvRef ref = binding.getBindingResourceEnvRef();
                String bindingName = binding.getJndiName();
                if (ac.hasResourceEnvRefBinding(ref)) {
                    String key = ref.getName();
                    String old = this.ivResourceEnvRefMap.put(key, bindingName);
                    if (old != null) {
                        throw new MetaDataException("duplicate binding for ResourceEnvRef name = " + key);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added ResourceEnvRef binding for (" + key + "," + bindingName + ")");
                    continue;
                }
                throw new MetaDataException("unresolved ResourceEnvRefBinding for binding name = " + bindingName);
            }
        }
        if ((mdrBindingList = ac.getMessageDestinationRefs()) != null) {
            for (MessageDestinationRefBinding binding : mdrBindingList) {
                MessageDestinationRef ref = binding.getBindingMessageDestinationRef();
                String bindingName = binding.getJndiName();
                if (ref != null) {
                    String key = ref.getName();
                    String old = this.ivMdRefMap.put(key, bindingName);
                    if (old != null) {
                        throw new MetaDataException("duplicate binding for MessageDestinationRef() name = " + key);
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added MessageDestinationRef binding for (" + key + "," + bindingName + ")");
                    continue;
                }
                throw new MetaDataException("unresolved MessageDestinationRefBinding for binding name = " + bindingName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMaps(ApplicationClientBinding)");
        }
    }
}

