/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.InvalidResourcePropertyException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;

public class WASResourceUtilities {
    private static final TraceComponent tc = Tr.register(WASResourceUtilities.class, null, null);

    public static String constructMRID(String resourceType, String configID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructMRID", new Object[]{resourceType, configID});
        }
        String mrid = resourceType + ":" + configID;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructMRID", mrid);
        }
        return mrid;
    }

    public static String getAppNameFromDeployment(ObjectName appDeployment) {
        String METHOD_NAME = "getAppNameFromDeployment";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromDeployment", new Object[]{appDeployment});
        }
        String appName = null;
        String id = ConfigServiceHelper.getConfigDataId(appDeployment).getContextUri();
        StringTokenizer tokenizer = new StringTokenizer(id, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!token.equals("deployments") || !tokenizer.hasMoreTokens()) continue;
            appName = tokenizer.nextToken();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromDeployment", appName);
        }
        return appName;
    }

    public static Set getMBeansByType(String node, String server, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{node, server, type});
        }
        Set result = WASResourceUtilities.getMBeansByType(node, server, type, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean", result);
        }
        return result;
    }

    public static Set getMBeansByType(String node, String server, String type, boolean useDmgrAdminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{node, server, type, new Boolean(useDmgrAdminClient)});
        }
        StringBuffer queryStringBuffer = new StringBuffer("WebSphere:*,type=" + type);
        if (node != null && !node.equals("")) {
            queryStringBuffer.append(",node=" + node);
        }
        if (server != null && !server.equals("")) {
            queryStringBuffer.append(",process=" + server);
        }
        String query = queryStringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "query", query);
        }
        Set result = WASResourceUtilities.getMbeanByQueryString(query, useDmgrAdminClient);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean", result);
        }
        return result;
    }

    public static ObjectName getAppMgmtMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMgmtMBean");
        }
        ObjectName appmgmtMBean = WASResourceUtilities.getAppMgmtMBean(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMgmtMBean", appmgmtMBean);
        }
        return appmgmtMBean;
    }

    public static ObjectName getAppMgmtMBean(boolean useDmgrAdminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMgmtMBean");
        }
        ObjectName appmgmtMBean = null;
        Set appMbeans = WASResourceUtilities.getMBeansByType(null, null, "AppManagement", useDmgrAdminClient);
        Iterator appMbeansIterator = appMbeans.iterator();
        if (appMbeansIterator.hasNext()) {
            appmgmtMBean = (ObjectName)appMbeansIterator.next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMgmtMBean", appmgmtMBean);
        }
        return appmgmtMBean;
    }

    public static ObjectName getPerfMBean(ObjectName mbean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPerfMBean", mbean);
        }
        ObjectName perfMBean = null;
        String process = mbean.getKeyProperty("process");
        String node = mbean.getKeyProperty("node");
        Set perfMbeans = WASResourceUtilities.getMBeansByType(node, process, "Perf");
        Iterator appMbeansIterator = perfMbeans.iterator();
        if (appMbeansIterator.hasNext()) {
            perfMBean = (ObjectName)appMbeansIterator.next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPerfMBean", perfMBean);
        }
        return perfMBean;
    }

    public static Set getMbeanByQueryString(String queryString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanByQueryString", queryString);
        }
        Set mbeans = WASResourceUtilities.getMbeanByQueryString(queryString, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanByQueryString", mbeans);
        }
        return mbeans;
    }

    public static Set getMbeanByQueryString(String queryString, boolean useDmgrAdminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanByQueryString", new Object[]{queryString, new Boolean(useDmgrAdminClient)});
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        Set mbeans = useDmgrAdminClient ? adminService.getDeploymentManagerAdminClient().queryNames(new ObjectName(queryString), null) : adminService.queryNames(new ObjectName(queryString), null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanByQueryString", mbeans);
        }
        return mbeans;
    }

    public static Object getMbeanAttribute(ObjectName mbean, String attribute) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanAttribute", new Object[]{mbean, attribute});
        }
        Object result = WASResourceUtilities.getMbeanAttribute(mbean, attribute, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMbeanAttribute", result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getMbeanAttribute(ObjectName mbean, String attribute, boolean useDmgrAdminClient) throws InvalidResourcePropertyException, WASResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMbeanAttribute", new Object[]{mbean, attribute, new Boolean(useDmgrAdminClient)});
        }
        Object result = null;
        try {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                result = useDmgrAdminClient ? adminService.getDeploymentManagerAdminClient().getAttribute(mbean, attribute) : adminService.getAttribute(mbean, attribute);
                object = result;
                Object var7_8 = null;
            }
            catch (AttributeNotFoundException anfe) {
                FFDCFilter.processException((Throwable)anfe, (String)"com.ibm.ws.management.wasresource.common.WASResource.getMbeanAttributes", (String)"429");
                if (!tc.isDebugEnabled()) throw new InvalidResourcePropertyException(anfe);
                Tr.debug(tc, "Attribute not found: " + attribute, anfe);
                throw new InvalidResourcePropertyException(anfe);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResource.getMbeanAttributes", (String)"434");
                if (!tc.isDebugEnabled()) throw new WASResourceException(e);
                Tr.debug(tc, "Exception caught", e);
                throw new WASResourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getMbeanAttribute", result);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return object;
        Tr.exit(tc, "getMbeanAttribute", result);
        return object;
    }

    public static void setMbeanAttribute(ObjectName mbean, String attribute, Object attributeValue) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMbeanAttribute", new Object[]{mbean, attribute});
        }
        WASResourceUtilities.setMbeanAttribute(mbean, attribute, attributeValue, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMbeanAttribute");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setMbeanAttribute(ObjectName mbean, String attribute, Object attributeValue, boolean useDmgrAdminClient) throws InvalidResourcePropertyException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMbeanAttribute", new Object[]{mbean, attribute, new Boolean(useDmgrAdminClient)});
        }
        try {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                Attribute att = new Attribute(attribute, attributeValue);
                if (useDmgrAdminClient) {
                    adminService.getDeploymentManagerAdminClient().setAttribute(mbean, att);
                }
                adminService.setAttribute(mbean, att);
            }
            catch (AttributeNotFoundException anfe) {
                FFDCFilter.processException((Throwable)anfe, (String)"com.ibm.ws.management.wasresource.common.WASResource.getMbeanAttributes", (String)"429");
                if (!tc.isDebugEnabled()) throw new InvalidResourcePropertyException(anfe);
                Tr.debug(tc, "Attribute not found: " + attribute, anfe);
                throw new InvalidResourcePropertyException(anfe);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResource.getMbeanAttributes", (String)"434");
                if (!tc.isDebugEnabled()) throw new WASResourceException(e);
                Tr.debug(tc, "Exception caught", e);
                throw new WASResourceException(e);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "setMbeanAttribute");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "setMbeanAttribute");
    }

    public static Object mbeanInvoke(ObjectName mbean, String operationName, Object[] params, String[] sigs) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvoke", new Object[]{mbean, operationName, params, sigs});
        }
        Object result = WASResourceUtilities.mbeanInvoke(mbean, operationName, params, sigs, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvoke");
        }
        return result;
    }

    public static Object mbeanInvoke(ObjectName mbean, String operationName, Object[] params, String[] sigs, boolean useDmgrAdminClient) throws WASResourceOperationException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvoke", new Object[]{mbean, operationName, params, sigs, new Boolean(useDmgrAdminClient)});
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            Object result = useDmgrAdminClient ? adminService.getDeploymentManagerAdminClient().invoke(mbean, operationName, params, sigs) : adminService.invoke(mbean, operationName, params, sigs);
            object = result;
            Object var9_9 = null;
        }
        catch (Exception e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResource.mbeanInvoke", (String)"125");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught", e);
                }
                throw new WASResourceOperationException(e);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_10 = null;
                    if (!tc.isEntryEnabled()) break block7;
                    Tr.exit(tc, "mbeanInvoke");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvoke");
        }
        return object;
    }

    public static WASResourceReferenceParameters getWASReferenceParametersFromMbean(ObjectName mbean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWASReferenceParametersFromMbean", new Object[]{mbean});
        }
        HashMap<QName, String> refProps = new HashMap<QName, String>();
        String type = mbean.getKeyProperty("type");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ResouceType resolved is " + type);
        }
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_Type, type);
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(type, mbean.toString()));
        refProps.put(WASResourcesConstants.WAS_WSDM_Resource_MbeanIdentifier, mbean.toString());
        WASResourceReferenceParameters wsResRefParam = new WASResourceReferenceParameters("", refProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASReferenceParametersFromMbean", wsResRefParam);
        }
        return wsResRefParam;
    }
}

