/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wasresource.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceRegistryXSDProcessor;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;

public class WASResourceTypeRegistry {
    private static final TraceComponent tc;
    private static final WASResourceTypeRegistry wsResTypeRegistry;
    private HashMap resouceTypeRegistry = new HashMap();
    private static List bundlesProvidingResources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WASResourceTypeRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WASResoureTypeRegistry");
        }
        try {
            block20: {
                try {
                    block19: {
                        try {
                            WASResourceRegistryXSDProcessor xsdProcessor = WASResourceRegistryXSDProcessor.getInstance();
                            List resourceList = xsdProcessor.getResources();
                            ArrayList<EObject> extensionResourceList = new ArrayList<EObject>();
                            for (int i = 0; i < resourceList.size(); ++i) {
                                try {
                                    String resourceType;
                                    EObject resource = (EObject)resourceList.get(i);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Resource is " + resource);
                                    }
                                    if ((resourceType = xsdProcessor.getResourceType(resource)) != null && resourceType != "") {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "getting resource type  " + resourceType);
                                        }
                                        WASResoureTypeRegistryEntry regEntry = new WASResoureTypeRegistryEntry(resourceType, xsdProcessor.getResourceImplClass(resource));
                                        this.resouceTypeRegistry.put(xsdProcessor.getResourceType(resource), regEntry);
                                        continue;
                                    }
                                    String resourceExtType = xsdProcessor.getResourceExtType(resource);
                                    if (resourceExtType == null || resourceExtType == "") continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "getting resource extension type  " + resourceExtType);
                                    }
                                    extensionResourceList.add(resource);
                                    continue;
                                }
                                catch (Throwable th) {
                                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.wasresource.common.WASResoureTypeRegistry.WASResoureTypeRegistry", (String)"76", (Object)this);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Error while loading resource type instances from xml.   Continue processing...", th);
                                }
                            }
                            for (int j = 0; j < extensionResourceList.size(); ++j) {
                                try {
                                    EObject extResource = (EObject)extensionResourceList.get(j);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Ext resource is " + extResource);
                                    }
                                    WASResoureTypeRegistryEntry regEntry = (WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(xsdProcessor.getResourceExtType(extResource));
                                    regEntry.addExtTypeClassName(xsdProcessor.getResourceImplClass(extResource));
                                    continue;
                                }
                                catch (Throwable th) {
                                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.wasresource.common.WASResoureTypeRegistry.WASResoureTypeRegistry", (String)"89", (Object)this);
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Error while loading resource ext type instances from xml.   Continue processing...", th);
                                }
                            }
                        }
                        catch (Throwable th) {
                            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.wasresource.common.WASResoureTypeRegistry.WASResoureTypeRegistry", (String)"131", (Object)this);
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug(tc, "Error while loading resource type instances from xml.   Continue processing...", th);
                        }
                    }
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "resouceTypeRegistry is " + this.resouceTypeRegistry);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResoureTypeRegistry.WASResoureTypeRegistry", (String)"37", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error while loading resource type instances", e);
                    }
                    Object var9_13 = null;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "WASResoureTypeRegistry", this);
                    return;
                }
            }
            Object var9_12 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "WASResoureTypeRegistry", this);
            return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "WASResoureTypeRegistry", this);
            throw throwable;
        }
    }

    public boolean isValidType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidType", type);
        }
        boolean result = false;
        if (this.resouceTypeRegistry.get(type) != null) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidType", new Boolean(result));
        }
        return result;
    }

    protected static WASResourceTypeRegistry getInstance() {
        return wsResTypeRegistry;
    }

    public String getResourceTypeClass(String resourceType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceTypeClass", new Object[]{resourceType, this});
        }
        String typeClass = ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).getTypeClassName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceTypeClass", typeClass);
        }
        return typeClass;
    }

    public WASResource createResourceTypeInstance(HashMap eprRefProps) throws WASResourceInitializeException {
        return this.createResourceTypeInstance(eprRefProps, null);
    }

    public WASResource createResourceTypeInstance(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceTypeInstance", new Object[]{eprRefProps, this});
        }
        String resourceType = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_Type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource Type is " + resourceType);
        }
        WASResource typeClassInstance = null;
        if (this.resouceTypeRegistry.get(resourceType) != null) {
            typeClassInstance = ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).createTypeResourceInstance(eprRefProps, session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceTypeInstance", typeClassInstance);
        }
        if (typeClassInstance == null) {
            throw new WASResourceInitializeException("Resource Type :" + resourceType + " not registered");
        }
        return typeClassInstance;
    }

    public List createResourceExtTypeInstances(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceExtTypeInstance", new Object[]{eprRefProps, this});
        }
        List extTypeClassInstances = this.createResourceExtTypeInstances(eprRefProps, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceTypeInstance", extTypeClassInstances);
        }
        return extTypeClassInstances;
    }

    public List createResourceExtTypeInstances(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceExtTypeInstance", new Object[]{eprRefProps, session, this});
        }
        String resourceType = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_Type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource Type is " + resourceType);
        }
        List extTypeClassInstances = ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).createExtTypeResourceInstance(eprRefProps, session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceTypeInstance", extTypeClassInstances);
        }
        return extTypeClassInstances;
    }

    public WASResource getResourceTypeObject(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceTypeObject", new Object[]{eprRefProps, this});
        }
        String resourceType = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_Type);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource Type is " + resourceType);
        }
        WASResource typeClassInstance = ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).getTypeResourceObject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceTypeObject", typeClassInstance);
        }
        return typeClassInstance;
    }

    public WASResource getResourceTypeInstance(HashMap eprRefProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceTypeInstance", new Object[]{eprRefProps, this});
        }
        WASResource typeClassInstance = null;
        String resourceType = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_Type);
        String resourceID = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_MRID);
        if (resourceID != null) {
            typeClassInstance = ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).getTypeResourceInstance(resourceID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceTypeInstance", typeClassInstance);
        }
        return typeClassInstance;
    }

    public void removeResourceTypeInstance(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeResourceTypeInstance", new Object[]{eprRefProps, this});
        }
        String resourceType = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_Type);
        String resourceID = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_MRID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resource Type is " + resourceType + ".  ResourceID is " + resourceID);
        }
        ((WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(resourceType)).removeTypeResourceInstance(resourceID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeResourceTypeInstance");
        }
    }

    public void cleanResgistryEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup", this);
        }
        Iterator registryKeyIter = this.resouceTypeRegistry.keySet().iterator();
        while (registryKeyIter.hasNext()) {
            WASResoureTypeRegistryEntry entry = (WASResoureTypeRegistryEntry)this.resouceTypeRegistry.get(registryKeyIter.next());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cleaning up " + entry);
            }
            entry.cleanExpiredResourceInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public static Set getAllRegisteredTypes() {
        return WASResourceTypeRegistry.getInstance().getAllTypes();
    }

    public Set getAllTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllTypes", this);
        }
        Set types = this.resouceTypeRegistry.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllTypes", types);
        }
        return types;
    }

    public Set getValidConfigTypes(Session session, ConfigService cs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidConfigTypes");
        }
        Set result = this.getAllTypes();
        String[] configTypes = null;
        try {
            configTypes = cs.getSupportedConfigObjectTypes();
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            String type = (String)itr.next();
            int i = 0;
            for (i = 0; i < configTypes.length && !type.equals(configTypes[i]); ++i) {
            }
            if (i != configTypes.length) continue;
            itr.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValidConfigTypes", result);
        }
        return result;
    }

    private Class getResourceClass(final String className) throws ClassNotFoundException {
        Class clazz;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResourceClass", className);
            }
            clazz = null;
            Iterator it = bundlesProvidingResources.iterator();
            while (it.hasNext() && clazz == null) {
                final Bundle bundle = (Bundle)it.next();
                if (bundle == null) {
                    return Class.forName(className);
                }
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return bundle.loadClass(className);
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load class " + className + " from bundle " + bundle.getSymbolicName());
                }
            }
            if (clazz == null) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Class.forName(className, true, ExtClassLoader.getInstance());
                        }
                    });
                }
                catch (Exception e) {
                    if (!tc.isEventEnabled()) break block13;
                    Tr.event(tc, "unable to load class " + className + "using Extension " + "classloader");
                }
            }
        }
        if (clazz == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException(className);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unable to load class " + className);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to load class " + className);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getResourceClass", cnfe);
            }
            throw cnfe;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceClass", clazz);
        }
        return clazz;
    }

    static {
        String epid;
        tc = Tr.register(WASResourceTypeRegistry.class, null, null);
        wsResTypeRegistry = new WASResourceTypeRegistry();
        bundlesProvidingResources = new ArrayList();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".ws-resources-def");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                bundlesProvidingResources.add(Platform.getBundle((String)extensions[i].getNamespace()));
            }
        }
    }

    private class WASResoureTypeRegistryEntry {
        String resourceType;
        String typeClassName;
        HashMap typeResourceInstancesMap = new HashMap();
        ArrayList typeExtensionClassNames = new ArrayList();
        HashMap typeResourceExpirationMap = new HashMap();

        private WASResoureTypeRegistryEntry(String resType, String typeClassName) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WASResoureTypeRegistryEntry", new Object[]{resType, typeClassName});
            }
            this.setResourceType(resType);
            this.setTypeClassName(typeClassName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WASResoureTypeRegistryEntry");
            }
        }

        private WASResoureTypeRegistryEntry(String resType, String typeClassName, String resMrid, WASResource resInstance) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WASResoureTypeRegistryEntry", new Object[]{resType, typeClassName, resMrid, resInstance});
            }
            this.setResourceType(resType);
            this.setTypeClassName(typeClassName);
            this.setTypeResourceInstance(resMrid, resInstance);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WASResoureTypeRegistryEntry");
            }
        }

        private String getResourceType() {
            return this.resourceType;
        }

        private void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        private String getTypeClassName() {
            return this.typeClassName;
        }

        private void setTypeClassName(String typeClassName) {
            this.typeClassName = typeClassName;
        }

        private HashMap getTypeInstances() {
            return this.typeResourceInstancesMap;
        }

        private void addExtTypeClassName(String extClassName) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addExtTypeClassName", extClassName);
            }
            this.typeExtensionClassNames.add(extClassName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addExtTypeClassName", this.typeExtensionClassNames);
            }
        }

        private ArrayList getExtTypeClassNames() {
            return this.typeExtensionClassNames;
        }

        private synchronized WASResource createTypeResourceInstance(HashMap eprRefProps, boolean initializeResource, Session session) throws WASResourceInitializeException {
            WASResource result;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createTypeResourceInstance", eprRefProps);
            }
            String mrid = (String)eprRefProps.get(WASResourcesConstants.WAS_WSDM_Resource_MRID);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mrid to lookup is " + mrid);
            }
            if ((result = (WASResource)this.typeResourceInstancesMap.get(mrid)) == null) {
                try {
                    Class resClass = WASResourceTypeRegistry.this.getResourceClass(this.getTypeClassName());
                    result = (WASResource)resClass.newInstance();
                    result.setSession(session);
                    if (initializeResource) {
                        result.initialize(eprRefProps);
                    }
                    this.typeResourceInstancesMap.put(mrid, result);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry.WASResoureTypeRegistryEntry.getTypeResourceInstance", (String)"148", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error while creating resource type instances", e);
                    }
                    throw new WASResourceInitializeException(e);
                }
            } else {
                result.setSession(session);
            }
            this.typeResourceExpirationMap.put(mrid, new Boolean(false));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTypeResourceInstance", result);
            }
            return result;
        }

        private synchronized WASResource createTypeResourceInstance(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createTypeResourceInstance", eprRefProps);
            }
            WASResource result = this.createTypeResourceInstance(eprRefProps, true, session);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTypeResourceInstance", result);
            }
            return result;
        }

        private synchronized List createExtTypeResourceInstance(HashMap eprRefProps, Session session) throws WASResourceInitializeException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createExtTypeResourceInstance", new Object[]{eprRefProps, session});
            }
            ArrayList<WASResource> result = new ArrayList<WASResource>();
            ArrayList extTypeClassNameList = this.getExtTypeClassNames();
            for (int i = 0; i < extTypeClassNameList.size(); ++i) {
                String extClassName = (String)extTypeClassNameList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extension class name is " + extClassName);
                }
                try {
                    Class resClass = WASResourceTypeRegistry.this.getResourceClass(extClassName);
                    WASResource resource = (WASResource)resClass.newInstance();
                    resource.setSession(session);
                    result.add(resource);
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry.WASResoureTypeRegistryEntry.createExtTypeResourceInstance", (String)"315", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error while creating ext resource type instances", e);
                    }
                    throw new WASResourceInitializeException(e);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createExtTypeResourceInstance", result);
            }
            return result;
        }

        private synchronized WASResource getTypeResourceObject() throws WASResourceInitializeException {
            WASResource wASResource;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTypeResourceObject");
            }
            WASResource result = null;
            try {
                Class resClass = WASResourceTypeRegistry.this.getResourceClass(this.getTypeClassName());
                wASResource = result = (WASResource)resClass.newInstance();
                Object var5_5 = null;
            }
            catch (Exception e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.wasresource.common.WASResourceTypeRegistry.WASResoureTypeRegistryEntry.getTypeResourceInstance", (String)"148", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error while creating resource type instances", e);
                    }
                    throw new WASResourceInitializeException(e);
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var5_6 = null;
                        if (!tc.isEntryEnabled()) break block7;
                        Tr.exit(tc, "getTypeResourceObject", result);
                    }
                    throw throwable;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTypeResourceObject", result);
            }
            return wASResource;
        }

        private WASResource getTypeResourceInstance(String resourceMrid) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTypeResourceInstance", resourceMrid);
            }
            WASResource result = (WASResource)this.typeResourceInstancesMap.get(resourceMrid);
            this.typeResourceExpirationMap.put(resourceMrid, new Boolean(false));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTypeResourceInstance", result);
            }
            return result;
        }

        private synchronized void setTypeResourceInstance(String resourceMrid, WASResource typeResourceInstance) {
            this.typeResourceInstancesMap.put(resourceMrid, typeResourceInstance);
        }

        private synchronized void removeTypeResourceInstance(String resourceMrid) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removeTypeResourceInstance", resourceMrid);
            }
            this.typeResourceInstancesMap.remove(resourceMrid);
            this.typeResourceExpirationMap.remove(resourceMrid);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTypeResourceInstance");
            }
        }

        public synchronized void cleanExpiredResourceInstance() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanup");
            }
            for (String resourceMrid : this.typeResourceInstancesMap.keySet()) {
                Boolean expired = (Boolean)this.typeResourceExpirationMap.get(resourceMrid);
                if (expired.booleanValue()) {
                    this.removeTypeResourceInstance(resourceMrid);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Resource: " + resourceMrid + " removed");
                    continue;
                }
                this.typeResourceExpirationMap.put(resourceMrid, new Boolean(true));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cleanup");
            }
        }

        public String toString() {
            return "ResourceType: " + this.resourceType + ". Resource type classname: " + this.typeClassName;
        }
    }
}

