/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformServerConfigHelperImpl
implements PlatformServerConfigHelper {
    private PropertiesFactory factory = null;
    private static final TraceComponent tc = Tr.register(PlatformServerConfigHelperImpl.class, null, null);

    public PlatformServerConfigHelperImpl() {
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.factory = propertiespkg.getPropertiesFactory();
    }

    public void configureServer(Server server) {
        RepositoryContext nodeContext = ((ContextResourceSet)server.eResource().getResourceSet()).getContext().getParent();
        RepositoryContext cellContext = nodeContext.getParent();
        this.configureServer(cellContext, server);
    }

    public void configureServer(RepositoryContext cellContext, Server server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Entering configureServer", server);
        }
        try {
            Session session = new Session();
            RepositoryContext nodeContext = ((ContextResourceSet)server.eResource().getResourceSet()).getContext().getParent();
            if (PlatformConfigHelperUtil.isNodeZOS(session, nodeContext)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configureServer: node --> zOS");
                }
                ServerIndex server_index = null;
                URI uri = URI.createURI("serverindex.xml");
                Resource resource = nodeContext.getResourceSet().getResource(uri, true);
                server_index = (ServerIndex)resource.getContents().iterator().next();
                ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(server_index, server.getName());
                String serverType = serverEntry.getServerType();
                String serverUuid = null;
                String nodeAgentUuid = null;
                String genericUuid = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Type", serverType);
                }
                String[] sNames = this.getShortNames(cellContext, serverType);
                String shortName = sNames[0];
                String clusterShortName = sNames[1];
                server.setShortName(shortName);
                server.setClusterName(null);
                if (!AdminHelper.getPlatformHelper().isZOS()) {
                    ConfigService configService = ConfigServiceFactory.getConfigService();
                    nodeAgentUuid = PlatformConfigHelperUtil.getNodeAgentUuid(session, configService, nodeContext);
                    serverUuid = AdminHelper.getPlatformHelper().getUniqueId(nodeAgentUuid);
                    genericUuid = AdminHelper.getPlatformHelper().getUniqueId(nodeAgentUuid);
                } else {
                    serverUuid = AdminHelper.getPlatformHelper().getUniqueId();
                    genericUuid = AdminHelper.getPlatformHelper().getUniqueId();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UUID from PlatformHelper: " + serverUuid);
                }
                server.setUniqueId(serverUuid);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server UUID: " + server.getUniqueId());
                }
                if (!"GENERIC_SERVER".equals(serverType)) {
                    String systemName = this.buildStartCommands(server, nodeContext, shortName);
                    this.addServerProperties(server, clusterShortName, genericUuid, systemName);
                }
                this.configureServerIndex(server, nodeContext, shortName, clusterShortName);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.configureServer", (String)"149", (Object)this);
            th.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit configureServer");
        }
    }

    public void modifyShortName(Server server, String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyShortName()", new Object[]{server, type});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = new Session();
        String shortName = server.getShortName();
        RepositoryContext serverContext = ((ContextResourceSet)server.eResource().getResourceSet()).getContext();
        RepositoryContext nodeContext = serverContext.getParent();
        RepositoryContext cellContext = nodeContext.getParent();
        Resource resource = null;
        Resource node_res = null;
        Resource cell_res = null;
        Resource serv_res = null;
        Cell cell_obj = null;
        Node node_obj = null;
        ServerIndex server_index = null;
        try {
            URI uri = URI.createURI("serverindex.xml");
            resource = nodeContext.getResourceSet().getResource(uri, true);
            server_index = (ServerIndex)resource.getContents().iterator().next();
            URI uri1 = URI.createURI("node.xml");
            node_res = nodeContext.getResourceSet().getResource(uri1, true);
            URI uri2 = URI.createURI("cell.xml");
            cell_res = cellContext.getResourceSet().getResource(uri2, true);
            URI uri3 = URI.createURI("server.xml");
            serv_res = serverContext.getResourceSet().getResource(uri3, true);
            cell_obj = (Cell)cell_res.getContents().get(0);
            node_obj = (Node)node_res.getContents().get(0);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", (String)"195", (Object)this);
            Tr.error(tc, "Error trying to load resources", e);
            e.printStackTrace();
        }
        ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(server_index, server.getName());
        serverEntry.setServerShortName(server.getShortName().toString());
        if (!type.equals("Server")) {
            serverEntry.setGenericShortName(server.getShortName().toString());
            List props = null;
            props = type.equals("Node Agent") ? PlatformConfigHelperUtil.getAdminServiceProperties(server) : PlatformConfigHelperUtil.getApplicationServerProperties(server);
            Property p = null;
            for (int i = 0; i < props.size(); ++i) {
                p = (Property)props.get(i);
                if (!p.getName().equals("ClusterTransitionName")) continue;
                p.setValue(server.getShortName().toString());
            }
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", (String)"226", (Object)this);
            e.printStackTrace();
        }
        String cellShortName = cell_obj.getShortName();
        String nodeShortName = node_obj.getShortName();
        EList pDefs = server.getProcessDefinitions();
        Iterator iterate = pDefs.iterator();
        ProcessDef pDef = null;
        while (iterate.hasNext()) {
            pDef = (ProcessDef)iterate.next();
            if (!pDef.getProcessType().equals("Control")) continue;
            String jobname = shortName.trim();
            String env = cellShortName.trim() + "." + nodeShortName.trim() + "." + shortName.trim();
            String stop = "STOP " + shortName.trim() + "; CANCEL " + shortName.trim();
            String term = "FORCE " + shortName.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original Start Command" + pDef.getStartCommandArgs());
            }
            Map parsedCmd = this.parseStartCommandArgs((String)pDef.getStartCommandArgs().get(0));
            parsedCmd.put("JOBNAME", jobname);
            parsedCmd.put("ENV", env);
            String startArgs = this.generateStartCommandArgs(parsedCmd);
            pDef.getStartCommandArgs().clear();
            LinkedList<String> args = new LinkedList<String>();
            args.add(startArgs);
            pDef.getStartCommandArgs().addAll(args);
            pDef.setStopCommand(stop);
            pDef.setTerminateCommand(term);
        }
        try {
            serv_res.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", (String)"255", (Object)this);
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyShortName()", server);
        }
    }

    public void configureServerIndex(Server server, RepositoryContext nodeContext, String shortName, String clusterShortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureServerIndex", new Object[]{server, nodeContext, shortName, clusterShortName});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureServerIndex()", server);
        }
        ServerindexPackage pkg = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        ServerindexFactory serverIndexFactory = pkg.getServerindexFactory();
        URI uri = URI.createURI("serverindex.xml");
        Resource resource = nodeContext.getResourceSet().getResource(uri, true);
        ServerIndex server_index = (ServerIndex)resource.getContents().iterator().next();
        ServerEntry server_entry = PlatformConfigHelperUtil.lookupServerEntry(server_index, server.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Entry: ", server_entry);
        }
        if (server_entry == null) {
            server_entry = serverIndexFactory.createServerEntry();
            server_index.getServerEntries().add(server_entry);
        }
        server_entry.setServerName(server.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Name: " + server.getName());
        }
        server_entry.setServerDisplayName(server.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Display Name: " + server.getName());
        }
        server_entry.setServerShortName(shortName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Short  Name: " + shortName);
        }
        server_entry.setGenericShortName(clusterShortName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Cluster Name: " + clusterShortName);
        }
        server_entry.setServerUniqueId(server.getUniqueId());
        EList endpoints = server_entry.getSpecialEndpoints();
        NamedEndPoint orb_listen = null;
        NamedEndPoint boot = null;
        NamedEndPoint orb_ssl = null;
        NamedEndPoint namedEndpoint2 = null;
        for (NamedEndPoint namedEndpoint2 : endpoints) {
            if (namedEndpoint2.getEndPointName().equals("ORB_LISTENER_ADDRESS")) {
                orb_listen = namedEndpoint2;
                continue;
            }
            if (namedEndpoint2.getEndPointName().equals("BOOTSTRAP_ADDRESS")) {
                boot = namedEndpoint2;
                continue;
            }
            if (!namedEndpoint2.getEndPointName().equals("ORB_SSL_LISTENER_ADDRESS")) continue;
            orb_ssl = namedEndpoint2;
        }
        if (boot != null && orb_listen != null) {
            orb_listen.getEndPoint().setHost("*");
            orb_listen.getEndPoint().setPort(boot.getEndPoint().getPort());
        }
        if (orb_ssl != null) {
            orb_ssl.getEndPoint().setHost("*");
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.configureServerIndex", (String)"328", (Object)this);
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureServerIndex()", server_entry);
        }
    }

    private void addServerProperties(Server server, String clusterShortName, String generic_uuid, String systemName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServerProperties", new Object[]{server, clusterShortName, generic_uuid, systemName});
        }
        List props = PlatformConfigHelperUtil.getApplicationServerProperties(server);
        Property pp = null;
        for (int i = 0; i < props.size(); ++i) {
            pp = (Property)props.get(i);
            if (pp.getName().equals("was.ClusterTransitionUUID")) {
                props.remove(i);
                --i;
                continue;
            }
            if (pp.getName().equals("ClusterTransitionName")) {
                props.remove(i);
                --i;
                continue;
            }
            if (!pp.getName().equals("was.ConfiguredSystemName")) continue;
            props.remove(i);
            --i;
        }
        Property p = this.factory.createProperty();
        p.setName("ClusterTransitionName");
        p.setValue(clusterShortName);
        props.add(p);
        p = this.factory.createProperty();
        p.setName("was.ClusterTransitionUUID");
        p.setValue(generic_uuid);
        props.add(p);
        p = this.factory.createProperty();
        p.setName("was.ConfiguredSystemName");
        p.setValue(systemName);
        props.add(p);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServerProperties", props);
        }
    }

    private String[] getShortNames(RepositoryContext cellContext, String serverType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShortNames", cellContext);
        }
        String[] names = new String[2];
        RepositoryContextType rct = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
        List nodeContexts = cellContext.getChildren(rct);
        LinkedList<ServerIndex> serverIndexes = new LinkedList<ServerIndex>();
        Iterator iter = nodeContexts.iterator();
        Resource resource = null;
        ServerIndex server_index = null;
        RepositoryContext nodeCtx = null;
        while (iter.hasNext()) {
            resource = null;
            server_index = null;
            nodeCtx = (RepositoryContext)iter.next();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Iterating Context: ", nodeCtx);
            }
            try {
                URI uri = URI.createURI("serverindex.xml");
                resource = nodeCtx.getResourceSet().getResource(uri, true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.getShortNames", (String)"407", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error occured while iterating nodes: ", e);
                }
                e.printStackTrace();
            }
            server_index = (ServerIndex)resource.getContents().get(0);
            serverIndexes.add(server_index);
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Server indexes ", serverIndexes);
        }
        String shortName = "";
        String clusterShortName = "";
        if ("PROXY_SERVER".equals(serverType) || "ONDEMAND_ROUTER".equals(serverType)) {
            clusterShortName = shortName = PlatformConfigHelperUtil.findNextShortName_help(serverIndexes, PlatformConfigHelperUtil.PROXY_PREFIX);
        } else if ("NODE_AGENT".equals(serverType)) {
            clusterShortName = shortName = PlatformConfigHelperUtil.findNextShortName_help(serverIndexes, PlatformConfigHelperUtil.NODEAGENT_PREFIX);
        } else {
            shortName = PlatformConfigHelperUtil.findNextValidServerShortName(serverIndexes);
            clusterShortName = PlatformConfigHelperUtil.findNextValidClusterShortName(serverIndexes);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Short Name: " + shortName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Short Name: " + clusterShortName);
        }
        names[0] = shortName;
        names[1] = clusterShortName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShortNames", names);
        }
        return names;
    }

    public String buildStartCommands(Server server, RepositoryContext nodeContext, String shortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStartCommands", new Object[]{server, nodeContext, shortName});
        }
        Resource nodeResource = null;
        Resource cellResource = null;
        Resource serverIndexResource = null;
        Resource variablesResource = null;
        Cell cell_obj = null;
        Node node_obj = null;
        VariableMap var_map = null;
        ServerIndex server_index = null;
        RepositoryContext cellContext = nodeContext.getParent();
        try {
            URI nodeUri = URI.createURI("node.xml");
            nodeResource = nodeContext.getResourceSet().getResource(nodeUri, true);
            URI cellUri = URI.createURI("cell.xml");
            cellResource = cellContext.getResourceSet().getResource(cellUri, true);
            URI serverIndexUri = URI.createURI("serverindex.xml");
            serverIndexResource = nodeContext.getResourceSet().getResource(serverIndexUri, true);
            URI varUri = URI.createURI("variables.xml");
            variablesResource = nodeContext.getResourceSet().getResource(varUri, true);
            node_obj = (Node)nodeResource.getContents().get(0);
            cell_obj = (Cell)cellResource.getContents().get(0);
            server_index = (ServerIndex)serverIndexResource.getContents().get(0);
            var_map = (VariableMap)variablesResource.getContents().get(0);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.buildStartCommands", (String)"466", (Object)this);
            e.printStackTrace();
        }
        String cellShortName = cell_obj.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell Short Name: " + cellShortName);
        }
        String nodeShortName = node_obj.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Short Name: " + nodeShortName);
        }
        EList varMapEntries = var_map.getEntries();
        String ctrl_proc = null;
        String servant_proc = null;
        String adjunct_proc = null;
        String system_name = null;
        String server_proc = null;
        VariableSubstitutionEntry vse = null;
        String sn = null;
        for (int j = 0; j < varMapEntries.size(); ++j) {
            vse = (VariableSubstitutionEntry)varMapEntries.get(j);
            sn = vse.getSymbolicName();
            if (sn.equalsIgnoreCase("WAS_DEFAULT_CONTROL_PROC_NAME")) {
                ctrl_proc = vse.getValue();
                continue;
            }
            if (sn.equalsIgnoreCase("WAS_DEFAULT_SERVANT_PROC_NAME")) {
                servant_proc = vse.getValue();
                continue;
            }
            if (sn.equalsIgnoreCase("WAS_DEFAULT_ADJUNCT_PROC_NAME")) {
                adjunct_proc = vse.getValue();
                continue;
            }
            if (sn.equalsIgnoreCase("WAS_DEFAULT_SERVER_PROC_NAME")) {
                server_proc = vse.getValue();
                continue;
            }
            if (!sn.equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
            system_name = vse.getValue();
        }
        if (tc.isDebugEnabled() && (ctrl_proc == null || servant_proc == null || adjunct_proc == null || server_proc == null)) {
            Tr.debug(tc, "ctrl_proc: " + ctrl_proc);
            Tr.debug(tc, "servant_proc: " + servant_proc);
            Tr.debug(tc, "adjunct_proc: " + adjunct_proc);
            Tr.debug(tc, "server_proc: " + server_proc);
        }
        EList pDefs = server.getProcessDefinitions();
        Iterator iterate = pDefs.iterator();
        ProcessDef pDef = null;
        while (iterate.hasNext()) {
            String startArgs;
            Map parsedCmd;
            String env;
            String jobname;
            LinkedList<String> args;
            String start;
            pDef = (ProcessDef)iterate.next();
            if (pDef.getProcessType() == null || pDef.getProcessType().trim().equals("") || pDef.getProcessType().equals("Distributed")) {
                start = "START " + server_proc;
                String startArgs2 = "JOBNAME=" + shortName.trim() + ",ENV=" + cellShortName.trim() + "." + nodeShortName.trim() + "." + shortName.trim();
                String stop = "STOP " + shortName.trim() + "; CANCEL " + shortName.trim();
                String term = "FORCE " + shortName.trim();
                pDef.setStartCommand(start);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + pDef.getStartCommandArgs());
                }
                pDef.getStartCommandArgs().clear();
                args = new LinkedList<String>();
                args.add(startArgs2);
                pDef.getStartCommandArgs().addAll(args);
                pDef.setStopCommand(stop);
                pDef.setTerminateCommand(term);
                continue;
            }
            if (pDef.getProcessType().equals("Control")) {
                start = "START " + ctrl_proc;
                String jobname2 = shortName.trim();
                String env2 = cellShortName.trim() + "." + nodeShortName.trim() + "." + shortName.trim();
                String stop = "STOP " + shortName.trim() + "; CANCEL " + shortName.trim();
                String term = "FORCE " + shortName.trim();
                pDef.setStartCommand(start);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + pDef.getStartCommandArgs());
                }
                Map parsedCmd2 = this.parseStartCommandArgs((String)pDef.getStartCommandArgs().get(0));
                parsedCmd2.put("JOBNAME", jobname2);
                parsedCmd2.put("ENV", env2);
                String startArgs3 = this.generateStartCommandArgs(parsedCmd2);
                pDef.getStartCommandArgs().clear();
                LinkedList<String> args2 = new LinkedList<String>();
                args2.add(startArgs3);
                pDef.getStartCommandArgs().addAll(args2);
                pDef.setStopCommand(stop);
                pDef.setTerminateCommand(term);
                continue;
            }
            if (pDef.getProcessType().equals("Servant")) {
                pDef.setStartCommand(servant_proc);
                jobname = "&IWMSSNM.S";
                env = cellShortName.trim() + "." + nodeShortName.trim() + ".&IWMSSNM.";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + pDef.getStartCommandArgs());
                }
                parsedCmd = this.parseStartCommandArgs((String)pDef.getStartCommandArgs().get(0));
                parsedCmd.put("JOBNAME", jobname);
                parsedCmd.put("ENV", env);
                startArgs = this.generateStartCommandArgs(parsedCmd);
                pDef.getStartCommandArgs().clear();
                args = new LinkedList();
                args.add(startArgs);
                pDef.getStartCommandArgs().addAll(args);
                continue;
            }
            if (!pDef.getProcessType().equals("Adjunct")) continue;
            pDef.setStartCommand(adjunct_proc);
            jobname = "&IWMSSNM.A";
            env = cellShortName.trim() + "." + nodeShortName.trim() + ".&IWMSSNM.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original Start Command" + pDef.getStartCommandArgs());
            }
            parsedCmd = this.parseStartCommandArgs((String)pDef.getStartCommandArgs().get(0));
            parsedCmd.put("JOBNAME", jobname);
            parsedCmd.put("ENV", env);
            startArgs = this.generateStartCommandArgs(parsedCmd);
            pDef.getStartCommandArgs().clear();
            args = new LinkedList();
            args.add(startArgs);
            pDef.getStartCommandArgs().addAll(args);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStartCommands", new Object[]{system_name});
        }
        return system_name;
    }

    private Map parseStartCommandArgs(String startCommand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseStartCommandArgs", startCommand);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(startCommand, ",");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token", arg);
            }
            int eqIndex = arg.indexOf(61);
            String key = null;
            String value = null;
            if (eqIndex > 0) {
                key = arg.substring(0, eqIndex);
                value = arg.substring(eqIndex + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key", key);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value", value);
                }
                map.put(key, value);
                continue;
            }
            map.put(key, "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Map", map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseStartCommandArgs", startCommand);
        }
        return map;
    }

    private String generateStartCommandArgs(Map args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateStartCommandArgs", args);
        }
        StringBuffer buff = new StringBuffer();
        for (Map.Entry me : args.entrySet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key", me.getKey());
                Tr.debug(tc, "Value", me.getValue());
            }
            buff.append(me.getKey());
            if (me.getValue() == null || ((String)me.getValue()).trim().length() <= 0) continue;
            buff.append("=");
            buff.append(me.getValue());
            buff.append(",");
        }
        buff.deleteCharAt(buff.length() - 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateStartCommandArgs", buff.toString());
        }
        return buff.toString();
    }

    public String calculatedDefaultServerShortName() {
        return "null";
    }

    public void modifyClusterShortName(Server server, String type, String clusterShortName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyClusterShortName()", new Object[]{server, type, clusterShortName});
        }
        RepositoryContext nodeContext = ((ContextResourceSet)server.eResource().getResourceSet()).getContext().getParent();
        ServerindexPackage pkg = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        ServerindexFactory serverIndexFactory = pkg.getServerindexFactory();
        URI uri = URI.createURI("serverindex.xml");
        Resource resource = nodeContext.getResourceSet().getResource(uri, true);
        ServerIndex server_index = (ServerIndex)resource.getContents().iterator().next();
        ServerEntry server_entry = PlatformConfigHelperUtil.lookupServerEntry(server_index, server.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Entry: ", server_entry);
        }
        if (server_entry == null) {
            return;
        }
        server_entry.setGenericShortName(clusterShortName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Cluster Name: " + clusterShortName);
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.server.ServerConfigCommands.configureServerIndex", (String)"696", (Object)this);
            e.printStackTrace();
        }
        List props = PlatformConfigHelperUtil.getApplicationServerProperties(server);
        Property pp = null;
        for (int i = 0; i < props.size(); ++i) {
            pp = (Property)props.get(i);
            if (!pp.getName().equals("ClusterTransitionName")) continue;
            props.remove(i);
            --i;
        }
        Property p = this.factory.createProperty();
        p.setName("ClusterTransitionName");
        p.setValue(clusterShortName);
        props.add(p);
        try {
            resource = server.eResource();
            resource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.commands.server.ServerConfigCommands.configureServerIndex", (String)"696", (Object)this);
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyClusterShortName()");
        }
    }
}

