/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class PlatformConfigHelperUtil {
    private static TraceComponent tc = Tr.register(PlatformConfigHelperUtil.class, "Admin", null);
    protected static String SERVER_PREFIX = "BBOS";
    protected static String CLUSTER_PREFIX = "BBOC";
    protected static String NODEAGENT_PREFIX = "BBON";
    protected static String PROXY_PREFIX = "BBOX";

    private PlatformConfigHelperUtil() {
    }

    static List getApplicationServerProperties(Server s) {
        EList comps = s.getComponents();
        Component c = null;
        for (int i = 0; i < comps.size() && !((c = (Component)comps.get(i)) instanceof ApplicationServer); ++i) {
        }
        EList props = c.getProperties();
        return props;
    }

    static List getAdminServiceProperties(Server s) {
        EList comps = s.getServices();
        Service c = null;
        for (int i = 0; i < comps.size() && !((c = (Service)comps.get(i)) instanceof AdminService); ++i) {
        }
        EList props = c.getProperties();
        return props;
    }

    public static String findNextValidClusterShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, CLUSTER_PREFIX);
    }

    public static String findNextValidClusterShortName(List serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, CLUSTER_PREFIX);
    }

    public static String findNextValidServerShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, SERVER_PREFIX);
    }

    public static String findNextValidServerShortName(List serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, SERVER_PREFIX);
    }

    public static String findNextNodeAgentShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, NODEAGENT_PREFIX);
    }

    public static String findNextNodeAgentShortName(List serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, NODEAGENT_PREFIX);
    }

    public static String findNextShortName_help(ServerIndex serverIndex, String prefix) {
        EList serverEntries = serverIndex.getServerEntries();
        HashSet<String> set = new HashSet<String>();
        String sName = "";
        Object found = null;
        Iterator iter = serverEntries.iterator();
        while (iter.hasNext()) {
            ServerEntry serverEntry;
            if (iter == null || (serverEntry = (ServerEntry)iter.next()) == null) continue;
            if (prefix.equals(SERVER_PREFIX) || prefix.equals(NODEAGENT_PREFIX) || prefix.equals(PROXY_PREFIX)) {
                sName = serverEntry.getServerShortName();
            } else if (prefix.equals(CLUSTER_PREFIX)) {
                sName = serverEntry.getGenericShortName();
            }
            if (sName == null || sName.length() <= 0) continue;
            set.add(sName);
        }
        int counter = 1;
        if (set != null) {
            for (int i = 0; i < set.size() + 2; ++i) {
                String count = String.valueOf(counter);
                while (count.length() < 3) {
                    count = "0" + count;
                }
                String test = prefix + count;
                if (!set.contains(test)) {
                    return test;
                }
                ++counter;
            }
        } else {
            return prefix + "001";
        }
        return null;
    }

    public static String findNextShortName_help(List serverIndex, String prefix) {
        HashSet<String> set = new HashSet<String>();
        String sName = "";
        for (ServerIndex s_index : serverIndex) {
            EList serverEntries = s_index.getServerEntries();
            Object found = null;
            Iterator iter = serverEntries.iterator();
            while (iter.hasNext()) {
                ServerEntry serverEntry;
                if (iter == null || (serverEntry = (ServerEntry)iter.next()) == null) continue;
                if (prefix.equals(SERVER_PREFIX) || prefix.equals(NODEAGENT_PREFIX) || prefix.equals(PROXY_PREFIX)) {
                    sName = serverEntry.getServerShortName();
                } else if (prefix.equals(CLUSTER_PREFIX)) {
                    sName = serverEntry.getGenericShortName();
                }
                if (sName == null || sName.length() <= 0) continue;
                set.add(sName);
            }
        }
        int counter = 1;
        if (set != null) {
            for (int i = 0; i < set.size() + 2; ++i) {
                String count = String.valueOf(counter);
                while (count.length() < 3) {
                    count = "0" + count;
                }
                String test = prefix + count;
                if (!set.contains(test)) {
                    return test;
                }
                ++counter;
            }
        } else {
            return prefix + "001";
        }
        return null;
    }

    public static ServerEntry lookupServerEntry(ServerIndex serverIndex, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupServerEntry", serverIndex);
        }
        EList serverEntries = serverIndex.getServerEntries();
        ServerEntry found = null;
        for (ServerEntry serverEntry : serverEntries) {
            if (!serverEntry.getServerName().equals(serverName)) continue;
            found = serverEntry;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupServerEntry", found);
        }
        return found;
    }

    public static String getNodeAgentUuid(Session session, ConfigService configService, RepositoryContext nodeContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeAgentUuid", nodeContext);
        }
        String serverUniqueId = null;
        String nodeName = nodeContext.getName();
        ObjectName node = configService.resolve(session, "Node=" + nodeName)[0];
        ObjectName serverIndex = configService.getRelationship(session, node, "ServerIndex")[0];
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] entries = configService.queryConfigObjects(session, serverIndex, pattern, null);
        for (int k = 0; k < entries.length; ++k) {
            String serverType = (String)configService.getAttribute(session, entries[k], "serverType");
            if (serverType == null || serverType.length() <= 0 || !serverType.equals("NODE_AGENT")) continue;
            serverUniqueId = (String)configService.getAttribute(session, entries[k], "serverUniqueId");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentUuid", serverUniqueId);
        }
        return serverUniqueId;
    }

    public static boolean isNodeZOS(Session session, RepositoryContext nodeContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", nodeContext);
        }
        String nodeName = nodeContext.getName();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper metadataHelper = workSpace.getMetadataHelper();
        boolean result = metadataHelper.isNodeZOS(nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(result));
        }
        return result;
    }
}

