/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformClusterMemberHelperImpl
implements PlatformClusterMemberConfigHelper {
    private static TraceComponent tc = Tr.register(PlatformClusterMemberHelperImpl.class, "Admin", null);

    public void configureClusterMember(ClusterMember c, Server s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureClusterMember", new Object[]{c, s});
        }
        Session session = new Session();
        if (s != null) {
            RepositoryContext nodeContext = ((ContextResourceSet)s.eResource().getResourceSet()).getContext().getParent();
            try {
                if (PlatformConfigHelperUtil.isNodeZOS(session, nodeContext)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configureClusterMember: node --> zOS");
                    }
                    List props = PlatformConfigHelperUtil.getApplicationServerProperties(s);
                    for (int i = 0; i < props.size(); ++i) {
                        Property p = (Property)props.get(i);
                        if (p.getName().equals("was.ClusterTransitionUUID")) {
                            props.remove(i);
                            --i;
                            continue;
                        }
                        if (!p.getName().equals("ClusterTransitionName")) continue;
                        props.remove(i);
                        --i;
                    }
                    c.setUniqueId(s.getUniqueId());
                    RepositoryContext serverContext = ((ContextResourceSet)s.eResource().getResourceSet()).getContext();
                    URI uri = URI.createURI("server.xml");
                    Resource resource = serverContext.getResourceSet().getResource(uri, true);
                    resource.save(new HashMap());
                    Resource resource3 = null;
                    Resource resource4 = null;
                    URI uri3 = URI.createURI("serverindex.xml");
                    resource3 = nodeContext.getResourceSet().getResource(uri3, true);
                    ServerIndex server_index = (ServerIndex)resource3.getContents().get(0);
                    ServerEntry server_entry = PlatformConfigHelperUtil.lookupServerEntry(server_index, s.getName());
                    ServerCluster clust = c.getCluster();
                    if (s.getClusterName() == null || s.getClusterName().equals("")) {
                        s.setClusterName(clust.getName());
                    }
                    server_entry.setGenericShortName(clust.getShortName());
                    resource3.save(new HashMap());
                    URI uri4 = URI.createURI("variables.xml");
                    resource4 = nodeContext.getResourceSet().getResource(uri4, true);
                    VariableMap varMap = (VariableMap)resource4.getContents().get(0);
                    EList entries = varMap.getEntries();
                    String symName = null;
                    String symVal = null;
                    for (int j = 0; j < entries.size(); ++j) {
                        VariableSubstitutionEntry vse = (VariableSubstitutionEntry)entries.get(j);
                        symName = vse.getSymbolicName();
                        symVal = null;
                        if (!symName.equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
                        symVal = vse.getValue();
                        break;
                    }
                    for (int i = 0; i < props.size(); ++i) {
                        Property p = (Property)props.get(i);
                        if (!p.getName().equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
                        p.setValue(symVal);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterMemberHelperImpl.configureClusterMember", (String)"146", (Object)this);
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureClusterMember");
        }
    }
}

