/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformClusterConfigHelperImpl
implements PlatformClusterConfigHelper {
    private static TraceComponent tc = Tr.register(PlatformClusterConfigHelperImpl.class, "Admin", null);

    public void configureServerClusterFromServer(ServerCluster c, Server s) {
        RepositoryContext cellContext = ((ContextResourceSet)c.eResource().getResourceSet()).getContext().getParent();
        this.configureServerClusterFromServer(cellContext, c, s);
    }

    public void configureServerClusterFromServer(RepositoryContext cellContext, ServerCluster c, Server s) {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configureServerClusterFromServer", new Object[]{c, s});
            }
            Session session = new Session();
            Resource resource = null;
            ServerIndex server_index = null;
            List nodeContexts = cellContext.getChildren();
            LinkedList<ServerIndex> serverIndexes = new LinkedList<ServerIndex>();
            Iterator iter = nodeContexts.iterator();
            RepositoryContextType rct = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
            RepositoryContext nodeContext = ((ContextResourceSet)s.eResource().getResourceSet()).getContext().getParent();
            try {
                if (!PlatformConfigHelperUtil.isNodeZOS(session, nodeContext)) break block21;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configureServerClusterFromServer: node --> zOS");
                }
                while (iter.hasNext()) {
                    RepositoryContext nodeCtx = (RepositoryContext)iter.next();
                    if (nodeCtx.getType() != rct) continue;
                    try {
                        URI uri = URI.createURI("serverindex.xml");
                        resource = nodeCtx.getResourceSet().getResource(uri, true);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", (String)"107", (Object)this);
                    }
                    EList ext = resource.getContents();
                    server_index = (ServerIndex)resource.getContents().get(0);
                    serverIndexes.add(server_index);
                }
                String shortName = PlatformConfigHelperUtil.findNextValidServerShortName(serverIndexes);
                String clusterShortName = PlatformConfigHelperUtil.findNextValidClusterShortName(serverIndexes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shortName ", shortName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clusterShortName ", clusterShortName);
                }
                if (s != null) {
                    List props = PlatformConfigHelperUtil.getApplicationServerProperties(s);
                    for (int i = 0; i < props.size(); ++i) {
                        Property p = (Property)props.get(i);
                        if (p.getName().equals("was.ClusterTransitionUUID")) {
                            c.setUniqueId(p.getValue());
                            props.remove(i);
                            --i;
                            continue;
                        }
                        if (!p.getName().equals("ClusterTransitionName")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting cluster shortname  from server transition name", p.getValue());
                        }
                        if (c.getShortName() == null) {
                            c.setShortName(p.getValue());
                        }
                        props.remove(i);
                        --i;
                    }
                    try {
                        URI uri = URI.createURI("server.xml");
                        Resource res = s.eResource().getResourceSet().getResource(uri, true);
                        res.save(new HashMap());
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", (String)"141", (Object)this);
                        e.printStackTrace();
                    }
                } else {
                    String serverUuid = null;
                    if (!AdminHelper.getPlatformHelper().isZOS()) {
                        ConfigService configService = ConfigServiceFactory.getConfigService();
                        serverUuid = PlatformConfigHelperUtil.getNodeAgentUuid(session, configService, nodeContext);
                    } else {
                        serverUuid = AdminHelper.getPlatformHelper().getUniqueId();
                    }
                    c.setUniqueId(serverUuid);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting cluster shortname ", clusterShortName);
                    }
                    c.setShortName(clusterShortName);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", (String)"163", (Object)this);
                Tr.error(tc, "Error during configureServerClusterFromServer", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureServerClusterFromServer", c);
        }
    }

    public String calculatedServerClusterShortName() {
        return null;
    }

    public void modifyClusterShortName(ServerCluster sc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyClusterShortName", new Object[]{sc});
        }
        String shortName = sc.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "shortname", shortName);
        }
        RepositoryContext cellCtx = ((ContextResourceSet)sc.eResource().getResourceSet()).getContext().getParent();
        EList list = sc.getMembers();
        for (ClusterMember cm : list) {
            String node_name = cm.getNodeName();
            RepositoryContextType nodeType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
            Resource res = null;
            try {
                RepositoryContext nodeCtx = cellCtx.getChild(nodeType, node_name);
                URI uri = URI.createURI("serverindex.xml");
                res = nodeCtx.getResourceSet().getResource(uri, true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.modifyClusterShortName", (String)"201", (Object)this);
                e.printStackTrace();
            }
            ServerIndex server_index = (ServerIndex)res.getContents().get(0);
            ServerEntry server_entry = PlatformConfigHelperUtil.lookupServerEntry(server_index, cm.getMemberName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifying server entry for node=" + node_name + " server=" + cm.getMemberName());
            }
            server_entry.setGenericShortName(shortName);
            try {
                res.save(new HashMap());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.modifyClusterShortName", (String)"211", (Object)this);
                e.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyClusterShortName");
        }
    }
}

