/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.CompatibilityDocumentHandler;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformRepository;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class VersionMetadata {
    private static TraceComponent tc = Tr.register(VersionMetadata.class, "Transform", "com.ibm.ws.management.resources.sync");
    private static final String COMPATIBILITY_DOCNAME = "compatibility.xml";
    private static HashMap productCompatibilityInformation = new HashMap();

    public static String getCanonicalVersion(String version) {
        String result = version.startsWith("7.") ? "7.x" : (version.startsWith("6.1") ? "6.1.x" : (version.startsWith("6.0.2") ? "6.0.2.x" : (version.startsWith("6.0") ? "6.0.x" : (version.startsWith("5.") ? "5.x" : (version.equals("5") ? "5.x" : version)))));
        return result;
    }

    private static String getCanonicalVersion(String version, Vector properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalVersion", version);
        }
        String canonicalVersion = null;
        boolean finished = false;
        for (int i = 0; i < properties.size(); ++i) {
            Properties props = (Properties)properties.get(i);
            Enumeration<?> myEnum = props.propertyNames();
            String key = (String)myEnum.nextElement();
            String value = (String)props.get(key);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found key " + key + " and value " + value);
            }
            if (canonicalVersion == null) {
                canonicalVersion = new String(value);
            }
            if (version.equals(key)) {
                canonicalVersion = new String(value);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCanonicalVersion", canonicalVersion);
                }
                return value;
            }
            boolean done = false;
            int oldVersionIndex = 0;
            int oldKeyIndex = 0;
            while (!done) {
                int kint;
                String s1 = VersionMetadata.getNextSubcomponent(version, oldVersionIndex, 46);
                String s2 = VersionMetadata.getNextSubcomponent(key, oldKeyIndex, 46);
                if (s1 == null && s2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Version and key are the same");
                    }
                    canonicalVersion = new String(value);
                    done = true;
                    finished = true;
                    break;
                }
                if (s1 == null && s2 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, key + " is greater than " + version);
                    }
                    done = true;
                    finished = true;
                    break;
                }
                if (s1 != null && s2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, version + " is greater than " + key);
                    }
                    canonicalVersion = new String(value);
                    done = true;
                    break;
                }
                Integer vInt = new Integer(s1);
                Integer kInt = new Integer(s2);
                int vint = vInt;
                if (vint > (kint = kInt.intValue())) {
                    canonicalVersion = new String(value);
                    done = true;
                    break;
                }
                if (vint < kint) {
                    done = true;
                    finished = true;
                    break;
                }
                oldVersionIndex += s1.length() + 1;
                oldKeyIndex += s2.length() + 1;
            }
            if (finished) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalVersion", canonicalVersion);
        }
        return canonicalVersion;
    }

    private static String getNextSubcomponent(String string, int startIndex, int separator) {
        if (startIndex >= string.length()) {
            return null;
        }
        int i = string.indexOf(separator, startIndex);
        if (i > 0) {
            String s = string.substring(startIndex, i);
            return s;
        }
        String s = string.substring(startIndex);
        return s;
    }

    protected static String getCanonicalVersion(String version, String product2) throws AdminException {
        InputStream input;
        Vector productVector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalVersion", " version = " + version + ", product = " + product2);
        }
        Vector productVersions = null;
        if (productCompatibilityInformation.containsKey(product2) && (productVector = (Vector)productCompatibilityInformation.get(product2)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The canonical versions for this product have already been processed.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCanonicalVersion", " version " + version + " product + " + product2 + ": " + VersionMetadata.getCanonicalVersion(version, productVector));
            }
            return VersionMetadata.getCanonicalVersion(version, productVector);
        }
        String docURI = "xforms/" + product2 + "/" + COMPATIBILITY_DOCNAME;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCanonicalVersion() tries " + docURI);
        }
        try {
            input = TransformRepository.extract2(docURI);
        }
        catch (Throwable t) {
            version = "NONE";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCanonicalVersion", " version " + version + " product + " + product2 + "; no compatibility.xml");
            }
            return version;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing compatibility file ", docURI);
        }
        VersionMetadata.processCompatibilityXML(input, product2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalVersion", " version " + version + " product " + product2);
        }
        productVersions = (Vector)productCompatibilityInformation.get(product2);
        return VersionMetadata.getCanonicalVersion(version, productVersions);
    }

    private static void processCompatibilityXML(InputStream input, String product2) throws TransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCompatibilityXML", "Product " + product2);
        }
        try {
            InputStreamReader inputReader = new InputStreamReader(input);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(inputReader);
            CompatibilityDocumentHandler handler = new CompatibilityDocumentHandler();
            parser.parse(source, (DefaultHandler)handler);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding " + product2 + " compatibility data to product storage: " + handler.getVersionMappings());
            }
            productCompatibilityInformation.put(product2, handler.getVersionMappings());
        }
        catch (Throwable t) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processCompatibilityXML", "Product " + product2);
            }
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.loadMetadata", (String)"229");
            throw new TransformException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCompatibilityXML", "Product " + product2);
        }
    }

    private static AdminException getAdminException(Throwable t) {
        AdminException e = t instanceof AdminException ? (AdminException)t : new AdminException(t);
        return e;
    }
}

