/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.AggregatedKeyIterator;
import com.ibm.ws.management.transform.AggregatedKeyValuePair;
import com.ibm.ws.management.transform.NamespaceTransformer;
import com.ibm.ws.management.transform.NamespaceTransformerFactory;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformMap;
import com.ibm.ws.management.transform.TransformRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransformMetadata
implements ResourceNameFilter,
ConfigRepositoryListener {
    public static final String XFORMS_FOLDER = "xforms";
    public static final String XFORMED_FOLDER = "xformed";
    public static final String XFORM_METADATA_DOCNAME = "transformMetadata.xml";
    public static final String XFORM_METADATA_BASENAME = "transformMetadata";
    public static final String XFORM_METADATA_EXTENSION = ".xml";
    public static final String NO_PRODUCT = "noproduct";
    private static Map metadata = new HashMap();
    private Map documentTransforms;
    private Map documentFilters;
    private NamespaceTransformer nsTransformer;
    private String version;
    WriterPriorityReadersWriterLock lock;
    private boolean needsReload = true;
    private Properties properties;
    private String dmgrKey;
    private String nodeKey;
    private static TraceComponent tc = Tr.register(TransformMetadata.class, "Transform", "com.ibm.ws.management.resources.sync");

    public static synchronized TransformMetadata getTransformMetadata(String version, String dmgrKey, String nodeKey) throws AdminException {
        TransformMetadata tm;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransformMetadata", new Object[]{dmgrKey, nodeKey});
        }
        if ((tm = (TransformMetadata)metadata.get(nodeKey)) == null) {
            tm = new TransformMetadata(version, dmgrKey, nodeKey);
            metadata.put(nodeKey, tm);
        }
        return tm;
    }

    public TransformMetadata(String version, String dmgrKey, String nodeKey) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating TransformMetadata for ", version + " " + dmgrKey + " " + nodeKey);
        }
        this.version = version;
        this.dmgrKey = new String(dmgrKey);
        this.nodeKey = new String(nodeKey);
        this.lock = new WriterPriorityReadersWriterLock();
        this.load(version, dmgrKey, nodeKey);
    }

    private synchronized void load(String version, String dmgrKey, String nodeKey) throws AdminException {
        if (this.needsReload) {
            this.lockForWriting();
            try {
                try {
                    AggregatedKeyIterator dmgrIterator = this.getAggregatedKeyIterator(dmgrKey);
                    AggregatedKeyIterator nodeIterator = this.getAggregatedKeyIterator(nodeKey);
                    AggregatedKeyValuePair dmgrPair = (AggregatedKeyValuePair)dmgrIterator.next();
                    AggregatedKeyValuePair nodePair = (AggregatedKeyValuePair)nodeIterator.next();
                    String dmgrProduct = dmgrPair.getKey();
                    String dmgrVersion = dmgrPair.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load", "dmgrProduct = " + dmgrProduct + " dmgrVersion = " + dmgrVersion);
                    }
                    String nodeProduct = nodePair.getKey();
                    String nodeVersion = nodePair.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load", "nodeProduct = " + nodeProduct + " nodeVersion = " + nodeVersion);
                    }
                    if (dmgrVersion.compareTo(nodeVersion) == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load", "Base product versions are compatible");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load", "Base product versions are not compatible");
                        }
                        this.loadMetadataHelper(nodeVersion, nodeProduct);
                    }
                    while (dmgrIterator.hasNext()) {
                        dmgrPair = (AggregatedKeyValuePair)dmgrIterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The next dmgr product is " + dmgrPair.getKey() + " at version " + dmgrPair.getValue());
                        }
                        if (nodeIterator.hasNext()) {
                            nodePair = (AggregatedKeyValuePair)nodeIterator.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The next node product is " + nodePair.getKey() + " at version " + nodePair.getValue());
                            }
                            boolean done = false;
                            while (!done) {
                                if (dmgrPair.getKey().equals(nodePair.getKey())) {
                                    if (dmgrPair.getValue().equals(nodePair.getValue())) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Product " + dmgrPair.getKey() + " on dmgr and node are compatible");
                                        }
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Product " + dmgrPair.getKey() + " is downlevel at version " + nodePair.getValue() + " on node; they are not compatible");
                                        }
                                        String newVersion = nodePair.getValue();
                                        this.loadMetadataHelper(newVersion, nodePair.getKey());
                                    }
                                    done = true;
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "dmgr will filter out product " + dmgrPair.getKey());
                                }
                                this.loadMetadataHelper(NO_PRODUCT, dmgrPair.getKey());
                                dmgrPair = (AggregatedKeyValuePair)dmgrIterator.next();
                            }
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "dmgr will filter out product " + dmgrPair.getKey());
                        }
                        this.loadMetadataHelper(NO_PRODUCT, dmgrPair.getKey());
                    }
                    if (nodeIterator.hasNext()) {
                        nodePair = (AggregatedKeyValuePair)nodeIterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The next node product not installed on the dmgr is " + nodePair.getKey() + " at version " + nodePair.getValue());
                        }
                        String newVersion = nodePair.getValue();
                        this.loadMetadataHelper(newVersion, nodePair.getKey());
                    }
                    this.needsReload = false;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.load", (String)"148", (Object)this);
                    throw this.getAdminException(t);
                }
                Object var15_16 = null;
                this.unlockForWriting();
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                this.unlockForWriting();
                throw throwable;
            }
        }
    }

    private boolean loadProductMetadata(String version, String product2) throws AdminException {
        InputStream input;
        String folder = "xforms/" + product2 + "/" + version;
        String docURI = folder + "/" + XFORM_METADATA_DOCNAME;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadProductMetadata tries " + docURI);
        }
        try {
            input = TransformRepository.extract2(docURI);
        }
        catch (Throwable t) {
            docURI = "xforms/" + version + "/" + XFORM_METADATA_DOCNAME;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadProductMetadata retries " + docURI);
            }
            try {
                input = TransformRepository.extract(docURI);
            }
            catch (Throwable t2) {
                FFDCFilter.processException((Throwable)t2, (String)"com.ibm.ws.management.transform.TransformMetadata.loadProductMetadata", (String)"172", (Object)this);
                throw this.getAdminException(t2);
            }
        }
        boolean result = false;
        if (input != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loading product transform metadata", docURI);
            }
            this.loadMetadata(input, product2, version);
            result = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is no transform metadata for product " + product2 + " at version " + version);
        }
        return result;
    }

    private void loadExtensionsMetadata(String version, String product2) {
        String[] extensions;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadExtensionsMetadata version = " + version + " product = " + product2);
        }
        if ((extensions = TransformRepository.getExtensionMetadata(version, product2)) != null) {
            for (int i = 0; i < extensions.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading extensions transform metadata", extensions[i]);
                }
                try {
                    InputStream input = TransformRepository.extract(extensions[i]);
                    this.loadMetadata(input, version);
                    continue;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.loadExtensionsMetadata", (String)"209", (Object)this);
                }
            }
        }
    }

    private void loadMetadata(InputStream input, String product2, String version) throws TransformException {
        try {
            InputStreamReader inputReader = new InputStreamReader(input);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(inputReader);
            TransformMetadataDocumentHandler handler = new TransformMetadataDocumentHandler(product2, version);
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.loadMetadata", (String)"229", (Object)this);
            throw new TransformException(t);
        }
    }

    private void loadMetadata(InputStream input, String version) throws TransformException {
        try {
            InputStreamReader inputReader = new InputStreamReader(input);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputSource source = new InputSource(inputReader);
            TransformMetadataDocumentHandler handler = new TransformMetadataDocumentHandler(null, version);
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.loadMetadata", (String)"229", (Object)this);
            throw new TransformException(t);
        }
    }

    private void loadNamespaceMetadata(String version, String product2) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadNamespaceMetadata version = " + version + " product = " + product2);
        }
        String docURI = "xforms/" + version;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadNamespaceMetadata tries with " + docURI);
        }
        this.nsTransformer = NamespaceTransformerFactory.getNamespaceTransformer(docURI);
        if (this.nsTransformer.mapIsEmpty()) {
            docURI = "xforms/" + product2 + "/" + version;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadNamespaceMetadata retries with " + docURI);
            }
            this.nsTransformer = NamespaceTransformerFactory.getNamespaceTransformer(docURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapIsEmpty = " + this.nsTransformer.mapIsEmpty());
            }
        }
    }

    public NamespaceTransformer getNamespaceTransformer() {
        return this.nsTransformer;
    }

    public boolean accept(String parent, String docName) {
        boolean result = false;
        if (docName.startsWith(XFORM_METADATA_BASENAME) && docName.endsWith(XFORM_METADATA_EXTENSION) && !docName.equals(XFORM_METADATA_DOCNAME)) {
            result = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "accept", new Object[]{parent, docName, result ? Boolean.TRUE : Boolean.FALSE});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filteredDoc(String folder, String docName) throws AdminException {
        boolean result = false;
        if (this.needsReload) {
            this.load(this.version, this.dmgrKey, this.nodeKey);
        }
        this.lockForReading();
        try {
            block6: {
                try {
                    if (this.documentFilters == null || !this.documentFilters.containsKey(docName)) break block6;
                    List scopes = (List)this.documentFilters.get(docName);
                    if (scopes == null) {
                        result = true;
                        break block6;
                    }
                    result = scopes.contains(this.getDocScope(folder + "/" + docName));
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.filteredDoc", (String)"300", (Object)this);
                    Object var6_7 = null;
                    this.unlockForReading();
                }
            }
            Object var6_6 = null;
            this.unlockForReading();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlockForReading();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTransforms(String docURI) throws AdminException {
        if (this.needsReload) {
            this.load(this.version, this.dmgrKey, this.nodeKey);
        }
        this.lockForReading();
        ArrayList<TransformMap> result = null;
        try {
            block12: {
                try {
                    List mappings;
                    if (this.documentTransforms == null) break block12;
                    String docName = this.getDocName(docURI);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "docname = " + docName + " from docURI " + docURI);
                    }
                    if ((mappings = (List)this.documentTransforms.get(docName)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mappings are not null.");
                        }
                        for (TransformMap tmap : mappings) {
                            List scopes = tmap.getScopes();
                            if (scopes == null) {
                                if (result == null) {
                                    result = new ArrayList<TransformMap>();
                                }
                                result.add(tmap);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "matching tmap with all scopes; transform list is", tmap.getTransformURIs());
                                continue;
                            }
                            String scope = this.getDocScope(docURI);
                            if (!scopes.contains(scope)) continue;
                            if (result == null) {
                                result = new ArrayList();
                            }
                            result.add(tmap);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "matching tmap with specific scope; transform list is", tmap.getTransformURIs());
                        }
                        break block12;
                    }
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "no entries for", docName);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.TransformMetadata.getTransforms", (String)"372", (Object)this);
                    Object var10_11 = null;
                    this.unlockForReading();
                }
            }
            Object var10_10 = null;
            this.unlockForReading();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.unlockForReading();
            throw throwable;
        }
        return result;
    }

    private String getDocName(String docURI) {
        String name = docURI;
        int index = docURI.lastIndexOf("/");
        if (index != -1) {
            name = docURI.substring(docURI.lastIndexOf("/") + 1);
        }
        return name;
    }

    private String getDocScope(String docURI) {
        StringTokenizer st = new StringTokenizer(docURI, "/");
        int scopeToken = st.countTokens() - 2;
        String scope = null;
        for (int i = 0; i < scopeToken; ++i) {
            scope = st.nextToken();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDocScope", new Object[]{docURI, scope});
        }
        return scope;
    }

    private void lockForReading() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lockForReading", this.version);
        }
        boolean locked = false;
        while (!locked) {
            try {
                this.lock.startReading();
                locked = true;
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.TransformMetadata.lockForReading", (String)"421", (Object)this);
            }
        }
    }

    private void unlockForReading() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unlockForReading", this.version);
        }
        this.lock.stopReading();
    }

    private void lockForWriting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lockForWriting", this.version);
        }
        boolean locked = false;
        while (!locked) {
            try {
                this.lock.startWriting();
                locked = true;
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.transform.TransformMetadata.lockForWriting", (String)"448", (Object)this);
            }
        }
    }

    private void unlockForWriting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unlockForWriting", this.version);
        }
        this.lock.stopWriting();
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        ConfigChangeNotifier[] changes = event2.getChanges();
        if (changes != null) {
            for (int i = 0; i < changes.length && !this.needsReload; ++i) {
                String uri = changes[i].getUri();
                if (!this.getDocName(uri).startsWith(XFORM_METADATA_BASENAME) || uri.indexOf(this.version) == -1) continue;
                this.lockForWriting();
                this.needsReload = true;
                this.unlockForWriting();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "needsReload onChangeCompletion", uri);
            }
        }
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
    }

    public void onRepositoryEpochRefresh() {
        this.lockForWriting();
        this.needsReload = true;
        this.unlockForWriting();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "needsReload onRepositoryEpochRefresh", this.version);
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    private AdminException getAdminException(Throwable t) {
        AdminException e = t instanceof AdminException ? (AdminException)t : new AdminException(t);
        return e;
    }

    private void loadMetadataHelper(String version, String product2) throws AdminException {
        if (this.documentTransforms == null) {
            this.documentTransforms = new HashMap();
            this.documentFilters = new HashMap();
        }
        if (this.loadProductMetadata(version, product2)) {
            this.loadExtensionsMetadata(version, product2);
            this.loadNamespaceMetadata(version, product2);
        }
    }

    protected AggregatedKeyIterator getAggregatedKeyIterator(String aggregatedKey) {
        AggregatedKeyIterator aki = new AggregatedKeyIterator(aggregatedKey);
        return aki;
    }

    static /* synthetic */ String access$100(TransformMetadata x0) {
        return x0.version;
    }

    private class TransformMetadataDocumentHandler
    extends DefaultHandler {
        private StringBuffer charBuffer = null;
        private String document;
        private List transforms;
        private List scopes;
        private String className;
        private String classPath;
        private List transformMappings = new ArrayList();
        private List transformFilters = new ArrayList();
        private String folder = "xforms/" + TransformMetadata.access$100(TransformMetadata.this) + "/";
        private String product;

        private TransformMetadataDocumentHandler(String product2, String newVersion) {
            if (product2 == null) {
                this.product = null;
            } else {
                this.product = new String(product2);
                if (!product2.equals("base")) {
                    this.folder = "xforms/" + product2 + "/" + newVersion + "/";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redefining folder to " + this.folder);
                    }
                }
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            this.charBuffer = new StringBuffer();
            if (qname.equals("transformMap") || qname.equals("transformFilter")) {
                this.document = null;
                this.transforms = null;
                this.scopes = null;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuffer.append(ch, start, length);
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            if (qname.equals("document")) {
                this.document = this.charBuffer.toString();
            } else if (qname.equals("transform")) {
                if (this.transforms == null) {
                    this.transforms = new ArrayList();
                }
                this.transforms.add(this.folder + this.charBuffer.toString());
            } else if (qname.equals("scope")) {
                if (this.scopes == null) {
                    this.scopes = new ArrayList();
                }
                this.scopes.add(this.charBuffer.toString());
            } else if (qname.equals("className")) {
                this.className = this.charBuffer.toString();
            } else if (qname.equals("classPath")) {
                this.classPath = this.charBuffer.toString();
            } else if (qname.equals("transformMap")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New transformMap", new Object[]{this.document, this.transforms, this.scopes});
                }
                TransformMap transformMap = new TransformMap(this.document, this.transforms, this.scopes, true);
                this.transformMappings = (List)TransformMetadata.this.documentTransforms.get(this.document);
                if (this.transformMappings == null) {
                    this.transformMappings = new ArrayList();
                    TransformMetadata.this.documentTransforms.put(this.document, this.transformMappings);
                }
                this.transformMappings.add(transformMap);
            } else if (qname.equals("customTransform")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New customTransform", new Object[]{this.document, this.className, this.classPath});
                }
                TransformMap transformMap = new TransformMap(this.document, this.scopes, this.className, this.classPath, true);
                this.transformMappings = (List)TransformMetadata.this.documentTransforms.get(this.document);
                if (this.transformMappings == null) {
                    this.transformMappings = new ArrayList();
                    TransformMetadata.this.documentTransforms.put(this.document, this.transformMappings);
                }
                this.transformMappings.add(transformMap);
            } else if (qname.equals("transformFilter")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New transformFilter", new Object[]{this.document, this.scopes});
                }
                if (TransformMetadata.this.documentFilters.containsKey(this.document)) {
                    List filterScopes = (List)TransformMetadata.this.documentFilters.get(this.document);
                    if (filterScopes == null) {
                        TransformMetadata.this.documentFilters.put(this.document, this.scopes);
                    } else if (this.scopes != null) {
                        filterScopes.addAll(this.scopes);
                        TransformMetadata.this.documentFilters.put(this.document, filterScopes);
                    }
                } else {
                    TransformMetadata.this.documentFilters.put(this.document, this.scopes);
                }
            }
        }
    }
}

