/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.transform.ConfigTransformer;
import com.ibm.websphere.management.transform.ConfigTransformerWithDocUri;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.NamespaceTransformer;
import com.ibm.ws.management.transform.RepositoryURIResolver;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class DocumentTransformer {
    private RepositoryURIResolver uriResolver;
    private int splitLimit;
    private static TraceComponent tc = Tr.register(DocumentTransformer.class, "Transform", "com.ibm.ws.management.resources.sync");

    public DocumentTransformer(RepositoryURIResolver resolver) {
        this.uriResolver = resolver;
        this.splitLimit = Integer.getInteger("com.ibm.ws.management.transform.split-limit", 1000);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DocumentTransformer setting split-limit to " + this.splitLimit);
        }
    }

    public InputStream transform(InputStream source, List xformMaps, NamespaceTransformer nt, String docURI) throws TransformException {
        source = this.fixNamespaces(nt, source);
        ArrayList workingXformMaps = new ArrayList();
        workingXformMaps.addAll(xformMaps);
        boolean done = false;
        while (!done) {
            if (this.hasCustomTransformer(workingXformMaps)) {
                source = this.customTransform(source, workingXformMaps, docURI);
                workingXformMaps.remove(0);
                if (workingXformMaps.size() == 0) {
                    done = true;
                }
            } else {
                ArrayList<TransformMap> newXformList = new ArrayList<TransformMap>();
                int counter = 0;
                boolean finished = false;
                while (!finished) {
                    Iterator i = workingXformMaps.iterator();
                    if (!i.hasNext()) continue;
                    TransformMap tm = (TransformMap)i.next();
                    if (tm.getCustomClassName() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found XSL transform " + tm.getDocName());
                        }
                        newXformList.add(counter++, tm);
                        workingXformMaps.remove(tm);
                        if (workingXformMaps.size() != 0) continue;
                        finished = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "All transforms found.");
                        continue;
                    }
                    finished = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found custom transform " + tm.getCustomClassName());
                }
                ArrayList<String> urlList = new ArrayList<String>();
                counter = 0;
                for (TransformMap xformMap : newXformList) {
                    List list = xformMap.getTransformURIs();
                    if (list != null) {
                        for (int j = 0; j < list.size(); ++j) {
                            String url = (String)list.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "urlList element = " + url);
                            }
                            urlList.add(counter++, url);
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No transformURIs found");
                }
                List xforms = this.gatherTransformStreams(newXformList);
                int counter2 = 0;
                if (xforms.size() > 0) {
                    Iterator i = xforms.iterator();
                    while (i.hasNext()) {
                        source = this.transform(source, (InputStream)i.next(), (String)urlList.get(counter2++));
                    }
                }
            }
            if (workingXformMaps.size() != 0) continue;
            done = true;
        }
        InputStream result = source;
        return result;
    }

    /*
     * Loose catch block
     */
    private InputStream fixNamespaces(NamespaceTransformer nsTransformer, InputStream doc) throws TransformException {
        ByteArrayOutputStream output;
        block9: {
            InputStreamReader reader = new InputStreamReader(doc, Charset.forName("UTF-8"));
            output = new ByteArrayOutputStream(2048);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, Charset.forName("UTF-8"));
            nsTransformer.transform(reader, writer);
            writer.close();
            Object var8_6 = null;
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
                break block9;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.fixNamespaces", (String)"129", (Object)this);
            }
            break block9;
            {
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.fixNamespaces", (String)"108", (Object)this);
                    throw this.getTransformException(t);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.fixNamespaces", (String)"129", (Object)this);
                }
                throw throwable;
            }
        }
        ByteArrayInputStream result = new ByteArrayInputStream(output.toByteArray());
        return result;
    }

    private List gatherTransformStreams(List xformMaps) throws TransformException {
        ArrayList xforms = new ArrayList();
        for (TransformMap xformMap : xformMaps) {
            if (xformMap.getTransformURIs() == null) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "gatherTransformStreams adding " + xformMap.getTransformURIs());
                }
                xforms.addAll(xformMap.getTransformStreams());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.gatherTransformStreams", (String)"131", (Object)this);
                throw new TransformException(t);
            }
        }
        return xforms;
    }

    private TransformException getTransformException(Throwable t) {
        TransformException e = t instanceof TransformException ? (TransformException)t : new TransformException(t);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream transform(InputStream source, InputStream xform, String uri) throws TransformException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "transform called with uri = " + uri);
        }
        ByteArrayOutputStream output = null;
        try {
            StreamSource xformSource = new StreamSource(xform);
            StreamSource input = new StreamSource(source);
            output = new ByteArrayOutputStream(2048);
            StreamResult result = new StreamResult(output);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/split-limit", this.splitLimit);
            String version = this.extractVersion(uri);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Version " + version + " was extracted from uri " + uri);
            }
            String string = version;
            synchronized (string) {
                this.uriResolver.replaceVersion(version);
                tFactory.setURIResolver(this.uriResolver);
                Transformer transformer = tFactory.newTransformer(xformSource);
                transformer.transform(input, result);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.transform", (String)"174", (Object)this);
            throw this.getTransformException(t);
        }
        source = new ByteArrayInputStream(output.toByteArray());
        return source;
    }

    private boolean hasCustomTransformer(List xformMaps) {
        if (xformMaps != null) {
            TransformMap tm = (TransformMap)xformMaps.get(0);
            return tm.getCustomClassName() != null;
        }
        return false;
    }

    private InputStream customTransform(InputStream source, List xformMaps, String docURI) {
        InputStream resultStream = null;
        TransformMap tm = (TransformMap)xformMaps.get(0);
        try {
            ConfigTransformer transformer = tm.getCustomTransformer();
            if (transformer == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigTransformer class not found");
                }
                ConfigTransformerWithDocUri transformer2 = tm.getCustomTransformerWithDocUri();
                resultStream = transformer2.transform(source, docURI);
            } else {
                resultStream = transformer.transform(source);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.transform.DocumentTransformer.customTransform", (String)"275", (Object)this);
        }
        return resultStream;
    }

    private String extractVersion(String url) {
        int i = url.indexOf(47);
        char[] cArray = url.toCharArray();
        if (cArray[i + 1] >= '0' && cArray[i + 1] <= '9') {
            int j = url.indexOf(47, i + 1);
            String substring = url.substring(i + 1, j);
            return substring;
        }
        i = url.indexOf(47, i + 1);
        int j = url.indexOf(47, i + 1);
        String substring = url.substring(i + 1, j);
        return substring;
    }
}

