/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompatibilityDocumentHandler
extends DefaultHandler {
    private static TraceComponent tc = Tr.register(CompatibilityDocumentHandler.class, "Transform", "com.ibm.ws.management.resources.sync");
    private StringBuffer charBuffer = null;
    private String beginningVersion;
    private String canonicalName;
    private Properties versionMappings = new Properties();
    private static String BEGINNING_VERSION = "beginningVersion";
    private static String CANONICAL_NAME = "canonicalName";
    private static String VERSION_GROUP = "versionGroup";

    protected CompatibilityDocumentHandler() {
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        this.charBuffer = new StringBuffer();
        if (qname.equals(VERSION_GROUP)) {
            int i = attributes.getLength();
            for (int j = 0; j < i; ++j) {
                if (attributes.getQName(j).equals(BEGINNING_VERSION)) {
                    this.beginningVersion = attributes.getValue(j);
                    continue;
                }
                if (!attributes.getQName(j).equals(CANONICAL_NAME)) continue;
                this.canonicalName = attributes.getValue(j);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charBuffer.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (qname.equals(BEGINNING_VERSION)) {
            this.beginningVersion = this.charBuffer.toString();
        } else if (qname.equals(CANONICAL_NAME)) {
            this.canonicalName = this.charBuffer.toString();
        } else if (qname.equals(VERSION_GROUP)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New canonical version mapping", new Object[]{this.beginningVersion, this.canonicalName});
            }
            this.versionMappings.setProperty(this.beginningVersion, this.canonicalName);
        }
    }

    protected Vector getVersionMappings() {
        Object[] versions = new String[this.versionMappings.size()];
        int index = 0;
        Enumeration<?> myEnum = this.versionMappings.propertyNames();
        while (myEnum.hasMoreElements()) {
            String key = (String)myEnum.nextElement();
            versions[index++] = new String(key);
        }
        Arrays.sort(versions);
        Vector<Properties> vector = new Vector<Properties>(versions.length);
        for (index = 0; index < versions.length; ++index) {
            Properties newProperty = new Properties();
            newProperty.setProperty((String)versions[index], this.versionMappings.getProperty((String)versions[index]));
            vector.add(index, newProperty);
        }
        return vector;
    }
}

