/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.ConnectorHelper;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.tools.WsServerController;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class WsServerStop
extends WsServerController {
    private static final String DEFAULT_TRACE_FILE = "stopServer.log";
    private static TraceComponent tc = Tr.register(WsServerStop.class, "Admin", BUNDLE_NAME);
    private BeanContextServices bc = null;
    private Repository repository = null;
    private String hostName = null;
    private String portNumber = null;
    private String connType = null;
    private boolean stopServers = false;
    private boolean saveNodeState = false;
    private VariableMap variableMap = null;
    private static int twentyMinutes = 1200000;

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + this.serverName;
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    public static void main(String[] args) throws AdminException {
        WsServerStop wsServerStop = new WsServerStop();
        if (!WsServerStop.isPlatformWindows()) {
            System.exit(wsServerStop.executeUtility(args));
        }
        wsServerStop.writeExitCode(args, wsServerStop.executeUtilityOnWindows(args));
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] args) throws AdminException {
        WindowsService winSvc = super.getWindowsServiceIfAvailable(args);
        if (winSvc != null) {
            try {
                if (winSvc.getServiceStatus() != 2) {
                    winSvc = null;
                }
            }
            catch (AdminException exc) {
                winSvc = null;
            }
        }
        return winSvc;
    }

    protected void execWithWinService(WindowsService winSvc) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execWithWinService");
        }
        winSvc.doWASServiceAction("stop", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execWithWinService");
        }
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-port")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.portNumber = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-conntype")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.connType = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-stopservers")) {
            this.stopServers = true;
        } else if (option.equals("-saveNodeState")) {
            this.saveNodeState = true;
        } else {
            nextOption = super.parseUtilitySpecificOption(args, curOption);
        }
        return nextOption;
    }

    protected void issueUsageMessage() {
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4014I", null, null);
        } else if (this.isDmgr) {
            this.issueMessage("ADMU4015I", null, null);
        } else {
            this.issueMessage("ADMU4003I", null, null);
        }
        this.issueMessage("ADMU4002I", null, null);
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4013I", null, null);
        }
        this.issueMessage("ADMU4004I", null, null);
        this.issueMessage("ADMU4010I", null, null);
        this.issueMessage("ADMU4012I", null, null);
        this.issueMessage("ADMU4011I", null, null);
        this.issueMessage("ADMU4006I", null, null);
        this.issueMessage("ADMU4009I", null, null);
        this.issueMessage("ADMU4020I", null, null);
        this.issueMessage("ADMU4022I", null, null);
        this.issueMessage("ADMU4023I", null, null);
        this.issueMessage("ADMU4024I", null, null);
        this.issueMessage("ADMU4026I", null, null);
        this.issueMessage("ADMU4025I", null, null);
    }

    private void stopAllServers(AdminClient admin) throws Exception {
        ObjectName mbean = null;
        Set s = null;
        try {
            mbean = new ObjectName("WebSphere:*,type=NodeAgent,node=" + this.nodeName + ",process=nodeagent");
            Tr.debug(tc, "mbean " + mbean.getCanonicalName());
            s = admin.queryNames(mbean, null);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.tools.WsServerStop.stopAllServers", (String)"161", (Object)this);
            throw new AdminException("Failed to query NodeAgent mbean at node: " + this.nodeName);
        }
        ObjectName objectName = mbean = s.iterator().hasNext() ? (ObjectName)s.iterator().next() : null;
        if (mbean == null) {
            throw new AdminException("no NodeAgent mbean found at node: " + this.nodeName);
        }
        String[] signature = new String[]{};
        Object[] params = new Object[]{};
        admin.invoke(mbean, "stopNode", params, signature);
    }

    /*
     * Unable to fully structure code
     */
    public int runTool() throws Exception {
        block35: {
            block33: {
                block34: {
                    block31: {
                        block32: {
                            block37: {
                                status = 0;
                                admin = null;
                                if (this.portNumber == null) break block37;
                                if (this.hostName == null) {
                                    this.hostName = "localhost";
                                }
                                if (this.connType == null) {
                                    this.connType = "SOAP";
                                }
                                this.issueMessage("ADMU3101I", new Object[]{this.hostName, this.portNumber, this.serverName}, null);
                                connProps = new Properties();
                                connProps.setProperty("host", this.hostName);
                                connProps.setProperty("port", this.portNumber);
                                connProps.setProperty("type", this.connType);
                                if (this.userid != null) {
                                    connProps.setProperty("username", this.userid);
                                }
                                if (this.pwd != null) {
                                    connProps.setProperty("password", this.pwd);
                                }
                                admin = AdminClientFactory.createAdminClient(connProps);
                                ** GOTO lbl92
                            }
                            if (this.serverConfigExists()) break block31;
                            this.issueMessage("ADMU3522E", new Object[]{this.serverName}, null);
                            connProps = -1;
                            var10_9 = null;
                            if (this.statusSocket == null) break block32;
                            try {
                                this.statusSocket.close();
                            }
                            catch (IOException x) {
                                // empty catch block
                            }
                        }
                        return connProps;
                    }
                    this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
                    this.bc = new BeanContextServicesSupport();
                    configService = ConfigServiceFactory.createConfigService((String)this.configRoot, (String)this.cellName, (String)this.nodeName, (String)this.serverName);
                    this.repository = RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)this.cellName, (String)this.nodeName, (String)this.serverName);
                    this.bc.addService(Repository.class, (BeanContextServiceProvider)this.repository);
                    this.variableMap = VariableMapFactory.createVariableMap((Repository)this.repository);
                    this.bc.add(this.variableMap);
                    this.variableMap.initialize(null);
                    if (!GenericServerProcHelper.isServerAGenericServer(this.createServerIdentifiers()) && !GenericServerProcHelper.isServerAnIHSServer(this.createServerIdentifiers())) ** GOTO lbl79
                    tmpStatus = null;
                    tmpStatus = GenericServerProcHelper.isServerAnIHSServer(this.createServerIdentifiers()) != false ? GenericServerProcHelper.getStatusUsingPing(this.createServerIdentifiers()) : GenericServerProcHelper.getStatusUsingPidFile(this.createServerIdentifiers());
                    if (!tmpStatus.equals("RUNNING")) break block33;
                    GenericServerProcHelper.stopArbitraryServerProcess(this.createServerIdentifiers());
                    this.issueMessage("ADMU7772I", new Object[]{this.serverName}, null);
                    var5_22 = 0;
                    var10_10 = null;
                    if (this.statusSocket == null) break block34;
                    try {
                        this.statusSocket.close();
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                }
                return var5_22;
            }
            this.issueMessage("ADMU7773E", new Object[]{this.serverName}, null);
            Tr.error(WsServerStop.tc, "ADMU7773E", this.serverName);
            throw new AdminException(this.getFormattedMessage("ADMU7773E", new Object[]{this.serverName}, null));
lbl79:
            // 1 sources

            helper = new ConnectorHelper(configService, this.variableMap, null, "localhost", null, false, this.userid, this.pwd);
            protocols = new ArrayList<String>();
            remoteAdminProtocol = helper.getRemoteAdminProtocol();
            if (remoteAdminProtocol != null) {
                protocols.add(remoteAdminProtocol);
            }
            if ((localAdminProtocol = helper.getLocalAdminProtocol()) != null) {
                protocols.add(localAdminProtocol);
            }
            if ((preferredConnector = helper.getPreferredConnector()) != null) {
                protocols.add(preferredConnector);
            }
            admin = helper.createConnector(protocols, true);
lbl92:
            // 2 sources

            if (admin != null) {
                if (this.stopServers) {
                    if (this.saveNodeState) {
                        this.getServers();
                        this.issueMessage("ADMU2010I", new Object[]{this.nodeName}, null);
                        this.stopAllServers(admin);
                    } else {
                        this.stopAllServers();
                    }
                } else if (this.nowait) {
                    this.sendStop(admin);
                    this.issueMessage("ADMU3401I", null, null);
                } else {
                    this.statusPort = this.getStatusPort();
                    needToWaitForCallback = this.sendWaitStop(admin);
                    this.issueMessage("ADMU3201I", null, null);
                    status = needToWaitForCallback != false ? this.waitForServerInit(this.timeout != false ? this.statusTimeout : WsServerStop.twentyMinutes) : 0;
                    if (status == 0) {
                        this.issueMessage("ADMU4000I", new Object[]{this.serverName}, null);
                        System.out.println("");
                    } else {
                        this.issueMessage("ADMU3111E", null, null);
                        System.out.println("");
                        timeString = new Integer(this.statusTimeout / 1000).toString();
                        throw new AdminException(this.getFormattedMessage("ADMU3060E", new Object[]{timeString}, "Timed out waiting for server shutdown."));
                    }
                }
            }
            needToWaitForCallback = status;
            var10_11 = null;
            if (this.statusSocket == null) break block35;
            try {
                this.statusSocket.close();
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        return needToWaitForCallback;
        catch (ConnectorException x) {
            block36: {
                Tr.error(WsServerStop.tc, "ADMU3002E", this.serverName);
                Tr.error(WsServerStop.tc, "ADMU3007E", x.toString());
                Tr.service(WsServerStop.tc, "ADMU3007E", x);
                if (x.getMessage().indexOf("ADMN0022E") != -1) {
                    throw x;
                }
                this.issueMessage("ADMU0509I", new Object[]{"server", this.serverName}, null);
                this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
                var4_21 = -10;
                var10_12 = null;
                if (this.statusSocket == null) break block36;
                try {
                    this.statusSocket.close();
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
            return var4_21;
        }
        catch (Exception e) {
            Tr.error(WsServerStop.tc, "ADMU3002E", this.serverName);
            Tr.error(WsServerStop.tc, "ADMU3007E", e.toString());
            Tr.service(WsServerStop.tc, "ADMU3007E", e);
            throw e;
            {
                catch (Throwable var9_27) {
                    block38: {
                        var10_13 = null;
                        if (this.statusSocket == null) break block38;
                        try {
                            this.statusSocket.close();
                        }
                        catch (IOException x) {}
                    }
                    throw var9_27;
                }
            }
        }
    }

    protected boolean isFinalStatus(int result) {
        return result == 0;
    }

    protected int getFailureStatus() {
        return -10;
    }

    protected int getTimeoutStatus() {
        return -11;
    }

    protected void logUnknownException(Exception exc) {
        Tr.error(tc, "ADMU3019E", exc);
    }

    private void sendStop(AdminClient admin) throws Exception {
        ObjectName server = this.getServerHandle(admin);
        if (server != null) {
            String opName = "stop";
            admin.invoke(server, opName, null, null);
        }
    }

    private boolean sendWaitStop(AdminClient admin) throws Exception {
        boolean needToWaitForCallback = true;
        boolean rethrow = false;
        ObjectName server = this.getServerHandle(admin);
        if (server != null) {
            String opName = "stop";
            String[] signature = new String[]{"java.lang.Boolean", "java.lang.Integer"};
            Object[] params = new Object[]{new Boolean(true), this.statusPort};
            try {
                admin.invoke(server, opName, params, signature);
            }
            catch (Exception e1) {
                try {
                    admin.isAlive();
                    rethrow = true;
                    throw e1;
                }
                catch (Exception e2) {
                    if (rethrow) {
                        throw e2;
                    }
                    needToWaitForCallback = false;
                }
            }
        }
        return needToWaitForCallback;
    }

    protected void printEnhancedErrorMessage(Throwable t) {
        if (t instanceof AdminException) {
            AdminException ae = (AdminException)t;
            ae.getCause();
        } else if (t instanceof ConnectorException) {
            this.issueMessage("ADMU4122E", null, "The specified server may not be running.");
        }
    }

    private boolean serverConfigExists() {
        boolean exists = false;
        String serverPath = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers/" + this.serverName;
        File serverDir = new File(serverPath);
        if (serverDir.exists()) {
            exists = true;
        }
        return exists;
    }
}

