/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class ServerTemplateBuilder {
    protected String configRoot;
    protected String fileURI;
    protected PropertiesFactory propFactory;

    public void setConfigRoot(String root) {
        this.configRoot = root;
    }

    public void setFileName(String fileName) {
        this.fileURI = fileName;
    }

    public ServerTemplateBuilder() {
        this.initializeFactories();
    }

    private PropertySet createZOSV5defaultTemplate() {
        PropertySet v5Template = this.propFactory.createPropertySet();
        Property prop = this.propFactory.createProperty();
        prop.setName("name");
        prop.setValue("defaultZOS_5X");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductVersion");
        prop.setValue("5.0.0.0");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductMinorVersion");
        prop.setValue("0.0.0");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.nodeOperatingSystem");
        prop.setValue("os390");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductMajorVersion");
        prop.setValue("5");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("description");
        prop.setValue("");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("isSystemTemplate");
        prop.setValue("true");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("isDefaultTemplate");
        prop.setValue("true");
        v5Template.getProperties().add(prop);
        return v5Template;
    }

    private PropertySet createV5defaultTemplate() {
        PropertySet v5Template = this.propFactory.createPropertySet();
        Property prop = this.propFactory.createProperty();
        prop.setName("name");
        prop.setValue("default_5X");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductVersion");
        prop.setValue("5.0.0");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductMinorVersion");
        prop.setValue("0.0");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.nodeOperatingSystem");
        prop.setValue("");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("com.ibm.websphere.baseProductMajorVersion");
        prop.setValue("5");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("description");
        prop.setValue("");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("isSystemTemplate");
        prop.setValue("true");
        v5Template.getProperties().add(prop);
        prop = this.propFactory.createProperty();
        prop.setName("isDefaultTemplate");
        prop.setValue("true");
        v5Template.getProperties().add(prop);
        return v5Template;
    }

    public void addV5Templates() {
        try {
            List lst = this.readTemplateFile();
            lst.add(this.createV5defaultTemplate());
            lst.add(this.createZOSV5defaultTemplate());
            this.writeTemplateFile(lst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializeFactories() {
        CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveInit.init();
        ConfigInit.init();
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propFactory = propertiespkg.getPropertiesFactory();
    }

    private ResourceSet getResourceSet() {
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(ServerTemplateBuilder.this.configRoot + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        return rs;
    }

    private void writeTemplateFile(List objs) {
        try {
            ResourceSet resSet = this.getResourceSet();
            URI uri = URI.createFileURI(this.fileURI);
            Resource res = resSet.createResource(uri);
            res.getContents().addAll(objs);
            res.save(new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List readTemplateFile() {
        try {
            ResourceSet resSet = this.getResourceSet();
            URI uri = URI.createFileURI(this.fileURI);
            Resource res = resSet.createResource(uri);
            res.load(new HashMap());
            EList resList = res.getContents();
            return resList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ServerTemplateBuilder sb = new ServerTemplateBuilder();
        String cRoot = System.getProperty("user.install.root");
        cRoot = cRoot + File.separator + "config";
        String fileName = cRoot + File.separator + "templates" + File.separator + "servertypes" + File.separator + "APPLICATION_SERVER" + File.separator + "template-metadata.xml";
        System.out.println("Adding V5 templates in " + fileName);
        sb.setConfigRoot(cRoot);
        sb.setFileName(fileName);
        sb.addV5Templates();
    }
}

