/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.bla.util.UtilHelper;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.management.bla.model.Asset;
import com.ibm.wsspi.management.bla.model.AssetFactory;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.bla.op.OpExecutionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class RestoreConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(RestoreConfigUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "restoreConfig.log";
    public static final int BUFFER_SIZE = 1024;
    private File restoreLocation;
    private String backupFileName;
    private boolean stopServers = true;
    private byte[] buffer = new byte[1024];
    private int numFilesRestored;
    private boolean forceOption = false;
    private static final ResourceBundle APP_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    private ConfigRepository configRepo;
    private Properties clientProps = new Properties();

    public static void main(String[] args) {
        System.exit(new RestoreConfigUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5500I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        this.backupFileName = args[3];
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        if (args[curOption].equals("-nostop")) {
            this.stopServers = false;
        } else if (args[curOption].equals("-force")) {
            this.forceOption = true;
        } else if (args[curOption].equals("-location")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.restoreLocation = new File(args[curOption + 1]);
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected int runTool() throws Exception {
        if (this.restoreLocation == null) {
            this.restoreLocation = new File(this.configRoot);
        }
        if (!new File(this.backupFileName).exists()) {
            this.issueMessage("ADMU5501E", new Object[]{this.backupFileName}, null);
            return -1;
        }
        ModelMgr.initialize((String)"ws-server");
        Object stoppedServers = null;
        if (this.stopServers) {
            this.stopAllServers();
        }
        if (this.restoreLocation.exists()) {
            File newName = this.getUniqueDirectory(this.restoreLocation);
            this.issueMessage("ADMU5502I", new Object[]{this.restoreLocation, newName}, null);
            boolean success = this.renameRestoreLocation(newName);
            if (!success) {
                this.issueMessage("ADMU5503E", null, null);
                return -1;
            }
        }
        this.issueMessage("ADMU5505I", new Object[]{this.backupFileName, this.restoreLocation}, null);
        this.ckCellNameAgainstFile();
        this.uncompressConfigDir();
        this.issueMessage("ADMU5506I", new Object[]{new Integer(this.numFilesRestored)}, null);
        this.restoreAppBinaries();
        this.restoreAssets();
        this.removeExistingWorkSpace();
        return 0;
    }

    private File getUniqueDirectory(File location) {
        int uniqueCounter = 1;
        File uniqueName = new File(location + ".old");
        while (uniqueName.exists()) {
            uniqueName = new File(location + ".old_" + String.valueOf(uniqueCounter++));
        }
        return uniqueName;
    }

    private boolean renameRestoreLocation(File newLocation) {
        boolean successful = this.restoreLocation.renameTo(newLocation);
        if (successful) {
            this.issueMessage("ADMU5504I", null, null);
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ckCellNameAgainstFile() throws IOException {
        block4: {
            String jCellName = "cells" + File.separatorChar + this.cellName + File.separatorChar;
            try {
                ZipEntry entry;
                FileInputStream fis = new FileInputStream(this.backupFileName);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().startsWith(jCellName)) continue;
                    Object var6_5 = null;
                    return;
                }
                if (!this.forceOption) {
                    this.issueMessage("ADMU7005E", new Object[]{jCellName}, null);
                    System.exit(1);
                    break block4;
                }
                this.issueMessage("ADMU7006W", new Object[]{jCellName}, null);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
            Object var6_6 = null;
            return;
        }
        Object var6_7 = null;
    }

    private void uncompressConfigDir() throws IOException {
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(this.backupFileName);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (!this.isQuiet()) {
                    System.out.print('.');
                }
                byte[] data = new byte[1024];
                File outFile = new File(this.restoreLocation, entry.getName());
                outFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(outFile);
                dest = new BufferedOutputStream(fos, 1024);
                while ((count = zis.read(data, 0, 1024)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                ++this.numFilesRestored;
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipFile(ZipEntry zipEntry, ZipFile zipper) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        InputStream is = zipper.getInputStream(zipEntry);
        File newFile = new File(this.restoreLocation, zipEntry.getName());
        newFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(newFile);
        try {
            int numBytes = 0;
            while ((numBytes = is.read(this.buffer)) > -1) {
                fos.write(this.buffer, 0, numBytes);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fos.close();
            is.close();
            throw throwable;
        }
        fos.close();
        is.close();
        ++this.numFilesRestored;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    private void getConfigRepository() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRepository: " + this.configRepo);
        }
        if (this.configRepo != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigRepository");
            }
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot: " + this.configRoot);
            }
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            this.clientProps.setProperty("cellName", this.cellName);
            this.clientProps.setProperty("location", "local");
            System.setProperty("local.cell", this.cellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get system property for local.cell : " + System.getProperty("local.cell"));
            }
            this.clientProps.setProperty("was.install.root", System.getProperty("was.install.root"));
            this.clientProps.setProperty("user.install.root", System.getProperty("user.install.root", System.getProperty("was.install.root")));
            this.configRepo = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)this.clientProps);
        }
        catch (AdminException ae) {
            Tr.error(tc, "ADMU0005E", ae);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRepository: " + this.configRepo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractAsset(Hashtable table) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractAsset", new Object[]{table});
        }
        try {
            Enumeration en = table.keys();
            String base = this.configRoot + "/cells/" + this.cellName + "/" + "assets" + "/";
            while (en.hasMoreElements()) {
                Object var11_11;
                String assetS = (String)en.nextElement();
                Vector v = (Vector)table.get(assetS);
                if (v.size() == 0) continue;
                AssetSpec as = new AssetSpec(assetS);
                String assetBinUri = base + as.getAssetName() + "/" + "aver" + "/" + as.getAssetVersion() + "/" + v.get(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "assetBinUri: " + assetBinUri);
                }
                Archive archive = null;
                try {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Getting archive: " + assetBinUri);
                        }
                        archive = EarUtils.getArchive(assetBinUri, false, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "archive: " + archive);
                        }
                        if (archive == null) {
                            var11_11 = null;
                            if (archive == null) continue;
                            archive.close();
                            continue;
                        }
                        EarUtils.extractArchive(archive, (String)v.get(0), true, 66);
                    }
                    catch (Throwable th) {
                        this.issueMessage("ADMU7009E", new Object[]{assetBinUri, v.elementAt(0), th}, "ADMU7009E=ADMU7009E: There is an unexpected exception in expandArchive. The archive file " + assetBinUri + " will not be extracted in following " + "paths " + v.elementAt(0) + ". Exception: " + th);
                        var11_11 = null;
                        if (archive == null) continue;
                        archive.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    if (archive != null) {
                        archive.close();
                    }
                    throw throwable;
                }
                var11_11 = null;
                if (archive == null) continue;
                archive.close();
            }
        }
        catch (Throwable th) {
            this.issueMessage("ADMU6012I", new Object[]{th}, "Exception in extract asset: " + th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractAsset");
        }
    }

    private void getAssetDestUrl(Asset asset, Hashtable table, VariableMap varMap) throws OpExecutionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssetDestUrl", new Object[]{asset, table, varMap});
        }
        if (Asset.AssetStorageType.FULL.equals((Object)asset.getAssetStorageType())) {
            Vector<String> v;
            AssetSpec assetSpec = asset.getAssetSpec();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "assetSpec: " + assetSpec);
            }
            String assetDestUrl = asset.getAssetDestinationURI();
            String assetUri = asset.getAssetURI();
            String path = this.normalizePath(varMap, assetDestUrl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "path: " + path);
            }
            if ((v = (Vector<String>)table.get(assetSpec.toString())) == null) {
                v = new Vector<String>();
                table.put(assetSpec.toString(), v);
            }
            if (!v.contains(path)) {
                v.add(path);
                v.add(assetUri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssetDestUrl: " + table);
        }
    }

    public void restoreAssets() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreAssets");
        }
        this.issueMessage("ADMU6002I", null, "Begin restoring asset binaries..");
        try {
            boolean isND;
            ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
            Resource res = this.getResource("cell.xml", "cell.xml", bundle);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res: " + res);
            }
            if (res == null) {
                return;
            }
            VariableMap varMap = this.createVarMap();
            Cell cell = (Cell)res.getContents().get(0);
            String cellType = cell.getCellType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellType: " + cellType);
            }
            boolean bl = isND = cellType.equalsIgnoreCase("DISTRIBUTED");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isND: " + isND);
            }
            this.getConfigRepository();
            if (!isND) {
                Hashtable table = new Hashtable();
                AssetFactory assetFact = AssetFactory.getSingleton();
                AssetSpec aspec = new AssetSpec("__ibm__repoctx__all__");
                List assetSpecs = assetFact.listAssetSpecs(aspec, this.configRepo);
                for (AssetSpec assetSpec : assetSpecs) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "assetSpec: " + assetSpec);
                    }
                    Asset asset = assetFact.readAssetFromAssetSpec(assetSpec, this.configRepo);
                    this.getAssetDestUrl(asset, table, varMap);
                }
                this.extractAsset(table);
            } else {
                Hashtable table = new Hashtable();
                AssetFactory assetFact = AssetFactory.getSingleton();
                CompositionUnitFactory cuFact = CompositionUnitFactory.getSingleton();
                CompositionUnitSpec cspec = new CompositionUnitSpec("__ibm__repoctx__all__");
                List cuSpecs = cuFact.listCompositionUnitSpecs(cspec, this.configRepo);
                for (CompositionUnitSpec cuSpec : cuSpecs) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cuSpec: " + cuSpec);
                    }
                    CompositionUnit cu = cuFact.readCompositionUnitFromCompositionUnitSpec(cuSpec, this.configRepo);
                    List targets = cu.listTargetsForCU();
                    boolean isCUTargetOnDmgr = false;
                    for (String target : targets) {
                        ObjectName obj = new ObjectName(target);
                        String cellN = obj.getKeyProperty("cell");
                        String nodeN = obj.getKeyProperty("node");
                        String serverN = obj.getKeyProperty("server");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cell=" + cellN + ",node=" + nodeN + ",server=" + serverN);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cellName=" + this.cellName + ",nodeName=" + this.nodeName);
                        }
                        if (!"dmgr".equals(serverN) || !this.nodeName.equals(nodeN)) continue;
                        isCUTargetOnDmgr = true;
                        break;
                    }
                    if (!isCUTargetOnDmgr || !cu.getType().equals("asset")) continue;
                    String backingID = cu.getBackingID();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "backingID: " + backingID);
                    }
                    if (UtilHelper.isEmpty((String)backingID)) continue;
                    AssetSpec assetSpec = new AssetSpec(backingID);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "assetSpec: " + assetSpec);
                    }
                    Asset asset = assetFact.readAssetFromAssetSpec(assetSpec, this.configRepo);
                    this.getAssetDestUrl(asset, table, varMap);
                }
                this.extractAsset(table);
            }
        }
        catch (Throwable th) {
            this.issueMessage("ADMU6012I", new Object[]{th}, "Exception in asset restore: " + th);
        }
        this.issueMessage("ADMU6009I", null, "ADMU6009I: Processing complete.");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreAssets");
        }
    }

    public void restoreAppBinaries() {
        this.issueMessage("ADMU6001I", null, "Begin restoring application binaries..");
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
            Resource res = this.getResource("nodes/" + this.nodeName + "/serverindex.xml", "serverindex.xml", bundle);
            if (res == null) {
                return;
            }
            VariableMap varMap = this.createVarMap();
            Hashtable table = new Hashtable();
            ServerIndex top = (ServerIndex)res.getContents().get(0);
            EList entries = top.getServerEntries();
            for (int i = 0; i < entries.size(); ++i) {
                ServerEntry entry = (ServerEntry)entries.get(i);
                EList depls = entry.getDeployedApplications();
                for (int lcv = 0; lcv < depls.size(); ++lcv) {
                    String si = (String)depls.get(lcv);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "si: " + si);
                    }
                    if (si.indexOf(47) == -1 || si.indexOf(47) == si.lastIndexOf(47)) continue;
                    String earName = si.substring(0, si.indexOf(47));
                    Tr.debug(tc, "ear name: " + earName);
                    if (earName.equals("isclite.ear")) {
                        Tr.debug(tc, "Notice: isclite.ear is installed as a systemapp using zeroEarCopy option.\n Since the isclite.ear binary does not exist in config repository, we do not try to expand it.\nThe isclite.ear should already be expanded in systemApps directory.");
                        continue;
                    }
                    if (earName.equals("filetransfer.ear")) {
                        Tr.debug(tc, "Notice: filetransfer.ear is installed as a systemapp using zeroEarCopy option.\n Since the filetransfer.ear binary does not exist in config repository, we do not try to expand it.\nThe filetransfer.ear should already be expanded in systemApps directory.");
                        continue;
                    }
                    if (earName.equals("WebSphereWSDM.ear")) {
                        Tr.debug(tc, "Notice: WebSphereWSDM.ear is installed as a systemapp using zeroEarCopy option.\n Since the WebSphereWSDM.ear binary does not exist in config repository, we do not try to expand it.\nThe WebSphereWSDM.ear should already be expanded in systemApps directory.");
                        continue;
                    }
                    if (earName.equals("ibmasyncrsp.ear")) {
                        Tr.debug(tc, "Notice: ibmasyncrsp.ear is installed as a systemapp using zeroEarCopy option.\n Since the ibmasyncrsp.ear binary does not exist in config repository, we do not try to expand it.\nThe ibmasyncrsp.ear should already be expanded in systemApps directory.");
                        continue;
                    }
                    Vector<String> v = (Vector<String>)table.get(earName);
                    if (v == null) {
                        v = new Vector<String>();
                        table.put(earName, v);
                    }
                    try {
                        Resource deplRes = this.getResource("applications/" + si + "/deployment.xml", "deployment.xml", bundle);
                        Deployment depl = (Deployment)deplRes.getContents().get(0);
                        String path = this.normalizePath(varMap, ((ApplicationDeployment)depl.getDeployedObject()).getBinariesURL());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "path: " + path);
                        }
                        if (!v.contains(path)) {
                            v.addElement(path);
                        }
                        deplRes.unload();
                        continue;
                    }
                    catch (Throwable th) {
                        this.issueMessage("ADMU7004E", new Object[]{si, earName, th}, "ADMU7004E=ADMU7004E: Unexpected exception while building cache entry for " + si + ". Exception is: " + th + " All the related binaries may not be deleted/updated.");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "table: " + table);
            }
            res.unload();
            Enumeration en = table.keys();
            String base = this.configRoot + "/cells/" + this.cellName + "/applications/";
            while (en.hasMoreElements()) {
                String earName = (String)en.nextElement();
                Vector v = (Vector)table.get(earName);
                if (v.size() == 0) continue;
                earName = base + earName + "/" + earName;
                EARFile earFile = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting ear: " + earName);
                    }
                    earFile = EarUtils.getEarFile(earName, false, true);
                }
                catch (Throwable th) {
                    this.issueMessage("ADMU7008E", new Object[]{earName, v, th}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + earName + " will not be extracted in following " + "paths " + v + ". Exception: " + th);
                }
                if (earFile == null) continue;
                for (int i = 0; i < v.size(); ++i) {
                    try {
                        EarUtils.extractEar(earFile, (String)v.elementAt(i), true);
                        continue;
                    }
                    catch (Throwable th) {
                        this.issueMessage("ADMU7008E", new Object[]{earName, v.elementAt(i), th}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + earName + " will not be extracted in following " + "paths " + v.elementAt(i) + ". Exception: " + th);
                    }
                }
                earFile.close();
            }
        }
        catch (Throwable th) {
            this.issueMessage("ADMU6012I", new Object[]{th}, "Exception in app restore: " + th);
        }
        this.issueMessage("ADMU6009I", null, "ADMU6009I: Processing complete.");
    }

    private VariableMap createVarMap() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVarMap");
        }
        Repository repository2 = RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)this.cellName, (String)this.nodeName, null);
        VariableMap map = VariableMapFactory.createVariableMap((Repository)repository2);
        map.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    protected ResourceSet createResourceSet(final String configRoot) {
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(configRoot + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        return rs;
    }

    private Resource getResource(String shortPath, String fileName, ResourceBundle bundle) {
        String filepath = this.configRoot + "/cells/" + this.cellName + "/" + shortPath;
        try {
            ResourceSet resourceSet = this.createResourceSet(this.configRoot);
            URI uri = URI.createFileURI(filepath);
            Resource res = resourceSet.getResource(uri, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + filepath + " is: " + res);
            }
            return res;
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception loading " + filepath + " as resource: " + th);
            }
            return null;
        }
    }

    private String normalizePath(VariableMap v, String path) {
        String ret = v.expand(path);
        ret = ret.replace('/', File.separatorChar);
        ret = ret.replace('\\', File.separatorChar);
        return ret;
    }

    protected String getFormattedMessage(String key, Object[] args, String defaultString) {
        if (key == null || !key.startsWith("ADMA")) {
            return super.getFormattedMessage(key, args, defaultString);
        }
        try {
            String result = APP_BUNDLE.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }

    private void removeExistingWorkSpace() {
        String strWorkSpaceRoot = this.getUserInstallRoot() + File.separator + "wstemp";
        String strWorkSpaceDirName = "workspace";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removing Existing WorkSpace(s) in " + strWorkSpaceRoot);
        }
        try {
            File fWorkSpaceRoot = new File(strWorkSpaceRoot);
            if (fWorkSpaceRoot.exists() && fWorkSpaceRoot.isDirectory()) {
                this.searchAndRemoveWorkSpace(fWorkSpaceRoot, strWorkSpaceDirName, 0);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error: either " + strWorkSpaceRoot + " does not exist or it is a file");
            }
        }
        catch (Throwable eio) {
            Tr.debug(tc, "Error: Hit an exception when removing workspace :" + eio.toString());
        }
    }

    protected String getUserInstallRoot() {
        String strUserInstallRoot = System.getProperty("user.install.root");
        if (strUserInstallRoot == null || strUserInstallRoot.length() <= 0) {
            strUserInstallRoot = System.getProperty("was.install.root");
        }
        if (File.separator.equals("/")) {
            strUserInstallRoot = strUserInstallRoot.replace('\\', '/');
        } else if (File.separator.equals("\\")) {
            strUserInstallRoot = strUserInstallRoot.replace('/', '\\');
        }
        return strUserInstallRoot;
    }

    private void searchAndRemoveWorkSpace(File fDir, String strWorkSpaceDirName, int iLevel) throws IOException {
        ++iLevel;
        String[] astr = null;
        try {
            astr = fDir.list();
        }
        catch (SecurityException e) {
            Tr.debug(tc, "The directory: " + fDir.getAbsolutePath() + " has a securityViolation and is not accessible.");
            return;
        }
        for (int iI = 0; iI < astr.length; ++iI) {
            File ft = new File(fDir, astr[iI]);
            if (!ft.isDirectory()) continue;
            if (astr[iI].equals(strWorkSpaceDirName) && iLevel >= 2) {
                this.removeWholeDirectory(ft);
                continue;
            }
            if (iLevel >= 2) continue;
            this.searchAndRemoveWorkSpace(ft, strWorkSpaceDirName, iLevel);
        }
    }

    private void removeWholeDirectory(File fDir) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removing workspace in " + fDir.getAbsolutePath());
        }
        String[] astr = null;
        try {
            astr = fDir.list();
        }
        catch (SecurityException e) {
            String strPathName = fDir.getAbsolutePath();
            Tr.debug(tc, "The directory: " + strPathName + " has a securityViolation. Not accessible.");
            return;
        }
        for (int iI = 0; iI < astr.length; ++iI) {
            File ft = new File(fDir, astr[iI]);
            if (ft.isDirectory()) {
                this.removeWholeDirectory(ft);
                continue;
            }
            if (ft.delete()) continue;
            String strPathName = ft.getAbsolutePath();
            Tr.debug(tc, "Error: File can not be removed: " + ft.getAbsolutePath());
        }
        if (!fDir.delete()) {
            Tr.debug(tc, "Error: Directory can not be removed: " + fDir.getAbsolutePath());
        }
    }
}

