/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.DoNotDoAddNodeException;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class NodeRenameUtility
extends AbstractNodeConfigUtility {
    private static final TraceComponent tc = Tr.register(NodeRenameUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "renameNode.log";
    private static final String FSEP = "/";
    private Repository localRunTimeRepository;
    private VariableMap map;
    private String newNodeName = "";
    private String nodeShortName = "";
    private Properties clientProps;

    public static void main(String[] args) {
        System.exit(new NodeRenameUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 6;
    }

    protected int parseRequiredArgs(String[] args) {
        int nextArg = 6;
        this.connHost = args[3];
        this.connPort = args[4];
        this.newNodeName = args[5];
        return nextArg;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-nodeshortname")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.nodeShortName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-conntype")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.connType = args[curOption + 1];
                this.adminProperties.setProperty("-connType", this.connType);
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0252I", null, null);
    }

    protected void toolFailed(Throwable exception) {
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU0251I", new Object[]{this.nodeName}, null);
        this.init();
        this.checkIfNodeNamesMatch();
        this.issueMessage("ADMU0254I", new Object[]{this.newNodeName}, null);
        this.renameNode();
        this.issueMessage("ADMU0250I", new Object[]{this.nodeName, this.newNodeName}, null);
        return 0;
    }

    private void renameNode() throws Exception, DoNotDoAddNodeException {
        this.configNodeOnDMgr();
        this.doRegenNDPluginConfig();
        this.syncNode();
        this.fixNodeSetupCmdLine(this.newNodeName, this.clientProps);
        this.fixWsadminProps(this.clientProps);
        if (this.isZOS()) {
            this.transformConfig2Native(this.cellName, this.newNodeName);
        }
    }

    private void configNodeOnDMgr() throws Exception {
        ObjectName adminOps = this.getMBeanByType("AdminOperations");
        if (adminOps == null) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.invokeMBean(adminOps, "renameNodeOnDmgr", new Object[]{this.nodeName, this.newNodeName, this.nodeShortName}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
    }

    private void doRegenNDPluginConfig() throws Exception {
        ObjectName jvmBean;
        ObjectName configGen = this.getMBeanByType("PluginCfgGenerator");
        if (configGen != null && (jvmBean = this.getMBeanByType("JVM")) != null) {
            String iRoot = (String)this.adminClient.invoke(jvmBean, "getProperty", new Object[]{"user.install.root"}, new String[]{"java.lang.String"});
            Object cRoot = null;
            try {
                this.invokeMBean(configGen, "generate", new Object[]{iRoot, cRoot, this.cellName, null, null, "plugin-cfg.xml"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
            }
            catch (MBeanException exc) {
                this.issueMessage("ADMU0040E", new Object[]{configGen, "generate", exc}, null);
            }
        }
    }

    private void checkIfNodeNamesMatch() throws Exception {
        if (this.newNodeName != null && this.newNodeName.length() > 0 && this.nodeName.equalsIgnoreCase(this.newNodeName)) {
            throw new AdminException(this.getFormattedMessage("ADMU0039E", new Object[]{this.nodeName}, null));
        }
    }

    private void init() throws Exception {
        this.clientProps = this.getClientProperties();
        if ("RMI".equals(this.clientProps.getProperty("type")) && this.clientProps.getProperty("host") != null && this.clientProps.getProperty("port") != null) {
            Properties sysProps = System.getProperties();
            sysProps.setProperty("com.ibm.CORBA.securityServerHost", this.clientProps.getProperty("host"));
            sysProps.setProperty("com.ibm.CORBA.securityServerPort", this.clientProps.getProperty("port"));
            System.setProperties(sysProps);
        }
        this.localRunTimeRepository = null;
        this.map = null;
        this.adminClient = this.getAdminClient(this.clientProps);
        if (!this.isConnectedToDeploymentManager()) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.issueMessage("ADMU0009I", new Object[]{this.connHost, this.connPort}, null);
        ModelMgr.initialize((String)"ws-server");
        this.stopAllServers();
    }

    private boolean isConnectedToDeploymentManager() throws Exception {
        ObjectName dmgr = this.getMBeanByType("DeploymentManager");
        return dmgr != null;
    }

    protected void syncNode() throws Exception {
        NodeSync synch = NodeSync.createNodeSync();
        try {
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            this.clientProps.setProperty("nodeName", this.newNodeName);
            synch.initialize(this.clientProps, null, null);
            this.issueMessage("ADMU0016I", null, null);
            Boolean b = synch.sync();
            if (!b.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException ae) {
            Tr.error(tc, "ADMU0005E", ae);
            throw ae;
        }
    }

    protected Repository getLocalRepository() throws Exception {
        Vector servers;
        if (this.localRunTimeRepository == null && (servers = this.getServerList()) != null && servers.size() > 0) {
            this.setupServerRepository(this.cellName, (String)servers.elementAt(0));
        }
        return this.localRunTimeRepository;
    }

    private void setupServerRepository(String cellname, String server) throws Exception {
        this.localRunTimeRepository = this.setupServerRepository(cellname, this.nodeName, server);
        this.map = VariableMapFactory.createVariableMap((Repository)this.localRunTimeRepository);
        this.map.initialize(null);
    }

    private Repository setupServerRepository(String cellname, String node, String server) throws Exception {
        return RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)cellname, (String)node, (String)server);
    }

    protected VariableMap getVariableMap() throws Exception {
        Vector servers;
        if (this.map == null && (servers = this.getServerList()) != null && servers.size() > 0) {
            this.setupServerRepository(this.cellName, (String)servers.elementAt(0));
        }
        return this.map;
    }

    public void fix390NodeSetupCmdLine(String sclFileName, String nodeName) throws Exception {
        File sclFile = new File(sclFileName);
        String line = null;
        if (sclFile.exists()) {
            Vector<String> filecontent = new Vector<String>();
            FileInputStream fis = new FileInputStream(sclFileName);
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)fis, "Cp1047"));
            while ((line = rd.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line is " + line);
                }
                if (line != null && line.indexOf("WAS_NODE=") >= 0 && !line.startsWith("#")) {
                    line = line.substring(0, line.indexOf("=") + 1) + nodeName;
                }
                filecontent.add(line);
            }
            rd.close();
            FileOutputStream fos = new FileOutputStream(sclFileName);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "Cp1047"));
            int sz = filecontent.size();
            for (int i = 0; i < sz; ++i) {
                pw.println((String)filecontent.get(i));
            }
            pw.flush();
            pw.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{sclFileName});
        }
    }

    protected void fixNodeSetupCmdLine(String nodeName, Properties p) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixNodeSetupCmdLine", new Object[]{nodeName, p});
        }
        String os = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
        Tr.debug(tc, "LaunchScriptCollaborator: " + platform.getClass());
        String sclFilename = p.getProperty("user.install.root") + "/bin/setupCmdLine";
        sclFilename = platform.customizeScriptFilename(sclFilename);
        if (this.isZOS()) {
            this.fix390NodeSetupCmdLine(sclFilename, nodeName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fixNodeSetupCmdLine");
            }
            return;
        }
        File sclFile = new File(sclFilename);
        if (sclFile.exists()) {
            Vector<String> filecontent = new Vector<String>();
            FileInputStream fis = new FileInputStream(sclFilename);
            BufferedReader rd = null;
            String readerEncoding = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned readerencoding = " + readerEncoding);
            }
            rd = new BufferedReader(new InputStreamReader((InputStream)fis, readerEncoding));
            String line = null;
            while ((line = rd.readLine()) != null) {
                if (line.indexOf("WAS_NODE=") >= 0 && !line.startsWith(platform.getPlatformComment())) {
                    line = line.substring(0, line.indexOf("=") + 1) + nodeName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modified line in setupCmdLine: " + line);
                    }
                }
                filecontent.add(line);
            }
            rd.close();
            FileOutputStream fos = new FileOutputStream(sclFilename);
            PrintWriter writer = null;
            String writerEncoding = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned writer encoding = " + writerEncoding);
            }
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)fos, writerEncoding));
            for (int i = 0; i < filecontent.size(); ++i) {
                line = (String)filecontent.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line", line);
                }
                writer.println((String)filecontent.get(i));
            }
            writer.flush();
            writer.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{sclFilename});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixNodeSetupCmdLine");
        }
    }
}

