/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.File;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeRemovalUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register(NodeRemovalUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "removeNode.log";
    protected String restoredCellName = null;
    protected boolean terminateServers = false;
    private Repository localRepository = null;
    private VariableMap map = null;
    private boolean forceRemove = false;
    private String backupRoot = null;
    private Properties clientProps = null;
    private boolean invokedFromMBean = false;
    private boolean removeWasForced = false;
    private boolean baseBackupDirFound = false;
    private Properties nodeProperties = new Properties();

    public static void main(String[] args) {
        System.exit(new NodeRemovalUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU2002I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        return 3;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-local") || option.equals("-force")) {
            this.forceRemove = true;
        } else if (option.equals("-fromMBean")) {
            this.invokedFromMBean = true;
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU2001I", new Object[]{this.nodeName}, null);
        this.createAdminClientInstance();
        try {
            ModelMgr.initialize((String)"ws-server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ModelMgr initialized");
            }
            if (this.doCheckIfRemoveNodeIsOkToRun() == -1) {
                return -1;
            }
            Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
            if (this.terminateServers) {
                this.terminateAllServers();
            } else {
                this.stopAllServers();
            }
            this.doRemoveNodeOnDmgr();
            this.completeAddOrRemoveNode();
            this.doFinalCleanup();
            this.showNextTasks();
        }
        catch (Throwable t) {
            this.issueMessage("ADMU0029E", new Object[]{NodeRemovalUtility.getRootCause(t).getMessage()}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            throw Utils.makeAdminException(t);
        }
        return 0;
    }

    private void doRemoveNodeOnDmgr() throws Exception {
        try {
            if (this.adminClient != null) {
                this.issueMessage("ADMU2021I", null, null);
                this.doUnconfigOnDMgr();
            }
        }
        catch (Exception exc) {
            Tr.error(tc, "ADMU2023E", exc);
            this.issueMessage("ADMU2023E", new Object[]{exc}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exc;
            }
            this.removeWasForced = true;
        }
    }

    private void doFinalCleanup() throws Exception, AdminException {
        this.deleteAppBins();
        String originalDir = this.configRoot + "/cells/" + this.cellName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting " + originalDir);
        }
        this.deleteDirs(originalDir);
        this.restoredCellName = this.restoreBaseAppServerConfig();
        this.localRepository = null;
        this.fixWsadminProps(this.getClientProperties());
        this.fixSetupCmdLine(this.restoredCellName, this.getClientProperties());
        if (this.isZOS()) {
            this.transformConfig2Native(this.restoredCellName, this.nodeName);
        }
        this.doRemoveService();
        this.issueMessage("ADMU2017I", null, null);
    }

    private int doCheckIfRemoveNodeIsOkToRun() throws Exception {
        if (!this.isMemberOfCell()) {
            this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            return -1;
        }
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            return -1;
        }
        if (!this.checkIfBackupBaseDirExists()) {
            this.issueMessage("ADMU2035W", null, null);
            this.issueMessage("ADMU2036I", null, null);
            return -1;
        }
        return 0;
    }

    private void createAdminClientInstance() throws Exception {
        try {
            this.initAdminClient();
        }
        catch (Exception exc) {
            Tr.error(tc, "ADMU0006E", exc);
            this.issueMessage("ADMU0006E", new Object[]{exc}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exc;
            }
            this.removeWasForced = true;
        }
    }

    private void doRemoveService() throws AdminException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return;
        }
        String cmdToXqt = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "WASService.exe";
        WindowsService windowsService = WindowsService.getWindowsServiceInstance("nodeagent", null);
        if (windowsService == null) {
            return;
        }
        String serviceName = windowsService.getServiceName();
        String cmdArgs = " -remove " + serviceName;
        Tr.audit(tc, cmdToXqt + " " + cmdArgs);
        CreationParams params = new CreationParams();
        params.setExecutable(cmdToXqt);
        params.setProcessName("WASService");
        params.setDetachProcess(true);
        StringTokenizer tok = new StringTokenizer(cmdArgs);
        String[] argArray = new String[tok.countTokens()];
        int argIndex = 0;
        while (tok.hasMoreTokens()) {
            argArray[argIndex++] = tok.nextToken();
        }
        params.setCommandLineArgs(argArray);
        try {
            Process p = ProcessFactory.create((CreationParams)params);
            p.waitForTermination(30);
            p.release();
        }
        catch (Exception e) {
            this.issueMessage("ADMU1501W", null, null);
            throw new AdminException(this.getFormattedMessage("ADMU1501W", null, null));
        }
    }

    private void issueWarnings(Collection c, String warning) {
        if (c != null && !c.isEmpty()) {
            int len = 0;
            String nl = "\n";
            String[] msgs = (String[])c.toArray();
            for (int i = 0; i < msgs.length; ++i) {
                len += msgs[i].length();
                len += nl.length();
            }
            len = (len + 256) / 256 * 256;
            StringBuffer buffer = new StringBuffer(len);
            for (int i = 0; i < msgs.length; ++i) {
                String s = msgs[i];
                buffer.append(nl);
                if (s.length() > 0) {
                    buffer.append(s);
                    continue;
                }
                buffer.append("Warning message missing?");
            }
            String count = "" + msgs.length;
            this.issueMessage(warning, new Object[]{count, this.nodeName, buffer.toString()}, null);
        }
    }

    private void initAdminClient() throws Exception {
        Properties cellmgrProps = this.getCellMgrProps();
        if (cellmgrProps == null) {
            return;
        }
        if (this.userid != null) {
            cellmgrProps.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            cellmgrProps.setProperty("password", this.pwd);
        }
        this.adminClient = this.getAdminClient(cellmgrProps);
        this.notificationService = this.getNotificationServiceMBean();
        this.emitNotification("ADMU2001I", this.getFormattedMessage("ADMU2001I", new Object[]{this.nodeName}, null));
    }

    protected Properties getClientProperties() throws Exception {
        if (this.clientProps == null) {
            this.clientProps = System.getProperties();
            this.clientProps.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
            this.clientProps.setProperty("host", "localhost");
            this.clientProps.setProperty("type", "SOAP");
            try {
                this.clientProps.setProperty("port", this.getBaseSOAPPort().toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return this.clientProps;
    }

    private Integer getBaseSOAPPort() throws Exception {
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        Resource r = cfgRoot.getResource(3, "serverindex.xml");
        ServerIndex doc = (ServerIndex)r.getContents().get(0);
        EList servers = doc.getServerEntries();
        ServerEntry svrEntry = (ServerEntry)servers.iterator().next();
        EList endPoints = svrEntry.getSpecialEndpoints();
        for (NamedEndPoint endPoint : endPoints) {
            if (!endPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) continue;
            EndPoint ep = endPoint.getEndPoint();
            return new Integer(ep.getPort());
        }
        return new Integer(8880);
    }

    private String restoreBaseAppServerConfig() throws Exception {
        this.issueMessage("ADMU2014I", null, null);
        String baseBackup = this.backupRoot + "/base/cells/";
        String restoredCell = null;
        File[] files = new File(baseBackup).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            restoredCell = files[i].getName();
            break;
        }
        this.nodeName = this.getOriginalNodeName(baseBackup, restoredCell);
        String restoredBase = this.configRoot + "/cells/";
        String baseTemplatesBackup = this.backupRoot + "/base/templates/";
        String restoredBaseTemplates = this.configRoot + "/templates/";
        String baseWaspoliciesBackup = this.backupRoot + "/base/waspolicies/";
        String restoredBaseWaspolicies = this.configRoot + "/waspolicies/";
        File restore = new File(restoredBase);
        if (!restore.exists()) {
            restore.mkdirs();
        }
        this.copyDocuments(baseBackup, restoredBase);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting " + restoredBaseTemplates);
        }
        this.deleteDirs(restoredBaseTemplates);
        File restoreTemplates = new File(restoredBaseTemplates);
        if (!restoreTemplates.exists()) {
            restoreTemplates.mkdirs();
        }
        this.copyDocuments(baseTemplatesBackup, restoredBaseTemplates);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting " + restoredBaseWaspolicies);
        }
        this.deleteDirs(restoredBaseWaspolicies);
        File restoreWaspolicies = new File(restoredBaseWaspolicies);
        File waspoliciesBackup = new File(baseWaspoliciesBackup);
        if (waspoliciesBackup.exists()) {
            if (!restoreWaspolicies.exists()) {
                restoreWaspolicies.mkdirs();
            }
            this.copyDocuments(baseWaspoliciesBackup, restoredBaseWaspolicies);
        }
        File plugincfg = new File(this.configRoot + "/plugin-cfg.xml");
        File backupPlugincfg = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (backupPlugincfg.exists()) {
            this.copyDocument(backupPlugincfg, plugincfg);
        }
        File plugincfgService = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File backupPlugincfgService = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (backupPlugincfgService.exists()) {
            this.copyDocument(backupPlugincfgService, plugincfgService);
        }
        this.restoreApplications(restoredCell);
        return restoredCell;
    }

    private String getOriginalNodeName(String configBkpCellDir, String nameOfOrigCell) {
        String nodeDir = configBkpCellDir + nameOfOrigCell + "/nodes/";
        String originalNodeName = null;
        File[] files = new File(nodeDir).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            originalNodeName = files[i].getName();
            break;
        }
        return originalNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreApplications(String resCell) {
        block12: {
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "restoreApplications: " + resCell);
                }
                VariableMap oldMap = null;
                try {
                    try {
                        File f_apps;
                        oldMap = this.getVarMap(this.configRoot, resCell, this.nodeName);
                        if (oldMap == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "restoreApplications:  null varmap for base cell");
                            }
                            Object var10_3 = null;
                            break block11;
                        }
                        String apps = this.configRoot + "/cells/" + resCell + "/applications";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "apps dir: " + apps);
                        }
                        if ((f_apps = new File(apps)).exists()) {
                            File[] lst = f_apps.listFiles();
                            for (int i = 0; i < lst.length; ++i) {
                                File ear;
                                if (!lst[i].isDirectory() || !(ear = new File(apps + "/" + lst[i].getName() + "/" + lst[i].getName())).exists()) continue;
                                Vector paths = this.getDeploymentPaths(apps + "/" + lst[i].getName() + "/deployments");
                                this.expandEar(ear.getPath(), paths, oldMap);
                            }
                        }
                        break block12;
                    }
                    catch (Throwable th) {
                        this.issueMessage("ADMU0529E", new Object[]{th}, null);
                        Object var10_5 = null;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "restoreApplications");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_6 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "restoreApplications");
                    }
                    oldMap = null;
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "restoreApplications");
            return;
        }
        Object var10_4 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "restoreApplications");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAppBins() {
        block11: {
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "deleteAppBins");
                }
                VariableMap newMap = null;
                try {
                    try {
                        newMap = this.getVarMap(this.configRoot, this.cellName, this.nodeName);
                        if (newMap == null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "deleteAppBins: no var map was created");
                            }
                            Object var4_2 = null;
                            break block10;
                        }
                        String appRoot = newMap.expand("$(APP_INSTALL_ROOT)/" + this.cellName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting: " + appRoot);
                        }
                        this.deleteDirs(appRoot);
                        break block11;
                    }
                    catch (Throwable th) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception: " + th + " in deleting binaries from ND config for " + this.nodeName);
                        }
                        Object var4_4 = null;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit(tc, "deleteAppBins");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "deleteAppBins");
                    }
                    newMap = null;
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "deleteAppBins");
            return;
        }
        Object var4_3 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "deleteAppBins");
    }

    protected void emitNotification(String key, String msg) {
        if (this.notificationService != null) {
            String ntfyType = null;
            ntfyType = key.equals("ADMU2001I") && !this.invokedFromMBean ? "websphere.removenode.starting" : (key.equals("ADMU2024I") || key.equals("ADMU2025I") ? "websphere.removenode.complete" : (key.equals("ADMU0211I") ? "websphere.removenode.failed" : "websphere.removenode.message"));
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{ntfyType, msg, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    private Properties getCellMgrProps() throws Exception {
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        String[] nodes = cfgRoot.list(3, null);
        ServerEntry cellmgr = null;
        block0: for (int i = 0; i < nodes.length; ++i) {
            cfgRoot.setValue(3, nodes[i]);
            Resource r = cfgRoot.getResource(3, "serverindex.xml");
            ServerIndex doc = (ServerIndex)r.getContents().get(0);
            EList servers = doc.getServerEntries();
            for (int j = 0; j < servers.size(); ++j) {
                ServerEntry s = (ServerEntry)servers.get(j);
                String type = s.getServerType();
                if (!type.equals("DEPLOYMENT_MANAGER")) continue;
                cellmgr = s;
                continue block0;
            }
        }
        EndPoint soapEP = null;
        EndPoint rmiEP = null;
        if (cellmgr != null) {
            EList endpoints = cellmgr.getSpecialEndpoints();
            for (int i = 0; i < endpoints.size(); ++i) {
                NamedEndPoint nep = (NamedEndPoint)endpoints.get(i);
                if (nep.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                    soapEP = nep.getEndPoint();
                }
                if (!nep.getEndPointName().equals("BOOTSTRAP_ADDRESS")) continue;
                rmiEP = nep.getEndPoint();
            }
        }
        Properties p = null;
        if (soapEP != null) {
            p = new Properties();
            p.setProperty("type", "SOAP");
            p.setProperty("port", new Integer(soapEP.getPort()).toString());
            p.setProperty("host", soapEP.getHost());
        } else if (rmiEP != null) {
            p = new Properties();
            p.setProperty("type", "RMI");
            p.setProperty("port", new Integer(rmiEP.getPort()).toString());
            p.setProperty("host", rmiEP.getHost());
        }
        return p;
    }

    protected Repository getLocalRepository() throws Exception {
        this.setupLocalRepository();
        return this.localRepository;
    }

    protected VariableMap getVariableMap() throws Exception {
        if (this.map == null) {
            this.setupLocalRepository();
        }
        return this.map;
    }

    private void setupLocalRepository() throws Exception {
        ServerIdentifiers sid = new ServerIdentifiers();
        sid.setConfigRoot(this.configRoot);
        if (this.restoredCellName != null) {
            sid.setCellName(this.restoredCellName);
            sid.setServerName("server1");
        } else {
            sid.setCellName(this.cellName);
            sid.setServerName("nodeagent");
        }
        sid.setNodeName(this.nodeName);
        this.localRepository = RepositoryFactory.createRepository((String)"ws-server", (String)sid.getConfigRoot(), (String)sid.getCellName(), (String)sid.getNodeName(), (String)sid.getServerName());
        this.map = VariableMapFactory.createVariableMap((Repository)this.localRepository);
        this.map.initialize(null);
    }

    protected AdminClient getAdminClient(Properties connProps) throws Exception {
        AdminClient _admin = null;
        _admin = AdminClientFactory.createAdminClient(connProps);
        Object[] objectArray = new Object[2];
        objectArray[0] = connProps.getProperty("host");
        objectArray[1] = connProps.getProperty("port");
        this.issueMessage("ADMU0009I", objectArray, null);
        return _admin;
    }

    public void setForceRemove(boolean doForce) {
        this.forceRemove = doForce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void showNextTasks() {
        block17: {
            Session session;
            ConfigService configService;
            block16: {
                this.printLineSeparator(null);
                this.issueMessage("ADMU0306I", null, null);
                this.issueMessage("ADMU2031I", new Object[]{this.cellName}, null);
                this.issueMessage("ADMU0307I", null, null);
                this.issueMessage("ADMU2032I", null, null);
                this.printLineSeparator(null);
                this.issueMessage("ADMU0306I", null, null);
                this.issueMessage("ADMU2033I", new Object[]{this.cellName}, null);
                this.issueMessage("ADMU0307I", null, null);
                this.issueMessage("ADMU2034I", null, null);
                configService = null;
                session = null;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "SecurityDomain");
                configService = ConfigServiceFactory.getConfigService();
                session = new Session();
                ObjectName[] domains = configService.queryConfigObjects(session, null, pattern, null);
                if (domains == null || domains.length <= 0) break block16;
                this.printLineSeparator(null);
                this.issueMessage("ADMU0306I", null, null);
                this.issueMessage("ADMU2095I", new Object[]{this.cellName}, null);
                this.issueMessage("ADMU0307I", null, null);
                this.issueMessage("ADMU2096I", null, null);
            }
            Object var6_6 = null;
            try {
                if (configService != null && session != null) {
                    configService.discard(session);
                }
                break block17;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception when discarding configSerive session" + e);
                }
                break block17;
            }
            {
                catch (Throwable th) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unexpected exception when determining if security domains exist" + th);
                    }
                    Object var6_7 = null;
                    try {
                        if (configService != null && session != null) {
                            configService.discard(session);
                        }
                        break block17;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unexpected exception when discarding configSerive session" + e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var6_8 = null;
                    try {
                        if (configService != null && session != null) {
                            configService.discard(session);
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block18;
                        Tr.debug(tc, "Unexpected exception when discarding configSerive session" + e);
                    }
                }
                throw throwable;
            }
        }
        if (this.removeWasForced) {
            this.issueMessage("ADMU2025W", new Object[]{this.nodeName}, null);
        } else {
            this.issueMessage("ADMU2024I", new Object[]{this.nodeName}, null);
        }
    }

    private void doUnconfigOnDMgr() throws Exception {
        Object metaHelper = null;
        this.nodeProperties.setProperty("CELL_NAME_KEY", this.cellName);
        this.nodeProperties.setProperty("NODE_NAME_KEY", this.nodeName);
        ObjectName adminOps = this.getMBeanByType("AdminOperations");
        if (adminOps != null) {
            this.invokeMBean(adminOps, "doUnMergeConfigDataOnDmgr", new Object[]{this.nodeProperties}, new String[]{"java.util.Properties"});
        }
    }

    private boolean checkIfBackupBaseDirExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfBackupBaseDirExists");
        }
        boolean bExist = false;
        String baseBackup = this.backupRoot + "/base/cells/";
        Tr.debug(tc, "backup base dir = " + baseBackup);
        File baseBackupDir = new File(baseBackup);
        if (baseBackupDir.exists()) {
            this.baseBackupDirFound = true;
            bExist = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfBackupBaseDirExists" + bExist);
        }
        return bExist;
    }
}

