/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.ServiceContext;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.util.WASEcoreUtil;
import com.ibm.websphere.product.WASSystem;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.DoNotDoAddNodeException;
import com.ibm.ws.management.tools.NodeAgentConfigBuilder;
import com.ibm.ws.management.tools.UpdateVirtualHost;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.PortConflictResolver;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.management.bla.model.Asset;
import com.ibm.wsspi.management.bla.model.AssetFactory;
import com.ibm.wsspi.management.bla.model.AssetSpec;
import com.ibm.wsspi.management.bla.model.BLA;
import com.ibm.wsspi.management.bla.model.BLAFactory;
import com.ibm.wsspi.management.bla.model.BLASpec;
import com.ibm.wsspi.management.bla.model.CompositionUnit;
import com.ibm.wsspi.management.bla.model.CompositionUnitFactory;
import com.ibm.wsspi.management.bla.model.CompositionUnitSpec;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.registry.Profile;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class NodeFederationUtility
extends AbstractNodeConfigUtility
implements DistinguishedEndpointConstants {
    public static final String ADDNODE_ARCHIVE_PATH_KEY = "ADDNODE_ARCHIVE_PATH_KEY";
    public static final String CELL_NAME_KEY = "CELL_NAME_KEY";
    public static final String NODE_NAME_KEY = "NODE_NAME_KEY";
    public static final String NODE_Group_NAME_KEY = "NODE_Group_NAME_KEY";
    public static final String CORE_Group_NAME_KEY = "CORE_Group_NAME_KEY";
    public static final String APPSERVER_BOOTSTRAP_PORT_PROP = "APPSERVER_BOOTSTRAP_PORT";
    public static final int DEFAULT_APPSERVER_BOOTSTRAP_PORT = 9810;
    private static final TraceComponent tc = Tr.register(NodeFederationUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "addNode.log";
    private static final String FSEP = "/";
    protected String newCellName = null;
    private boolean setRollback = false;
    private boolean includeapps = false;
    private boolean includesecurity = true;
    private Vector appsIncluded = null;
    private ArrayList<BLASpec> skipBlas = new ArrayList();
    private ArrayList<CompositionUnitSpec> skipCus = new ArrayList();
    private ArrayList<AssetSpec> skipAssets = new ArrayList();
    private Hashtable apps2path = null;
    private boolean launchNodeAgent = true;
    private Integer startingPort = null;
    private ObjectName repositoryHandle = null;
    private ConfigRepositoryClient configRepositoryClient = null;
    private ConfigRepository nodeConfigRepository = null;
    private Repository localRunTimeRepository = null;
    private VariableMap map = null;
    private IpcFactory ipcFactory = null;
    private ServerindexFactory indexFactory = null;
    private String originalDir = null;
    private String backupDir = null;
    private String backupRoot = null;
    private String origTemplatesDir = null;
    private String backupTemplatesDir = null;
    private String origWaspoliciesDir = null;
    private String backupWaspoliciesDir = null;
    private String tmpCellDir = null;
    private boolean invokedFromMBean = false;
    private boolean nodeAddedToDmgr = false;
    private boolean registerService = false;
    private String serviceUserName = null;
    private String servicePassword = null;
    private String coreGroupName = "DefaultCoreGroup";
    private boolean includebuses = false;
    private boolean excludeSecurityDomains;
    private String nodeAgentShortName = null;
    private Integer givenAppserverBootstrapPort = null;
    private String nodeGroupName = "DefaultNodeGroup";
    private ConfigServiceProxy configService = null;
    private CommandMgr cmdMgr = null;
    private static final int NODE_GROUP_CHECK_CONVERT_NEEDED = 2;
    private String fromDir;
    private String toNodeDir;
    private String nodeAgentDir;
    private String appDir;
    private String blaDir;
    private String cuDir;
    private String assetDir;
    private Properties clientProps;
    private Properties nodeProperties = new Properties();
    private Properties portProperties = null;
    private String portPropsFileName = null;
    private String dcsHostName = null;
    private String localUserName = null;
    private String localPassword = null;
    private boolean noAutoSignerRetrieval = false;
    private NodeAgentConfigBuilder naConfigBuilder;
    private List _adminHosts = null;
    private List _adminPorts = null;
    private static final String REGISTER_SERVICE = "register_service";
    private static final String START_NODEAGENT = "start_nodeagent";

    public static void main(String[] args) {
        Properties systemProperties = System.getProperties();
        systemProperties.put("com.ibm.WebSphere.main_class", "NodeFederationUtility");
        System.setProperties(systemProperties);
        System.exit(new NodeFederationUtility().executeUtility(args));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String defaultTraceFile = System.getProperty("user.install.root");
        if (defaultTraceFile == null || defaultTraceFile.length() <= 0) {
            defaultTraceFile = System.getProperty("was.install.root");
        }
        defaultTraceFile = defaultTraceFile + File.separator + "logs";
        defaultTraceFile = defaultTraceFile + File.separator + DEFAULT_TRACE_FILE;
        return defaultTraceFile;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0000I", null, null);
    }

    protected int parseRequiredArgs(String[] args) {
        int nextArg = 4;
        this.connHost = args[3];
        if (args.length > 4 && !args[4].startsWith("-")) {
            this.connPort = args[4];
            ++nextArg;
        } else {
            this.connPort = "8879";
        }
        return nextArg;
    }

    protected int parseUtilitySpecificOption(String[] args, int curOption) {
        int nextOption = curOption + 1;
        String option = args[curOption];
        if (option.equals("-includeapps")) {
            this.includeapps = true;
            this.adminProperties.setProperty("-includeapps", "true");
        } else if (option.equals("-conntype")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.connType = args[curOption + 1];
                this.adminProperties.setProperty("-connType", this.connType);
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-startingport")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.startingPort = new Integer(args[curOption + 1]);
                this.adminProperties.setProperty("-startingPort", this.startingPort.toString());
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-nodegroupname")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.nodeGroupName = args[curOption + 1];
                this.adminProperties.setProperty(NODE_Group_NAME_KEY, this.nodeGroupName);
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-noagent")) {
            this.launchNodeAgent = false;
            this.adminProperties.setProperty("-noagent", "false");
        } else if (option.equals("-registerservice")) {
            this.registerService = true;
            this.adminProperties.setProperty("-registerservice", "true");
        } else if (option.equals("-serviceusername")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.serviceUserName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-servicepassword")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.servicePassword = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-coregroupname")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.coreGroupName = args[curOption + 1];
                this.adminProperties.setProperty(CORE_Group_NAME_KEY, this.coreGroupName);
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-nodeagentshortname")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.nodeAgentShortName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-portprops")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.portPropsFileName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-dcshostname")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.dcsHostName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-localusername")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.localUserName = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-localpassword")) {
            if (this.isValidParameter(args, curOption + 1)) {
                this.localPassword = args[curOption + 1];
                ++nextOption;
            } else {
                nextOption = -2;
            }
        } else if (option.equals("-fromMBean")) {
            this.invokedFromMBean = true;
            this.adminProperties.setProperty("-fromMBean", "true");
        } else if (option.equals("-includebuses")) {
            this.includebuses = true;
            this.adminProperties.setProperty("-includebuses", "true");
        } else if (option.equals("-noautosignerretrieval")) {
            this.noAutoSignerRetrieval = true;
        } else if (option.equals("-excludesecuritydomains")) {
            this.adminProperties.setProperty("excludesecuritydomains", "true");
            this.excludeSecurityDomains = true;
        } else {
            nextOption = -1;
        }
        return nextOption;
    }

    protected void toolFailed(Throwable exception) {
        if (this.setRollback) {
            this.rollbackToBase();
        }
        super.toolFailed();
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    protected int runTool() throws Exception {
        this.checkIfNodeRegisteredToAdminAgent();
        if (!this.noAutoSignerRetrieval) {
            String[] cmdArgs = new String[]{"CellDefaultTrustStore", "ClientDefaultTrustStore", "-host", this.connHost, "-port", this.connPort, "-user", this.userid, "-password", this.pwd, "-conntype", this.connType, "-autoAcceptBootstrapSigner"};
            RetrieveSignersHelper retrieveSignersHelper = RetrieveSignersHelper.getInstance();
            retrieveSignersHelper.callRetrieveSigners(cmdArgs);
        }
        this.createAdminClientInstance();
        this.notificationService = this.getNotificationServiceMBean();
        try {
            if (!(this.serviceUserName == null && this.servicePassword == null || this.registerService && this.serviceUserName != null && this.servicePassword != null)) {
                this.issueMessage("ADMU1502E", null, null);
                throw new AdminException(this.getFormattedMessage("ADMU1502E", null, null));
            }
            this.getNodeProperties();
            if (this.portPropsFileName != null) {
                this.validatePortPropsFileName();
                if (this.startingPort != null) {
                    this.startingPort = null;
                    this.issueMessage("ADMU0060W", null, null);
                }
            }
            if (this.nodeAgentShortName != null && !AdminHelper.getPlatformHelper().isZOS()) {
                this.nodeAgentShortName = null;
                this.issueMessage("ADMU0061W", null, null);
            }
            this.doSetUp();
            this.warnForLocalOS();
            this.doCheckIfAddNodeIsOkToRun();
            this.doAddNode();
            this.doPostAddNodeProcessing();
        }
        catch (Throwable t) {
            this.printLineSeparator(null);
            this.issueMessage("ADMU0027E", new Object[]{NodeFederationUtility.getRootCause(t).getMessage()}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            throw Utils.makeAdminException(t);
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    private void validatePortPropsFileName() throws AdminException {
        block11: {
            FileInputStream in;
            block10: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validatePortProps entry");
                }
                this.portProperties = new Properties();
                in = null;
                try {
                    in = new FileInputStream(this.portPropsFileName);
                }
                catch (FileNotFoundException fnfe) {
                    throw new AdminException(fnfe, "Qualified filename, " + this.portPropsFileName + ", not found");
                }
                this.portProperties.load(in);
                String propVal = this.portProperties.getProperty(APPSERVER_BOOTSTRAP_PORT_PROP);
                if (propVal == null) break block10;
                this.givenAppserverBootstrapPort = new Integer(propVal);
                this.portProperties.remove(APPSERVER_BOOTSTRAP_PORT_PROP);
            }
            Object var4_5 = null;
            try {
                in.close();
                break block11;
            }
            catch (IOException e) {
                // empty catch block
            }
            {
                break block11;
                catch (IOException ioe) {
                    throw new AdminException(ioe, "Exception encounter while trying to load properties from " + this.portPropsFileName);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.prepareORBLAandBOOTSTRAP_ADDRESS(this.portProperties);
                throw throwable;
            }
        }
        this.prepareORBLAandBOOTSTRAP_ADDRESS(this.portProperties);
    }

    private void prepareORBLAandBOOTSTRAP_ADDRESS(Properties portProps) throws AdminException {
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isZOS = true, prepareORBLAandBOOTSTRAP_ADDRESS entry");
        }
        String bootStrapAddressPropVal = portProps.getProperty("BOOTSTRAP_ADDRESS");
        String orbListenerAddressPropVal = portProps.getProperty("ORB_LISTENER_ADDRESS");
        if (orbListenerAddressPropVal != null && bootStrapAddressPropVal == null) {
            portProps.setProperty("BOOTSTRAP_ADDRESS", orbListenerAddressPropVal);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "only ORB_LISTENER_ADDRESS was set " + orbListenerAddressPropVal + ". set BOOTSTRAP_ADDRESS to ORB_LISTENER_ADDRESS in this case");
            }
        }
    }

    private void doRegisterService() throws AdminException {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-add");
        argList.add(this.nodeName + "_nodeagent");
        argList.add("-serverName");
        argList.add("nodeagent");
        argList.add("-profilePath");
        argList.add(System.getProperty("user.install.root").replace('/', '\\'));
        argList.add("-restart");
        argList.add("false");
        argList.add("-startType");
        argList.add("automatic");
        Properties proxyProps = this.adminClient.getConnectorProperties();
        if (proxyProps.getProperty("username") != null && proxyProps.getProperty("password") != null && !proxyProps.getProperty("username").equals("") && !proxyProps.getProperty("password").equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting -stopArgs paramaters");
            }
            argList.add("-stopArgs");
            argList.add("\"-username " + proxyProps.getProperty("username") + " -password " + proxyProps.getProperty("password") + "\"");
            argList.add("-encodeParams");
        }
        this.execWASService(REGISTER_SERVICE, argList);
    }

    private void doStartService() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doStartService");
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-start");
        argList.add(this.nodeName + "_nodeagent");
        this.execWASService(START_NODEAGENT, argList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStartService");
        }
    }

    private void execWASService(String serviceName, List argList) throws AdminException {
        String cmdToXqt = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "WASService.exe";
        Tr.debug(tc, "Doing " + serviceName + " using WASService");
        Tr.debug(tc, "  Executable: " + cmdToXqt);
        Tr.debug(tc, "  Arguments: " + argList.toString());
        if (this.serviceUserName != null && serviceName.equals(REGISTER_SERVICE)) {
            Tr.debug(tc, "  Using -userid " + this.serviceUserName);
            argList.add("-userid");
            argList.add(this.serviceUserName);
            Tr.debug(tc, "  Using -password ****");
            argList.add("-password");
            argList.add(this.servicePassword);
        }
        CreationParams params = new CreationParams();
        Tr.debug(tc, "cmdToXqt = " + cmdToXqt);
        params.setExecutable(cmdToXqt);
        params.setProcessName("WAS_" + serviceName);
        params.setDetachProcess(true);
        String[] cmdLineArgs = new String[argList.size()];
        cmdLineArgs = argList.toArray(cmdLineArgs);
        params.setCommandLineArgs(cmdLineArgs);
        try {
            Tr.debug(tc, "Launching " + serviceName + " process ...");
            com.ibm.ws.process.Process p = ProcessFactory.create((CreationParams)params);
            p.waitForTermination();
            Tr.debug(tc, "Exit code from WASService: " + p.getExitCode());
            p.release();
            System.out.println();
        }
        catch (Exception e) {
            this.issueMessage("ADMU1500W", null, null);
            throw new AdminException(this.getFormattedMessage("ADMU1500W", null, null));
        }
    }

    private void doAddNode() throws Exception, DoNotDoAddNodeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAddNode");
        }
        this.collectNodeMetadata(null);
        this.doSetLockOnDMgrForAddAndRemoveNode();
        this.doPreConfigUpdateProcessing();
        if (this.includeapps) {
            this.doRemoveWebServers();
        }
        this.doAllConfigUpdates();
        this.doReleaseLockOnDMgrForAddAndRemoveNode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doAddNode");
        }
    }

    private void doConfigOnDMgr() throws Exception {
        ObjectName adminOps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doConfigOnDMgr");
        }
        if ((adminOps = this.getMBeanByType("AdminOperations")) == null) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.invokeMBean(adminOps, "mergeConfigDataOnDmgr", new Object[]{this.nodeProperties, this.adminProperties}, new String[]{"java.util.Properties", "java.util.Properties"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doConfigOnDMgr");
        }
    }

    private void getNodeProperties() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties");
        }
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
        Properties tmpProperties = new Properties();
        tmpProperties.setProperty("local.cell", this.cellName);
        tmpProperties.setProperty("was.repository.root", this.configRoot);
        managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(tmpProperties);
        this.nodeProperties = managedObjectMetadataAccessor.getMetadataProperties(this.nodeName);
        this.nodeProperties.setProperty(CELL_NAME_KEY, this.cellName);
        this.nodeProperties.setProperty(NODE_NAME_KEY, this.nodeName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeProperties", this.nodeProperties.toString());
        }
    }

    private void doDisableRollback() {
        this.setRollback = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRollback = false");
        }
    }

    private void doEnableRollback() {
        this.setRollback = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setRollback = true");
        }
    }

    private void doAllConfigUpdates() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doAllConfigUpdates");
        }
        this.doEnableRollback();
        this.doRemoveDeployedAppsFromSystemApps();
        this.copyConfigToNewCell();
        this.addPMIConfigForNodeAgent();
        this.deleteNamestoreFiles();
        this.doUpdateConfigDocumentsOnLocalMachine();
        this.doUploadConfigDocumentsToDMgr();
        this.doConfigOnDMgr();
        this.doRegenNDPluginConfig();
        this.doUpdateVirtualHost();
        this.syncNode();
        this.doValidateAddNodeWasSuccessful();
        this.doDisableRollback();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doAllConfigUpdates");
        }
    }

    private void addPMIConfigForNodeAgent() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPMIConfigForNodeAgent()");
        }
        File fromFile = new File(this.configRoot + "/templates/system/nodes/servers/nodeagent/pmi-config.xml");
        File toDir = new File(this.nodeAgentDir);
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        File toFile = new File(this.nodeAgentDir + "pmi-config.xml");
        this.copyDocument(fromFile, toFile);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPMIConfigForNodeAgent()");
        }
    }

    private void doRemoveWebServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveWebServers");
        }
        String wsId = null;
        AppManagement appmgmt = AppManagementProxy.getLocalProxy();
        Vector nodeList = this.getNodeList();
        for (int n = 0; n < nodeList.size(); ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeName[" + n + "]: " + nodeList.get(n));
            }
            if (((String)nodeList.get(n)).equals(this.nodeName)) continue;
            this.issueMessage("ADMU0129I", new Object[]{nodeList.get(n)}, "ADMU0129I: Remote server in node {0} will not be propagated to new cell.  Create new server and map applications as necessary using deployment manager.");
            appmgmt.removeAllAppsFromNode((String)nodeList.get(n), this.cellName, null, wsId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRemoveWebServers");
        }
    }

    private Vector getNodeList() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeList");
        }
        Vector<String> nodeList = new Vector<String>();
        String ndir = this.configRoot + "/cells/" + this.cellName + "/nodes";
        File nodeContexts = new File(ndir);
        File[] nodes = nodeContexts.listFiles();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].isDirectory()) continue;
                String nodeName = nodes[i].getName();
                nodeList.add(nodeName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeList", nodeList.toString());
        }
        return nodeList;
    }

    private void doRemoveDeploymentTargets(List deplContents, List displayedServersList) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveDeploymentTargets");
        }
        block2: for (int k = 0; k < deplContents.size(); ++k) {
            Deployment deployment = (Deployment)deplContents.get(k);
            EList deploymentTargets = deployment.getDeploymentTargets();
            while (true) {
                ServerTarget serverTarget = null;
                DeploymentTarget deploymentTarget = null;
                boolean wereServerTargetsRemoved = false;
                for (int m = 0; m < deploymentTargets.size(); ++m) {
                    deploymentTarget = (DeploymentTarget)deploymentTargets.get(m);
                    if (!(deploymentTarget instanceof ServerTarget) || (serverTarget = (ServerTarget)deploymentTarget).getNodeName().equals(this.nodeName)) continue;
                    if (!this.isInList(deploymentTarget.getName(), displayedServersList)) {
                        displayedServersList.add(deploymentTarget.getName());
                        this.issueMessage("ADMU0129I", new Object[]{deploymentTarget.getName()}, "ADMU0129I: Remote server {0} will not be propagated to new cell.  Create new server and map applications as necessary using deployment manager.");
                    }
                    WASEcoreUtil.remove(deploymentTarget);
                    wereServerTargetsRemoved = true;
                    break;
                }
                if (!wereServerTargetsRemoved) continue block2;
                try {
                    deployment.eResource().save(new HashMap());
                }
                catch (Throwable t) {
                    throw Utils.makeAdminException(t);
                }
                wereServerTargetsRemoved = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRemoveDeploymentTargets");
        }
    }

    private void doRemoveDeployedAppsFromSystemApps() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRemoveDeployedAppsFromSystemApps");
        }
        ConfigRoot tmpConfigRoot = this.getLocalRepository().getConfigRoot();
        Resource tmpResource = null;
        try {
            tmpResource = tmpConfigRoot.getResource(3, "systemapps.xml");
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        EList extent = tmpResource.getContents();
        Object entry = null;
        ServerIndex serverIndex = null;
        ServerEntry serverEntry = null;
        if (extent == null || extent.isEmpty() || !(extent.get(0) instanceof ServerIndex)) {
            return;
        }
        serverIndex = (ServerIndex)extent.get(0);
        EList serverEntryList = serverIndex.getServerEntries();
        for (int i = 0; i < serverEntryList.size(); ++i) {
            entry = serverEntryList.get(i);
            if (!(entry instanceof ServerEntry)) continue;
            serverEntry = entry;
            Iterator iterator = serverEntry.getDeployedApplications().iterator();
            while (iterator.hasNext()) {
                String deploymentPath = this.map.expand((String)iterator.next());
                if (this.shouldRetainSystemApp(deploymentPath)) continue;
                iterator.remove();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "remove sys app - " + deploymentPath);
            }
            serverEntry.eResource().save(new HashMap());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRemoveDeployedAppsFromSystemApps");
        }
    }

    private boolean shouldRetainSystemApp(String deploymentPath) {
        Properties props;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldRetainSystemApp");
        }
        if ((props = this.getSystemAppProps(deploymentPath)).isEmpty()) {
            return false;
        }
        if (props.getProperty("com.ibm.websphere.systemapps.retainND").equals("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ShouldRetainSystemApp = true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldRetainSystemApp");
        }
        return false;
    }

    private Properties getSystemAppProps(String earPath) {
        return this.loadPropsFromFile(earPath + FSEP + "META-INF/ibm-application-sa.props");
    }

    private Properties loadPropsFromFile(String file) {
        Properties props;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadPropsFromFile");
            }
            props = new Properties();
            try {
                FileInputStream in = new FileInputStream(file);
                props.load(in);
                in.close();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read props file from " + file);
                }
            }
            catch (Throwable th) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Warning: Exception in reading " + file + " ex: " + th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropsFromFile", props.toString());
        }
        return props;
    }

    private void doUploadConfigDocumentsToDMgr() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUploadConfigDocumentsToDMgr");
        }
        try {
            this.issueMessage("ADMU0014I", new Object[]{this.nodeName, this.newCellName}, null);
            this.createAppDocuments(this.appDir);
            if (this.includeapps) {
                this.getSkipsBLAsCusAssets();
                System.clearProperty("local.cell");
            }
            this.deleteBLAs();
            this.deleteCUs();
            this.deleteAssets();
            File zipFile = File.createTempFile(this.nodeName + "__", ".car");
            String oldCell = this.configRoot + "/cells/" + this.cellName;
            this.deleteDirs(oldCell);
            boolean quiet = this.isQuiet();
            this.setQuiet(true);
            File waspo = new File(this.configRoot + "/waspolicies");
            if (!this.excludeSecurityDomains && waspo.exists()) {
                this.compressDir(this.configRoot + "/cells", this.configRoot + "/waspolicies", zipFile);
            } else {
                this.compressDir(this.configRoot + "/cells", zipFile);
            }
            if (tc.isDebugEnabled()) {
                String fpath = new File(this.configRoot).getParent() + "/logs/uploaded.car";
                Tr.debug(tc, "Uploaded .car file is saved to " + fpath);
                try {
                    this.copyDocument(zipFile, new File(fpath));
                }
                catch (Throwable e) {
                    Tr.debug(tc, "Failed to save a copy of the .car file to " + fpath, e);
                }
            }
            this.setQuiet(quiet);
            String dest = this.copyToServer(zipFile, "upload/addNode/" + this.nodeName + FSEP + this.nodeName + Long.toHexString(System.currentTimeMillis()) + ".car");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dest is " + dest);
            }
            this.nodeProperties.put(ADDNODE_ARCHIVE_PATH_KEY, dest);
            this.nodeAddedToDmgr = true;
        }
        catch (Exception e) {
            this.nodeAddedToDmgr = false;
            Tr.error(tc, "ADMU0011E", e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUploadConfigDocumentsToDMgr");
        }
    }

    private void doUpdateConfigDocumentsOnLocalMachine() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUpdateConfigDocumentsOnLocalMachine");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create a new local config directory and server.xml for node agent");
        }
        this.createNodeAgentServerDoc(this.nodeAgentDir);
        this.createHAMgrXml(this.nodeAgentDir);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setup NodeAgent data");
        }
        this.setupNodeAgentData(this.newCellName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "fix up local serverindex.xml");
        }
        this.addToServerIndex("nodeagent");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUpdateConfigDocumentsOnLocalMachine");
        }
    }

    private void doPreConfigUpdateProcessing() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doPreConfigUpdateProcessing");
        }
        this.configRepositoryClient = this.getRepositoryClient(this.clientProps);
        ModelMgr.initialize((String)"ws-server");
        this.fromDir = this.configRoot + "/cells/" + this.cellName;
        this.toNodeDir = this.configRoot + "/cells/" + this.newCellName + "/nodes/" + this.nodeName;
        this.nodeAgentDir = this.toNodeDir + "/servers/nodeagent/";
        this.tmpCellDir = this.configRoot + "/cells/" + this.newCellName;
        this.appDir = this.tmpCellDir + "/applications";
        this.blaDir = this.tmpCellDir + "/blas";
        this.cuDir = this.tmpCellDir + "/cus";
        this.assetDir = this.tmpCellDir + "/assets";
        this.originalDir = this.fromDir;
        this.localRunTimeRepository = null;
        this.map = null;
        if (this.localUserName == null && this.localPassword == null) {
            this.localUserName = this.userid;
            this.localPassword = this.pwd;
        }
        this.stopAllServers(this.localUserName, this.localPassword);
        this.makeBackups();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doPreConfigUpdateProcessing");
        }
    }

    private void doPostAddNodeProcessing() throws Exception {
        String defaultStaticContentDirectory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doPostAddNodeProcessing");
        }
        this.doPostAddNodeUpdateLocalFiles();
        if (this.isZOS()) {
            this.transformConfig2Native(this.newCellName, this.nodeName);
            System.setProperty("was.serverstart.cell", this.newCellName);
            System.setProperty("was.serverstart.node", this.nodeName);
            System.setProperty("was.serverstart.server", "nodeagent");
        }
        if (this.registerService && NodeFederationUtility.isPlatformWindows()) {
            this.doRegisterService();
            if (this.launchNodeAgent) {
                this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
                this.doStartService();
            }
        } else if (this.launchNodeAgent) {
            try {
                this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
                this.launchNodeAgent();
            }
            catch (Exception e) {
                this.issueMessage("ADMU0114E", null, null);
                Tr.debug(tc, "Node Agent didn't start successfully - but continuing with Node Federation");
            }
        }
        if ((defaultStaticContentDirectory = System.getProperty("user.install.root")) == null || defaultStaticContentDirectory.length() <= 0) {
            defaultStaticContentDirectory = System.getProperty("was.install.root");
        }
        defaultStaticContentDirectory = defaultStaticContentDirectory + File.separator + "staticContent";
        File file = new File(defaultStaticContentDirectory);
        file.mkdirs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created default static content directory for proxy server: " + defaultStaticContentDirectory);
        }
        this.cellName = this.newCellName;
        ArrayList<String> doNotRemoveList = new ArrayList<String>();
        doNotRemoveList.add("nodeagent");
        this.removeAllServices(doNotRemoveList);
        this.doPostAddNodeIssueMessages();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doPostAddNodeProcessing");
        }
    }

    private void doPostAddNodeIssueMessages() {
        this.printLineSeparator(null);
        if (!this.includeapps) {
            this.issueMessage("ADMU0300I", new Object[]{this.nodeName, this.newCellName}, null);
        } else {
            this.issueMessage("ADMU0308I", new Object[]{this.nodeName, this.newCellName}, null);
        }
        this.printLineSeparator(null);
        this.showNextTasks();
    }

    private void doPostAddNodeUpdateLocalFiles() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doPostAddNodeUpdateLocalFiles");
        }
        File originalcell = new File(this.fromDir);
        originalcell.delete();
        this.fixSetupCmdLine(this.newCellName, this.clientProps);
        this.fixWsadminProps(this.clientProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doPostAddNodeUpdateLocalFiles");
        }
    }

    private void doValidateAddNodeWasSuccessful() throws Exception {
        this.throwExceptionIfNodeCannotPingCellMgr();
    }

    private void doReleaseLockOnDMgrForAddAndRemoveNode() throws Exception {
        this.completeAddOrRemoveNode();
    }

    private void doRegenNDPluginConfig() throws Exception {
        ObjectName jvmBean;
        ObjectName configGen;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doRegenNDPluginConfig");
        }
        if ((configGen = this.getMBeanByType("PluginCfgGenerator")) != null && (jvmBean = this.getMBeanByType("JVM")) != null) {
            String iRoot = (String)this.adminClient.invoke(jvmBean, "getProperty", new Object[]{"user.install.root"}, new String[]{"java.lang.String"});
            Object cRoot = null;
            try {
                this.invokeMBean(configGen, "generate", new Object[]{iRoot, cRoot, this.newCellName, null, null, "plugin-cfg.xml"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
            }
            catch (MBeanException exc) {
                this.issueMessage("ADMU0040E", new Object[]{configGen, "generate", exc}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doRegenNDPluginConfig");
        }
    }

    private void doUpdateVirtualHost() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUpdateVirtualHost");
        }
        if (this._adminHosts == null) {
            this.getAdminHostPorts();
        }
        UpdateVirtualHost uvh = new UpdateVirtualHost(this.configService);
        uvh.updateDefaultHostHostAliases(this.connHost, this._adminHosts, this._adminPorts);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUpdateVirtualHost");
        }
    }

    private void doSetLockOnDMgrForAddAndRemoveNode() throws Exception, DoNotDoAddNodeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doSetLockOnDMgrForAddAndRemoveNode");
        }
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            throw new DoNotDoAddNodeException();
        }
        Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doSetLockOnDMgrForAddAndRemoveNode");
        }
    }

    private void doCheckIfAddNodeIsOkToRun() throws Exception {
        ObjectName adminOps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheckIfAddNodeIsOkToRun");
        }
        if (this.isMemberOfCell()) {
            this.issueMessage("ADMU0033E", new Object[]{this.nodeName}, null);
            throw new DoNotDoAddNodeException(this.getFormattedMessage("ADMU0033E", new Object[]{this.nodeName}, null));
        }
        if (this.nodeNameAlreadyExistsInCell()) {
            throw new AdminException(this.getFormattedMessage("ADMU0039E", new Object[]{this.nodeName}, null));
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0126E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            throw new DoNotDoAddNodeException(this.getFormattedMessage("ADMU0126E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null));
        }
        if (!this.isClockInSync()) {
            this.failAddNodeBecauseClocksNotInSync();
        }
        if ((adminOps = this.getMBeanByType("AdminOperations")) == null) {
            throw new AdminException("Could not get the deployment manager's AdminOperations MBean");
        }
        MBeanInfo info = this.adminClient.getMBeanInfo(adminOps);
        MBeanOperationInfo[] opinfos = info.getOperations();
        for (int j = 0; j < opinfos.length; ++j) {
            if (!opinfos[j].getName().equals("checkNodeAndDmgrCompatibility")) continue;
            this.invokeMBean(adminOps, "checkNodeAndDmgrCompatibility", new Object[]{this.nodeProperties}, new String[]{"java.util.Properties"});
            break;
        }
        this.checkProductExtensionsNew(this.nodeProperties, this.adminClient);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.sameNodeAsCellMgr()) {
            throw new AdminException(this.getFormattedMessage("ADMU0032E", new Object[]{this.nodeName}, null));
        }
        if (this.sameNameAsCell()) {
            throw new AdminException(this.getFormattedMessage("ADMU0034E", new Object[]{this.newCellName}, "ADMU0034E: The node/cell name of the node being federated must have a different name than the cell name of the ND manager node: {0}"));
        }
        this.checkIfNodeCanJoinNodeGroup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheckIfAddNodeIsOkToRun");
        }
    }

    private void checkIfNodeCanJoinNodeGroup() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfNodeCanJoinNodeGroup()");
        }
        Throwable th = null;
        Session session = new Session();
        try {
            try {
                Properties metadataProps = new Properties();
                metadataProps.setProperty("local.cell", this.cellName);
                metadataProps.setProperty("was.repository.root", this.configRoot);
                ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(metadataProps));
                String os = metadataHelper.getNodePlatformOS(this.nodeName);
                String ver = metadataHelper.getNodeBaseProductVersion(this.nodeName);
                Properties prop = metadataHelper.getAccessor().getMetadataProperties(this.nodeName);
                String sysplex = prop.getProperty("com.ibm.websphere.nodeSysplexName");
                AdminCommand cmd = null;
                if (this.cmdMgr == null) {
                    this.cmdMgr = CommandMgr.getCommandMgr();
                }
                cmd = this.cmdMgr.createCommand("canNodeJoinNodeGroup");
                cmd.setConfigSession(session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeGroupName = " + this.nodeGroupName);
                    Tr.debug(tc, "nodeName      = " + this.nodeName);
                    Tr.debug(tc, "platform      = " + os);
                    Tr.debug(tc, "version       = " + ver);
                    Tr.debug(tc, "sysplexName   = " + sysplex);
                }
                cmd.setParameter("nodeGroupName", this.nodeGroupName);
                cmd.setParameter("nodeName", this.nodeName);
                cmd.setParameter("platform", os);
                cmd.setParameter("version", ver);
                cmd.setParameter("sysplexName", sysplex);
                cmd.execute();
                CommandResult result = cmd.getCommandResult();
                Collection c = result.getMessages();
                this.issueWarningsIfAny(c, "ADMU0054W");
                if (result.isSuccessful()) {
                    int res = (Integer)result.getResult();
                    if (res == 2) {
                        cmd = this.cmdMgr.createCommand("convertToSysplexNodeGroup");
                        cmd.setConfigSession(session);
                        cmd.setTargetObject(this.nodeGroupName);
                        this.setConvertToSysplexNodeGroupParams(cmd, sysplex);
                        cmd.execute();
                        result = cmd.getCommandResult();
                        c = result.getMessages();
                        this.issueWarningsIfAny(c, "ADMU0055W");
                        if (!result.isSuccessful()) {
                            th = result.getException();
                            throw new AdminException(th, this.getFormattedMessage("ADMU0051E", new Object[]{th, this.nodeGroupName, this.nodeName}, "ADMU0051E: Exception occurred while converting node group {2} to sysplex node group for node {1}. {0}"));
                        }
                    }
                    this.configService.save(session, true);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfNodeCanJoinNodeGroup()");
                    }
                } else {
                    th = result.getException();
                    throw new AdminException(th, this.getFormattedMessage("ADMU0050E", new Object[]{th, this.nodeName, this.nodeGroupName}, "ADMU0050E: Exception encountered while checking if node {1} can join node group {2}. {0}"));
                }
                Object var14_14 = null;
            }
            catch (Exception e) {
                throw new AdminException(e, this.getFormattedMessage("ADMU0050E", new Object[]{e, this.nodeName, this.nodeGroupName}, "ADMU0050E: Exception encountered while checking if node {1} can join node group {2}. {0}"));
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.configService.discard(session);
            throw throwable;
        }
        this.configService.discard(session);
    }

    public void setConvertToSysplexNodeGroupParams(AdminCommand cmd, String localSysplexName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConvertToSysplexNodeGroupParams");
        }
        Properties props = new Properties();
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        String oldCell = cfgRoot.getValue(0);
        cfgRoot.setValue(0, this.cellName);
        Resource r = cfgRoot.getResource(0, "nodegroups" + File.separator + this.getSysplexNodeGroup() + File.separator + "nodegroup.xml");
        NodeGroup nodegroup = (NodeGroup)r.getContents().get(0);
        EList propList = nodegroup.getProperties();
        for (Property prop : propList) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop is: ", prop);
            }
            if (!prop.getName().startsWith("was.")) continue;
            props.put(prop.getName(), prop.getValue());
        }
        props.put("sysplexName", localSysplexName.trim());
        cfgRoot.setValue(0, oldCell);
        cmd.setParameter("shortName", nodegroup.getShortName());
        cmd.setParameter("sysplexProps", props);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "shortName is " + nodegroup.getShortName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConvertToSysplexNodeGroupParams");
        }
    }

    public String getSysplexNodeGroup() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSysplexNodeGroup");
        }
        String sysplexNodeGroupName = null;
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        String oldNode = cfgRoot.getValue(3);
        cfgRoot.setValue(3, this.nodeName);
        Resource r = cfgRoot.getResource(3, "node.xml");
        Node node = (Node)r.getContents().get(0);
        EList propList = node.getProperties();
        for (Property prop : propList) {
            if (!prop.getName().equals("was.sysplexNodeGroup")) continue;
            sysplexNodeGroupName = prop.getValue();
            break;
        }
        cfgRoot.setValue(3, oldNode);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSysplexNodeGroup", sysplexNodeGroupName);
        }
        return sysplexNodeGroupName;
    }

    private void failAddNodeBecauseClocksNotInSync() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "failAddNodeBecauseClockNotInSync");
        }
        long localTime = System.currentTimeMillis();
        long remoteTime = Utils.getRemoteTime(this.adminClient, this.getMBeanByType("JVM"));
        Date local = new Date(localTime);
        Date remote = new Date(remoteTime);
        String remoteString = DateFormat.getDateTimeInstance().format(remote);
        String localString = DateFormat.getDateTimeInstance().format(local);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remote time is " + remoteString);
            Tr.debug(tc, "local time is " + localString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "failAddNodeBecauseClockNotInSync");
        }
        this.issueMessage("ADMU0124I", new Object[]{localString, remoteString}, "ADMU0124I: The system clock of the new node {0} is not synchronized with that of the deployment manager {1}.");
        this.issueMessage("ADMU0125E", new Object[]{String.valueOf(5L)}, "ADMU0125E: Change the clock of the new node to be within 5 minutes of the clock of the deployment manager.");
        throw new DoNotDoAddNodeException();
    }

    private void doSetUp() throws Exception {
        this.issueMessage("ADMU0001I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        this.createAdminClientInstance();
        this.configService = new ConfigServiceProxy(this.adminClient);
        this.cmdMgr = CommandMgr.getCommandMgr(this.adminClient);
        if (!this.isConnectedToDeploymentManager()) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.issueMessage("ADMU0009I", new Object[]{this.connHost, this.connPort}, null);
        this.repositoryHandle = this.getMBeanByType("ConfigRepository");
        this.newCellName = ObjectNameHelper.getCellName(this.repositoryHandle);
        this.clientProps.setProperty("cellName", this.newCellName);
        this.appsIncluded = new Vector();
        this.apps2path = new Hashtable();
    }

    private void createAdminClientInstance() throws Exception {
        this.clientProps = this.getClientProperties();
        if ("RMI".equals(this.clientProps.getProperty("type")) && this.clientProps.getProperty("host") != null && this.clientProps.getProperty("port") != null) {
            Properties sysProps = System.getProperties();
            sysProps.setProperty("com.ibm.CORBA.securityServerHost", this.clientProps.getProperty("host"));
            sysProps.setProperty("com.ibm.CORBA.securityServerPort", this.clientProps.getProperty("port"));
            System.setProperties(sysProps);
        }
        this.adminClient = this.getAdminClient(this.clientProps);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adminClient connectorProps = " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)this.adminClient.getConnectorProperties()));
        }
    }

    private boolean nodeNameAlreadyExistsInCell() throws InstanceNotFoundException, ConnectorException, ConfigServiceException {
        Session session;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeNameAlreadyExistsInCell");
        }
        if (this.configService.resolve(session = new Session(), "Node=" + this.nodeName).length > 0) {
            this.configService.discard(session);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nodeNameAlreadyExistsInCell is true");
            }
            return true;
        }
        this.configService.discard(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeNameAlreadyExistsInCell is false");
        }
        return false;
    }

    private boolean isConnectedToDeploymentManager() throws Exception {
        ObjectName dmgr = this.getMBeanByType("DeploymentManager");
        return dmgr != null;
    }

    protected boolean isDmgrSameOrLaterVersion() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDmgrSameOrLaterVersion");
        }
        String nodeVersion = Utils.getProductVersion();
        String dmgrVersion = this.getDMgrVersion();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node version is " + nodeVersion);
            Tr.debug(tc, "Dmgr version is " + dmgrVersion);
        }
        if (nodeVersion == null || dmgrVersion == null) {
            return true;
        }
        int compare = Utils.compareVersions(dmgrVersion, nodeVersion);
        if (compare >= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isDmgrSameOrLaterVersion is true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDmgrSameOrLaterVersion is false");
        }
        return false;
    }

    protected String getDMgrVersion() throws Exception {
        return Utils.getRemoteProductVersion("ND", this.getMBeanByType("Server"), this.adminClient);
    }

    private boolean isClockInSync() throws Exception {
        return Utils.isClockInSync(this.adminClient, this.getMBeanByType("JVM"));
    }

    private void makeBackups() throws Exception {
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        this.backupDir = this.backupRoot + "/base/cells/" + this.cellName;
        this.backupTemplatesDir = this.backupRoot + "/base/templates";
        this.backupWaspoliciesDir = this.backupRoot + "/base/waspolicies";
        this.origTemplatesDir = this.configRoot + "/templates";
        this.origWaspoliciesDir = this.configRoot + "/waspolicies";
        this.deleteBackupDirectory();
        this.issueMessage("ADMU0015I", null, null);
        this.backupConfigDirectory();
        this.backupPluginCfg();
        this.backupTemplates();
        this.backupWaspolicies();
    }

    private void deleteBackupDirectory() throws Exception {
        this.issueMessage("ADMU0024I", null, null);
        this.deleteDirs(this.backupDir);
        this.deleteDirs(this.backupTemplatesDir);
        this.deleteDirs(this.backupWaspoliciesDir);
    }

    private void backupConfigDirectory() throws Exception {
        File backup = new File(this.backupDir);
        if (!backup.exists()) {
            backup.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copying " + this.originalDir + " to " + this.backupDir);
        }
        this.copyDocuments(this.originalDir, this.backupDir);
    }

    private void backupPluginCfg() throws Exception {
        File plugincfg = new File(this.configRoot + "/plugin-cfg.xml");
        File backupPlugincfg = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (plugincfg.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying " + plugincfg + " to " + backupPlugincfg);
            }
            this.copyDocument(plugincfg, backupPlugincfg);
        }
        File plugincfgService = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File backupPlugincfgService = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (plugincfgService.exists()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying " + plugincfgService + " to " + backupPlugincfgService);
            }
            this.copyDocument(plugincfgService, backupPlugincfgService);
        }
    }

    private void backupTemplates() throws Exception {
        File backupTemplates = new File(this.backupTemplatesDir);
        if (!backupTemplates.exists()) {
            backupTemplates.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copying " + this.origTemplatesDir + " to " + this.backupTemplatesDir);
        }
        this.copyDocuments(this.origTemplatesDir, this.backupTemplatesDir);
    }

    private void backupWaspolicies() throws Exception {
        File backupWaspolicies = new File(this.backupWaspoliciesDir);
        if (!backupWaspolicies.exists()) {
            backupWaspolicies.mkdirs();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copying " + this.origWaspoliciesDir + " to " + this.backupWaspoliciesDir);
        }
        this.copyDocuments(this.origWaspoliciesDir, this.backupWaspoliciesDir);
    }

    private void copyConfigToNewCell() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copy files into new structure to match new cell");
        }
        this.copyDocuments(this.originalDir, this.tmpCellDir);
    }

    private void deleteNamestoreFiles() {
        String serverPath = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers";
        File serverDir = new File(serverPath);
        File[] serverNames = serverDir.listFiles();
        String[] excludeNames = new String[]{"namestore-cell.xml", "namestore-node.xml"};
        if (serverNames != null) {
            for (int i = 0; i < serverNames.length; ++i) {
                if (!serverNames[i].isDirectory()) continue;
                for (int j = 0; j < excludeNames.length; ++j) {
                    try {
                        File naming = new File(serverNames[i], excludeNames[j]);
                        if (!naming.exists()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deleting namingstore file " + naming);
                        }
                        naming.delete();
                        continue;
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Error trying to delete exception list", e);
                    }
                }
            }
        }
    }

    private void createHAMgrXml(String nodeAgentDir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "creatHAMgrXML");
        }
        String templatePath = this.configRoot + "/templates/servertypes/APPLICATION_SERVER/servers/default";
        File hamgrXml = new File(nodeAgentDir, "hamanagerservice.xml");
        File fromDir = new File(templatePath, "hamanagerservice.xml");
        this.copyDocument(fromDir, hamgrXml);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "creatHAMgrXML");
        }
    }

    private void createNodeAgentServerDoc(String nodeAgentDir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNodeAgentServerDoc");
        }
        this.issueMessage("ADMU0012I", new Object[]{this.nodeName}, null);
        this.naConfigBuilder = new NodeAgentConfigBuilder();
        this.naConfigBuilder.setConfigRepositoryRoot(nodeAgentDir);
        this.naConfigBuilder.setProcessName("nodeagent");
        this.naConfigBuilder.setNodeName(this.nodeName);
        if (this.nodeAgentShortName != null) {
            this.naConfigBuilder.setNodeAgentShortName(this.nodeAgentShortName);
        }
        if (this.portProperties != null) {
            this.naConfigBuilder.setPortProperties(this.portProperties);
        }
        this.naConfigBuilder.write(this.naConfigBuilder.buildRootElements(), "server.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNodeAgentServerDoc");
        }
    }

    protected void syncNode() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncNode");
        }
        NodeSync synch = NodeSync.createNodeSync();
        try {
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            synch.initialize(this.clientProps, null, this.getVariableMap());
            this.issueMessage("ADMU0016I", null, null);
            Boolean b = synch.sync();
            if (!b.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException ae) {
            Tr.error(tc, "ADMU0005E", ae);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncNode");
        }
    }

    private void rollbackToBase() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackToBase");
        }
        this.issueMessage("ADMU0026I", null, null);
        try {
            File newcell;
            File originalWaspolicies;
            File originalTemplates;
            File backup;
            File original = new File(this.originalDir);
            if (!original.exists()) {
                original.mkdirs();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copying back " + this.backupDir + " to " + this.originalDir);
            }
            if ((backup = new File(this.backupDir)).exists()) {
                this.copyDocuments(this.backupDir, this.originalDir);
            }
            if (!(originalTemplates = new File(this.origTemplatesDir)).exists()) {
                originalTemplates.mkdirs();
            }
            if ((backup = new File(this.backupTemplatesDir)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copying back " + this.backupTemplatesDir + " to " + this.origTemplatesDir);
                }
                this.copyDocuments(this.backupTemplatesDir, this.origTemplatesDir);
            }
            if (!(originalWaspolicies = new File(this.origWaspoliciesDir)).exists()) {
                originalWaspolicies.mkdirs();
            }
            if ((backup = new File(this.backupWaspoliciesDir)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copying back " + this.backupWaspoliciesDir + " to " + this.origWaspoliciesDir);
                }
                this.copyDocuments(this.backupWaspoliciesDir, this.origWaspoliciesDir);
            }
            File plugincfg = new File(this.configRoot + "/plugin-cfg.xml");
            File backupPlugincfg = new File(this.backupRoot + "/base/plugin-cfg.xml");
            if (backupPlugincfg.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copying back " + backupPlugincfg + " to " + plugincfg);
                }
                this.copyDocument(backupPlugincfg, plugincfg);
            }
            File plugincfgService = new File(this.configRoot + "/plugin-cfg-service.xmi");
            File backupPlugincfgService = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
            if (backupPlugincfgService.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "copying back " + backupPlugincfgService + " to " + plugincfgService);
                }
                this.copyDocument(backupPlugincfgService, plugincfgService);
            }
            if (this.apps2path.size() > 0) {
                this.rollbackBinaries();
            }
            if ((newcell = new File(this.tmpCellDir)).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delete " + this.tmpCellDir);
                }
                this.deleteDirs(this.tmpCellDir);
                newcell.delete();
            }
            if (this.nodeAddedToDmgr) {
                this.removeFromCell(this.adminClient);
            }
        }
        catch (Exception e) {
            Tr.error(tc, "ADMU0007E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackToBase");
        }
    }

    private void rollbackBinaries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackBinaries");
        }
        try {
            VariableMap origMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
            VariableMap newMap = this.getVarMap(this.configRoot, this.newCellName, this.nodeName);
            Enumeration en = this.apps2path.keys();
            while (en.hasMoreElements()) {
                String earDir = (String)en.nextElement();
                Vector paths = (Vector)this.apps2path.get(earDir);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing: " + earDir + " for paths: " + paths);
                }
                Vector<String> expand = new Vector<String>();
                for (int i = 0; i < paths.size(); ++i) {
                    String p1 = origMap.expand((String)paths.elementAt(i));
                    if (!this.appsIncluded.contains(earDir)) {
                        expand.addElement(p1);
                        continue;
                    }
                    String p2 = newMap.expand((String)paths.elementAt(i));
                    if (p1.equals(p2)) continue;
                    expand.addElement(p1);
                    this.deleteDirs(p2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Rollback " + earDir + " to be expanded to: " + expand);
                }
                this.expandEar(this.originalDir + "/applications/" + earDir + FSEP + earDir, expand);
            }
        }
        catch (Throwable th) {
            this.issueMessage("ADMU0089E", new Object[]{th}, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackBinaries");
        }
    }

    private boolean sameNodeAsCellMgr() throws Exception {
        String node;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameNodeAsCellMgr");
        }
        boolean same = false;
        ObjectName cellmgr = this.getMBeanByType("DeploymentManager");
        if (cellmgr != null && (node = cellmgr.getKeyProperty("node")).equals(this.nodeName)) {
            same = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sameNodeAsCellMgr", same);
        }
        return same;
    }

    private boolean sameNameAsCell() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameNameAsCell");
        }
        boolean same = false;
        if (this.cellName.compareToIgnoreCase(this.newCellName.toString()) == 0) {
            same = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameNameAsCell", same);
        }
        return same;
    }

    private void getFileTransferConfig(Properties p) throws Exception {
        ObjectName fileTransferServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileTransferConfig ", p.toString());
        }
        if ((fileTransferServer = this.getMBeanByType("FileTransferServer")) != null) {
            FileTransferConfig ftcfg = (FileTransferConfig)this.invokeMBean(fileTransferServer, "getServerConfig", null, null);
            this.testLocalhost(ftcfg);
            p.put("fileTransferConfig", ftcfg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileTransferConfig");
        }
    }

    private void testLocalhost(FileTransferConfig ftc) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testLocalhost");
        }
        try {
            int port = 0;
            String portProperty = null;
            String host = (String)ftc.getProperties().get("host");
            if (host.equals("localhost") || host.equals("127.0.0.1")) {
                Socket s;
                portProperty = (String)ftc.getProperties().get("secure_port");
                if (!ftc.isSecurityEnabled() || portProperty == null || portProperty.equals("")) {
                    portProperty = (String)ftc.getProperties().get("port");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Testing file transfer socket with host=" + host + " and port=" + portProperty);
                }
                if ((s = new Socket(host, port = Integer.parseInt(portProperty))) != null) {
                    s.close();
                }
            }
        }
        catch (Exception e) {
            throw new AdminException(this.getFormattedMessage("ADMU0038E", null, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testLocalhost");
        }
    }

    private ConfigRepositoryClient getRepositoryClient(Properties p) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRepositoryClient");
        }
        ConfigRepositoryClient crc = null;
        try {
            this.getFileTransferConfig(p);
            crc = (ConfigRepositoryClient)ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)p);
            crc.initialize(p);
        }
        catch (Exception e) {
            Tr.error(tc, "ADMU0010E", e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRepositoryClient");
        }
        return crc;
    }

    protected ResourceSet createResourceSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceSet");
        }
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(NodeFederationUtility.this.configRoot + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceSet");
        }
        return rs;
    }

    private void createAppDocuments(String appDir) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAppDocuments", appDir);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "apps to be uploaded: " + this.appsIncluded);
        }
        VariableMap oldMap = this.getVarMap(this.backupRoot + "/base", this.cellName, this.nodeName);
        File a = new File(appDir);
        if (!a.exists()) {
            return;
        }
        File[] apps = a.listFiles();
        if (apps == null) {
            return;
        }
        for (int i = 0; i < apps.length; ++i) {
            String appName = apps[i].getName();
            Vector paths = this.getDeploymentPaths(appDir + File.separator + appName + "/deployments");
            this.apps2path.put(appName, paths);
            if (this.appsIncluded.contains(appName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ".. uploading .." + appName);
                }
                if (oldMap == null) continue;
                String p1 = null;
                String p2 = null;
                for (int j = 0; j < paths.size(); ++j) {
                    try {
                        p1 = p2 = (String)paths.elementAt(j);
                        p1 = oldMap.expand(p1);
                        p2 = this.getVariableMap().expand(p2);
                        if (p1.equals(p2)) continue;
                        this.copyDocuments(p1, p2);
                        this.deleteDirs(p1);
                        continue;
                    }
                    catch (Throwable th) {
                        this.issueMessage("ADMU0122E", new Object[]{th, p1, p2}, null);
                        throw new AdminException(th);
                    }
                }
                continue;
            }
            this.deleteDirs(appDir + File.separator + appName);
            if (oldMap == null) continue;
            for (int j = 0; j < paths.size(); ++j) {
                try {
                    this.deleteDirs(oldMap.expand((String)paths.elementAt(j)));
                    continue;
                }
                catch (Throwable th) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Could not delete: " + oldMap.expand((String)paths.elementAt(j)));
                }
            }
        }
        oldMap = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAppDocuments");
        }
    }

    protected void emitNotification(String key, String msg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitNotification");
        }
        if (this.notificationService != null) {
            String ntfyType = null;
            ntfyType = key.equals("ADMU0001I") && !this.invokedFromMBean ? "websphere.addnode.starting" : (key.equals("ADMU0003I") ? "websphere.addnode.complete" : (key.equals("ADMU0211I") ? "websphere.addnode.failed" : "websphere.addnode.message"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification type is " + ntfyType);
            }
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{ntfyType, msg, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "emitNotification");
        }
    }

    protected void setupNodeAgentData(String cellname) throws Exception {
        this.setupServerRepository(cellname, "nodeagent");
    }

    protected Repository getNewLocalRepository(String server) throws Exception {
        return RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)this.newCellName, (String)this.nodeName, (String)server);
    }

    protected Repository getLocalRepository() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalRepository");
        }
        if (this.localRunTimeRepository == null) {
            Vector servers = this.getServerList();
            if (servers != null && servers.size() > 0) {
                this.setupServerRepository(this.cellName, (String)servers.elementAt(0));
            } else {
                this.setupServerRepository(this.cellName, "nodeagent");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalRepository");
        }
        return this.localRunTimeRepository;
    }

    protected VariableMap getVariableMap() throws Exception {
        Vector servers;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableMap");
        }
        if (this.map == null && (servers = this.getServerList()) != null && servers.size() > 0) {
            this.setupServerRepository(this.cellName, (String)servers.elementAt(0));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariableMap");
        }
        return this.map;
    }

    private void setupServerRepository(String cellname, String server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupServerRepository");
        }
        this.localRunTimeRepository = this.setupServerRepository(cellname, this.nodeName, server);
        this.map = VariableMapFactory.createVariableMap((Repository)this.localRunTimeRepository);
        this.map.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupServerRepository");
        }
    }

    private Repository setupServerRepository(String cellname, String node, String server) throws Exception {
        return RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)cellname, (String)node, (String)server);
    }

    protected int launchNodeAgent() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchNodeAgent");
        }
        int status = 0;
        try {
            LaunchCommand launcher2 = null;
            ServerIdentifiers sid = new ServerIdentifiers();
            sid.setConfigRoot(this.configRoot);
            sid.setCellName(this.newCellName);
            sid.setNodeName(this.nodeName);
            sid.setServerName("nodeagent");
            this.issueMessage("ADMU0020I", new Object[]{sid.getServerName()}, null);
            launcher2 = this.isZOS() ? new LaunchCommand(this.getNewLocalRepository("nodeagent"), this.getVariableMap(), sid) : new LaunchCommand(this.getLocalRepository(), this.getVariableMap(), sid);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Launching a new server process: " + sid.getServerName());
            }
            status = System.getProperty("os.name").equals("OS/400") ? this.launchNodeAgentOnOS400() : this.launchNodeAgentNotOnOS400(launcher2);
        }
        catch (Exception e) {
            Tr.error(tc, "ADMU0114E", e);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchNodeAgent", status);
        }
        return status;
    }

    private int launchNodeAgentOnOS400() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchNodeAgentOnOS400");
        }
        String cmd = "";
        if (System.getenv("PROFILE_CONFIG_ACTION") != null && System.getenv("PROFILE_CONFIG_ACTION").equalsIgnoreCase("true") && System.getenv("WAS_USER_SCRIPT") != null) {
            cmd = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "startServer nodeagent";
        } else {
            String instanceName = System.getProperty("instance.name");
            cmd = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "startServer -profileName " + instanceName + " " + "nodeagent";
        }
        if (this.nowait) {
            cmd = cmd + " -nowait";
        }
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(cmd);
        if (!this.nowait) {
            p.waitFor();
            this.issueMessage("ADMU0022I", null, null);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream(), "cp037"));
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream(), "cp037"));
            boolean succeeded = false;
            String jobId = null;
            String line = null;
            while ((line = in.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, line);
                }
                if (line.indexOf("CPC1221") != -1) {
                    jobId = line.substring(13, 38);
                }
                if (line.indexOf("CWNATV01I") == -1) continue;
                succeeded = true;
                break;
            }
            while (!succeeded && (line = err.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, line);
                }
                if (line.indexOf("CPC1221") != -1) {
                    jobId = line.substring(13, 38);
                }
                if (line.indexOf("CWNATV01I") == -1) continue;
                succeeded = true;
                break;
            }
            if (succeeded) {
                this.issueMessage("ADMU0030I", new Object[]{jobId}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{jobId}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "launchNodeAgentOnOS400");
        }
        return 0;
    }

    private int launchNodeAgentNotOnOS400(LaunchCommand launcher2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "launchNodeAgentNotOnOS400");
        }
        int status = 0;
        if (!this.nowait) {
            launcher2.setStatusSocketPort(this.getStatusPort());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "status socket = " + this.getStatusPort().toString());
            }
        }
        com.ibm.ws.process.Process p = launcher2.launchProcess();
        if (!this.nowait) {
            this.issueMessage("ADMU0022I", null, null);
            if (!this.isZOS()) {
                new ProcessWatcher(p);
            }
            if ((status = this.waitForServerInit()) == 0) {
                this.issueMessage("ADMU0030I", new Object[]{p.id()}, null);
            } else {
                this.issueMessage("ADMU0031E", new Object[]{p.id()}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "launchNodeAgentNotOnOS400", status);
        }
        return status;
    }

    private int waitForServerInit() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForServerInit");
        }
        Socket acceptedSocket = null;
        boolean statusReceived = false;
        boolean timedOut = false;
        int result = 0;
        while (!statusReceived && !timedOut) {
            try {
                acceptedSocket = this.getStatusSocket().accept();
            }
            catch (InterruptedIOException e) {
                acceptedSocket = null;
                timedOut = true;
            }
            catch (IOException ioe) {
                Tr.error(tc, "ADMU0023E", ioe);
                acceptedSocket = null;
                statusReceived = true;
                result = -1;
            }
            if (acceptedSocket == null) continue;
            result = this.getStatus(acceptedSocket);
            if (result == 0 || result == 0 || result == -1) {
                statusReceived = true;
                continue;
            }
            if (result != 2) continue;
            this.issueMessage("ADMU3220I", null, null);
        }
        if (!statusReceived) {
            result = -2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForServerInit", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int getStatus(Socket s) {
        FilterInputStream dataInput;
        InputStream socketInput;
        int status;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getStatus");
            }
            status = -1;
            socketInput = null;
            dataInput = null;
            socketInput = s.getInputStream();
            dataInput = new DataInputStream(socketInput);
            status = ((DataInputStream)dataInput).readInt();
            Object var8_5 = null;
            try {
                dataInput.close();
                socketInput.close();
                break block10;
            }
            catch (IOException e2) {
                Tr.error(tc, "ADMU0023E", e2);
            }
            {
                break block10;
                catch (IOException e) {
                    Tr.error(tc, "ADMU0023E", e);
                    int n = -1;
                    Object var8_6 = null;
                    try {
                        dataInput.close();
                        socketInput.close();
                    }
                    catch (IOException e2) {
                        Tr.error(tc, "ADMU0023E", e2);
                    }
                    dataInput = null;
                    socketInput = null;
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    dataInput.close();
                    socketInput.close();
                }
                catch (IOException e2) {
                    Tr.error(tc, "ADMU0023E", e2);
                }
                dataInput = null;
                socketInput = null;
                throw throwable;
            }
        }
        dataInput = null;
        socketInput = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", status);
        }
        return status;
    }

    private String getDCSHostName(ServerEntry s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDCSHostName");
        }
        String strDcsHostName = null;
        EList endpoints = s.getSpecialEndpoints();
        for (NamedEndPoint nep : endpoints) {
            if (!nep.getEndPointName().equals("DCS_UNICAST_ADDRESS")) continue;
            strDcsHostName = nep.getEndPoint().getHost();
            return strDcsHostName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDCSHostName", strDcsHostName);
        }
        return strDcsHostName;
    }

    private void addToServerIndex(String nodeAgent) throws Exception {
        ConfigRoot cfgRoot;
        Resource r;
        ServerIndex doc;
        String hostname;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToServerIndex");
        }
        if ((hostname = (doc = (ServerIndex)(r = (cfgRoot = this.getLocalRepository().getConfigRoot()).getResource(3, "serverindex.xml")).getContents().get(0)).getHostName()) == null || hostname.length() < 1) {
            hostname = AdminHelper.getInstance().getHostName();
            doc.setHostName(hostname);
        }
        this.throwExceptionIfCellMgrCannotPing(hostname);
        ServerindexPackage ipkg = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        this.indexFactory = ipkg.getServerindexFactory();
        IpcPackage ipcpkg = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcpkg.getIpcFactory();
        EList servers = doc.getServerEntries();
        ArrayList jmsQueues = new ArrayList();
        List adminHostPorts = this.getAdminHostPorts();
        for (int i = 0; i < servers.size(); ++i) {
            ServerEntry s = (ServerEntry)servers.get(i);
            if (AdminHelper.getPlatformHelper().isZOS() && this.dcsHostName == null) {
                this.dcsHostName = this.getDCSHostName(s);
            }
            String servername = s.getServerName();
            this.adjustServerConfig(servername, jmsQueues, adminHostPorts);
            this.addOrRemoveAppsForServer(s);
        }
        ServerEntry entry = this.indexFactory.createServerEntry();
        entry.setServerName(nodeAgent);
        entry.setServerDisplayName(nodeAgent);
        entry.setServerType("NODE_AGENT");
        String[] configRoots = this.getConfigRoots();
        PortConflictResolver pcr = new PortConflictResolver(configRoots);
        this.updateAppServerPorts(doc, nodeAgent, pcr);
        if (this.startingPort == null) {
            this.naConfigBuilder.addNodeAgentEndpoints(doc, entry, this.indexFactory, pcr, this.dcsHostName);
        } else {
            this.startingPort = new Integer(this.naConfigBuilder.addNodeAgentEndpointsUsingStartingPort(doc, entry, this.indexFactory, this.startingPort, this.dcsHostName));
        }
        doc.getServerEntries().add(entry);
        this.setORBLAandBOOTSTRAP_ADDRESS_toSameValue(doc);
        r.save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToServerIndex");
        }
    }

    private List getAdminHostPorts() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminHostPorts");
        }
        ArrayList<String> adminHostPorts = new ArrayList<String>();
        this._adminHosts = new ArrayList();
        this._adminPorts = new ArrayList();
        Resource r = this.getLocalRepository().getConfigRoot().getResource(0, "virtualhosts.xml");
        EList vhExtent = r.getContents();
        for (int i = 0; i < vhExtent.size(); ++i) {
            Object res = vhExtent.get(i);
            if (!(vhExtent.get(i) instanceof VirtualHost)) continue;
            VirtualHost vh = (VirtualHost)res;
            if (vh.getName().equals("admin_host")) {
                Iterator iter = vh.getAliases().iterator();
                while (iter.hasNext()) {
                    adminHostPorts.add(((HostAlias)iter.next()).getPort());
                }
                continue;
            }
            if (!vh.getName().equals("default_host")) continue;
            for (HostAlias hostAlias : vh.getAliases()) {
                this._adminHosts.add(hostAlias.getHostname());
                this._adminPorts.add(hostAlias.getPort());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminHostPorts", adminHostPorts.toArray().toString());
        }
        return adminHostPorts;
    }

    private String[] getConfigRoots2() throws WSProfileException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoots");
        }
        String[] configRoots = null;
        File registryFile = WSProfile.getRegistryFile();
        Tr.debug(tc, "Using profile registry: " + registryFile);
        List profiles = WSProfile.listProfileNames(registryFile);
        configRoots = new String[profiles.size()];
        int curProfile = 0;
        for (String profileName : profiles) {
            Tr.debug(tc, "Found profile: " + profileName);
            File profileLoc = WSProfile.getProfileLocation(profileName, registryFile);
            Tr.debug(tc, "   Profile location: " + profileLoc);
            configRoots[curProfile++] = profileLoc.getAbsolutePath() + "/config";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRoots", configRoots.toString());
        }
        return configRoots;
    }

    private String[] getConfigRoots() throws WSProfileException {
        String[] wsLocations;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoots");
        }
        if ((wsLocations = this.getAllWASLocations()) == null || wsLocations.length == 0) {
            return this.getConfigRoots2();
        }
        Vector vConfigRootLocations = new Vector();
        for (int locIndex = 0; locIndex < wsLocations.length; ++locIndex) {
            this.getAllConfigLocations(vConfigRootLocations, wsLocations[locIndex]);
        }
        String[] configRoots = new String[vConfigRootLocations.size()];
        for (int i = 0; i < vConfigRootLocations.size(); ++i) {
            configRoots[i] = (String)vConfigRootLocations.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoots", configRoots.toString());
        }
        return configRoots;
    }

    private String[] getAllWASLocations() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllWASLocations");
        }
        WASSystem aSys = null;
        try {
            aSys = WASSystem.getWASSystemInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAllWASLocations");
            }
            return aSys.getWASLocations();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Vector getAllConfigLocations(Vector container2, String sWASHome) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAllConfigLocations with container " + container2.toString() + " was home as " + sWASHome);
            }
            if (sWASHome == null) {
                return container2;
            }
            if (container2 == null) {
                container2 = new Vector<String>();
            }
            try {
                File registryFile = WSProfile.getRegistryFile(sWASHome);
                if (registryFile != null && registryFile.exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing profile registry: " + registryFile.getAbsolutePath());
                    }
                    List profileList = WSProfile.getProfileList(registryFile);
                    for (Profile profile : profileList) {
                        String profileHome = profile.getPath().getAbsolutePath();
                        String configRoot = NodeFederationUtility.getConfigRootFromProfileHome(profileHome);
                        if (configRoot == null) continue;
                        container2.addElement(configRoot);
                    }
                }
            }
            catch (WSProfileException wspe) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Error reading profile registry: " + wspe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllConfigLocations", container2.toString());
        }
        return container2;
    }

    private int getPortValueFromEndPoints(List endpoints, String portName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortValueFromEndPoints", portName);
        }
        int thePort = -1;
        for (NamedEndPoint ep : endpoints) {
            if (!ep.getEndPointName().equals(portName)) continue;
            thePort = ep.getEndPoint().getPort();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortValueFromEndPoints", thePort);
        }
        return thePort;
    }

    private void setPortValue(List endpoints, String portName, int portValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPortValue");
        }
        for (NamedEndPoint ep : endpoints) {
            if (!ep.getEndPointName().equals(portName)) continue;
            ep.getEndPoint().setPort(portValue);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPortValue");
        }
    }

    private void setORBLAandBOOTSTRAP_ADDRESS_toSameValue(ServerIndex serverIndex) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setORBLAandBOORSTRAP_ADDRESS_toSameValue");
        }
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isZOS = true, setORBLAandBOOTSTRAP_ADDRESS_toSameValue entry");
        }
        int bootStrapPort = -1;
        int orbListenerPort = -1;
        EList servers = serverIndex.getServerEntries();
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            EList endpoints = ((ServerEntry)i.next()).getSpecialEndpoints();
            bootStrapPort = this.getPortValueFromEndPoints(endpoints, "BOOTSTRAP_ADDRESS");
            orbListenerPort = this.getPortValueFromEndPoints(endpoints, "ORB_LISTENER_ADDRESS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "orbListenerPort = " + orbListenerPort + "bootstrapPort = " + bootStrapPort);
            }
            if (bootStrapPort == orbListenerPort) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "orbListenerPort and bootstrapPort is same, no need to set");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting ORB_LISTENER_ADDRESS to bootStrapPort");
            }
            this.setPortValue(endpoints, "ORB_LISTENER_ADDRESS", bootStrapPort);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setORBLAandBOORSTRAP_ADDRESS_toSameValue");
        }
    }

    private void updateAppServerPorts(ServerIndex serverIndex, String nodeAgent, PortConflictResolver pcr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAppServerPorts");
        }
        EList servers = serverIndex.getServerEntries();
        if (this.givenAppserverBootstrapPort == null) {
            this.replace2809InAppServerPorts(servers, nodeAgent, pcr);
        } else {
            this.replaceBootstrapInAppServerPorts(servers, nodeAgent, pcr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAppServerPorts");
        }
    }

    private void replace2809InAppServerPorts(List servers, String nodeAgent, PortConflictResolver pcr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replace2809InAppServerPorts");
        }
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            EList endpoints = ((ServerEntry)i.next()).getSpecialEndpoints();
            for (NamedEndPoint ep : endpoints) {
                int oldPort;
                if (!ep.getEndPointName().equals("BOOTSTRAP_ADDRESS") || (oldPort = ep.getEndPoint().getPort()) != 2809) continue;
                int newBootstrapPort = Utils.resolvePort(9810, pcr);
                this.replacePort(ep, newBootstrapPort, pcr);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replace2809InAppServerPorts");
        }
    }

    private void replaceBootstrapInAppServerPorts(List servers, String nodeAgent, PortConflictResolver pcr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceBootstrapInAppServerPorts");
        }
        boolean givenAppserverBootstrapPortUsed = false;
        int newBootstrapPort = this.givenAppserverBootstrapPort;
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            EList endpoints = ((ServerEntry)i.next()).getSpecialEndpoints();
            for (NamedEndPoint ep : endpoints) {
                if (!ep.getEndPointName().equals("BOOTSTRAP_ADDRESS")) continue;
                if (givenAppserverBootstrapPortUsed) {
                    newBootstrapPort = Utils.resolvePort(newBootstrapPort, pcr);
                }
                this.replacePort(ep, newBootstrapPort, pcr);
                givenAppserverBootstrapPortUsed = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceBootstrapInAppServerPorts");
        }
    }

    private void replacePort(NamedEndPoint ep, int newPort, PortConflictResolver pcr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replacePort");
        }
        int oldPort = ep.getEndPoint().getPort();
        ep.getEndPoint().setPort(newPort);
        pcr.reservePort(newPort);
        pcr.unreservePort(oldPort);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replacePort");
        }
    }

    private void issueWarningsIfAny(Collection c, String warning) {
        if (c != null && !c.isEmpty()) {
            int len = 0;
            String nl = "\n";
            String[] msgs = (String[])c.toArray();
            for (int i = 0; i < msgs.length; ++i) {
                len += msgs[i].length();
                len += nl.length();
            }
            len = (len + 256) / 256 * 256;
            StringBuffer buffer = new StringBuffer(len);
            for (int i = 0; i < msgs.length; ++i) {
                String s = msgs[i];
                buffer.append(nl);
                if (s.length() > 0) {
                    buffer.append(s);
                    continue;
                }
                buffer.append("Warning message missing?");
            }
            String count = "" + msgs.length;
            this.issueMessage(warning, new Object[]{count, this.nodeName, this.nodeGroupName, buffer.toString()}, null);
        }
    }

    private void addOrRemoveAppsForServer(ServerEntry s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOrRemoveAppsForServer");
        }
        EList apps = s.getDeployedApplications();
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove all apps");
            }
            while (apps.size() > 0) {
                apps.remove(0);
            }
        } else {
            for (int j = 0; j < apps.size(); ++j) {
                String longName = (String)apps.get(j);
                if (longName.startsWith("adminconsole.ear")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "... skip .. " + longName);
                    }
                    apps.remove(longName);
                    --j;
                    continue;
                }
                String appName = longName.substring(0, longName.indexOf(47));
                try {
                    boolean exists;
                    String docURI = "cells/" + this.newCellName + "/applications/" + longName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for " + docURI + " in " + this.configRepositoryClient);
                    }
                    String[] result = this.configRepositoryClient.listResourceNames(docURI, 1, 1);
                    Tr.debug(tc, "result.length = " + result.length);
                    boolean bl = exists = result.length == 1;
                    if (exists) {
                        this.issueMessage("ADMU0120I", new Object[]{appName}, null);
                        apps.remove(longName);
                        --j;
                        continue;
                    }
                    this.appsIncluded.add(appName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "... include app: " + appName);
                    continue;
                }
                catch (Throwable th) {
                    this.issueMessage("ADMU0121E", new Object[]{th, appName}, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOrRemoveAppsForServer");
        }
    }

    private void throwExceptionIfCellMgrCannotPing(String hostName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwExceptionIfCellMgrCannotPing");
        }
        if (this.isZOS()) {
            this.throwExceptionIfCellMgrCannotPing_1(hostName);
        } else {
            String ipAddress = (String)this.adminClient.invoke(this.getMBeanByType("JVM"), "getIPAddress", new Object[]{hostName}, new String[]{"java.lang.String"});
            String ipLocalAddress = InetAddress.getByName(hostName).getHostAddress();
            if (ipAddress == null || !ipAddress.equals(ipLocalAddress)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JVM->getIPAddress->ipAddress: " + ipAddress);
                    Tr.debug(tc, "IP local address is " + ipLocalAddress);
                }
                throw new AdminException(this.getFormattedMessage("ADMU0036E", new Object[]{hostName, ipLocalAddress}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwExceptionIfCellMgrCannotPing");
        }
    }

    private void throwExceptionIfCellMgrCannotPing_1(String hostName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwExceptionIfCellMgrCannotPing_1");
        }
        String localHost = null;
        String ipAddress = (String)this.adminClient.invoke(this.getMBeanByType("JVM"), "getIPAddress", new Object[]{hostName}, new String[]{"java.lang.String"});
        InetAddress[] ipAddresses = InetAddress.getAllByName(hostName);
        for (int i = 0; i < ipAddresses.length; ++i) {
            localHost = ipAddresses[i].getHostAddress();
            if (ipAddress == null || !ipAddress.equals(localHost)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "throwExceptionIfCellMgrCannotPing_1");
            }
            return;
        }
        throw new AdminException(this.getFormattedMessage("ADMU0036E", new Object[]{hostName, InetAddress.getByName(hostName).getHostAddress()}, null));
    }

    private void throwExceptionIfNodeCannotPingCellMgr() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwExceptionIfNodeCannotPingCellMgr");
        }
        List nodes = this.getNewNodes();
        String node2 = null;
        String hostname = null;
        for (String node2 : nodes) {
            hostname = this.getDmgrHostName(node2);
            if (hostname == null || hostname.length() == 0) continue;
            try {
                InetAddress.getByName(hostname);
                break;
            }
            catch (Exception e) {
                this.issueMessage("ADMU0037E", new Object[]{hostname}, null);
                throw new AdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwExceptionIfNodeCannotPingCellMgr");
        }
    }

    private String getDmgrHostName(String node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDmgrHostName");
        }
        String hostname = null;
        Repository myRepository = this.setupServerRepository(this.newCellName, node, null);
        ConfigRoot cfgRoot = myRepository.getConfigRoot();
        Resource r = cfgRoot.getResource(3, "serverindex.xml");
        EList serverindexExtent = r.getContents();
        ServerIndex doc = null;
        block0: for (int i = 0; i < serverindexExtent.size(); ++i) {
            doc = (ServerIndex)r.getContents().get(i);
            EList servers = doc.getServerEntries();
            for (int j = 0; j < servers.size(); ++j) {
                ServerEntry s = (ServerEntry)servers.get(j);
                String type = s.getServerType();
                if (type.equals("DEPLOYMENT_MANAGER")) break block0;
            }
            doc = null;
        }
        if (doc != null) {
            hostname = doc.getHostName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDmgrHostName", hostname);
        }
        return hostname;
    }

    protected List getNewNodes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewNodes");
        }
        ArrayList<String> nodeList = new ArrayList<String>();
        String sdir = this.configRoot + "/cells/" + this.newCellName + "/nodes";
        File serverContexts = new File(sdir);
        File[] nodes = serverContexts.listFiles();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                String n;
                if (!nodes[i].isDirectory() || (n = nodes[i].getName()).equals(this.nodeName)) continue;
                nodeList.add(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewNodes", nodeList.toArray().toString());
        }
        return nodeList;
    }

    private void showNextTasks() {
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU0302I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU0303I", new Object[]{this.newCellName}, null);
        if (!this.includeapps) {
            this.printLineSeparator(null);
            this.issueMessage("ADMU0306I", null, null);
            this.issueMessage("ADMU0304I", null, null);
            this.issueMessage("ADMU0307I", null, null);
            this.issueMessage("ADMU0305I", new Object[]{this.newCellName}, null);
        }
        this.printLineSeparator(null);
        this.issueMessage("ADMU0003I", new Object[]{this.nodeName}, null);
    }

    private void adjustServerConfig(String servername, List jmsServerQueueNames, List adminHostPorts) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustServerConfig");
        }
        if (jmsServerQueueNames == null) {
            jmsServerQueueNames = new ArrayList<String>();
        }
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        String oldServer = cfgRoot.getValue(4);
        cfgRoot.setValue(4, servername);
        Resource r = cfgRoot.getResource(4, "server.xml");
        cfgRoot.setValue(4, oldServer);
        ServiceContext rootObj = null;
        EList serverExtent = r.getContents();
        for (int i = 0; i < serverExtent.size(); ++i) {
            Object res = serverExtent.get(i);
            if (!(res instanceof Server)) continue;
            rootObj = (Server)res;
            break;
        }
        if (rootObj != null) {
            int c;
            EList services = rootObj.getServices();
            for (int i = 0; i < services.size(); ++i) {
                Service s = (Service)services.get(i);
                if (s instanceof AdminService) {
                    AdminService a = (AdminService)s;
                    a.setStandalone(false);
                    continue;
                }
                if (!(s instanceof TransportChannelService)) continue;
                TransportChannelService tps = (TransportChannelService)s;
                EList chains = tps.getChains();
                for (c = 0; c < chains.size(); ++c) {
                    Chain chain = (Chain)chains.get(c);
                    if (chain == null || chain.getTransportChannels().isEmpty()) continue;
                    TransportChannel first = (TransportChannel)chain.getTransportChannels().get(0);
                    TransportChannel last = (TransportChannel)chain.getTransportChannels().get(chain.getTransportChannels().size() - 1);
                    if (!(first instanceof TCPInboundChannel) || !(last instanceof WebContainerInboundChannel) || !this.isBoundToAdminPort((TCPInboundChannel)first, servername, adminHostPorts)) continue;
                    chain.setEnable(false);
                }
            }
            EList components = rootObj.getComponents();
            for (int i = 0; i < components.size(); ++i) {
                Component s = (Component)components.get(i);
                if (s instanceof JMSServer) {
                    JMSServer j = (JMSServer)s;
                    EList queueNames = j.getQueueNames();
                    for (int q = 0; q < queueNames.size(); ++q) {
                        String qName = (String)queueNames.get(q);
                        if (jmsServerQueueNames.contains(qName)) continue;
                        jmsServerQueueNames.add(qName);
                    }
                    components.remove(s);
                    break;
                }
                if (!(s instanceof ApplicationServer) || this.isZOS()) continue;
                EList containers = s.getComponents();
                for (c = 0; c < containers.size(); ++c) {
                    Component container2 = (Component)containers.get(c);
                    if (!(container2 instanceof WebContainer)) continue;
                    WebContainer webContainer = (WebContainer)container2;
                    EList transports = webContainer.getTransports();
                    for (int t = 0; t < transports.size(); ++t) {
                        HTTPTransport tran = (HTTPTransport)transports.get(t);
                        if (!this.isInList(new Integer(tran.getAddress().getPort()).toString(), adminHostPorts)) continue;
                        transports.remove(t);
                        --t;
                    }
                }
            }
        }
        r.save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustServerConfig");
        }
    }

    private boolean isBoundToAdminPort(TCPInboundChannel channel, String serverName, List adminPorts) throws Exception {
        ServerEntry entry;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isBoundToAdminPort");
        }
        if ((entry = this.getServerEntry(serverName)) == null) {
            return false;
        }
        EndPoint endPoint = this.getEndPointByName(entry, channel.getEndPointName());
        if (entry == null) {
            return false;
        }
        return this.isInList(String.valueOf(endPoint.getPort()), adminPorts);
    }

    private EndPoint getEndPointByName(ServerEntry entry, String endPointName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEndPointByName", endPointName);
        }
        if (endPointName == null) {
            return null;
        }
        EList endPoints = entry.getSpecialEndpoints();
        for (int i = 0; i < endPoints.size(); ++i) {
            NamedEndPoint namedEndPoint;
            Object current = endPoints.get(i);
            if (!(current instanceof NamedEndPoint) || !endPointName.equals((namedEndPoint = (NamedEndPoint)current).getEndPointName())) continue;
            return namedEndPoint.getEndPoint();
        }
        return null;
    }

    private ServerEntry getServerEntry(String serverName) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerEntry", serverName);
        }
        if (serverName == null) {
            return null;
        }
        ConfigRoot root = this.getLocalRepository().getConfigRoot();
        Resource r = root.getResource(3, "serverindex.xml");
        EList extent = r.getContents();
        if (extent == null || extent.isEmpty() || !(extent.get(0) instanceof ServerIndex)) {
            return null;
        }
        ServerIndex index = (ServerIndex)extent.get(0);
        extent = index.getServerEntries();
        for (int i = 0; i < extent.size(); ++i) {
            ServerEntry entry;
            Object current = extent.get(i);
            if (!(current instanceof ServerEntry) || !serverName.equals((entry = (ServerEntry)current).getServerName())) continue;
            return entry;
        }
        return null;
    }

    private boolean isInList(String val, List list) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isInList value is " + val + " list is " + list.toArray().toString());
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(val)) continue;
            return true;
        }
        return false;
    }

    private String copyToServer(File file, String targetName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToServer", new Object[]{file, targetName});
        }
        AdminClient dmgrClient = this.getAdminClient();
        dmgrClient.getConnectorProperties();
        FileTransferClient transfer = FileTransferFactory.getFileTransferClient((AdminClient)dmgrClient);
        String stagingDir = transfer.getServerStagingLocation();
        FileTransferOptions options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        options.setDeleteSourceOnCompletion(true);
        transfer.uploadFile(file, targetName, options);
        String ret = stagingDir + targetName;
        ret = ret.replace('\\', '/');
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer", ret);
        }
        return ret;
    }

    protected void collectNodeMetadata(AdminClient adminClient) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "collectNodeMetadata");
            }
            try {
                Properties _collectorMgrProps = this.getClientProperties();
                _collectorMgrProps.setProperty("local.cell", _collectorMgrProps.getProperty("cellName"));
                _collectorMgrProps.setProperty("local.node", _collectorMgrProps.getProperty("nodeName"));
                _collectorMgrProps.setProperty("was.repository.root", this.configRoot);
                ManagedObjectMetadataCollectorManager collectorMgr = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(_collectorMgrProps, adminClient);
                Properties metadata2 = collectorMgr.updateMetadata("Collect Metadata", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "metadata is " + metadata2.toString());
                }
            }
            catch (Throwable t) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Could not run local metadata collection.", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectNodeMetadata");
        }
    }

    protected void warnForLocalOS() throws Exception {
        ConfigRoot cfgRoot;
        Resource res;
        ServerIndex doc;
        String nodeHostName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "warnForLocalOS");
        }
        if ((nodeHostName = (doc = (ServerIndex)(res = (cfgRoot = this.getLocalRepository().getConfigRoot()).getResource(3, "serverindex.xml")).getContents().get(0)).getHostName()) == null || nodeHostName.length() < 1) {
            nodeHostName = AdminHelper.getInstance().getHostName();
            doc.setHostName(nodeHostName);
        }
        Boolean isZOS = AdminHelper.getPlatformHelper().isZOS();
        ObjectName secAdmin = this.getMBeanByType("SecurityAdmin");
        if (secAdmin == null) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Going to call security mbean, isZOS: " + isZOS + ", nodeHostName: " + nodeHostName);
        }
        List returnList = null;
        MBeanInfo info = this.adminClient.getMBeanInfo(secAdmin);
        MBeanOperationInfo[] opinfos = info.getOperations();
        for (int j = 0; j < opinfos.length; ++j) {
            if (!opinfos[j].getName().equals("warnForLocalOS")) continue;
            returnList = (List)this.invokeMBean(secAdmin, "warnForLocalOS", new Object[]{isZOS, nodeHostName}, new String[]{"java.lang.Boolean", "java.lang.String"});
            break;
        }
        if (returnList != null && returnList.size() > 0 && returnList.get(0) != null && ((Boolean)returnList.get(0)).booleanValue()) {
            if (returnList.size() > 1 && returnList.get(1) != null) {
                this.issueMessage("ADMU2037W", new Object[]{nodeHostName, (String)returnList.get(1)}, null);
            } else {
                this.issueMessage("ADMU2037W", new Object[]{nodeHostName, this.connHost}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "warnForLocalOS");
        }
    }

    private void checkIfNodeRegisteredToAdminAgent() throws Exception {
        Resource profileCellResource;
        Cell profileCell;
        boolean isRegistered;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfNodeRegisteredToAdminAgent");
        }
        if (isRegistered = (profileCell = (Cell)(profileCellResource = this.getLocalRepository().getConfigRoot().getResource(0, "cell.xml")).getContents().get(0)).isCellRegistered()) {
            throw new AdminException(this.getFormattedMessage("ADMU0043E", new Object[0], "Error trying to federate a node that is still registered to an AdminAgent."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfNodeRegisteredToAdminAgent" + isRegistered);
        }
    }

    protected void getNodeConfigRepository() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeConfigRepository: " + this.nodeConfigRepository);
        }
        if (this.nodeConfigRepository != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nodeConfigRepository");
            }
            return;
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "configRoot: " + this.configRoot);
            }
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "get system property for local.cell : " + System.getProperty("local.cell"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "set system property for local.cell to cellName of node (base app server): " + this.cellName);
            }
            System.setProperty("local.cell", this.cellName);
            this.nodeConfigRepository = ConfigRepositoryFactory.getConfigRepository();
            if (this.nodeConfigRepository != null) {
                this.nodeConfigRepository.initialize(this.clientProps);
            } else {
                ConfigRepositoryFactory.createConfigRepository((boolean)true).initialize(this.clientProps);
            }
        }
        catch (AdminException ae) {
            Tr.error(tc, "ADMU0005E", ae);
            throw ae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeConfigRepository: " + this.nodeConfigRepository);
        }
    }

    private void getCommonAssets(AssetFactory assetFact) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommonAssets");
        }
        this.getNodeConfigRepository();
        List assetSpecs = assetFact.listAssetSpecs(new AssetSpec("__ibm__repoctx__all__"), this.nodeConfigRepository);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "assetSpecs: ", assetSpecs);
        }
        for (AssetSpec assetSpec : assetSpecs) {
            String assetName = assetSpec.getAssetName();
            String assetVer = assetSpec.getAssetVersion();
            String assetURI = "cells/" + this.newCellName + "/assets/" + assetName + "/aver/" + assetVer;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "assetURI: ", assetURI);
            }
            try {
                String[] assetResult = this.configRepositoryClient.listResourceNames(assetURI, 255, 1);
                Tr.debug(tc, "assetResult.length = " + assetResult.length);
                boolean assetExist = assetResult != null && assetResult.length > 0;
                if (!assetExist) continue;
                this.issueMessage("ADMU0120I", new Object[]{assetName + " on ASSET"}, null);
                if (!this.skipAssets.contains(assetSpec)) {
                    this.skipAssets.add(assetSpec);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "... exclude asset: " + assetSpec);
            }
            catch (Throwable th) {
                this.issueMessage("ADMU0121E", new Object[]{th, assetName}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommonAssets: " + this.skipAssets);
        }
    }

    private void getCommonCUs(CompositionUnitFactory cuFact) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommonCUs");
        }
        this.getNodeConfigRepository();
        List cuSpecs = cuFact.listCompositionUnitSpecs(new CompositionUnitSpec("__ibm__repoctx__all__"), this.nodeConfigRepository);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cuSpecs: ", cuSpecs);
        }
        for (CompositionUnitSpec cuSpec : cuSpecs) {
            String cuName = cuSpec.getCUName();
            String cuVer = cuSpec.getCUVersion();
            String cuURI = "cells/" + this.newCellName + "/cus/" + cuName + "/cver/" + cuVer;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cuURI: ", cuURI);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configRepositoryClient : " + this.configRepositoryClient);
                }
                String[] cuResult = this.configRepositoryClient.listResourceNames(cuURI, 255, 1);
                Tr.debug(tc, "cuResult.length = " + cuResult.length);
                boolean cuExist = cuResult != null && cuResult.length > 0;
                if (!cuExist) continue;
                this.issueMessage("ADMU0120I", new Object[]{cuName + " on CU"}, null);
                if (!this.skipCus.contains(cuSpec)) {
                    this.skipCus.add(cuSpec);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "... exclude cu: " + cuSpec);
            }
            catch (Throwable th) {
                this.issueMessage("ADMU0121E", new Object[]{th, cuSpec}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommonCUs: " + this.skipCus);
        }
    }

    private void getCommonBLAs(BLAFactory blaFact) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommonBLAs");
        }
        this.getNodeConfigRepository();
        List blaSpecs = blaFact.listBLASpecs(new BLASpec("__ibm__repoctx__all__"), this.nodeConfigRepository);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "blaSpecs: ", blaSpecs);
        }
        for (BLASpec blaSpec : blaSpecs) {
            String blaName = blaSpec.getBLAName();
            String blaVer = blaSpec.getBLAVersion();
            String blaURI = "cells/" + this.newCellName + "/blas/" + blaName + "/bver/" + blaVer;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "blaURI: ", blaURI);
            }
            try {
                String[] blaResult = this.configRepositoryClient.listResourceNames(blaURI, 255, 1);
                Tr.debug(tc, "blaResult.length = " + blaResult.length);
                boolean blaExist = blaResult != null && blaResult.length > 0;
                if (!blaExist) continue;
                this.issueMessage("ADMU0120I", new Object[]{blaName + " on BLA"}, null);
                if (!this.skipBlas.contains(blaSpec)) {
                    this.skipBlas.add(blaSpec);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "... exclude bla: " + blaSpec);
            }
            catch (Throwable th) {
                this.issueMessage("ADMU0121E", new Object[]{th, blaSpec}, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommonBLAs: " + this.skipBlas);
        }
    }

    private void getSkipsBLAsCusAssets() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSkipsBLAsCusAssets");
        }
        this.getNodeConfigRepository();
        AssetFactory assetFact = AssetFactory.getSingleton();
        this.getCommonAssets(assetFact);
        for (AssetSpec assetSpec : this.skipAssets) {
            Asset asset = assetFact.readAssetFromAssetSpec(assetSpec, this.nodeConfigRepository);
            List deployedCus = asset.getAssetRef().listDeployedCUs();
            this.skipCus.addAll(deployedCus);
        }
        CompositionUnitFactory cuFact = CompositionUnitFactory.getSingleton();
        this.getCommonCUs(cuFact);
        for (CompositionUnitSpec cuSpec : this.skipCus) {
            CompositionUnit cu = cuFact.readCompositionUnitFromCompositionUnitSpec(cuSpec, this.nodeConfigRepository);
            List blaSpecs = cu.getCURef().listParentBLAs();
            for (BLASpec blaSpec : blaSpecs) {
                if (this.skipBlas.contains(blaSpec)) continue;
                this.skipBlas.addAll(blaSpecs);
            }
        }
        BLAFactory blaFact = BLAFactory.getSingleton();
        this.getCommonBLAs(blaFact);
        for (BLASpec blaSpec : this.skipBlas) {
            BLA bla = blaFact.readBLAFromBLASpec(blaSpec, this.nodeConfigRepository);
            Iterator iter = bla.listCompositionUnits();
            while (iter.hasNext()) {
                CompositionUnitSpec cuspec = (CompositionUnitSpec)iter.next();
                if (this.skipCus.contains(cuspec)) continue;
                this.skipCus.add(cuspec);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "skipAssets: " + this.skipAssets);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "skipBlas: " + this.skipBlas);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "skipCus: " + this.skipCus);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSkipsBLAsCusAssets");
        }
    }

    private void deleteBLAs() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBLAs");
        }
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove all blas");
            }
            this.deleteDirs(this.blaDir);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove skip blas");
            }
            for (BLASpec blaSpec : this.skipBlas) {
                String bla = this.blaDir + File.separator + blaSpec.getBLAName() + File.separator + "bver" + File.separator + blaSpec.getBLAVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting bla " + bla);
                }
                this.deleteDirs(bla);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBLAs");
        }
    }

    private void deleteCUs() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteCUs");
        }
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove all cus");
            }
            this.deleteDirs(this.cuDir);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove skip cus");
            }
            for (CompositionUnitSpec cuSpec : this.skipCus) {
                String cu = this.cuDir + File.separator + cuSpec.getCUName() + File.separator + "cver" + File.separator + cuSpec.getCUVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting cu " + cu);
                }
                this.deleteDirs(cu);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteCUs");
        }
    }

    private void deleteAssets() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAssets");
        }
        if (!this.includeapps) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove all assets");
            }
            this.deleteDirs(this.assetDir);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove skip assets");
            }
            for (AssetSpec assetSpec : this.skipAssets) {
                String asset = this.assetDir + File.separator + assetSpec.getAssetName() + File.separator + "aver" + File.separator + assetSpec.getAssetVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting asset " + asset);
                }
                this.deleteDirs(asset);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAssets");
        }
    }

    public class ProcessWatcher
    extends Thread {
        com.ibm.ws.process.Process process;

        public ProcessWatcher(com.ibm.ws.process.Process process) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ProcessWather");
            }
            this.process = process;
            this.setDaemon(true);
            this.start();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ProcessWather");
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Socket soc = new Socket("localhost", NodeFederationUtility.this.getStatusSocket().getLocalPort());
                DataOutputStream dos = new DataOutputStream(soc.getOutputStream());
                dos.writeInt(-1);
                dos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }
}

