/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.util.Utils;
import com.ibm.wsspi.management.tools.DmgrSideExtensionChecker;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class KnownFeaturePacksChecker
implements DmgrSideExtensionChecker {
    private static final TraceComponent tc = Tr.register(KnownFeaturePacksChecker.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private ResourceBundle res = ResourceBundle.getBundle("com.ibm.ws.management.resources.adminservice", Locale.getDefault());

    public void checkCompatibility(Properties remoteNodeMetadataProp, Properties dmgrMetadataProp) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCompatibility");
        }
        Enumeration<Object> allkeys = remoteNodeMetadataProp.keys();
        while (allkeys.hasMoreElements()) {
            String k = (String)allkeys.nextElement();
            if (k.indexOf("webServicesFeaturePackProductVersion") <= 0 && k.indexOf("SOAFeaturePackProductVersion") <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + k);
            }
            String nodeVer = remoteNodeMetadataProp.getProperty(k);
            String dmgrVer = dmgrMetadataProp.getProperty(k);
            if (dmgrVer != null && dmgrVer.length() != 0 && Utils.compareVersions(dmgrVer, nodeVer) >= 0) continue;
            k = k.substring(0, k.indexOf("ProductVersion")) + "ProductShortName";
            String prodName = remoteNodeMetadataProp.getProperty(k);
            throw new AdminException(this.getFormattedMessage("ADMN1102E", new String[]{prodName, dmgrVer, nodeVer}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCompatibility");
        }
    }

    protected String getFormattedMessage(String key, Object[] args, String defaultString) {
        try {
            String result = this.res.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }
}

