/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitializer;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cell.CellType;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.tools.ExtensionChecker;
import com.ibm.wsspi.management.tools.NodeSideExtensionChecker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public abstract class AbstractNodeConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(AbstractNodeConfigUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    protected static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    protected String connType = "SOAP";
    protected String connHost = null;
    protected String connPort = null;
    protected AdminClient adminClient = null;
    protected ObjectName notificationService = null;
    protected Properties notificationUserData = null;
    protected String netmgrName = null;
    private ConfigServiceProxy configService = null;
    private WASProduct wasProduct = null;
    private Object addOrRemoveNodeToken = null;
    private boolean zos = false;
    private boolean zos_set = false;

    protected abstract VariableMap getVariableMap() throws Exception;

    protected abstract Repository getLocalRepository() throws Exception;

    protected void toolFailed() {
        try {
            this.completeAddOrRemoveNode();
        }
        catch (Exception exc) {
            this.issueMessage("ADMU0042E", null, null);
        }
    }

    protected boolean isMemberOfCell() throws Exception {
        Resource res = this.getResource("cells/" + this.cellName + "/cell.xml", "cell.xml");
        Cell cell = (Cell)res.getContents().get(0);
        return cell.getCellType().equals(CellType.DISTRIBUTED_LITERAL);
    }

    private Resource getResource(String uri, String fileName) throws Exception {
        ConfigRoot cfgRoot = this.getLocalRepository().getConfigRoot();
        Resource res = cfgRoot.getResource(0, fileName);
        return res;
    }

    protected Properties getClientProperties() throws Exception {
        Properties clientProps = new Properties();
        clientProps.setProperty("type", this.connType);
        clientProps.setProperty("host", this.connHost);
        clientProps.setProperty("port", this.connPort);
        clientProps.setProperty("nodeName", this.nodeName);
        clientProps.setProperty("cellName", this.cellName);
        clientProps.setProperty("was.install.root", System.getProperty("was.install.root"));
        clientProps.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
        clientProps.setProperty("location", "remote");
        if (this.userid != null) {
            clientProps.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            clientProps.setProperty("password", this.pwd);
        }
        return clientProps;
    }

    protected String getUserInstallRootIfSetElseGetWasInstallRoot() {
        return System.getProperty("user.install.root", System.getProperty("was.install.root"));
    }

    protected AdminClient getAdminClient(Properties connProps) throws Exception {
        AdminClient _admin = null;
        try {
            _admin = AdminClientFactory.createAdminClient(connProps);
        }
        catch (Exception e) {
            Tr.error(tc, "ADMU0006E", e);
            throw e;
        }
        return _admin;
    }

    protected ObjectName getMBeanByType(String type) throws Exception {
        return this.getMBeanByType(type, this.getNetmgrName());
    }

    protected ObjectName getMBeanByType(String type, String processName) throws Exception {
        if (this.adminClient == null) {
            return null;
        }
        ObjectName handle = null;
        try {
            Iterator iter;
            String queryStr = "WebSphere:*,process=" + processName + ",type=" + type;
            ObjectName queryName = new ObjectName(queryStr);
            Set s = this.adminClient.queryNames(queryName, null);
            if (s.size() != 1) {
                Tr.debug(tc, "There are " + s.size() + " " + type + "s!");
            }
            if ((iter = s.iterator()).hasNext()) {
                handle = (ObjectName)iter.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, type + " handle is ==> " + handle.getCanonicalName());
                }
            } else {
                Tr.warning(tc, "ADMU0008E", new Object[]{type, "No ObjectName found."});
            }
        }
        catch (Exception e) {
            Tr.error(tc, "ADMU0008E", new Object[]{type, e});
            throw e;
        }
        return handle;
    }

    protected Object invokeMBean(ObjectName mbean, String opName, Object[] params, String[] signature) throws Exception {
        Object result = null;
        if (mbean != null) {
            try {
                result = this.adminClient.invoke(mbean, opName, params, signature);
            }
            catch (Exception e) {
                Tr.error(tc, "ADMU0040E", new Object[]{mbean, opName, e});
                throw e;
            }
        }
        return result;
    }

    protected boolean beginAddOrRemoveNode() throws Exception {
        ObjectName adminOps = this.getMBeanByType("AdminOperations");
        if (adminOps != null) {
            String nodeVersion = Utils.getProductVersion();
            this.addOrRemoveNodeToken = this.invokeMBean(adminOps, "getTokenForNodeFederationOrRemoval", new Object[]{nodeVersion}, new String[]{"java.lang.String"});
            if (this.addOrRemoveNodeToken == null) {
                return false;
            }
        }
        return true;
    }

    protected void completeAddOrRemoveNode() throws Exception {
        ObjectName adminOps;
        if (this.addOrRemoveNodeToken != null && (adminOps = this.getMBeanByType("AdminOperations")) != null) {
            this.invokeMBean(adminOps, "completeNodeFederationOrRemoval", new Object[]{this.addOrRemoveNodeToken}, new String[]{"java.lang.Object"});
            this.addOrRemoveNodeToken = null;
        }
    }

    protected ObjectName getNotificationServiceMBean() throws Exception {
        String NTFY_MBEAN_NAME = "WebSphere:*,type=NotificationService,process=" + this.getNetmgrName();
        try {
            Set s = this.adminClient.queryNames(new ObjectName(NTFY_MBEAN_NAME), null);
            if (s.isEmpty()) {
                Tr.error(tc, "ADMU0008E", new Object[]{NTFY_MBEAN_NAME, "none"});
                return null;
            }
            this.notificationUserData = new Properties();
            this.notificationUserData.setProperty("nodeName", this.nodeName);
            return (ObjectName)s.iterator().next();
        }
        catch (Exception exc) {
            Tr.error(tc, "ADMU0008E", new Object[]{NTFY_MBEAN_NAME, exc});
            return null;
        }
    }

    protected void copyDocuments(String fromDirPath, String toDirPath) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.event(tc, "copyDocuments, fromDirPath=" + fromDirPath + ", toDirPath=" + toDirPath);
        }
        File fromDir = new File(fromDirPath);
        File toDir = new File(toDirPath);
        toDir.mkdirs();
        File[] files = fromDir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "In the source, file #" + i + ", " + files[i]);
            }
            if (files[i].isDirectory()) {
                if (tc.isDebugEnabled()) {
                    Tr.event(tc, "is a directory (will recurse)");
                }
                this.copyDocuments(fromDirPath + File.separator + files[i].getName(), toDirPath + File.separator + files[i].getName());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "is NOT a directory - createNewFile " + toDirPath + File.separator + files[i].getName());
            }
            File newFile = new File(toDirPath + File.separator + files[i].getName());
            this.copyDocument(files[i], newFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDocument(File from, File to) throws Exception {
        Object v1;
        if (from == null || to == null) {
            return;
        }
        BufferedInputStream in = null;
        OutputStream out = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(new FileInputStream(from));
            to.createNewFile();
            out = new BufferedOutputStream(new FileOutputStream(to));
            int MAXBYTES = 2048;
            byte[] data = new byte[MAXBYTES];
            while ((bytesRead = ((InputStream)in).read(data, 0, MAXBYTES)) != -1) {
                out.write(data, 0, bytesRead);
            }
            out.flush();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var9_9 = null;
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var11_13;
                v0 = var11_13 = null;
            }
            if (out != null) {
                out.close();
            }
            throw throwable;
        }
        try {
            if (in != null) {
                ((InputStream)in).close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var11_12;
            v1 = var11_12 = null;
        }
        if (out != null) {
            out.close();
        }
    }

    public void fix390SetupCmdLine(String sclFileName, String cellName) throws Exception {
        File sclFile = new File(sclFileName);
        String line = null;
        if (sclFile.exists()) {
            Vector<String> filecontent = new Vector<String>();
            FileInputStream fis = new FileInputStream(sclFileName);
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)fis, "Cp1047"));
            while ((line = rd.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line is " + line);
                }
                if (line != null && line.indexOf("WAS_CELL=") >= 0 && !line.startsWith("#")) {
                    line = line.substring(0, line.indexOf("=") + 1) + cellName;
                }
                filecontent.add(line);
            }
            rd.close();
            FileOutputStream fos = new FileOutputStream(sclFileName);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "Cp1047"));
            int sz = filecontent.size();
            for (int i = 0; i < sz; ++i) {
                pw.println((String)filecontent.get(i));
            }
            pw.flush();
            pw.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{sclFileName});
        }
    }

    protected void fixSetupCmdLine(String cellName, Properties p) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSetupCmdLine", new Object[]{cellName, DebugUtils.createPropertiesMaskPlainTextPassword((Properties)p)});
        }
        String os = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
        Tr.debug(tc, "LaunchScriptCollaborator: " + platform.getClass());
        String sclFilename = p.getProperty("user.install.root") + "/bin/setupCmdLine";
        sclFilename = platform.customizeScriptFilename(sclFilename);
        if (this.isZOS()) {
            this.fix390SetupCmdLine(sclFilename, cellName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fixSetupCmdLine");
            }
            return;
        }
        File sclFile = new File(sclFilename);
        if (sclFile.exists()) {
            Vector<String> filecontent = new Vector<String>();
            FileInputStream fis = new FileInputStream(sclFilename);
            BufferedReader rd = null;
            String readerEncoding = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned readerencoding = " + readerEncoding);
            }
            rd = new BufferedReader(new InputStreamReader((InputStream)fis, readerEncoding));
            String line = null;
            while ((line = rd.readLine()) != null) {
                if (line.indexOf("WAS_CELL=") >= 0) {
                    if (!line.startsWith(platform.getPlatformComment())) {
                        line = line.substring(0, line.indexOf("=") + 1) + cellName;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "modified WAS_CELL in setupCmdLine: " + line);
                        }
                    }
                } else if (line.indexOf("WAS_NODE=") >= 0 && !line.startsWith(platform.getPlatformComment())) {
                    line = line.substring(0, line.indexOf("=") + 1) + this.nodeName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modified WAS_NODE in setupCmdLine: " + line);
                    }
                }
                filecontent.add(line);
            }
            rd.close();
            FileOutputStream fos = new FileOutputStream(sclFilename);
            PrintWriter writer = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System.getProperty(\"file.encoding\") is: " + System.getProperty("file.encoding"));
            }
            String writerEncoding = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned writer encoding = " + writerEncoding);
            }
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)fos, writerEncoding));
            for (int i = 0; i < filecontent.size(); ++i) {
                line = (String)filecontent.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line", line);
                }
                writer.println((String)filecontent.get(i));
            }
            writer.flush();
            writer.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{sclFilename});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSetupCmdLine");
        }
    }

    protected void removeFromCell(AdminClient adminClient, boolean issueMsg) throws Exception {
        if (adminClient != null) {
            Properties nodeProperties = new Properties();
            nodeProperties.setProperty("CELL_NAME_KEY", this.cellName);
            nodeProperties.setProperty("NODE_NAME_KEY", this.nodeName);
            ObjectName adminOps = this.getMBeanByType("AdminOperations");
            if (adminOps != null) {
                this.invokeMBean(adminOps, "doUnMergeConfigDataOnDmgr", new Object[]{nodeProperties}, new String[]{"java.util.Properties"});
            }
            if (issueMsg) {
                this.issueMessage("ADMU2018I", new Object[]{this.nodeName}, null);
            }
        }
    }

    protected void removeFromCell(AdminClient adminClient) throws Exception {
        this.removeFromCell(adminClient, false);
    }

    protected ConfigServiceProxy getConfigService(AdminClient adminClient) throws Exception {
        if (this.configService == null) {
            this.configService = new ConfigServiceProxy(adminClient);
        }
        return this.configService;
    }

    protected void deleteDirs(String topdir) throws Exception {
        File topDir = new File(topdir);
        if (!topDir.exists()) {
            return;
        }
        File[] files = topDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirs(topdir + File.separator + files[i].getName());
                }
                files[i].delete();
            }
        }
        topDir.delete();
    }

    private Properties createPropsWithoutPlainTextPassword(Properties p1) {
        Properties p2 = new Properties(p1);
        String pwd = p2.getProperty("password");
        if (pwd != null) {
            p2.setProperty("password", "****");
        }
        return p2;
    }

    protected void fixWsadminProps(Properties clientProps) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixWsadminProps", this.createPropsWithoutPlainTextPassword(clientProps));
        }
        String os = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator platform = LaunchScriptCollaboratorFactory.getCollaborator(os);
        String filepath = null;
        String userRoot = System.getProperty("user.install.root");
        filepath = userRoot != null ? userRoot : clientProps.getProperty("was.install.root");
        File wsPropsFile = new File(filepath = filepath + "/properties/wsadmin.properties");
        if (wsPropsFile.exists()) {
            Vector filecontent = new Vector();
            RandomAccessFile wsapfile = new RandomAccessFile(wsPropsFile, "r");
            long pos = wsapfile.getFilePointer();
            while (pos < wsapfile.length()) {
                try {
                    this.fixWsadminLine(wsapfile.readLine(), clientProps, filecontent);
                }
                catch (EOFException x) {
                    break;
                }
                pos = wsapfile.getFilePointer();
            }
            wsapfile.close();
            FileWriter writer = new FileWriter(wsPropsFile);
            for (int i = 0; i < filecontent.size(); ++i) {
                writer.write((String)filecontent.get(i) + platform.getPlatformLineEnd());
            }
            writer.flush();
            writer.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixWsadminProps");
        }
    }

    private void fixWsadminLine(String line, Properties clientProps, Vector filecontent) throws IOException {
        if (line != null) {
            if (line.startsWith("com.ibm.ws.scripting.connectionType=")) {
                line = this.makeCorrectLine(line, filecontent, clientProps.getProperty("type"));
            } else if (line.startsWith("com.ibm.ws.scripting.port=")) {
                line = this.makeCorrectLine(line, filecontent, clientProps.getProperty("port"));
            } else if (line.startsWith("com.ibm.ws.scripting.host=")) {
                line = this.makeCorrectLine(line, filecontent, clientProps.getProperty("host"));
            }
        }
        filecontent.add(line);
    }

    private String makeCorrectLine(String line, Vector fileContent, String newValue) {
        String lineToReturn = line;
        String value = line.substring(line.indexOf(61) + 1).trim();
        if (!value.equals(newValue)) {
            this.commentOutLine(line, fileContent);
            line = line.substring(0, line.indexOf(61) + 1) + newValue;
        }
        return line;
    }

    private void commentOutLine(String line, Vector fileContent) {
        fileContent.add("#" + line);
    }

    protected WASProduct getWASProduct() {
        if (this.wasProduct == null) {
            this.wasProduct = new WASProduct();
        }
        return this.wasProduct;
    }

    protected void checkProductExtensionsNew(Properties localNodeMetadataProp, AdminClient adminclient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProductExtensionsNew", localNodeMetadataProp);
        }
        String extPointID = "com.ibm.wsspi.extension.node-side-extension-checker";
        IExtensionRegistry reg = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extPoint = reg.getExtensionPoint(extPointID);
        Properties dmgrMetadataProp = null;
        if (extPoint == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkProductExtensionsNew - ext point not defined");
            }
            return;
        }
        IConfigurationElement[] elements = extPoint.getConfigurationElements();
        for (int i = 0; i < elements.length; ++i) {
            NodeSideExtensionChecker ec;
            try {
                ec = (NodeSideExtensionChecker)elements[i].createExecutableExtension("class");
            }
            catch (Exception e) {
                throw new AdminException("At extension point " + extPointID + ", the extension class " + elements[i].getAttribute("class") + " failed to load");
            }
            if (dmgrMetadataProp == null) {
                Object acc = null;
                String nodeName = adminclient.getServerMBean().getKeyProperty("node");
                CommandMgrInitializer.initializeClientMode(adminclient);
                CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                AdminCommand cmd = cmdMgr.createCommand("getMetadataProperties");
                cmd.setParameter("nodeName", nodeName);
                cmd.execute();
                CommandResult cmdResult = cmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    throw new Exception(cmdResult.getException());
                }
                dmgrMetadataProp = (Properties)cmdResult.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dmgr node metadata:", dmgrMetadataProp);
                }
            }
            ec.checkCompatibility(localNodeMetadataProp, dmgrMetadataProp, adminclient);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProductExtensionsNew");
        }
    }

    protected void checkProductExtensions(WASProduct wasproduct, AdminClient adminclient) throws Exception {
        String extensionPointId = "com.ibm.wsspi.extension.extension-checker";
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        for (int i = 0; i < elements.length; ++i) {
            ExtensionChecker ec = (ExtensionChecker)elements[i].createExecutableExtension("class");
            ec.checkExtension(wasproduct, adminclient);
        }
    }

    public String getNetmgrName() {
        if (this.netmgrName == null) {
            this.netmgrName = Utils.getNetmgrName(this.adminClient);
        }
        return this.netmgrName;
    }

    protected String getBackupRoot(Repository localRepository, VariableMap map) {
        String backupRoot = null;
        try {
            block11: {
                block10: {
                    backupRoot = System.getProperty("was.repository.backup");
                    if (backupRoot == null) break block10;
                    if (!(backupRoot = backupRoot.replace('\\', '/')).endsWith("/")) break block11;
                    backupRoot = backupRoot.substring(0, backupRoot.length() - 1);
                    break block11;
                }
                Resource res = localRepository.getConfigRoot().getResource(4, "server.xml");
                Server server = (Server)res.getContents().get(0);
                EList servicesList = server.getServices();
                for (int i = 0; i < servicesList.size(); ++i) {
                    Service service = (Service)servicesList.get(i);
                    if (!(service instanceof AdminService)) continue;
                    AdminService admin = (AdminService)service;
                    RepositoryService configRepository = admin.getConfigRepository();
                    EList repProps = configRepository.getProperties();
                    for (int p = 0; p < repProps.size(); ++p) {
                        Property crProp = (Property)repProps.get(p);
                        String pname = crProp.getName();
                        String pval = crProp.getValue();
                        if (pname == null || !pname.equals("was.repository.backup") || pval == null) continue;
                        try {
                            backupRoot = map.expand(pval);
                            continue;
                        }
                        catch (IllegalArgumentException iae) {
                            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.management.tools.NodeRemoveUtility.getBackupRoot", (String)"300", (Object)this);
                        }
                    }
                    break;
                }
            }
            if (backupRoot == null) {
                backupRoot = this.configRoot + "/backup";
            }
        }
        catch (FileNotFoundException fnfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: " + fnfe.getMessage() + " Setting backupRoot to use default configRoot/backup.");
            }
            backupRoot = this.configRoot + "/backup";
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.CellManagerImpl.start", (String)"190", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred initializing config: " + e.getMessage());
            }
            backupRoot = this.configRoot + "/backup";
        }
        return backupRoot;
    }

    protected VariableMap getVarMap(String cRoot, String cName, String nName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVarMap: " + cRoot + ", " + cName + ", " + nName);
        }
        try {
            Repository rep = RepositoryFactory.createRepository((String)"ws-server", (String)cRoot, (String)cName, (String)nName, null);
            VariableMap oldMap = VariableMapFactory.createVariableMap((Repository)rep);
            oldMap.initialize(null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVarMap: " + oldMap);
            }
            return oldMap;
        }
        catch (Throwable th) {
            this.issueMessage("ADMU2027E", new Object[]{th, cRoot, cName, nName}, null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVarMap: NULL returned");
            }
            return null;
        }
    }

    protected void expandEar(String earPath, Vector v, VariableMap vMap) {
        Vector<String> v1 = new Vector<String>();
        for (int i = 0; i < v.size(); ++i) {
            v1.addElement(vMap.expand((String)v.elementAt(i)));
        }
        this.expandEar(earPath, v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandEar(String earPath, Vector v) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandEar: " + earPath + ", " + v);
        }
        if (v == null) return;
        if (v.size() == 0) {
            return;
        }
        EARFile ear = null;
        try {
            try {
                ear = EarUtils.getEarFile(earPath, false, true);
                for (int i = 0; i < v.size(); ++i) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expanding at: " + v.elementAt(i));
                        }
                        EarUtils.extractEar(ear, (String)v.elementAt(i), true);
                        continue;
                    }
                    catch (Throwable ex) {
                        this.issueMessage("ADMU2028E", new Object[]{ex, earPath, v.elementAt(i)}, null);
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable th) {
                this.issueMessage("ADMU2029E", new Object[]{th, earPath}, null);
                Object var7_8 = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "expandEar: " + earPath);
                }
                if (ear == null) return;
                ear.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "expandEar: " + earPath);
            }
            if (ear == null) throw throwable;
            ear.close();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandEar: " + earPath);
        }
        if (ear == null) return;
        ear.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getDeploymentPaths(String depls) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentPaths: " + depls);
        }
        Vector<String> ret = new Vector<String>();
        File deplsF = new File(depls);
        if (!deplsF.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentPaths: " + depls + " does not exist.");
            }
            return ret;
        }
        File[] appNames = deplsF.listFiles();
        ResourceSet set = this.createResourceSet(depls);
        int f = 0;
        while (true) {
            block18: {
                if (f >= appNames.length) {
                    return ret;
                }
                if (appNames[f].isDirectory()) {
                    Object var14_14;
                    String xmlName = appNames[f].getName() + "/deployment.xml";
                    Resource res = null;
                    try {
                        block17: {
                            try {
                                String url;
                                URI uri;
                                Deployment depl;
                                ApplicationDeployment appDepl;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Loading: " + xmlName);
                                }
                                if (!(appDepl = (ApplicationDeployment)(depl = (Deployment)(res = set.getResource(uri = URI.createURI(xmlName), true)).getContents().get(0)).getDeployedObject()).isEnableDistribution() || ret.contains(url = appDepl.getBinariesURL().replace('\\', '/'))) break block17;
                                ret.addElement(url);
                            }
                            catch (Throwable th) {
                                this.issueMessage("ADMU2030E", new Object[]{th, depls + File.pathSeparator + xmlName}, null);
                                var14_14 = null;
                                if (res != null) {
                                    res.unload();
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "getDeploymentPaths: " + ret);
                                }
                                break block18;
                            }
                        }
                        var14_14 = null;
                        if (res != null) {
                            res.unload();
                        }
                    }
                    catch (Throwable throwable) {
                        var14_14 = null;
                        if (res != null) {
                            res.unload();
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getDeploymentPaths: " + ret);
                        }
                        throw throwable;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDeploymentPaths: " + ret);
                    }
                }
            }
            ++f;
        }
    }

    protected ResourceSet createResourceSet(final String rootdir) {
        WASResourceSetImpl rs = new WASResourceSetImpl();
        URIConverterImpl uric = new URIConverterImpl(){

            public URI normalize(URI uri) {
                if (uri.isRelative()) {
                    return uri.resolve(URI.createFileURI(rootdir + File.separator));
                }
                return super.normalize(uri);
            }
        };
        rs.setURIConverter(uric);
        return rs;
    }

    protected void terminateAllServers() throws Exception {
        Vector servers = this.getServers();
        for (int i = 0; i < servers.size(); ++i) {
            String pidFile;
            String serverName = (String)servers.get(i);
            String rootDir = this.getVariableMap().expand("${LOG_ROOT}/" + serverName);
            File f = new File(rootDir, pidFile = serverName + ".pid");
            if (!f.exists()) continue;
            BufferedReader br = new BufferedReader(new FileReader(f));
            String pid = br.readLine();
            f.delete();
            try {
                Process p = ProcessFactory.bindTo((String)pid);
                p.stop();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected boolean isZOS() {
        if (!this.zos_set) {
            this.zos_set = true;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.zos = true;
            }
        }
        return this.zos;
    }

    protected void transformConfig2Native(String cellName, String nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformConfig2Native");
        }
        String wasHome = this.configRoot.substring(0, this.configRoot.lastIndexOf("/config"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "full transformConfig2Native with " + wasHome + " and " + cellName + " and " + nodeName);
        }
        try {
            AdminServiceImpl.getPlatformUtils().transform(cellName, nodeName);
        }
        catch (Exception e) {
            Tr.error(tc, this.getFormattedMessage("ADMU0011E", new Object[]{e}, null));
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformConfig2Native");
        }
    }

    class ShutdownThread
    extends Thread {
        ShutdownThread() {
        }

        public void run() {
            AbstractNodeConfigUtility.this.toolFailed();
        }
    }
}

