/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.sync.SyncResult;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SyncResultImpl
implements com.ibm.websphere.management.sync.SyncResult,
Serializable {
    private static final long serialVersionUID = 3288474355450479721L;
    private static TraceComponent tc = Tr.register(SyncResultImpl.class, "Sync", "com.ibm.ws.management.resources.sync");
    private long initTime = 0L;
    private long completeTime = 0L;
    private int result;
    private boolean updated;

    SyncResultImpl(SyncResult origResult) {
        this.initTime = origResult.getInitTime();
        this.completeTime = origResult.getCompleteTime();
        this.result = origResult.getResult();
        this.updated = origResult.isUpdated();
    }

    SyncResultImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SyncResult");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SyncResult");
        }
    }

    public int getResult() {
        return this.result;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccessful() {
        return this.result == 1 || this.result == 2;
    }

    void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.initTime = System.currentTimeMillis();
        this.completeTime = 0L;
        this.updated = false;
        this.result = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    void updated() {
        this.updated = true;
    }

    void setResult(int result) {
        this.result = result;
        this.completeTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss:SSS zzz");
        buf.append("initiate time: ").append(formatter.format(new Date(this.initTime))).append('\n');
        if (this.completeTime > 0L) {
            buf.append("complete time: ").append(formatter.format(new Date(this.completeTime))).append('\n');
        }
        buf.append("result: ");
        switch (this.result) {
            case 0: {
                buf.append("In Progress");
                break;
            }
            case 1: {
                buf.append("Complete");
                break;
            }
            case 4: {
                buf.append("Error");
                break;
            }
            case 2: {
                buf.append("Not Verfied");
                break;
            }
            case 3: {
                buf.append("Out of Sync");
            }
        }
        buf.append("\n");
        if (this.updated) {
            buf.append("Update occurred\n");
        } else {
            buf.append("No update occurred.\n");
        }
        return buf.toString();
    }
}

