/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.sync.SerializationHelper;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;

class NodeSyncTask
implements AlarmListener,
Runnable,
ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register(NodeSyncTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static Logger logger = null;
    public static final int IDLE = 0;
    public static final int COMPARE_FOLDERS = 1;
    public static final int PROCESSING_UPDATE = 2;
    public static final int PROCESSING_UPDATE_WITH_ERROR = 3;
    public static final int VERIFY_SYNC_RESULT = 4;
    private static final int SYNC_ITERATION_LIMIT = 5;
    private int state = 0;
    private NodeSync nodeSync;
    private boolean syncStatusOnly = false;
    private SyncResult currentResult = null;
    private ConfigEpoch nodeGlobalEpoch = null;
    private ConfigRepository repository;
    private Map folderEpoch = null;
    private boolean folderEpochInvalid = false;
    private boolean alarmSet = false;
    static final String CLASSNAME = NodeSyncTask.class.getName();
    private int consecutiveFailures = 0;
    private boolean autoSyncDisabled = false;
    private final String FOLDER_EPOCH_FILE_NAME = "nodeagentFolderLevel.epoch";
    private final String N0DE_EPOCH_FILE_NAME = "nodeGlobal.epoch";

    public NodeSyncTask(NodeSync nodeSync) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating NodeSyncTask");
        }
        this.nodeSync = nodeSync;
        this.state = 0;
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        this.repository.addListener((ConfigRepositoryListener)this);
        if (this.nodeGlobalEpoch == null && nodeSync.isHotRestartSyncEnabled()) {
            this.loadNodeGlobalEpoch();
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            logger = Logger.getLogger(CLASSNAME, "com.ibm.ws.management.resources.sync");
        }
    }

    synchronized Boolean initiate(boolean syncStatusOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiate: " + syncStatusOnly);
        }
        boolean result = false;
        if (this.state == 0) {
            this.syncStatusOnly = syncStatusOnly;
            if (this.currentResult == null) {
                this.currentResult = new SyncResult();
            } else {
                this.currentResult.initialize();
            }
            if (this.folderEpochInvalid) {
                this.nodeGlobalEpoch = null;
                this.folderEpoch = null;
                this.folderEpochInvalid = false;
            }
            this.setState(1);
            if (!syncStatusOnly) {
                this.nodeSync.sendStartEvent();
            }
            Thread nst = new Thread(this);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                nst.setDaemon(true);
                nst.setName("NodeSync");
            }
            nst.start();
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiate," + result);
        }
        return new Boolean(result);
    }

    boolean isIdle() {
        return this.state == 0;
    }

    SyncResult getCurrentResult() {
        return this.currentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "run");
            }
            try {
                try {
                    this.doSync();
                }
                catch (AdminException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSyncTask.run", (String)"157", (Object)this);
                    Object var3_2 = null;
                    this.setState(0);
                    break block6;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSyncTask.run", (String)"162", (Object)this);
                    Object var3_3 = null;
                    this.setState(0);
                }
                Object var3_1 = null;
                this.setState(0);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.setState(0);
                throw throwable;
            }
        }
    }

    public void alarm(Object obj) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Handling alarm");
        }
        this.alarmSet = false;
        this.triggerAutoSync();
    }

    void triggerAutoSync() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "triggerAutoSync");
        }
        if (this.nodeSync.getAutoSyncEnabled().booleanValue()) {
            if (this.nodeSync.isConnected()) {
                try {
                    this.initiate(false);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSyncTask.triggerAutoSync", (String)"174", (Object)this);
                    Tr.service(tc, "ADMS0017I");
                }
                if (!this.alarmSet) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alarm for interval of  " + this.nodeSync.getSyncInterval());
                    }
                    AlarmManager.createNonDeferrable((long)(this.nodeSync.getSyncInterval() * 60000), (AlarmListener)this);
                    this.alarmSet = true;
                }
            } else {
                Tr.error(tc, "ADMS0015E");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "autoSync is disabled");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "triggerAutoSync");
        }
    }

    int getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSync() throws AdminException {
        block75: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doSync");
            }
            boolean match = false;
            int numberOfTry = 0;
            ConfigEpoch cellEpoch = null;
            boolean fileChanged = false;
            boolean syncOnce = false;
            try {
                try {}
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSyncTask.doSync", (String)"8891", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in SecurityHelper ");
                    }
                    Object var15_17 = null;
                    if (match) {
                        this.currentResult.setResult(1);
                    } else if (this.syncStatusOnly) {
                        switch (this.state) {
                            case 1: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: {
                                this.currentResult.setResult(3);
                                break;
                            }
                        }
                    } else {
                        switch (this.state) {
                            case 1: {
                                if (syncOnce) {
                                    this.currentResult.setResult(2);
                                    break;
                                }
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.currentResult.setResult(4);
                                break;
                            }
                            case 4: {
                                this.currentResult.setResult(2);
                                break;
                            }
                        }
                    }
                    if (!this.syncStatusOnly) {
                        this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                        if (this.currentResult.isSuccessful()) {
                            if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                                this.logWTO("doSync", "ADMS0003I");
                            }
                            Tr.audit(tc, "ADMS0003I");
                        } else {
                            if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                                this.logWTO("doSync", "ADMS0036E");
                            }
                            Tr.audit(tc, "ADMS0036E");
                        }
                        this.manageConsecutiveFailures(this.currentResult.isSuccessful());
                    }
                    break block75;
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (match) {
                    this.currentResult.setResult(1);
                } else if (this.syncStatusOnly) {
                    switch (this.state) {
                        case 1: {
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 2: {
                            this.currentResult.setResult(3);
                            break;
                        }
                    }
                } else {
                    switch (this.state) {
                        case 1: {
                            if (syncOnce) {
                                this.currentResult.setResult(2);
                                break;
                            }
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.currentResult.setResult(4);
                            break;
                        }
                        case 4: {
                            this.currentResult.setResult(2);
                            break;
                        }
                    }
                }
                if (!this.syncStatusOnly) {
                    this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                    if (this.currentResult.isSuccessful()) {
                        if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                            this.logWTO("doSync", "ADMS0003I");
                        }
                        Tr.audit(tc, "ADMS0003I");
                    } else {
                        if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                            this.logWTO("doSync", "ADMS0036E");
                        }
                        Tr.audit(tc, "ADMS0036E");
                    }
                    this.manageConsecutiveFailures(this.currentResult.isSuccessful());
                }
                throw throwable;
            }
            do {
                Subject subject;
                if ((subject = SecurityHelper.getOwnedSubject()) != null) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
                cellEpoch = this.nodeSync.getCellRepositoryEpoch();
                boolean bl = match = this.nodeGlobalEpoch != null && this.nodeGlobalEpoch.equals((Object)cellEpoch);
                if (match) break;
                this.setState(1);
                ConfigChangeNotifier[] modifiedFolders = this.nodeSync.invokeGetModifiedFolders(this.getFolderEpoch());
                this.setState(2);
                if (AdminHelper.getPlatformHelper().isZOS() && modifiedFolders.length > 0) {
                    fileChanged = true;
                }
                if (this.syncStatusOnly) {
                    match = modifiedFolders.length == 0;
                    break;
                }
                this.setState(2);
                int batchSize = 10;
                ArrayList<FolderSyncRequest> batch = new ArrayList<FolderSyncRequest>(batchSize);
                int i = 0;
                while (i < modifiedFolders.length) {
                    batch.clear();
                    for (int j = 0; j < batchSize && i < modifiedFolders.length; ++i, ++j) {
                        FolderSyncRequest reqObj = this.createFolderSyncRequest(modifiedFolders[i]);
                        if (reqObj == null) continue;
                        batch.add(reqObj);
                    }
                    if (batch.size() <= 0) continue;
                    FolderSyncRequest[] reqs = new FolderSyncRequest[batch.size()];
                    batch.toArray(reqs);
                    FolderSyncUpdate[] syncUpdates = this.nodeSync.invokeGetFolderSyncUpdate(reqs);
                    for (int j = 0; j < syncUpdates.length; ++j) {
                        this.processFolderSyncUpdate(syncUpdates[j]);
                    }
                }
                if (this.state == 3) {
                    match = false;
                    break;
                }
                this.setState(4);
                this.nodeGlobalEpoch = cellEpoch;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Set node global epoch", this.nodeGlobalEpoch);
                }
                syncOnce = true;
            } while (!match && numberOfTry++ < 5);
            if (numberOfTry == 5) {
                Tr.audit(tc, "ADMS0023I");
            }
            Object var15_16 = null;
            if (match) {
                this.currentResult.setResult(1);
            } else if (this.syncStatusOnly) {
                switch (this.state) {
                    case 1: {
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 2: {
                        this.currentResult.setResult(3);
                        break;
                    }
                }
            } else {
                switch (this.state) {
                    case 1: {
                        if (syncOnce) {
                            this.currentResult.setResult(2);
                            break;
                        }
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.currentResult.setResult(4);
                        break;
                    }
                    case 4: {
                        this.currentResult.setResult(2);
                        break;
                    }
                }
            }
            if (!this.syncStatusOnly) {
                this.nodeSync.sendCompletionEvent(this.currentResult.isSuccessful());
                if (this.currentResult.isSuccessful()) {
                    if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                        this.logWTO("doSync", "ADMS0003I");
                    }
                    Tr.audit(tc, "ADMS0003I");
                } else {
                    if (AdminHelper.getPlatformHelper().isZOS() && fileChanged) {
                        this.logWTO("doSync", "ADMS0036E");
                    }
                    Tr.audit(tc, "ADMS0036E");
                }
                this.manageConsecutiveFailures(this.currentResult.isSuccessful());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doSync");
        }
    }

    private void manageConsecutiveFailures(boolean successful) {
        if (successful) {
            this.consecutiveFailures = 0;
            if (this.autoSyncDisabled) {
                Tr.audit(tc, "ADMS0211I");
                this.autoSyncDisabled = false;
                this.nodeSync.setAutoSyncEnabled(new Boolean(true));
            }
        } else {
            ++this.consecutiveFailures;
            if (this.consecutiveFailures >= 5 && this.nodeSync.getAutoSyncEnabled() == Boolean.TRUE && !"true".equalsIgnoreCase(System.getProperty("com.ibm.websphere.management.sync.allowfailure"))) {
                Tr.audit(tc, "ADMS0212I");
                this.autoSyncDisabled = true;
                this.nodeSync.setAutoSyncEnabled(new Boolean(false));
            }
        }
    }

    private FolderSyncRequest createFolderSyncRequest(ConfigChangeNotifier changedFolder) throws AdminException {
        if (changedFolder.getChangeType() == 1) {
            this.currentResult.updated();
            this.deleteFolder(changedFolder.getUri());
            return null;
        }
        return this.generateFolderSyncRequest(changedFolder);
    }

    private void deleteFolder(String folderUri) throws AdminException {
        String[] docUris = this.repository.listResourceNames(folderUri, 1, Integer.MAX_VALUE);
        for (int i = 0; i < docUris.length; ++i) {
            try {
                this.repository.delete(docUris[i]);
                continue;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.sync.NodeSyncTask.deleteFolder", (String)"357", (Object)this);
                this.setState(3);
            }
        }
        if (this.state == 2) {
            this.folderEpoch.remove(folderUri);
        }
    }

    private void processFolderSyncUpdate(FolderSyncUpdate folderSyncUpdate) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processFolderSyncUpdate: " + folderSyncUpdate.getFolderUri());
        }
        boolean partialSuccess = false;
        SyncElement[] syncInfo = folderSyncUpdate.getFolderSyncElements();
        if (syncInfo.length > 0) {
            this.currentResult.updated();
        }
        for (int i = 0; i < syncInfo.length; ++i) {
            SyncElement syncElement = syncInfo[i];
            int status = syncElement.getStatus();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, syncElement.getDocumentContentSource().getDocument().getURI() + ": " + status);
            }
            try {
                if (status == 2) {
                    this.repository.create(syncElement.getDocumentContentSource());
                    continue;
                }
                if (status == 1) {
                    syncElement.getDocumentContentSource().getDocument().setOverwrite(true);
                    this.repository.modify(syncElement.getDocumentContentSource());
                    continue;
                }
                if (status == 3) {
                    this.repository.delete(syncElement.getDocumentContentSource().getDocument().getURI());
                    continue;
                }
                Tr.warning(tc, "ADMS0009W", syncElement);
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSyncTask.processFolderSyncUpdate", (String)"405", (Object)this);
                Tr.service(tc, "ADMS0020E", new Object[]{syncElement.getDocumentContentSource().getDocument().getURI(), e});
                partialSuccess = true;
                this.setState(3);
            }
        }
        if (!partialSuccess) {
            this.getFolderEpoch().put(folderSyncUpdate.getFolderUri(), folderSyncUpdate.getFolderEpoch());
        }
    }

    private FolderSyncRequest generateFolderSyncRequest(ConfigChangeNotifier notifier) throws AdminException {
        FolderSyncRequest request = new FolderSyncRequest(notifier.getUri());
        if (notifier.getChangeType() == 2) {
            String[] documentUris = this.repository.listResourceNames(notifier.getUri(), 1, 1);
            for (int i = 0; i < documentUris.length; ++i) {
                request.setDocumentDigest(documentUris[i], this.repository.getDigest(documentUris[i]));
            }
        }
        return request;
    }

    private Map getFolderEpoch() {
        if (this.folderEpoch == null && this.nodeSync.isHotRestartSyncEnabled()) {
            this.loadFolderLevelEpochs();
        }
        if (this.folderEpoch == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new folder epoch map");
            }
            this.folderEpoch = new HashMap();
            String[] folders = this.repository.listResourceNames("/", 2, Integer.MAX_VALUE);
            this.folderEpoch.put("/", null);
            for (int i = 0; i < folders.length; ++i) {
                if (folders[i].startsWith(".repository") || folders[i].startsWith("templates")) continue;
                this.folderEpoch.put(folders[i], null);
            }
        }
        return this.folderEpoch;
    }

    private void loadFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadFolderLevelEpochs");
        }
        this.folderEpoch = (Map)SerializationHelper.loadObject("nodeagentFolderLevel.epoch");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadFolderLevelEpochs");
        }
    }

    public void persistFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistFolderLevelEpochs");
        }
        if (this.folderEpoch != null) {
            SerializationHelper.persistObject(this.folderEpoch, "nodeagentFolderLevel.epoch");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "folderEpoch is null, no need to persist anything");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistFolderLevelEpochs");
        }
    }

    private ConfigEpoch loadNodeGlobalEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNodeGlobalEpoch");
        }
        ConfigEpoch epoch = (ConfigEpoch)SerializationHelper.loadObject("nodeGlobal.epoch");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeGlobalEpoch");
        }
        return epoch;
    }

    public void persistNodeGlobalEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistNodeGlobalEpoch");
        }
        if (this.nodeGlobalEpoch != null) {
            SerializationHelper.persistObject(this.nodeGlobalEpoch, "nodeGlobal.epoch");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeGlobalEpoch is null, no need to persist anything");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistNodeGlobalEpoch");
        }
    }

    private synchronized void setState(int newState) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setState: " + newState);
        }
        this.state = newState;
        this.notifyAll();
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
    }

    public void onRepositoryEpochRefresh() {
        this.folderEpochInvalid = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Received repository epoch refresh notification");
        }
    }

    private void logWTO(String sourceMethod, String msg) {
        LoggerHelper.addExtension(logger, "handler_preference", "operator");
        logger.logp(WsLevel.INFO, CLASSNAME, sourceMethod, msg);
        LoggerHelper.removeExtension(logger, "handler_preference");
    }
}

