/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.metadata.NodeAgentCollector;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.NodeSyncTask;
import com.ibm.ws.management.sync.SyncResult;
import com.ibm.ws.management.sync.SyncResultImpl;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NodeSync
extends RuntimeCollaborator
implements RoutingListener,
DiagnosticProvider {
    private static TraceComponent tc = Tr.register(NodeSync.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static NodeSync nodeSync = null;
    private boolean autoSyncEnabled = true;
    private boolean origAutoSyncEnabled;
    private int syncInterval = 1;
    private int origSyncInterval;
    private NodeSyncTask nodeSyncTask = null;
    private boolean serverStartupSyncEnabled = false;
    private boolean origServerStartupSyncEnabled;
    ArrayList exclusionList = null;
    private Properties serviceProps = null;
    private Properties connProps = null;
    private AdminClient adminClient = null;
    private ObjectName cellSyncObjName = null;
    private ObjectName cellRepositoryObjName = null;
    private String nodeName = null;
    private String cellName = null;
    boolean inServer = false;
    private SyncHandler syncHandler = new SyncHandler();
    private ServerInfo netmgr;
    private boolean connected = false;
    private static List localListeners = new ArrayList(2);
    private long notifSeq = 0L;
    public static final String AUTOSYNC_ENABLED = "was.sync.autoSyncEnabled";
    public static final String SYNC_INTERVAL = "was.sync.syncInterval";
    public static final String SERVER_STARTUP_SYNC_ENABLED = "was.sync.serverStartupSyncEnabled";
    public static final String EXCLUSION_LIST = "was.sync.exclusionList";
    public static final String PROCESS_TYPE = "was.sync.processType";
    private String dpName = "NodeSyncDP";
    private DiagnosticProviderInfo dpInfo;
    private boolean hotRestartSync = false;
    private boolean nodeAgentStopping = false;

    private NodeSync() {
        this.connProps = new Properties();
    }

    public static synchronized NodeSync createNodeSync() throws AdminException {
        if (nodeSync != null) {
            throw new AdminException("NodeSync component is initialzied already");
        }
        nodeSync = new NodeSync();
        return nodeSync;
    }

    public static NodeSync getNodeSync() {
        return nodeSync;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isInServer() {
        return this.inServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalSyncEventListener(NotificationListener listener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLocalSyncEeventListener(NotificationListener listener) {
        List list = localListeners;
        synchronized (list) {
            localListeners.remove(listener);
        }
    }

    public void initialize(Properties props, List exclusions, VariableMap variableMap) throws AdminException {
        Properties initProps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if ((initProps = (Properties)props.clone()) != null) {
            String autoSyncProp = initProps.getProperty(AUTOSYNC_ENABLED);
            if (autoSyncProp != null && !autoSyncProp.equals("")) {
                this.autoSyncEnabled = Boolean.valueOf(autoSyncProp);
                initProps.remove(AUTOSYNC_ENABLED);
            }
            this.origAutoSyncEnabled = this.autoSyncEnabled;
            String syncIntervalProp = initProps.getProperty(SYNC_INTERVAL);
            if (syncIntervalProp != null && !syncIntervalProp.equals("")) {
                int i = Integer.parseInt(syncIntervalProp);
                if (i > 0) {
                    this.syncInterval = i;
                }
                initProps.remove(SYNC_INTERVAL);
            }
            this.origSyncInterval = this.syncInterval;
            String serverStartupSyncProp = initProps.getProperty(SERVER_STARTUP_SYNC_ENABLED);
            if (serverStartupSyncProp != null && !serverStartupSyncProp.equals("")) {
                this.serverStartupSyncEnabled = Boolean.valueOf(serverStartupSyncProp);
                initProps.remove(SERVER_STARTUP_SYNC_ENABLED);
            }
            this.origServerStartupSyncEnabled = this.serverStartupSyncEnabled;
            String processType = initProps.getProperty(PROCESS_TYPE);
            if (processType != null && !processType.equals("")) {
                if (processType.equalsIgnoreCase("NodeAgent")) {
                    this.inServer = true;
                }
                initProps.remove(PROCESS_TYPE);
            }
            this.hotRestartSync = Utils.isSyncHotRestartEnabled();
            if (this.hotRestartSync && tc.isDebugEnabled()) {
                Tr.debug(tc, "hot restart sync is enabled for NodeSync");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "autoSyncEnabled = " + this.autoSyncEnabled);
                Tr.debug(tc, "syncInterval = " + this.syncInterval);
                Tr.debug(tc, "serverStartupSyncEnabled = " + this.serverStartupSyncEnabled);
                Tr.debug(tc, "processType = " + processType);
                Tr.debug(tc, "hotRestartSync = " + this.hotRestartSync);
            }
            this.serviceProps = initProps;
        }
        if (this.inServer) {
            try {
                Properties diagnosticProps = new Properties();
                diagnosticProps.setProperty("diagnosticProvider", "true");
                AdminServiceFactory.getMBeanFactory().activateMBean("NodeSync", this, "nodeSync", null, diagnosticProps);
                tc.setDiagnosticProviderID(this.getDiagnosticProviderId());
            }
            catch (AdminException ae) {
                FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.sync.NodeSync.initialize", (String)"179", (Object)this);
                Tr.error(tc, "ADMS0100E", ae);
                throw ae;
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            this.nodeName = adminService.getNodeName();
            this.cellName = adminService.getCellName();
            RoutingTable rt = RoutingTable.getInstance();
            rt.addRoutingListener(this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering as RoutingListener");
            }
            DiagnosticProviderHelper.registerMBeanWithDiagnosticService(this.dpName, this.getObjectName());
        } else {
            this.getConnectionProps(initProps);
            try {
                ConfigRepository cr = ConfigRepositoryFactory.getConfigRepository();
                if (cr != null) {
                    cr.initialize(initProps);
                } else {
                    ConfigRepositoryFactory.createConfigRepository((boolean)true).initialize(initProps);
                }
            }
            catch (AdminException ae) {
                FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.sync.NodeSync.initialize", (String)"194", (Object)this);
                throw ae;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName = " + this.nodeName);
            Tr.debug(tc, "cellName = " + this.cellName);
        }
        this.nodeSyncTask = new NodeSyncTask(this);
        this.initializeExclusions(exclusions);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Boolean requestSync() {
        return this.nodeSyncTask.initiate(false);
    }

    public Boolean sync() throws AdminException {
        Boolean result = new Boolean(this.syncHandler.sync());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sync result is " + result);
        }
        return result;
    }

    public Boolean isNodeSynchronized() throws AdminException {
        Boolean result = new Boolean(this.syncHandler.isNodeSynchronized());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sync result is " + result);
        }
        return result;
    }

    protected boolean isHotRestartSyncEnabled() {
        return this.hotRestartSync;
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.nodeAgentStopping = true;
        if (this.hotRestartSync) {
            this.nodeSyncTask.persistNodeGlobalEpoch();
            this.nodeSyncTask.persistFolderLevelEpochs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    ConfigEpoch getCellRepositoryEpoch() throws AdminException {
        ConfigEpoch result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryEpoch");
        }
        try {
            AdminClient adminClient = this.getAdminClient();
            ObjectName cellRepName = this.getCellRepositoryObjName();
            String opName = "getRepositoryEpoch";
            result = (ConfigEpoch)adminClient.invoke(cellRepName, opName, null, null);
        }
        catch (ConnectorNotAvailableException cnae) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(cnae);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSync.getCellRepositoryEpoch", (String)"320", (Object)this);
            Tr.error(tc, "ADMS0005E", e);
            throw AdminException.getAdminException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryEpoch", result);
        }
        return result;
    }

    public ConfigChangeNotifier[] invokeGetModifiedFolders(Map folderEpochs) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeGetModifiedFolders");
        }
        ConfigChangeNotifier[] modifiedFolders = null;
        try {
            Object[] params;
            String[] signature;
            String[] s;
            AdminClient adminClient = this.getAdminClient();
            ObjectName cellSyncName = this.getCellSyncName();
            String opName = "getModifiedFolders";
            if (cellSyncName.getKeyProperty("version").equals("5.0")) {
                s = new String[]{"java.lang.String", "java.util.HashMap"};
                Object[] p = new Object[]{this.nodeName, folderEpochs};
                signature = s;
                params = p;
            } else {
                s = new String[]{"java.lang.String", "java.util.HashMap", "java.util.Properties"};
                Object[] p = new Object[]{this.nodeName, folderEpochs, this.serviceProps};
                signature = s;
                params = p;
            }
            Object result = adminClient.invoke(cellSyncName, opName, params, signature);
            modifiedFolders = (ConfigChangeNotifier[])result;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifiedFolders", modifiedFolders);
            }
        }
        catch (ConnectorNotAvailableException cnae) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(cnae);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSync.invokeGetModifiedFolders", (String)"418", (Object)this);
            Tr.error(tc, "ADMS0005E", e);
            throw AdminException.getAdminException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeGetModifiedFolders");
        }
        return modifiedFolders;
    }

    FolderSyncUpdate[] invokeGetFolderSyncUpdate(FolderSyncRequest[] reqs) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeGetFolderSyncUpdate");
        }
        FolderSyncUpdate[] result = null;
        try {
            Object[] params;
            String[] signature;
            AdminClient adminClient = this.getAdminClient();
            ObjectName cellSyncName = this.getCellSyncName();
            String opName = "getFolderSyncUpdates";
            if (cellSyncName.getKeyProperty("version").equals("5.0")) {
                String[] s = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;"};
                Object[] p = new Object[]{this.nodeName, this.exclusionList, reqs};
                signature = s;
                params = p;
            } else {
                String[] s = new String[]{"java.lang.String", "java.util.List", "[Lcom.ibm.ws.management.sync.FolderSyncRequest;", "java.util.Properties"};
                Object[] p = new Object[]{this.nodeName, this.exclusionList, reqs, this.serviceProps};
                signature = s;
                params = p;
            }
            result = (FolderSyncUpdate[])adminClient.invoke(cellSyncName, opName, params, signature);
        }
        catch (ConnectorNotAvailableException cnae) {
            Tr.error(tc, "ADMS0015E");
            throw new AdminException(cnae);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSync.invokeGetFolderSyncUpdate", (String)"453", (Object)this);
            Tr.error(tc, "ADMS0005E", e);
            throw AdminException.getAdminException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeGetFolderSyncUpdate", result);
        }
        return result;
    }

    public SyncResult getSyncResult() {
        return this.nodeSyncTask.getCurrentResult();
    }

    public com.ibm.websphere.management.sync.SyncResult getResult() {
        SyncResult result = this.nodeSyncTask.getCurrentResult();
        if (result != null) {
            return new SyncResultImpl(result);
        }
        return null;
    }

    private AdminClient getAdminClient() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (this.adminClient == null) {
            try {
                if (this.inServer) {
                    throw new AdminException("Admin client connection to deployment manager is unavailable; nodeagent has not discovered the dmgr");
                }
                this.adminClient = AdminClientFactory.createAdminClient(this.connProps);
            }
            catch (Exception e) {
                Tr.error(tc, "ADMS0012E", e);
                throw AdminException.getAdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return this.adminClient;
    }

    private void getConnectionProps(Properties initProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionProps", DebugUtils.createPropertiesMaskPlainTextPassword((Properties)initProps));
        }
        String type = null;
        String host = null;
        String port = null;
        String username = null;
        String password = null;
        String securityEnabled = null;
        if (initProps != null) {
            type = initProps.getProperty("type");
            host = initProps.getProperty("host");
            port = initProps.getProperty("port");
            username = initProps.getProperty("username");
            password = initProps.getProperty("password");
            securityEnabled = initProps.getProperty("securityEnabled");
        }
        if (type != null && host != null && port != null) {
            this.connProps.setProperty("type", type);
            this.connProps.setProperty("host", host);
            this.connProps.setProperty("port", port);
            if (username != null) {
                this.connProps.setProperty("username", username);
            }
            if (password != null) {
                this.connProps.setProperty("password", password);
            }
            if (new Boolean(securityEnabled).booleanValue()) {
                this.connProps.setProperty("securityEnabled", "true");
            }
            this.nodeName = initProps.getProperty("nodeName");
            this.cellName = initProps.getProperty("cellName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionProps", DebugUtils.createPropertiesMaskPlainTextPassword((Properties)this.connProps));
        }
    }

    private ObjectName getCellSyncName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellSyncName");
        }
        if (this.cellSyncObjName == null) {
            try {
                String netmgrName = Utils.getNetmgrName(this.adminClient);
                String query = "WebSphere:type=CellSync,process=" + netmgrName + ",*";
                ObjectName queryName = new ObjectName(query);
                Set s = this.getAdminClient().queryNames(queryName, null);
                if (s != null && s.size() != 0) {
                    if (s.size() != 1) {
                        Tr.service(tc, "ADMS0013I", new Integer(s.size()));
                    }
                    Object[] o = s.toArray();
                    this.cellSyncObjName = (ObjectName)o[0];
                    String version = this.cellSyncObjName.getKeyProperty("version");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CellSync name is " + this.cellSyncObjName.getCanonicalName());
                    }
                }
            }
            catch (ConnectorNotAvailableException cnae) {
                Tr.error(tc, "ADMS0015E");
                throw new AdminException(cnae);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSync.getCellSyncName", (String)"740", (Object)this);
                Tr.error(tc, "ADMS0005E", e);
                throw AdminException.getAdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellSyncName");
        }
        return this.cellSyncObjName;
    }

    private ObjectName getCellRepositoryObjName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellRepositoryObjName");
        }
        if (this.cellRepositoryObjName == null) {
            try {
                String netmgrName = Utils.getNetmgrName(this.adminClient);
                String query = "WebSphere:type=ConfigRepository,process=" + netmgrName + ",*";
                ObjectName queryName = new ObjectName(query);
                Set s = this.getAdminClient().queryNames(queryName, null);
                if (s != null && s.size() != 0) {
                    if (s.size() != 1) {
                        Tr.service(tc, "ADMS0021I", new Integer(s.size()));
                    }
                    Object[] o = s.toArray();
                    this.cellRepositoryObjName = (ObjectName)o[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell repository name is " + this.cellRepositoryObjName.getCanonicalName());
                    }
                }
            }
            catch (ConnectorNotAvailableException cnae) {
                Tr.error(tc, "ADMS0015E");
                throw new AdminException(cnae);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.NodeSync.getCellRepositoryObjName", (String)"740", (Object)this);
                Tr.error(tc, "ADMS0005E", e);
                throw AdminException.getAdminException(e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellRepositoryObjName");
        }
        return this.cellRepositoryObjName;
    }

    public void childAdded(ServerInfo serverInfo) {
    }

    public void childRemoved(ServerInfo serverInfo) {
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentAdded");
        }
        this.cellSyncObjName = null;
        this.cellRepositoryObjName = null;
        this.netmgr = serverInfo;
        try {
            this.adminClient = this.netmgr.getAdminClient();
        }
        catch (Exception ex) {
            Tr.error(tc, "ADMR0012E", ex);
        }
        try {
            NodeAgentCollector.collectMetadataAndSendToDmgr(this.adminClient);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSync.parentAdded", (String)"626", (Object)this);
        }
        this.connected = true;
        this.nodeSyncTask.triggerAutoSync();
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentRemoved");
        }
        this.connected = false;
    }

    private void initializeExclusions(List userExclusions) {
        this.exclusionList = new ArrayList();
        this.exclusionList.add("cells/" + this.cellName + "/nodes/" + this.nodeName + "/namestore.xml");
        this.exclusionList.add("*/namestore-cell.xml");
        this.exclusionList.add("*/namestore-node.xml");
        this.exclusionList.add("*/node-metadata.properties");
        if (AdminHelper.getPlatformHelper().isControlJvm()) {
            this.exclusionList.add("*/was.env");
            this.exclusionList.add("*/control.jvm.options");
            this.exclusionList.add("*/servant.jvm.options");
            this.exclusionList.add("*/adjunct.jvm.options");
        }
        if (userExclusions != null) {
            this.exclusionList.addAll(userExclusions);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exclusionList = ", this.exclusionList);
        }
    }

    public Boolean getAutoSyncEnabled() {
        return this.autoSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAutoSyncEnabled(Boolean b) {
        if (this.autoSyncEnabled != b) {
            this.autoSyncEnabled = b;
            if (this.autoSyncEnabled) {
                Tr.audit(tc, "ADMS0018I");
            } else {
                Tr.audit(tc, "ADMS0019I");
            }
            if (this.autoSyncEnabled) {
                this.nodeSyncTask.triggerAutoSync();
            }
        }
    }

    public Integer getSyncInterval() {
        return new Integer(this.syncInterval);
    }

    public void setSyncInterval(Integer i) {
        int interval = i;
        if (interval > 0) {
            Tr.audit(tc, "ADMS0001I", i);
            this.syncInterval = interval;
        } else {
            Tr.warning(tc, "ADMS0002W", i);
        }
    }

    public Boolean getServerStartupSyncEnabled() {
        return this.serverStartupSyncEnabled ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setServerStartupSyncEnabled(Boolean b) {
        this.serverStartupSyncEnabled = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLocalEvent(Notification n) {
        List list = localListeners;
        synchronized (list) {
            for (int i = 0; i < localListeners.size(); ++i) {
                try {
                    ((NotificationListener)localListeners.get(i)).handleNotification(n, null);
                    continue;
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.sync.NodeSync.sendLocalEvent", (String)"671", (Object)this);
                }
            }
        }
    }

    void sendCompletionEvent(boolean b) {
        ObjectName src = null;
        if (this.inServer) {
            src = this.getObjectName();
        } else {
            try {
                src = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", (String)"717", (Object)this);
            }
        }
        long sequence = this.notifSeq++;
        Notification n = new Notification("websphere.nodesync.complete", src, sequence);
        n.setUserData(b ? Boolean.TRUE : Boolean.FALSE);
        this.sendLocalEvent(n);
        if (this.inServer) {
            try {
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSync.sendCompletionEvent", (String)"737", (Object)this);
                Tr.warning(tc, "ADMS0014W", t);
            }
        }
    }

    void sendStartEvent() {
        ObjectName src = null;
        if (this.inServer) {
            src = this.getObjectName();
        } else {
            try {
                src = new ObjectName("WebSphere:type=NodeSync,cell=" + this.cellName + ",node=" + this.nodeName);
            }
            catch (MalformedObjectNameException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.sync.NodeSync.sendStartEvent", (String)"760", (Object)this);
            }
        }
        long sequence = this.notifSeq++;
        Notification n = new Notification("websphere.nodesync.initiated", src, sequence);
        this.sendLocalEvent(n);
        if (this.inServer) {
            try {
                this.sendNotification(n);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSync.sendStartEvent", (String)"766", (Object)this);
                Tr.warning(tc, "ADMS0022W", t);
            }
        }
    }

    public boolean syncForServerStartup() throws AdminException {
        boolean result = true;
        if (this.serverStartupSyncEnabled) {
            result = false;
            if (this.isConnected()) {
                result = this.syncHandler.sync();
                CommonAppUtils.waitSyncForAppManagement();
            }
        }
        return result;
    }

    protected boolean isConnected() {
        return this.connected && !this.nodeAgentStopping;
    }

    public boolean isConnected(long timeout) {
        while (!this.isConnected() && timeout > 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeout -= 500L;
        }
        return this.isConnected();
    }

    public String getDiagnosticProviderName() {
        return this.dpName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (this.dpInfo == null) {
            InputStream regIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/sync/NodeSyncDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(regIS, this.dpName);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String localId, boolean registeredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{localId, new Boolean(registeredOnly)});
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("startup-autoSyncEnabled", new DiagnosticTypedValue(this.origAutoSyncEnabled, "NodeSync.autoSyncEnabled.descriptionKey"));
        config.put("startup-syncInterval", new DiagnosticTypedValue(this.origSyncInterval, "NodeSync.syncInterval.descriptionKey"));
        config.put("startup-serverStartupSyncEnabled", new DiagnosticTypedValue(this.origServerStartupSyncEnabled, "NodeSync.serverStartupSyncEnabled.descriptionKey"));
        HashMap<String, DiagnosticTypedValue> exclusions = new HashMap<String, DiagnosticTypedValue>();
        Iterator iter = this.exclusionList.iterator();
        int i = 1;
        while (iter.hasNext()) {
            exclusions.put("exclusion" + i, new DiagnosticTypedValue((String)iter.next(), "NodeSync.exclusions.descriptionKey"));
            ++i;
        }
        config.put("startup-exclusions", exclusions);
        config.put("current-autoSyncEnabled", new DiagnosticTypedValue(this.autoSyncEnabled, "NodeSync.autoSyncEnabled.descriptionKey"));
        config.put("current-syncInterval", new DiagnosticTypedValue(this.syncInterval, "NodeSync.syncInterval.descriptionKey"));
        config.put("current-serverStartupSyncEnabled", new DiagnosticTypedValue(this.serverStartupSyncEnabled, "NodeSync.serverStartupSyncEnabled.descriptionKey"));
        HashMap<String, DiagnosticTypedValue> s = new HashMap<String, DiagnosticTypedValue>();
        Enumeration<Object> e = this.serviceProps.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            s.put(name, new DiagnosticTypedValue(this.serviceProps.getProperty(name), "NodeSync.prop.descriptionKey"));
        }
        config.put("startup-serviceProps", s);
        DiagnosticEvent[] diagnosticEvent = new DiagnosticEvent[]{DiagnosticEventFactory.createConfigDump(this.getDiagnosticProviderId(), NodeSync.class.getName(), "configDump", config)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", diagnosticEvent);
        }
        return diagnosticEvent;
    }

    public DiagnosticEvent[] stateDump(String localId, boolean registeredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateDump", new Object[]{localId, new Boolean(registeredOnly)});
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("connected", new DiagnosticTypedValue(this.connected, "NodeSync.connected.descriptionKey"));
        HashMap<String, DiagnosticTypedValue> r = new HashMap<String, DiagnosticTypedValue>();
        com.ibm.websphere.management.sync.SyncResult result = this.getResult();
        if (result != null) {
            r.put("startTime", new DiagnosticTypedValue(new Date(result.getInitTime()), "NodeSync.initTime.descriptionKey"));
            r.put("completeTime", new DiagnosticTypedValue(new Date(result.getCompleteTime()), "NodeSync.completeTime.descriptionKey"));
            r.put("successful", new DiagnosticTypedValue(result.isSuccessful(), "NodeSync.successful.descriptionKey"));
            r.put("updated", new DiagnosticTypedValue(result.isUpdated(), "NodeSync.updated.descriptionKey"));
        }
        state.put("currentResult", r);
        DiagnosticEvent[] diagnosticEvent = new DiagnosticEvent[]{DiagnosticEventFactory.createStateDump(this.getDiagnosticProviderId(), NodeSync.class.getName(), "stateDump", state)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", diagnosticEvent);
        }
        return diagnosticEvent;
    }

    public DiagnosticEvent[] selfDiagnostic(String localId, boolean registeredOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{localId, new Boolean(registeredOnly)});
        }
        HashMap<String, DiagnosticTypedValue> diag = new HashMap<String, DiagnosticTypedValue>();
        diag.put("connected", new DiagnosticTypedValue(this.connected, "NodeSync.connected.descriptionKey"));
        if (this.connected) {
            diag.put("fileTransferAvailable", new DiagnosticTypedValue(this.isFileTransferAvailable(), "NodeSync.ftapp.descriptionKey"));
            Boolean inSync = null;
            try {
                inSync = this.isNodeSynchronized();
                diag.put("synchronized", new DiagnosticTypedValue(inSync, "NodeSync.ftapp.descriptionKey"));
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSync.selfDiagnostic", (String)"952", (Object)this);
            }
        }
        DiagnosticEvent[] diagnosticEvent = new DiagnosticEvent[]{DiagnosticEventFactory.createDiagnosticEvent(this.getDiagnosticProviderId(), "selfDiagnostic", 10, NodeSync.class.getName(), "selfDiagnostic", "", "", diag)};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", diagnosticEvent);
        }
        return diagnosticEvent;
    }

    public String[] localize(String[] aKeys, Locale aLocale) {
        if (this.dpInfo == null) {
            this.dpInfo = this.getRegisteredDiagnostics();
        }
        if (this.dpInfo == null) {
            return null;
        }
        return DiagnosticProviderHelper.localize(this.dpInfo.resourceBundleName, aKeys, aLocale);
    }

    private boolean isFileTransferAvailable() {
        boolean result = false;
        if (this.getFileTransferObjName() != null) {
            result = true;
        }
        return result;
    }

    private ObjectName getFileTransferObjName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileTransferObjName");
        }
        ObjectName ftName = null;
        try {
            String netmgrName = Utils.getNetmgrName(this.adminClient);
            String query = "WebSphere:type=Application,name=filetransfer,process=" + netmgrName + ",*";
            ObjectName queryName = new ObjectName(query);
            Set s = this.getAdminClient().queryNames(queryName, null);
            if (s != null && s.size() != 0) {
                Object[] o = s.toArray();
                ftName = (ObjectName)o[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "file transfer name is " + this.cellRepositoryObjName.getCanonicalName());
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.NodeSync.getFileTransferObjName", (String)"1008", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileTransferObjName", ftName);
        }
        return ftName;
    }

    private class SyncHandler {
        private SyncHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sync() {
            boolean result;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.requestSync();
                    this.waitForCurrentSync();
                    result = NodeSync.this.getSyncResult().isSuccessful();
                } else {
                    boolean waitForCurrentSync = this.waitForNextCompareFolder();
                    if (!waitForCurrentSync) {
                        NodeSync.this.requestSync();
                    }
                    this.waitForCurrentSync();
                    result = NodeSync.this.getSyncResult().isSuccessful();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sync", result ? Boolean.TRUE : Boolean.FALSE);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isNodeSynchronized() {
            boolean result;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isNodeSynchronized");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                if (NodeSync.this.nodeSyncTask.isIdle()) {
                    NodeSync.this.nodeSyncTask.initiate(true);
                    this.waitForCurrentSync();
                    result = NodeSync.this.getSyncResult().getResult() == 1;
                } else {
                    boolean waitForCurrentSync = this.waitForNextCompareFolder();
                    if (!waitForCurrentSync) {
                        NodeSync.this.nodeSyncTask.initiate(true);
                    }
                    this.waitForCurrentSync();
                    result = NodeSync.this.getSyncResult().getResult() == 1;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isNodeSynchronized", result ? Boolean.TRUE : Boolean.FALSE);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForCurrentSync() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "waitForCurrentSync");
            }
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (!NodeSync.this.nodeSyncTask.isIdle()) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "waitForCurrentSync");
            }
        }

        private boolean waitForNextCompareFolder() {
            NodeSyncTask nodeSyncTask = NodeSync.this.nodeSyncTask;
            synchronized (nodeSyncTask) {
                while (true) {
                    try {
                        NodeSync.this.nodeSyncTask.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    switch (NodeSync.this.nodeSyncTask.getCurrentState()) {
                        case 0: {
                            return false;
                        }
                        case 1: {
                            return true;
                        }
                    }
                }
            }
        }
    }
}

