/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class J2eeAppTargetHelper {
    private static TraceComponent tc = Tr.register(J2eeAppTargetHelper.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static ConfigRepository repository = null;
    private static String cellName = null;
    static final String DIR_NODES = "/nodes";
    static final String DIR_APPLICATIONS = "/applications";
    static final String DIR_DEPLOYMENTS = "/deployments";
    static final String DIR_DELTAS = "/deltas";
    private static boolean initialized = false;
    private static Set distributionDisabledApps = null;
    private static Map appDepsMap;
    private static Map appBinsMap;

    protected static void addDisabledApp(String app) {
        distributionDisabledApps.add(app);
    }

    protected static void removeDisabledApp(String app) {
        distributionDisabledApps.remove(app);
    }

    protected static boolean isDisabledApp(String app) {
        return distributionDisabledApps.contains(app);
    }

    protected static int disabledAppsCount() {
        int count = 0;
        if (distributionDisabledApps != null) {
            count = distributionDisabledApps.size();
        }
        return count;
    }

    /*
     * Loose catch block
     */
    private static List getApps(String nodeName) throws AdminException {
        ArrayList<String> appDeps;
        block20: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "getApps", nodeName);
            }
            String cellPath = "cells/" + cellName;
            String nodesPath = cellPath + DIR_NODES;
            String myNodePath = nodesPath + "/" + nodeName;
            String applicationsPath = cellPath + DIR_APPLICATIONS;
            String serverIndexURI = myNodePath + "/serverindex.xml";
            ServerIndex serverIndex = null;
            Resource resource = null;
            appDeps = new ArrayList<String>();
            WASResourceSetImpl resourceSet = null;
            DocumentContentSource dcs = null;
            dcs = repository.extract(serverIndexURI);
            resourceSet = new WASResourceSetImpl();
            URI uri = URI.createFileURI(dcs.getDocument().getURI());
            resource = resourceSet.createResource(uri);
            if (resource == null) {
                throw new AdminException("Unable to create resource: " + serverIndexURI);
            }
            resource.load(dcs.getSource(), new HashMap());
            serverIndex = (ServerIndex)resource.getContents().get(0);
            if (serverIndex != null) {
                EList servers = serverIndex.getServerEntries();
                for (int i = 0; i < servers.size(); ++i) {
                    ServerEntry server = (ServerEntry)servers.get(i);
                    EList serverApps = server.getDeployedApplications();
                    for (int j = 0; j < serverApps.size(); ++j) {
                        if (appDeps.contains(serverApps.get(j))) continue;
                        appDeps.add(applicationsPath + "/" + serverApps.get(j));
                    }
                }
            } else {
                throw new AdminException("Unable to load serverIndex from document: " + serverIndexURI);
            }
            Object var18_18 = null;
            try {
                if (dcs != null) {
                    dcs.getSource().close();
                }
                if (serverIndex == null) break block20;
                ResourceSet rs = resource.getResourceSet();
                if (rs != null) {
                    EList el = rs.getResources();
                    if (el != null) {
                        el.remove(resource);
                        break block20;
                    }
                    throw new AdminException("Unable to remove resource: " + serverIndexURI);
                }
                throw new AdminException("Unable to get resources for: " + serverIndexURI);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getApps", (String)"174", J2eeAppTargetHelper.class);
            }
            break block20;
            {
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getApps", (String)"147", J2eeAppTargetHelper.class);
                    throw J2eeAppTargetHelper.getAdminException(t);
                }
            }
            catch (Throwable throwable) {
                block21: {
                    Object var18_19 = null;
                    try {
                        if (dcs != null) {
                            dcs.getSource().close();
                        }
                        if (serverIndex == null) break block21;
                        ResourceSet rs = resource.getResourceSet();
                        if (rs != null) {
                            EList el = rs.getResources();
                            if (el != null) {
                                el.remove(resource);
                                break block21;
                            }
                            throw new AdminException("Unable to remove resource: " + serverIndexURI);
                        }
                        throw new AdminException("Unable to get resources for: " + serverIndexURI);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getApps", (String)"174", J2eeAppTargetHelper.class);
                    }
                }
                throw throwable;
            }
        }
        appDepsMap.put(nodeName, appDeps);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getApps", nodeName);
        }
        return appDeps;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set getDistribApps(String nodeName) throws AdminException {
        if (J2eeAppTargetHelper.tc.isDebugEnabled()) {
            Tr.entry(J2eeAppTargetHelper.tc, "getDistribApps", nodeName);
        }
        resource = null;
        resourceSet = null;
        dcs = null;
        deployment = null;
        appBins = new HashSet<String>();
        appDeps = (List)J2eeAppTargetHelper.appDepsMap.get(nodeName);
        i = appDeps.iterator();
        while (true) {
            if (!i.hasNext()) {
                J2eeAppTargetHelper.appBinsMap.put(nodeName, appBins);
                if (J2eeAppTargetHelper.tc.isDebugEnabled() == false) return appBins;
                Tr.exit(J2eeAppTargetHelper.tc, "getDistribApps", nodeName);
                return appBins;
            }
            appDepFolder = (String)i.next();
            deploymentURI = appDepFolder + "/deployment.xml";
            binaryDir = appDepFolder.substring(0, appDepFolder.lastIndexOf("/deployments/"));
            try {
                dcs = J2eeAppTargetHelper.repository.extract(deploymentURI);
                resourceSet = new WASResourceSetImpl();
                uri = URI.createFileURI(dcs.getDocument().getURI());
                resource = resourceSet.createResource(uri);
                if (resource == null) throw new AdminException("Unable to create resource: " + deploymentURI);
                resource.load(dcs.getSource(), new HashMap<K, V>());
                deployment = (Deployment)resource.getContents().get(0);
                if (deployment == null) throw new AdminException("Unable to load deployment from document: " + deploymentURI);
                appDep = (ApplicationDeployment)deployment.getDeployedObject();
                if (!appDep.isEnableDistribution()) {
                    J2eeAppTargetHelper.addDisabledApp(binaryDir);
                } else {
                    J2eeAppTargetHelper.removeDisabledApp(binaryDir);
                }
                appBins.add(binaryDir);
                var14_14 = null;
                ** GOTO lbl-1000
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getDistribApps", (String)"239", J2eeAppTargetHelper.class);
                throw J2eeAppTargetHelper.getAdminException(t);
            }
            {
                catch (Throwable var13_17) {
                    var14_14 = null;
                    try {
                        if (dcs != null) {
                            dcs.getSource().close();
                        }
                        if (deployment == null) throw var13_17;
                        rs = resource.getResourceSet();
                        if (rs == null) throw new AdminException("Unable to get resources for: " + deploymentURI);
                        el = rs.getResources();
                        if (el == null) throw new AdminException("Unable to remove resource: " + deploymentURI);
                        el.remove(resource);
                        throw var13_17;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getDistribApps", (String)"266", J2eeAppTargetHelper.class);
                    }
                    throw var13_17;
                }
lbl-1000:
                // 1 sources

                try {}
                catch (Throwable t) {}
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.getDistribApps", (String)"266", J2eeAppTargetHelper.class);
                continue;
                if (dcs != null) {
                    dcs.getSource().close();
                }
                if (deployment == null) continue;
                rs = resource.getResourceSet();
                if (rs == null) throw new AdminException("Unable to get resources for: " + deploymentURI);
                el = rs.getResources();
                if (el == null) throw new AdminException("Unable to remove resource: " + deploymentURI);
                el.remove(resource);
                continue;
            }
            break;
        }
    }

    private static synchronized void init() throws AdminException {
        if (!initialized) {
            distributionDisabledApps = new HashSet();
            appDepsMap = new HashMap();
            appBinsMap = new HashMap();
            repository = ConfigRepositoryFactory.getConfigRepository();
            if (repository == null) {
                Tr.error(tc, "ADMS0101E");
                throw new AdminException("Unable to get the configuration repository");
            }
            cellName = AdminServiceFactory.getAdminService().getCellName();
            initialized = true;
        }
    }

    protected static void initializeOperation(String node) {
        try {
            J2eeAppTargetHelper.init();
            J2eeAppTargetHelper.getApps(node);
            J2eeAppTargetHelper.getDistribApps(node);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.J2eeAppTargetHelper.initializeOperation", (String)"303", J2eeAppTargetHelper.class);
        }
    }

    protected static boolean isNodeATarget(String node, String appUri) {
        Set appBins = (Set)appBinsMap.get(node);
        boolean isTarget = appBins.contains(appUri);
        return isTarget;
    }

    private static AdminException getAdminException(Throwable t) {
        AdminException e = t instanceof AdminException ? (AdminException)t : new AdminException(t);
        return e;
    }
}

