/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class J2CRAProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(J2CRAProcessor.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String SERVERS_CONTEXT = "servers/";
    private static final long SYNC_ID = -1L;
    private static final Long BAD_ID;
    private ConfigRepository repository;
    private boolean isLocal;
    private String cellName = null;
    private String nodeName = null;
    private boolean isInNodeSync = false;
    private Vector globalSyncQ = null;
    private Hashtable changeTable = null;
    private Hashtable changeTableRA = null;

    public J2CRAProcessor(Boolean local, ConfigRepository repo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "J2CRAProcessor: " + local);
        }
        this.isLocal = local;
        this.repository = repo;
        String opName = "getBundle";
        try {
            Class<?> appClass = Class.forName("com.ibm.ws.management.application.AppUtils");
            Class<?> hash = Class.forName("java.util.Hashtable");
            Class[] pp = new Class[]{hash};
            Object ll = null;
            Object[] lparams = new Object[]{ll};
            Method mtd = appClass.getMethod(opName, pp);
        }
        catch (Exception e) {
            Tr.warning(tc, "ADMS0024W", e);
        }
        this.changeTable = new Hashtable();
        this.changeTableRA = new Hashtable();
        NodeSync.addLocalSyncEventListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "J2CRAProcessor");
        }
    }

    private void printBinTable(String s, long id, Vector tbl) {
        if (tc.isDebugEnabled()) {
            if (tbl == null || tbl.size() == 0) {
                Tr.debug(tc, "xxxxxxxxxxx " + s + "(BinTable) : " + id + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + s + " ( BinTable ) : " + id + " xxxxxxxxxx");
            Object uri = tbl.elementAt(0);
            Tr.debug(tc, "---->" + uri);
            for (int i = 1; i < tbl.size(); ++i) {
                String path = (String)tbl.elementAt(i);
                Tr.debug(tc, "-------->" + path);
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + id + " xxxxENDxxxx");
        }
    }

    private void printRATable(String s, long id, Hashtable tbl) {
        if (tc.isDebugEnabled()) {
            if (tbl == null || tbl.size() == 0) {
                Tr.debug(tc, "xxxxxxxxxxx " + s + "( RATable ) : " + id + " xxxxxxxxxx: NULL");
                return;
            }
            Tr.debug(tc, "xxxxxxxxxxx " + s + " ( RATable ) : " + id + " xxxxxxxxxx");
            Object[] keys = tbl.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                J2CResourceAdapter ra = (J2CResourceAdapter)tbl.get(key);
                Tr.debug(tc, "-------->" + ra.getName() + " : " + key);
            }
            Tr.debug(tc, "xxxxENDxxxx id: " + id + " xxxxENDxxxx");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
        long id;
        if (this.isLocal && !this.isInNodeSync) {
            return;
        }
        long l = id = this.isInNodeSync ? -1L : event2.getId();
        if (this.changeTable.get(new Long(id)) != null) {
            return;
        }
        if (this.changeTableRA.get(new Long(id)) != null) {
            return;
        }
        ConfigChangeNotifier[] changes = event2.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            try {
                Vector binTable = (Vector)this.changeTable.get(new Long(id));
                if (binTable != null) {
                    return;
                }
                Hashtable raTable = (Hashtable)this.changeTableRA.get(new Long(id));
                if (raTable != null) {
                    return;
                }
                if (!this.shouldProcess(changes[i].getUri())) continue;
                String uri = changes[i].getUri();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "process: " + uri + " id=" + id);
                }
                binTable = new Vector();
                raTable = new Hashtable();
                this.changeTable.put(new Long(id), binTable);
                this.changeTableRA.put(new Long(id), raTable);
                this.buildBin2RARelation(uri, binTable, raTable, this.createVarMap());
                break;
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMS0025W", new Object[]{th});
            }
        }
        if (!this.isInNodeSync) {
            this.printBinTable("pre ", id, (Vector)this.changeTable.get(new Long(id)));
            this.printRATable("pre ", id, (Hashtable)this.changeTableRA.get(new Long(id)));
        }
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        if (this.isLocal && !this.isInNodeSync) {
            return;
        }
        if (!this.isInNodeSync) {
            this.postProcess(event2.getId(), true);
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notf, Object handback) {
        if (notf.getType().equals("websphere.nodesync.initiated")) {
            this.isInNodeSync = true;
        } else if (notf.getType().equals("websphere.nodesync.complete")) {
            Vector q = this.globalSyncQ;
            this.isInNodeSync = false;
            this.globalSyncQ = null;
            this.printBinTable("pre ", -1L, (Vector)this.changeTable.get(new Long(-1L)));
            this.printRATable("pre ", -1L, (Hashtable)this.changeTableRA.get(new Long(-1L)));
            if (notf.getUserData() != null && Boolean.TRUE.equals(notf.getUserData())) {
                this.postProcess(-1L, this.isLocal);
            }
        }
    }

    private boolean shouldProcess(String uri) throws Exception {
        String rnode = null;
        try {
            if (!uri.endsWith("resources.xml")) {
                return false;
            }
            if (uri.indexOf(SERVERS_CONTEXT) != -1) {
                return false;
            }
            int indx = uri.indexOf(NODES_CONTEXT);
            if (indx == -1) {
                return false;
            }
            rnode = uri.substring(indx + 6);
            rnode = rnode.substring(0, rnode.indexOf(47));
            Tr.debug(tc, "rnode = " + rnode);
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADMS0027W", new Object[]{uri, th});
        }
        AdminService admin = AdminServiceFactory.getAdminService();
        if (admin != null) {
            this.cellName = admin.getCellName();
            this.nodeName = admin.getNodeName();
        } else {
            this.cellName = System.getProperty("local.cell");
            this.nodeName = System.getProperty("local.node");
        }
        if (this.cellName == null) {
            this.cellName = NodeSync.getNodeSync().getCellName();
            this.nodeName = NodeSync.getNodeSync().getNodeName();
        }
        Tr.debug(tc, "cellName = " + this.cellName + " nodeName = " + this.nodeName);
        return this.nodeName.equals(rnode);
    }

    private VariableMap createVarMap() throws Exception {
        VariableMap map;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createVarMap");
            }
            map = null;
            try {
                String cRoot = (String)this.repository.getConfig().get("was.repository.root");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cRoot = " + cRoot + " ,cellName = " + this.cellName + " ,nodeName = " + this.nodeName);
                }
                String opName = "createVarMap";
                Class<?> appClass = Class.forName("com.ibm.ws.management.application.AppUtils");
                Class[] pp = new Class[]{String.class, String.class, String.class, String.class};
                Object ll = null;
                Object[] lparams = new Object[]{cRoot, this.cellName, this.nodeName, ll};
                Method mtd = appClass.getMethod(opName, pp);
                map = (VariableMap)mtd.invoke(null, lparams);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "createVarMap: failed " + ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBin2RARelation(String uri, Vector binTable, Hashtable raTable, VariableMap map) {
        Resource res;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildBin2RARelation: " + uri);
        }
        if ((res = J2CRAProcessor.getResource(uri, "/resources.xml", this.repository)) == null) {
            return;
        }
        try {
            try {
                EList el = res.getContents();
                binTable.add(uri);
                for (int i = 0; i < el.size(); ++i) {
                    EObject eo = (EObject)el.get(i);
                    if (!(eo instanceof J2CResourceAdapter)) continue;
                    J2CResourceAdapter ra = (J2CResourceAdapter)eo;
                    String key = res.getURIFragment(eo);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RA key=" + key + " ra=" + ra);
                    }
                    raTable.put(key, ra);
                    String aPath = ra.getArchivePath();
                    aPath = J2CRAProcessor.normalizePath(map, aPath);
                    binTable.add(aPath);
                }
                Object var13_13 = null;
                if (res != null) {
                    res.unload();
                }
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMS0028E", new Object[]{th});
                Object var13_14 = null;
                if (res != null) {
                    res.unload();
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (res != null) {
                res.unload();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildBin2RARelation: ");
        }
    }

    protected static Resource getResource(String uri, String fileName, ConfigRepository repository2) {
        try {
            DocumentContentSource dcs = repository2.extract(uri);
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URI fileURI = URI.createURI(fileName);
            Resource res = resourceSet.createResource(fileURI);
            HashMap options = new HashMap();
            res.load(dcs.getSource(), options);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + uri + " is: " + res);
            }
            return res;
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADMS0029W", new Object[]{uri});
            Tr.debug(tc, "Exception" + th);
            return null;
        }
    }

    protected static String normalizePath(VariableMap v, String path) {
        String ret = path;
        if (v != null) {
            ret = v.expand(path);
        }
        ret = ret.replace('/', File.separatorChar);
        ret = ret.replace('\\', File.separatorChar);
        return ret;
    }

    public void postProcess(long id, boolean isSynchronous) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postProcess: " + id + ", synchronous=: " + isSynchronous);
        }
        try {
            Vector oldPaths = (Vector)this.changeTable.remove(new Long(id));
            Hashtable oldRAs = (Hashtable)this.changeTableRA.remove(new Long(id));
            if (oldPaths == null || oldPaths.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  oldTable is null or BAD !!!! " + id);
                }
                return;
            }
            if (oldRAs == null || oldRAs.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  oldTable is null or BAD !!!! " + id);
                }
                return;
            }
            String uri = (String)oldPaths.elementAt(0);
            Vector newPaths = new Vector();
            Hashtable newRAs = new Hashtable();
            VariableMap map = this.createVarMap();
            this.buildBin2RARelation(uri, newPaths, newRAs, map);
            for (int j = 1; j < oldPaths.size(); ++j) {
                String aPath = (String)oldPaths.elementAt(j);
                if (newPaths.contains(aPath) || this.checkCellLevel(map, aPath) || this.checkDeleteDisabled(map, aPath, oldRAs)) continue;
                this.deleteRar(aPath);
            }
            Object[] keys = oldRAs.keySet().toArray();
            for (int j = 0; j < keys.length; ++j) {
                String key = (String)keys[j];
                J2CResourceAdapter ra = (J2CResourceAdapter)newRAs.get(key);
                if (ra != null) continue;
                J2CResourceAdapter ora = (J2CResourceAdapter)oldRAs.get(key);
                this.stopRA(ora);
            }
            this.printBinTable("post bin", id, newPaths);
            this.printRATable("post RA ", id, newRAs);
            if (newPaths.size() == 0 && oldPaths.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  both old and new are of size 0. id=" + id);
                }
                return;
            }
            if (newRAs.size() == 0 && oldRAs.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postProcess  both old and new are of size 0. id=" + id);
                }
                return;
            }
        }
        catch (Throwable th) {
            Tr.error(tc, "ADMS0030E", new Object[]{th, new Long(id)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postProcess: " + id);
        }
    }

    public static ResourceBundle getBundle(Hashtable prefs) {
        Locale locale = null;
        if (prefs != null) {
            locale = (Locale)prefs.get("app.client.locale");
        }
        ResourceBundle resBundle = J2CRAProcessor.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        return resBundle;
    }

    public static ResourceBundle getBundle(String bName, Locale loc) {
        Locale locale = loc;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return ResourceBundle.getBundle(bName, locale);
        }
        catch (MissingResourceException e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getBundle", "595");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error loading class: " + bName + ", locale " + locale + ", " + e);
            }
            return null;
        }
    }

    public static String getMessage(ResourceBundle b, String s, Object[] args) {
        String m = J2CRAProcessor.getMessage(b, s);
        if (args == null) {
            return m;
        }
        return MessageFormat.format(m, args);
    }

    public static String getMessage(ResourceBundle bundle, String s) {
        if (bundle == null) {
            return s;
        }
        try {
            String ret = bundle.getString(s);
            if (ret == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Translation key not found: " + s);
                }
                return s;
            }
            return ret;
        }
        catch (MissingResourceException e) {
            RasUtils.logException(e, tc, CLASS_NAME, "getMessage", "632");
            return s;
        }
    }

    private void deleteRar(String path) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " ---- Delete from " + path);
        }
        if (path == null) {
            return;
        }
        try {
            String opName = "deleteDirTree";
            Class<?> appClass = Class.forName("com.ibm.ws.management.application.AppUtils");
            Class[] pp = new Class[]{String.class};
            Object[] lparams = new Object[]{path};
            Method mtd = appClass.getMethod(opName, pp);
            mtd.invoke(null, lparams);
        }
        catch (Throwable th) {
            Tr.error(tc, "ADMS0031E", new Object[]{th, path});
        }
    }

    private boolean checkDeleteDisabled(VariableMap map, String aPath, Hashtable oldRAs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDeleteDisabled: " + aPath);
        }
        boolean status = false;
        try {
            Object[] keys = oldRAs.keySet().toArray();
            block2: for (int j = 0; j < keys.length; ++j) {
                J2EEResourcePropertySet RApropSet;
                String key = (String)keys[j];
                J2CResourceAdapter ra = (J2CResourceAdapter)oldRAs.get(key);
                if (ra == null) continue;
                String arPath = ra.getArchivePath();
                arPath = J2CRAProcessor.normalizePath(map, arPath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arPath=" + arPath);
                }
                if (!aPath.equals(arPath) || (RApropSet = ra.getPropertySet()) == null) continue;
                EList properties = RApropSet.getResourceProperties();
                for (int k = 0; k < properties.size(); ++k) {
                    J2EEResourceProperty property = (J2EEResourceProperty)properties.get(k);
                    if (!property.getName().equals("WebSphereV5J2CRADisableDistribution") || !property.getValue().equals("DISABLED")) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This entry will be ignored.");
                    }
                    status = true;
                    continue block2;
                }
            }
        }
        catch (Throwable th) {
            Tr.warning(tc, "ADMS0028E", new Object[]{th});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkDeleteDisabled: " + status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCellLevel(VariableMap map, String aPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " checkCellLevel: " + aPath);
        }
        String uri = CELLS_CONTEXT + this.cellName + "/resources.xml";
        Resource res = J2CRAProcessor.getResource(uri, "/resources.xml", this.repository);
        boolean status = false;
        try {
            try {
                EList el = res.getContents();
                if (el != null) {
                    for (int i = 0; i < el.size(); ++i) {
                        EObject eo = (EObject)el.get(i);
                        if (!(eo instanceof J2CResourceAdapter)) continue;
                        J2CResourceAdapter ra = (J2CResourceAdapter)eo;
                        String arPath = ra.getArchivePath();
                        if (!(arPath = J2CRAProcessor.normalizePath(map, arPath)).equals(aPath)) continue;
                        status = true;
                        break;
                    }
                }
                Object var12_12 = null;
                if (res != null) {
                    res.unload();
                }
            }
            catch (Throwable th) {
                Tr.warning(tc, "ADMS0028E", new Object[]{th});
                Object var12_13 = null;
                if (res != null) {
                    res.unload();
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (res != null) {
                res.unload();
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " checkCellLevel: " + status);
        }
        return status;
    }

    private void stopRA(J2CResourceAdapter ra) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopRA: " + ra);
        }
        Properties props = new Properties();
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            return;
        }
        String name = ra.getName();
        try {
            ObjectName oName = new ObjectName("*:type=J2CResourceAdapter,name=" + name + ",*");
            Set s = adminService.queryNames(oName, null);
            if (s.isEmpty()) {
                Tr.exit(tc, "stopRA: " + name);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "J2CRA " + name + "is found");
            }
            String opName = "stop";
            String[] sigs = new String[]{};
            Object[] params = new Object[]{};
            ObjectName raMbean = (ObjectName)s.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean objectname=" + raMbean);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "J2CRA " + name + " was stopped.");
            }
        }
        catch (MalformedObjectNameException e) {
            String msg = e.getMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception=" + e);
            }
            Tr.warning(tc, "ADMS0024W", new Object[]{e});
        }
        catch (Exception e) {
            Tr.warning(tc, "ADMS0024W", new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopRA: " + ra);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.jmx/src/com/ibm/ws/management/sync/J2CRAProcessor.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.9");
        }
        CLASS_NAME = J2CRAProcessor.class.getName();
        BAD_ID = new Long(-2L);
    }
}

