/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.transform.RepositoryAdapter;
import com.ibm.wsspi.management.sync.SyncDocumentFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class FolderSyncTask
implements ResourceNameFilter {
    private static TraceComponent tc = Tr.register(FolderSyncTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    String nodeName;
    FolderSyncRequest request;
    ConfigRepository repository;
    RepositoryAdapter repositoryAdapter;
    ArrayList results = new ArrayList();
    List exclusionList;
    String nodesPath;
    String cellName;
    Properties taskProps;
    boolean recoveryNode;

    public ArrayList getResults() {
        return this.results;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setRepository(ConfigRepository repository2) throws AdminException {
        this.repository = repository2;
    }

    public void setRequest(FolderSyncRequest request) {
        this.request = request;
    }

    public void setExclusionList(List exclusionList) {
        this.exclusionList = exclusionList;
    }

    public void setProperties(Properties p) {
        String recoveryNodeProp;
        this.taskProps = p;
        if (this.taskProps != null && (recoveryNodeProp = this.taskProps.getProperty("recoveryNode")) != null && !recoveryNodeProp.equals("")) {
            this.recoveryNode = Boolean.valueOf(recoveryNodeProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Beginning FolderSyncTask for node/folder: " + this.nodeName + ", " + this.request.getFolderUri());
        }
        this.setupStaticMetadata();
        this.repositoryAdapter = RepositoryAdapter.getRepositoryAdapter(this.repository, this.nodeName);
        this.results.clear();
        String[] docs = this.repositoryAdapter.listResourceNames(this.request.getFolderUri(), 1, 1, this);
        docs = this.filterDocs(this.request.getFolderUri(), docs);
        HashMap nodeDocs = this.request.getDocuments();
        for (int i = 0; i < docs.length; ++i) {
            try {
                Object var6_8;
                if (this.request.getDocumentDigest(docs[i]) == null) {
                    this.results.add(new SyncElement(this.repositoryAdapter.extract(docs[i]), 2));
                    continue;
                }
                try {
                    block12: {
                        try {
                            DocumentDigest cellDigest = this.repositoryAdapter.getDigest(docs[i]);
                            if (cellDigest.equals(this.request.getDocumentDigest(docs[i]))) break block12;
                            this.results.add(new SyncElement(this.repositoryAdapter.extract(docs[i]), 1));
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.FolderSyncTask.execute", (String)"132", (Object)this);
                            var6_8 = null;
                            nodeDocs.remove(docs[i]);
                            continue;
                        }
                    }
                    var6_8 = null;
                    nodeDocs.remove(docs[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    nodeDocs.remove(docs[i]);
                    throw throwable;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.FolderSyncTask.execute", (String)"145", (Object)this);
            }
        }
        Iterator i = nodeDocs.keySet().iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            if (this.accept(null, uri)) {
                DocumentContentSource source = new DocumentContentSource(new Document(uri), (InputStream)null);
                this.results.add(new SyncElement(source, 3));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Excluding " + uri);
        }
        return;
    }

    protected void setupStaticMetadata() {
        this.nodesPath = "cells/" + this.cellName + "/nodes/";
    }

    protected String[] filterDocs(String folder, String[] docs) {
        if (docs.length < 1) {
            return docs;
        }
        if (!this.recoveryNode) {
            docs = this.differentNode(folder) ? this.filterDifferentNode(docs) : this.filterWithExtensions(folder, docs);
        }
        return docs;
    }

    private boolean differentNode(String folder) {
        boolean result = false;
        if (folder.startsWith(this.nodesPath) && !folder.startsWith(this.nodesPath + this.nodeName)) {
            result = true;
        }
        return result;
    }

    private String[] filterDifferentNode(String[] docs) {
        ArrayList<String> docList = new ArrayList<String>(2);
        for (int i = 0; i < docs.length; ++i) {
            if (docs[i].endsWith("/serverindex.xml")) {
                docList.add(docs[i]);
                continue;
            }
            if (!docs[i].endsWith("/node-metadata.properties")) continue;
            docList.add(docs[i]);
        }
        return docList.toArray(new String[0]);
    }

    private String[] filterWithExtensions(String folder, String[] docs) {
        ArrayList<String> docList = new ArrayList<String>();
        for (int i = 0; i < docs.length; ++i) {
            if (this.filteredByDocNameExtension(folder, docs[i]) || this.filteredByDocExtExtension(folder, docs[i])) continue;
            docList.add(docs[i]);
        }
        return docList.toArray(new String[0]);
    }

    private boolean filteredByDocNameExtension(String folder, String doc) {
        boolean filtered = false;
        List extensions = CellSync.getCellSync().getDocumentNameFilterExtensions(doc);
        filtered = this.filteredByExtension(extensions, folder, doc);
        return filtered;
    }

    private boolean filteredByDocExtExtension(String folder, String doc) {
        boolean filtered = false;
        String extName = this.getDocExtension(doc);
        List extensions = CellSync.getCellSync().getDocumentExtensionFilterExtensions(extName);
        filtered = this.filteredByExtension(extensions, folder, doc);
        return filtered;
    }

    private String getDocExtension(String doc) {
        String ext = "NO_EXTENSION";
        int index = doc.lastIndexOf(46);
        if (index >= 0) {
            ext = doc.substring(index, doc.length());
        }
        return ext;
    }

    private boolean filteredByExtension(List extensions, String folder, String doc) {
        boolean filtered = false;
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext() && !filtered) {
                SyncDocumentFilter filter = (SyncDocumentFilter)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling document filter extension", filter);
                    }
                    boolean accepted = filter.accept(folder, this.getDocumentName(doc), this.nodeName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Back from folder filter extension", new Object[]{filter, accepted});
                    }
                    if (accepted) continue;
                    filtered = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.FolderSyncTask.filteredByExtension", (String)"638", (Object)this);
                }
            }
        }
        return filtered;
    }

    private String getDocumentName(String uri) {
        int index = uri.lastIndexOf(47);
        String result = index >= 0 ? uri.substring(index + 1, uri.length()) : uri;
        return result;
    }

    public boolean accept(String parent, String name) {
        String uri = null;
        uri = parent == null ? name : (parent.endsWith("/") ? parent + name : parent + "/" + name);
        if (name.equals("node-metadata.properties")) {
            if (parent.startsWith(this.nodesPath + this.nodeName + "/")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Excluding " + uri);
                }
                return false;
            }
            return true;
        }
        if (this.exclusionList != null) {
            for (String exclusion : this.exclusionList) {
                if (!(exclusion.endsWith("*") && uri.startsWith(exclusion.substring(0, exclusion.length() - 1)) || exclusion.startsWith("*") && uri.endsWith(exclusion.substring(1))) && !uri.equalsIgnoreCase(exclusion)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Excluding " + uri);
                }
                return false;
            }
        }
        return true;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }
}

