/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.wsspi.management.sync.SyncFolderFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FolderCompareTask {
    private static TraceComponent tc = Tr.register(FolderCompareTask.class, "Sync", "com.ibm.ws.management.resources.sync");
    protected String nodeName;
    protected String cellName;
    protected Map nodeEpochTable;
    protected Map cellEpochTable;
    protected ArrayList results = new ArrayList();
    protected ConfigRepository repository;
    protected Properties taskProps;
    private boolean recoveryNode = false;
    protected String cellPath;
    protected String myNodePath;
    protected String nodesPath;
    protected String applicationsPath;
    static final String DIR_NODES = "/nodes";
    static final String DIR_APPLICATIONS = "/applications";

    public Map getCellEpochTable() {
        return this.cellEpochTable;
    }

    public ArrayList getResults() {
        return this.results;
    }

    public void setCellEpochTable(Map cellEpochTable) {
        this.cellEpochTable = cellEpochTable;
    }

    public void setNodeEpochTable(Map nodeEpochTable) {
        this.nodeEpochTable = nodeEpochTable;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New FolderCompareTask for node " + nodeName);
        }
    }

    public void setProperties(Properties p) {
        String recoveryNodeProp;
        this.taskProps = p;
        if (this.taskProps != null && (recoveryNodeProp = this.taskProps.getProperty("recoveryNode")) != null && !recoveryNodeProp.equals("")) {
            this.recoveryNode = Boolean.valueOf(recoveryNodeProp);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "recoveryNode property is " + this.recoveryNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFolder(String uri) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processFolder: " + uri);
        }
        boolean shouldSkip = false;
        if (!(this.isDmgrOnly(uri) || !this.recoveryNode && this.filteredByExtension(uri))) {
            Map map = this.cellEpochTable;
            synchronized (map) {
                if (!this.cellEpochTable.containsKey(uri)) {
                    this.cellEpochTable.put(uri, new ConfigEpoch());
                }
            }
            if (this.nodeEpochTable.containsKey(uri)) {
                ConfigEpoch nodeEpoch;
                ConfigEpoch cellEpoch = (ConfigEpoch)this.cellEpochTable.get(uri);
                if (!cellEpoch.equals((Object)(nodeEpoch = (ConfigEpoch)this.nodeEpochTable.get(uri)))) {
                    this.results.add(new ConfigChangeNotifier(uri, 2));
                }
                this.nodeEpochTable.remove(uri);
            } else {
                this.results.add(new ConfigChangeNotifier(uri, 0));
            }
            String[] subfolders = this.repository.listResourceNames(uri, 2, 1);
            subfolders = this.sortFolders(uri, subfolders);
            subfolders = this.limitFoldersToNode(uri, subfolders);
            for (int i = 0; i < subfolders.length; ++i) {
                this.processFolder(subfolders[i]);
            }
        }
    }

    public void setRepository(ConfigRepository repository2) {
        this.repository = repository2;
    }

    protected void setupMetadata() throws AdminException {
        this.cellPath = "cells/" + this.cellName;
        this.nodesPath = this.cellPath + DIR_NODES;
        this.myNodePath = this.nodesPath + "/" + this.nodeName;
        this.applicationsPath = this.cellPath + DIR_APPLICATIONS;
    }

    protected String[] sortFolders(String uri, String[] folders) {
        if (uri.equals(this.cellPath)) {
            String[] rFolders = new String[folders.length];
            int nodeIndex = -1;
            int appIndex = -1;
            for (int i = 0; i < folders.length; ++i) {
                if (folders[i].endsWith(DIR_NODES)) {
                    nodeIndex = i;
                    continue;
                }
                if (!folders[i].endsWith(DIR_APPLICATIONS)) continue;
                appIndex = i;
            }
            if (appIndex == -1 && nodeIndex == -1) {
                return folders;
            }
            int index = 0;
            if (appIndex != -1) {
                rFolders[index] = folders[appIndex];
                ++index;
            }
            if (nodeIndex != -1) {
                rFolders[index] = folders[nodeIndex];
                ++index;
            }
            for (int i = 0; i < folders.length; ++i) {
                if (i == nodeIndex || i == appIndex) continue;
                rFolders[index] = folders[i];
                ++index;
            }
            return rFolders;
        }
        return folders;
    }

    protected String[] limitFoldersToNode(String uri, String[] folders) {
        if (this.recoveryNode) {
            return folders;
        }
        if (this.otherNodeSubfolder(uri)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found different node's subdir: ", uri);
            }
            return new String[0];
        }
        return folders;
    }

    private boolean otherNodeSubfolder(String uri) {
        boolean result = false;
        if (uri.startsWith(this.nodesPath)) {
            String relPath = uri.substring(this.nodesPath.length());
            if (relPath.length() > 0) {
                relPath = relPath.substring(1);
            }
            if (!relPath.startsWith(this.nodeName) && relPath.indexOf(47) > 0) {
                result = true;
            }
        }
        return result;
    }

    public void execute() throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Beginning FolderCompareTask for node ", this.nodeName);
        }
        this.setupMetadata();
        this.processFolder("/");
        for (String uri : this.nodeEpochTable.keySet()) {
            if (uri == null || uri.startsWith(".repository") || uri.startsWith("templates")) continue;
            this.results.add(new ConfigChangeNotifier(uri, 1));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Folder compare result: ", this.results);
        }
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    private AdminException getAdminException(Throwable t) {
        AdminException e = t instanceof AdminException ? (AdminException)t : new AdminException(t);
        return e;
    }

    private boolean isDmgrOnly(String uri) {
        boolean dmgrOnly = false;
        if (uri.startsWith("templates") || uri.startsWith("xforms") || uri.startsWith("xformed") || uri.startsWith(".repository")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "filtering out dmgr-only folder:" + uri);
            }
            dmgrOnly = true;
        }
        return dmgrOnly;
    }

    private boolean filteredByExtension(String uri) {
        boolean filtered = false;
        String parent = this.getParentName(uri);
        List extensions = CellSync.getCellSync().getFolderFilterExtensions(parent);
        if (extensions != null) {
            String folder = this.getFolderName(uri);
            String parentUri = this.getParentUri(uri);
            Iterator i = extensions.iterator();
            while (i.hasNext() && !filtered) {
                SyncFolderFilter filter = (SyncFolderFilter)i.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling folder filter extension", filter);
                    }
                    boolean accepted = filter.accept(parentUri, folder, this.nodeName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Back from folder filter extension", new Object[]{filter, accepted});
                    }
                    if (accepted) continue;
                    filtered = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.FolderCompareTask.filteredByExtension", (String)"638", (Object)this);
                }
            }
        }
        return filtered;
    }

    private String getFolderName(String uri) {
        int index = uri.lastIndexOf(47);
        String result = index >= 0 ? uri.substring(index + 1, uri.length()) : uri;
        return result;
    }

    private String getParentName(String uri) {
        String parent = this.getParentUri(uri);
        return this.getFolderName(parent);
    }

    private String getParentUri(String uri) {
        int index = uri.lastIndexOf(47);
        String result = index >= 0 ? uri.substring(0, index) : "/";
        return result;
    }
}

