/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.management.sync.FolderCompareTask;
import com.ibm.ws.management.sync.FolderSyncRequest;
import com.ibm.ws.management.sync.FolderSyncTask;
import com.ibm.ws.management.sync.FolderSyncUpdate;
import com.ibm.ws.management.sync.SerializationHelper;
import com.ibm.ws.management.sync.SyncElement;
import com.ibm.ws.management.transform.TransformCacheInvalidator;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.sync.SyncDocumentFilter;
import com.ibm.wsspi.management.sync.SyncFolderFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class CellSync
extends RuntimeCollaborator
implements ConfigRepositoryListener {
    private static TraceComponent tc = Tr.register(CellSync.class, "Sync", "com.ibm.ws.management.resources.sync");
    private static CellSync cellSync = new CellSync();
    private ConfigRepository repository = null;
    String cellName = null;
    Map epochs = null;
    private static String folderSyncExtensionID = "com.ibm.wsspi.extension.folder-sync-filter";
    private static String documentSyncExtensionID = "com.ibm.wsspi.extension.document-sync-filter";
    Map folderFilterExtensions = null;
    Map docNameFilterExtensions = null;
    Map docExtFilterExtensions = null;
    private boolean hotRestartSync = false;
    private final String FOLDER_EPOCH_FILE_NAME = "cellFolderLevel.epoch";

    private CellSync() {
    }

    public static CellSync getCellSync() {
        return cellSync;
    }

    public void initialize(VariableMap variableMap) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            AdminServiceFactory.getMBeanFactory().activateMBean("CellSync", this, "cellSync", null);
        }
        catch (AdminException ae) {
            FFDCFilter.processException((Throwable)ae, (String)"com.ibm.ws.management.sync.CellSync.initialize", (String)"91", (Object)this);
            Tr.error(tc, "ADMS0100E", ae);
            throw ae;
        }
        this.repository = ConfigRepositoryFactory.getConfigRepository();
        if (this.repository == null) {
            Tr.error(tc, "ADMS0101E");
            throw new AdminException("Unable to get the configuration repository");
        }
        this.repository.addListener((ConfigRepositoryListener)this);
        this.cellName = AdminServiceFactory.getAdminService().getCellName();
        this.hotRestartSync = Utils.isSyncHotRestartEnabled();
        if (this.hotRestartSync) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "hot restart sync is enabled for cell sync, transform cache in a mixed cell will also be saved.");
            }
            this.loadFolderLevelEpochs();
        }
        if (this.epochs == null) {
            if (this.hotRestartSync && tc.isDebugEnabled()) {
                Tr.debug(tc, "epochs is null after loadFolderEpochs");
            }
            this.epochs = new HashMap();
        }
        TransformCacheInvalidator.initialize(this.repository, this.hotRestartSync);
        this.findFolderFilterExtensions();
        this.findDocumentFilterExtensions();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Boolean syncNode(String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncNode");
        }
        boolean result = false;
        ObjectName objName = this.getObjectName(nodeName);
        if (objName != null) {
            AdminHelper.getInstance().audit("ADMN1006I", "ADMN1007I", (Object)new Object[]{nodeName, null});
            result = this.invokeRequestSync(objName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncNode", result ? Boolean.TRUE : Boolean.FALSE);
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    private ObjectName getObjectName(String nodeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectName", nodeName);
        }
        ObjectName objName = null;
        try {
            String queryString = "WebSphere:type=NodeSync,node=" + nodeName + ",process=nodeagent,*";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "query string is " + queryString);
            }
            ObjectName queryName = new ObjectName(queryString);
            Set s = AdminServiceFactory.getAdminService().queryNames(queryName, null);
            if (s.size() != 0) {
                if (s.size() > 1) {
                    Tr.service(tc, "ADMS0109I", new Object[]{new Integer(s.size()), nodeName});
                }
                Object[] o = s.toArray();
                objName = (ObjectName)o[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Object name is " + objName.getCanonicalName());
                }
            } else {
                Tr.service(tc, "ADMS0111I", nodeName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.CellSync.getObjectName", (String)"173", (Object)this);
            Tr.service(tc, "ADMS0107E", new Object[]{nodeName, e});
            objName = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName");
        }
        return objName;
    }

    private boolean invokeRequestSync(ObjectName objName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeRequestSync");
        }
        boolean accepted = false;
        try {
            Object obj = AdminServiceFactory.getAdminService().invoke(objName, "requestSync", null, null);
            accepted = (Boolean)obj;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.CellSync.invokeRequestSync", (String)"360", (Object)this);
            Tr.error(tc, "ADMS0104I", new Object[]{objName, e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeRequestSync", accepted ? Boolean.TRUE : Boolean.FALSE);
        }
        return accepted;
    }

    protected String getCellName() {
        return this.cellName;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String nodeName, HashMap nodeEpochTable, Properties p) throws AdminException {
        this.initializeExtensions(nodeName);
        FolderCompareTask task = new FolderCompareTask();
        task.setNodeName(nodeName);
        task.setCellName(this.getCellName());
        task.setNodeEpochTable(nodeEpochTable);
        task.setCellEpochTable(this.epochs);
        task.setRepository(this.repository);
        task.setProperties(p);
        task.execute();
        ArrayList results = task.getResults();
        ConfigChangeNotifier[] retVal = new ConfigChangeNotifier[results.size()];
        results.toArray(retVal);
        return retVal;
    }

    public ConfigChangeNotifier[] getModifiedFolders(String nodeName, HashMap nodeEpochTable) throws AdminException {
        return this.getModifiedFolders(nodeName, nodeEpochTable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderSyncUpdate[] getFolderSyncUpdates(String nodeName, List exclusionList, FolderSyncRequest[] nodeInfo, Properties p) throws AdminException {
        FolderSyncTask task = new FolderSyncTask();
        task.setNodeName(nodeName);
        task.setCellName(this.getCellName());
        task.setExclusionList(exclusionList);
        task.setRepository(this.repository);
        task.setProperties(p);
        FolderSyncUpdate[] updates = new FolderSyncUpdate[nodeInfo.length];
        for (int i = 0; i < nodeInfo.length; ++i) {
            ConfigEpoch epoch = null;
            Map map = this.epochs;
            synchronized (map) {
                epoch = (ConfigEpoch)this.epochs.get(nodeInfo[i].getFolderUri());
                if (epoch == null) {
                    epoch = new ConfigEpoch();
                    this.epochs.put(nodeInfo[i].getFolderUri(), epoch);
                }
            }
            task.setRequest(nodeInfo[i]);
            task.execute();
            ArrayList results = task.getResults();
            SyncElement[] elements = new SyncElement[results.size()];
            results.toArray(elements);
            updates[i] = new FolderSyncUpdate(nodeInfo[i].getFolderUri(), epoch, elements);
        }
        return updates;
    }

    public FolderSyncUpdate[] getFolderSyncUpdates(String nodeName, List exclusionList, FolderSyncRequest[] nodeInfo) throws AdminException {
        return this.getFolderSyncUpdates(nodeName, exclusionList, nodeInfo, null);
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRepositoryEpochRefresh() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository epoch was refreshed so clear the folder epochs");
        }
        Map map = this.epochs;
        synchronized (map) {
            this.epochs.clear();
        }
        TransformCacheInvalidator.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        ConfigChangeNotifier[] changes = event2.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            String parent = changes[i].getUri().substring(0, changes[i].getUri().lastIndexOf("/"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Document " + changes[i].getUri() + " was updated.  Updating epoch for folder " + parent);
            }
            Map map = this.epochs;
            synchronized (map) {
                this.epochs.put(parent, new ConfigEpoch());
                TransformCacheInvalidator.invalidate(changes[i].getUri());
                continue;
            }
        }
    }

    void findFolderFilterExtensions() {
        this.folderFilterExtensions = new HashMap();
        IExtensionRegistry reg = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extPoint = reg.getExtensionPoint(folderSyncExtensionID);
        if (extPoint != null) {
            IConfigurationElement[] elements = extPoint.getConfigurationElements();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " folder filter extensions");
            }
            for (int i = 0; i < elements.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "folder = " + elements[i].getAttribute("folder"));
                    Tr.debug(tc, "class = " + elements[i].getAttribute("class"));
                }
                if (elements[i].getAttribute("class") == null) continue;
                String folder = elements[i].getAttribute("folder");
                if (folder != null) {
                    try {
                        SyncFolderFilter filter = (SyncFolderFilter)elements[i].createExecutableExtension("class");
                        Tr.debug(tc, "After filter creation");
                        ArrayList<SyncFolderFilter> extensions = (ArrayList<SyncFolderFilter>)this.folderFilterExtensions.get(folder);
                        if (extensions == null) {
                            extensions = new ArrayList<SyncFolderFilter>();
                            this.folderFilterExtensions.put(folder, extensions);
                        }
                        extensions.add(filter);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Added folder filter for " + folder + ": " + elements[i].getAttribute("class"));
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.CellSync.findFolderFilterExtensions", (String)"486", (Object)this);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid folder sync extension - no folder attribute: " + elements[i].getAttribute("class"));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No folder filter extensions were found.");
        }
    }

    void findDocumentFilterExtensions() {
        this.docNameFilterExtensions = new HashMap();
        this.docExtFilterExtensions = new HashMap();
        IExtensionRegistry reg = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extPoint = reg.getExtensionPoint(documentSyncExtensionID);
        if (extPoint != null) {
            IConfigurationElement[] elements = extPoint.getConfigurationElements();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + elements.length + " document filter extensions");
            }
            for (int i = 0; i < elements.length; ++i) {
                ArrayList<SyncDocumentFilter> extensions;
                SyncDocumentFilter filter;
                if (elements[i].getAttribute("class") == null) continue;
                String docName = elements[i].getAttribute("documentName");
                String extName = elements[i].getAttribute("documentExtension");
                if (docName != null) {
                    try {
                        filter = (SyncDocumentFilter)elements[i].createExecutableExtension("class");
                        extensions = (ArrayList<SyncDocumentFilter>)this.docNameFilterExtensions.get(docName);
                        if (extensions == null) {
                            extensions = new ArrayList<SyncDocumentFilter>();
                            this.docNameFilterExtensions.put(docName, extensions);
                        }
                        extensions.add(filter);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Added docName filter for " + docName + ": " + elements[i].getName());
                        }
                    }
                    catch (CoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.CellSync.findDocumentFilterExtensions", (String)"539", (Object)this);
                    }
                }
                if (extName == null) continue;
                try {
                    filter = (SyncDocumentFilter)elements[i].createExecutableExtension("class");
                    extensions = (List)this.docExtFilterExtensions.get(extName);
                    if (extensions == null) {
                        extensions = new ArrayList();
                        this.docExtFilterExtensions.put(extName, extensions);
                    }
                    extensions.add(filter);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added extName filter for " + extName + ": " + elements[i].getName());
                    continue;
                }
                catch (CoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.sync.CellSync.findDocumentFilterExtensions", (String)"563", (Object)this);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No folder filter extensions were found.");
        }
    }

    List getFolderFilterExtensions(String folder) {
        return (List)this.folderFilterExtensions.get(folder);
    }

    List getDocumentNameFilterExtensions(String doc) {
        return (List)this.docNameFilterExtensions.get(doc);
    }

    List getDocumentExtensionFilterExtensions(String ext) {
        return (List)this.docExtFilterExtensions.get(ext);
    }

    private void initializeExtensions(String node) {
        Collection c = this.folderFilterExtensions.values();
        ArrayList classes = new ArrayList();
        for (List l : c) {
            for (SyncFolderFilter filter : l) {
                Class<?> cl = filter.getClass();
                if (classes.contains(cl)) continue;
                classes.add(cl);
                try {
                    filter.initializeOperation(node);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.CellSync.initializeExtensions", (String)"610", (Object)this);
                }
            }
        }
        c = this.docNameFilterExtensions.values();
        for (List l : c) {
            for (SyncFolderFilter filter : l) {
                try {
                    filter.initializeOperation(node);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.CellSync.initializeExtensions", (String)"628", (Object)this);
                }
            }
        }
        c = this.docExtFilterExtensions.values();
        for (List l : c) {
            for (SyncFolderFilter filter : l) {
                try {
                    filter.initializeOperation(node);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.sync.CellSync.initializeExtensions", (String)"646", (Object)this);
                }
            }
        }
    }

    private void loadFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadFolderLevelEpochs");
        }
        this.epochs = (Map)SerializationHelper.loadObject("cellFolderLevel.epoch");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadFolderLevelEpochs");
        }
    }

    public void persistFolderLevelEpochs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistFolderLevelEpochs");
        }
        if (this.epochs != null) {
            SerializationHelper.persistObject(this.epochs, "cellFolderLevel.epoch");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "epochs is null, no need to persist anything");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistFolderLevelEpochs");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this.hotRestartSync) {
            FileRepository fileRepository = (FileRepository)this.repository;
            fileRepository.persistRepositoryEpoch();
            this.persistFolderLevelEpochs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }
}

