/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusCache;
import com.ibm.ws.management.status.DefaultStatusCache;
import com.ibm.ws.management.status.DeploymentManagerStatusCache;
import com.ibm.ws.management.status.NodeAgentStatusCache;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheClient;
import com.ibm.ws.management.status.StatusCacheClientProxy;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StatusCacheFactory {
    private static final TraceComponent tc = Tr.register(StatusCacheFactory.class, null, null);
    private static StatusCache cache = null;
    private static StatusCacheClient scc = null;
    private static boolean init = false;
    private static ArrayList clients = new ArrayList(2);
    private static Map statusCacheClients = new HashMap();
    private static final String STATUS_CACHE_INITIALIZED = StatusCacheFactory.class.getName() + ".initialized";
    private static final String STATUS_CACHE = StatusCache.class.getName();
    private static final String STATUS_CACHE_CLIENT = StatusCacheClient.class.getName();
    private static final String STATUS_CACHE_CLIENT_LIST = StatusCacheClient.class.getName() + ".list";
    private static StatusCacheClientProxy statusCacheClientProxy = new StatusCacheClientProxy();

    public static void init(Repository rep) {
        String uuid = AdminContext.peek();
        AbstractStatusCache.setRepository(rep);
        if (uuid == null) {
            init = true;
        } else {
            AdminSubsystemServiceRegistry.addService((String)STATUS_CACHE_INITIALIZED, (Object)"true");
        }
    }

    public static void init(ConfigService configService) {
        String uuid = AdminContext.peek();
        AbstractStatusCache.setConfigService(configService);
        if (uuid == null) {
            init = true;
        } else {
            AdminSubsystemServiceRegistry.addService((String)STATUS_CACHE_INITIALIZED, (Object)"true");
        }
    }

    public static StatusCache getStatusCache() {
        String profileKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatusCache()");
        }
        if ((profileKey = AdminContext.peek()) != null) {
            return StatusCacheFactory.getStatusCache(profileKey);
        }
        if (!init) {
            return null;
        }
        if (Boolean.getBoolean("com.ibm.websphere.management.status.disable")) {
            cache = new DefaultStatusCache();
        }
        if (cache == null) {
            String adminType = AdminServiceFactory.getAdminService().getProcessType();
            cache = adminType.equals("DeploymentManager") ? new DeploymentManagerStatusCache() : (adminType.equals("NodeAgent") ? new NodeAgentStatusCache() : new AppServerStatusCache());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusCache()", cache);
        }
        return cache;
    }

    private static StatusCache getStatusCache(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatusCache(String), profile key " + profileKey);
        }
        StatusCache remoteCache = null;
        String initialize = (String)AdminSubsystemServiceRegistry.getService((String)STATUS_CACHE_INITIALIZED);
        if (!initialize.equals("true")) {
            return null;
        }
        if (Boolean.getBoolean("com.ibm.websphere.management.status.disable")) {
            remoteCache = new DefaultStatusCache();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remoteCache is " + remoteCache);
        }
        if (remoteCache == null && (remoteCache = (StatusCache)AdminSubsystemServiceRegistry.getService((String)STATUS_CACHE)) == null) {
            String adminType = AdminServiceFactory.getAdminService().getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminType is " + adminType);
            }
            remoteCache = new NodeAgentStatusCache();
            AdminSubsystemServiceRegistry.addService((String)STATUS_CACHE, (Object)remoteCache);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusCache(String)");
        }
        return remoteCache;
    }

    protected static void setReport(StatusReport report) {
        String uuid = AdminContext.peek();
        StatusCacheClient[] array = new StatusCacheClient[]{};
        if (uuid == null) {
            array = clients.toArray(new StatusCacheClient[0]);
        } else {
            ArrayList remoteClients = (ArrayList)AdminSubsystemServiceRegistry.getService((String)STATUS_CACHE_CLIENT_LIST);
            if (remoteClients != null) {
                array = remoteClients.toArray(new StatusCacheClient[0]);
            }
        }
        for (int i = 0; i < array.length; ++i) {
            array[i].setReport(report);
        }
    }

    public static StatusCacheClient getStatusCacheClient(boolean new_object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatusCacheClient(" + new_object + ")");
        }
        StatusCacheClient client = StatusCacheFactory.getStatusCacheClientInternal(new_object);
        String adminType = AdminServiceFactory.getAdminService().getProcessType();
        if (adminType.equals("AdminAgent")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return StatusCacheClientProxy");
            }
            client = statusCacheClientProxy;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusCacheClient(" + new_object + ")");
        }
        return client;
    }

    static StatusCacheClient getStatusCacheClientInternal(boolean new_object) {
        String profileKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatusCacheClientInternal(" + new_object + ")");
        }
        if (tc.isDebugEnabled()) {
            String uuid = AdminContext.peek();
            try {
                throw new Exception("getStatusCacheClient(" + new_object + "), uuid=" + uuid);
            }
            catch (Exception ex) {
                Tr.debug(tc, "getStatusCacheClient stack trace", ex);
            }
        }
        if ((profileKey = AdminContext.peek()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatusCacheClient(" + new_object + ")");
            }
            return StatusCacheFactory.getStatusCacheClientInternal(new_object, profileKey);
        }
        if (new_object) {
            StatusCacheClient client = new StatusCacheClient();
            clients.add(client);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatusCacheClient(" + new_object + ")");
            }
            return client;
        }
        if (scc == null) {
            scc = new StatusCacheClient();
            clients.add(scc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusCacheClient(" + new_object + ")");
        }
        return scc;
    }

    private static synchronized StatusCacheClient getStatusCacheClientInternal(boolean new_object, String profileKey) {
        ArrayList<StatusCacheClient> remoteClientList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatusCacheClient new object " + new_object + " with profile key " + profileKey);
        }
        if ((remoteClientList = (ArrayList<StatusCacheClient>)AdminSubsystemServiceRegistry.getService((String)STATUS_CACHE_CLIENT_LIST)) == null) {
            remoteClientList = new ArrayList<StatusCacheClient>();
            AdminSubsystemServiceRegistry.addService((String)STATUS_CACHE_CLIENT_LIST, remoteClientList);
        }
        if (new_object) {
            StatusCacheClient remoteClient = new StatusCacheClient();
            remoteClientList.add(remoteClient);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatusCacheClient for new object");
            }
            return remoteClient;
        }
        StatusCacheClient remoteScc = (StatusCacheClient)AdminSubsystemServiceRegistry.getService((String)STATUS_CACHE_CLIENT);
        if (remoteScc == null) {
            remoteScc = new StatusCacheClient();
            remoteClientList.add(remoteScc);
            AdminSubsystemServiceRegistry.addService((String)STATUS_CACHE_CLIENT, (Object)remoteScc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatusCacheClient for old object");
        }
        return remoteScc;
    }
}

