/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

public class StatusCacheClient
implements NotificationListener {
    private static final TraceComponent tc = Tr.register(StatusCacheClient.class, null, null);
    private String mbean;
    private StatusCacheClient client = null;
    private StatusReport currentReport = null;
    private static final Integer STATUS_CACHE_LISTENER = new Integer(0);

    protected StatusCacheClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StatusCacheClient");
        }
        String nodeName = AdminServiceFactory.getAdminService().getNodeName();
        String serverName = AdminServiceFactory.getAdminService().getProcessName();
        this.mbean = "WebSphere:*,type=StatusCache,node=" + nodeName + ",process=" + serverName;
        this.listenForCacheReportNotifications(this.mbean);
        this.requestReport(this.mbean);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "StatusCacheClient");
        }
    }

    protected synchronized void setReport(StatusReport report) {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setReport, uuid:" + uuid, report);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "report: " + report.print());
        }
        this.currentReport = report;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReport");
        }
    }

    public StatusReport getReport() {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport, uuid: " + uuid);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "StatusCacheClient.getReport() Stack Trace", new Exception("StatusCacheClient.getReport(), uuid=" + uuid));
        }
        if (this.currentReport == null) {
            this.requestReport(this.mbean);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning report: " + (this.currentReport != null ? this.currentReport.print() : "(null)"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport: " + uuid, this.currentReport);
        }
        return this.currentReport;
    }

    public void requestReport(String mbean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReport", mbean);
        }
        ObjectName server = this.getMBean(mbean.toString());
        try {
            if (server == null) {
                Tr.debug(tc, "Could not request Status Cache report");
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking on" + server.toString());
            }
            this.invoke(server, "sendReport", null, null);
        }
        catch (MBeanException bean) {
            FFDCFilter.processException((Throwable)bean, (String)"com.ibm.ws.management.status.StatusCacheClient.requestReport", (String)"135", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not invoke function sendReport on: " + server);
                Tr.debug(tc, "Exception in requestReport", bean);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.StatusCacheClient.requestReport", (String)"142", (Object)this);
            Tr.debug(tc, "Exception in requestReport", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReport");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "StatusCacheClient.handleNotification, uuid:" + uuid, new Object[]{notification, handback});
        }
        if (handback.equals(STATUS_CACHE_LISTENER) && notification.getType().equals("websphere.status.report")) {
            ObjectName source = (ObjectName)notification.getSource();
            String process = source.getKeyProperty("process");
            String node = source.getKeyProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received a report from: " + process + " on node " + node);
            }
            StatusReport report = (StatusReport)notification.getUserData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Report: " + report);
            }
            if (report != null) {
                this.currentReport = report;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting new report: " + this.currentReport);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification", new Object[]{this.currentReport});
        }
    }

    private void listenForCacheReportNotifications(String mbean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listenForCacheReportNotifications");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName nodeagent = new ObjectName(mbean);
            adminService.addNotificationListenerExtended(nodeagent, this, null, STATUS_CACHE_LISTENER);
        }
        catch (JMException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.StatusCacheClient.listenForCacheReportNotifications", (String)"191", (Object)this);
            Tr.debug(tc, "JMX Exception in listenForCacheReportNotifications", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForCacheReportNotifications");
        }
    }

    private ObjectName getMBean(String filterString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{filterString});
        }
        try {
            ObjectName name = new ObjectName(filterString);
            Iterator iter = AdminServiceFactory.getAdminService().queryNames(name, null).iterator();
            if (iter.hasNext()) {
                ObjectName objectName = (ObjectName)iter.next();
                if (iter.hasNext()) {
                    Tr.debug(tc, "Multiple MBeans found when only one was expected");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean", new Object[]{objectName});
                }
                return objectName;
            }
        }
        catch (MalformedObjectNameException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.StatusCacheClient.getMBean", (String)"217", (Object)this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + filterString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(ObjectName name, String operation, Object[] params, String[] signature) throws MBeanException {
        Subject ownSubject;
        Subject savedSubject;
        block16: {
            Object object;
            block15: {
                Object var8_8;
                block14: {
                    String METHOD = "invoke";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invoke name = " + name + ", operation = " + operation + ", params = " + params, ", signature = " + signature);
                    }
                    savedSubject = null;
                    ownSubject = null;
                    ownSubject = SecurityHelper.getOwnedSubject();
                    try {
                        try {
                            if (ownSubject != null) {
                                savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                            }
                            if (name == null) {
                                Tr.error(tc, "Can not perform operation {0} on a null object name", operation);
                                var8_8 = null;
                                Object var10_14 = null;
                                if (ownSubject == null) return var8_8;
                                break block14;
                            }
                            try {
                                object = AdminServiceFactory.getAdminService().invoke(name, operation, params, signature);
                                break block15;
                            }
                            catch (InstanceNotFoundException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.StatusCacheClient.invoke", (String)"256", (Object)this);
                                Tr.error(tc, "Could not invoke an operation on object: " + name.toString() + ". The instance does not exist.");
                                break block16;
                            }
                            catch (ReflectionException rex) {
                                FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ws.management.status.StatusCacheClient.invoke", (String)"264", (Object)this);
                                Tr.error(tc, "Could not invoke an operation on object: " + name.toString() + " because of a reflection error.");
                                break block16;
                            }
                            catch (MBeanException mbex) {
                                FFDCFilter.processException((Throwable)mbex, (String)"com.ibm.ws.management.status.StatusCacheClient.invoke", (String)"272", (Object)this);
                                if (!tc.isDebugEnabled()) throw mbex;
                                Tr.debug(tc, "MBean Exception in invoke, rethrowing", mbex);
                                throw mbex;
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.StatusCacheClient.invoke", (String)"280", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in StatusCacheClient:" + e);
                            }
                            Object var10_17 = null;
                            if (ownSubject == null) return null;
                            SecurityHelper.popInvocationSubject(savedSubject);
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        if (ownSubject == null) throw throwable;
                        SecurityHelper.popInvocationSubject(savedSubject);
                        throw throwable;
                    }
                }
                SecurityHelper.popInvocationSubject(savedSubject);
                return var8_8;
            }
            Object var10_15 = null;
            if (ownSubject == null) return object;
            SecurityHelper.popInvocationSubject(savedSubject);
            return object;
        }
        Object var10_16 = null;
        if (ownSubject == null) return null;
        SecurityHelper.popInvocationSubject(savedSubject);
        return null;
    }
}

