/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.AppServerStatusReport;
import com.ibm.ws.management.status.ExecutionState;
import com.ibm.ws.management.status.StatusReport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class NodeAgentStatusReport
extends AbstractStatusReport
implements Serializable {
    private static final long serialVersionUID = 31678516957423593L;
    protected Map server_states;
    protected Map server_reports;
    protected Map server_types;
    protected String node;
    protected static final TraceComponent tc = Tr.register(NodeAgentStatusReport.class.getName(), null, null);

    public NodeAgentStatusReport(Map servers, Map reports, Map types) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NodeAgentStatusReport", new Object[]{servers, reports, types});
        }
        this.type = 1;
        this.server_states = new Hashtable(servers);
        this.server_reports = new Hashtable(reports);
        this.server_types = new Hashtable(types);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NodeAgentStatusReport", new Object[]{this.timestamp});
        }
    }

    public Map getServerReports() {
        return this.server_reports;
    }

    public String getApplicationState(String application, String node, String server) {
        AppServerStatusReport report;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState", new Object[]{application, node, server});
        }
        if ((report = (AppServerStatusReport)this.server_reports.get(server)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationState - no report", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String retVal = report.getApplicationState(application, node, server);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationState", new Object[]{retVal});
        }
        return retVal;
    }

    public String getMessageListenerState(String port, String node, String server) {
        AppServerStatusReport report;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageListenerState", new Object[]{port, node, server});
        }
        if ((report = (AppServerStatusReport)this.server_reports.get(server)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMessageListenerState - no report", new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String retVal = report.getMessageListenerState(port, node, server);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListenerState", new Object[]{retVal});
        }
        return retVal;
    }

    public String print() {
        StringBuffer buff = new StringBuffer();
        buff.append("Node: ");
        buff.append(this.node);
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this.server_states.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("Server: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\nReport: ");
            buff.append(this.server_reports.get(me.getKey()));
            if (this.server_reports.get(me.getKey()) != null) {
                buff.append(((StatusReport)this.server_reports.get(me.getKey())).print());
            }
            buff.append("\n");
            buff.append("\n");
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }

    public String getClusterState(String clust) {
        return "";
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String s) {
        this.node = s;
    }

    public String getServerState(String node, String serverName) {
        String trans;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerState", new Object[]{node, serverName});
        }
        if ((trans = ExecutionState.transition((String)((String)this.server_states.get(serverName)))) == null || "ExecutionState.UNKNOWN".equals(trans)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerState - ExecutionState.STOPPED");
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerState - " + trans);
        }
        return trans;
    }

    public String getServerType(String node, String server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", new Object[]{node, server});
        }
        String trans = (String)this.server_types.get(server);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Type", trans);
        }
        if (trans == null || trans.trim().equals("")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerType", "");
            }
            return "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", trans);
        }
        return trans;
    }

    public String getNodeState(String s) {
        return "ExecutionState.STARTED";
    }

    public String[] getNodes() {
        return null;
    }

    public String[] getServers(String node) {
        String[] serv = this.server_states.keySet().toArray(new String[0]);
        return serv;
    }
}

