/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.ExecutionState;
import java.util.Map;
import java.util.Set;

public class AppServerStatusReport
extends AbstractStatusReport {
    private static final long serialVersionUID = 31678516957423591L;
    protected Map cache;
    protected Map ports;
    protected Map server_types;
    protected String server;
    protected String node;
    protected static final TraceComponent tc = Tr.register(AppServerStatusReport.class.getName(), null, null);

    public AppServerStatusReport(Map c) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppServerStatusReport", new Object[]{c});
        }
        this.type = 0;
        this.cache = c;
        this.ports = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppServerStatusReport", new Object[]{this.timestamp});
        }
    }

    public AppServerStatusReport(Map c, Map p, Map types) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppServerStatusReport", new Object[]{c, p, types});
        }
        this.type = 0;
        this.cache = c;
        this.ports = p;
        this.server_types = types;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppServerStatusReport", new Object[]{this.timestamp});
        }
    }

    public String getMessageListenerState(String portName, String node, String server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageListenerState", new Object[]{portName, node, server});
        }
        if (this.ports == null) {
            return "ExecutionState.NOT_INSTALLED";
        }
        String trans = ExecutionState.transition((String)((String)this.ports.get(portName)));
        if (trans == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMessageListenerState - ExecutionState.STOPPED");
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageListenerState - " + trans);
        }
        return trans;
    }

    public String getApplicationState(String appName, String node, String server) {
        String trans;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState", new Object[]{appName, node, server});
        }
        if ((trans = ExecutionState.transition((String)((String)this.cache.get(appName)))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationState - ExecutionState.NOT_INSTALLED");
            }
            return "ExecutionState.NOT_INSTALLED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationState - " + trans);
        }
        return trans;
    }

    public String[] getApplications(String node, String server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplications", new Object[]{node, server});
        }
        Set applications = this.cache.keySet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplications");
        }
        return applications.toArray(new String[0]);
    }

    public String print() {
        StringBuffer buff = new StringBuffer();
        buff.append("Server: ");
        buff.append(this.server);
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this.cache.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("App: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\n");
            buff.append("\n");
        }
        if (this.ports != null) {
            Set portEntrySet = this.ports.entrySet();
            for (Map.Entry pme : portEntrySet) {
                buff.append("Port: ");
                buff.append(pme.getKey());
                buff.append("\nState: ");
                buff.append(pme.getValue());
                buff.append("\n");
                buff.append("\n");
            }
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }

    public String getClusterState(String clust) {
        return "";
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getServerState(String nodeName, String serverName) {
        return "ExecutionState.STARTED";
    }

    public String getServerType(String node, String server) {
        String type;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", new Object[]{node, server});
        }
        if ((type = (String)this.server_types.get(server)) == null) {
            type = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", new Object[]{type});
        }
        return type;
    }

    public String getNodeState(String nodeName) {
        return "ExecutionState.STARTED";
    }

    public String[] getNodes() {
        return null;
    }

    public String[] getServers(String node) {
        return null;
    }
}

