/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.status.AbstractStatusCache;
import com.ibm.ws.management.status.AppServerStatusReportExt;
import com.ibm.ws.management.status.StatusCacheExtension;
import com.ibm.ws.management.status.StatusReportExtendedData;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class AppServerStatusCache
extends AbstractStatusCache {
    private static final TraceComponent tc = Tr.register(AppServerStatusCache.class, null, null);
    private static final String CLASS_NAME = "com.ibm.ws.management.status.AppServerStatusCache";
    private static final String DMZ_PRODUCT_SHORT_NAME = "NDDMZ";

    protected AppServerStatusCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppServerStatusCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppServerStatusCache");
        }
    }

    protected void createStatusCacheExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensions");
        }
        this._statusCacheExtensionClasses = this.createStatusCacheExtensionClassList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numExt=" + this._statusCacheExtensionClasses.length);
        }
        this._statusCacheExtensions = new StatusCacheExtension[this._statusCacheExtensionClasses.length];
        for (int i = 0; i < this._statusCacheExtensionClasses.length; ++i) {
            String className = null;
            try {
                className = this._statusCacheExtensionClasses[i];
                Class<?> extenderClass = Class.forName(className);
                Object o = extenderClass.newInstance();
                if (o instanceof StatusCacheExtension) {
                    this._statusCacheExtensions[i] = (StatusCacheExtension)o;
                    continue;
                }
                Exception e = new Exception("Class \"" + className + "\" does not implement required interface.");
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AppServerStatusCache.requestReport", (String)"106", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid extension class \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
                continue;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AppServerStatusCache.requestReport", (String)"110", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to instantiate extension \"" + className + "\".", e);
                }
                this._statusCacheExtensions[i] = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensions");
        }
    }

    protected String[] createStatusCacheExtensionClassList() {
        String[] stringArray;
        String prodShortName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStatusCacheExtensionClassList");
        }
        try {
            ManagedObjectMetadataHelper metadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
            AdminService adminService = AdminServiceFactory.getAdminService();
            String thisNodeName = adminService.getNodeName();
            prodShortName = metadataHelper.getNodeBaseProductShortName(thisNodeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Product short name: " + prodShortName);
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.status.AppServerStatusCache.createStatusCacheExtensionClassList", (String)"128", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get product short name.  Assuming it's not NDDMZ.", th);
            }
            prodShortName = "";
        }
        if (DMZ_PRODUCT_SHORT_NAME.equals(prodShortName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "com.ibm.ws.management.bla.runtime.AppServerStatusCacheExtension";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "com.ibm.ws.management.bla.runtime.AppServerStatusCacheExtension";
            stringArray = stringArray3;
            stringArray3[1] = "com.ibm.ws.webservices.admin.status.AppServerStatusCacheExtension";
        }
        String[] extClassList = stringArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStatusCacheExtensionClassList", extClassList);
        }
        return extClassList;
    }

    public void registerEvents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvents");
        }
        this.listenForLocalApplicationNotifications();
        this.listenForMessageListenerNotifications();
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            if (extension2 == null) continue;
            extension2.registerEvents(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvents");
        }
    }

    public void _sendReport(Boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport - force", new Object[]{force});
        }
        if (force.equals(Boolean.TRUE)) {
            this.refreshCache(true);
        }
        this._sendReport();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport - force");
        }
    }

    public void _sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_sendReport");
        }
        HashMap server_type = AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess") ? this.generateServerTypes() : new HashMap();
        AppServerStatusReportExt report = new AppServerStatusReportExt(this._app_state, this._port_state, server_type);
        report.setCell(this._cellName);
        report.setNode(this._nodeName);
        report.setServer(this._serverName);
        if (AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            try {
                this._app_deployments = this.getDeployments();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting deployments", e);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AppServerStatusCache._sendReport", (String)"121", (Object)this);
            }
            report.setDeployments(this._app_deployments);
            report.generate();
        }
        for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
            StatusReportExtendedData extendedData;
            if (extension2 == null || (extendedData = extension2.getExtendedData(report)) == null) continue;
            report.setExtendedData(extendedData);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Src: " + this.getObjectName());
        }
        Notification notif = new Notification("websphere.status.report", this.getObjectName(), this._notif_num++);
        notif.setUserData(report);
        super.sendReportNotification(notif);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_sendReport");
        }
    }

    public String dumpCache() {
        StringBuffer buff = new StringBuffer();
        buff.append("Server: ");
        buff.append(this._serverName);
        buff.append("\n");
        buff.append("---------------------\n");
        Set entrySet = this._app_state.entrySet();
        for (Map.Entry me : entrySet) {
            buff.append("App: ");
            buff.append(me.getKey());
            buff.append("\nState: ");
            buff.append(me.getValue());
            buff.append("\n");
            buff.append("\n");
        }
        Set portEntrySet = this._port_state.entrySet();
        for (Map.Entry pme : portEntrySet) {
            buff.append("Port: ");
            buff.append(pme.getKey());
            buff.append("\nState: ");
            buff.append(pme.getValue());
            buff.append("\n");
            buff.append("\n");
        }
        buff.append("END OF DUMP");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, handback});
        }
        String notificationType = notification.getType();
        if (handback.equals(CONTROL_ADMIN_LISTENER)) {
            if (notificationType.equals("websphere.ws390.servant.started")) {
                ServantMBeanStatus st = (ServantMBeanStatus)notification.getUserData();
                this._servant_up = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New Servant, refreshing the cache");
                }
                this.sendReport(new Boolean(true));
                return;
            }
        } else if (handback.equals(LOCAL_APP_LISTENER)) {
            Object tString;
            ObjectName source = (ObjectName)notification.getSource();
            String appname = source.getKeyProperty("name");
            if (EditionHelper.isEditionSupportEnabled()) {
                appname = source.getKeyProperty("mbeanIdentifier");
                tString = appname.split("/");
                appname = tString[5];
                try {
                    appname = URLDecoder.decode(appname, "UTF-8");
                }
                catch (Exception ex) {
                    Tr.debug(tc, "Error URLDecoding mbean identifier appName: " + appname);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application changed is: " + appname);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notificationType);
            }
            if (notificationType.equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STOPPED");
                }
                tString = this._app_state;
                synchronized (tString) {
                    this._app_state.put(appname, "j2ee.state.stopped");
                }
            }
            if (notificationType.equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STOPPING");
                    Tr.debug(tc, "Application: " + appname + " is now STOPPED");
                }
                tString = this._app_state;
                synchronized (tString) {
                    this._app_state.put(appname, "j2ee.state.stopped");
                }
            }
            if (notificationType.equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now STARTING");
                }
                tString = this._app_state;
                synchronized (tString) {
                    this._app_state.put(appname, "j2ee.state.starting");
                }
            }
            if (notificationType.equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now RUNNING");
                }
                tString = this._app_state;
                synchronized (tString) {
                    this._app_state.put(appname, "j2ee.state.running");
                }
            }
            if (notificationType.equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + appname + " is now FAILED");
                }
                tString = this._app_state;
                synchronized (tString) {
                    this._app_state.put(appname, "j2ee.state.failed");
                }
            }
            this.sendReport();
        } else if (handback.equals(MESSAGE_PORT_LISTENER)) {
            ObjectName source = (ObjectName)notification.getSource();
            String portname = source.getKeyProperty("name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MessageListener changed is: " + portname);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Type: " + notificationType);
            }
            if (notificationType.equals("j2ee.state.stopped")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + portname + " is now STOPPED");
                }
                Map tString = this._port_state;
                synchronized (tString) {
                    this._port_state.put(portname, "j2ee.state.stopped");
                }
            }
            if (notificationType.equals("j2ee.state.stopping")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + portname + " is now STOPPING");
                }
                Map tString = this._port_state;
                synchronized (tString) {
                    this._port_state.put(portname, "j2ee.state.stopping");
                }
            }
            if (notificationType.equals("j2ee.state.starting")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + portname + " is now STARTING");
                }
                Map tString = this._port_state;
                synchronized (tString) {
                    this._port_state.put(portname, "j2ee.state.starting");
                }
            }
            if (notificationType.equals("j2ee.state.running")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + portname + " is now RUNNING");
                }
                Map tString = this._port_state;
                synchronized (tString) {
                    this._port_state.put(portname, "j2ee.state.running");
                }
            }
            if (notificationType.equals("j2ee.state.failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Message Port: " + portname + " is now FAILED");
                }
                Map tString = this._port_state;
                synchronized (tString) {
                    this._port_state.put(portname, "j2ee.state.failed");
                }
            }
            this.sendReport();
        } else {
            boolean handled = false;
            for (StatusCacheExtension extension2 : this._statusCacheExtensions) {
                if (extension2 == null) continue;
                handled |= extension2.handleNotification(notification, handback);
            }
            if (handled) {
                this.sendReport();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refreshCache(boolean force_refresh) {
        ConfigObject serverEntry;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshCache");
            }
            serverEntry = null;
            try {
                Object var5_3;
                try {
                    serverEntry = this.findServerEntry();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AppServerStatusCache.refreshCache", (String)"273", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when finding Server Entry", e);
                    }
                    var5_3 = null;
                    if (serverEntry == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server Entry was null, returning");
                        }
                        return;
                    }
                    break block29;
                }
                var5_3 = null;
                if (serverEntry != null) break block29;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (serverEntry != null) {
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Entry was null, returning");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server Entry was null, returning");
            }
            return;
        }
        Set cache_apps = this._app_state.keySet();
        Set se_apps = this.buildAppList(serverEntry);
        Iterator cache_it = cache_apps.iterator();
        while (cache_it.hasNext()) {
            String app = (String)cache_it.next();
            if (se_apps.contains(app)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove App: " + app + " from Cache as it is no longer in Server Entry");
            }
            force_refresh = true;
            cache_it.remove();
        }
        for (String app : se_apps) {
            if (cache_apps.contains(app)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Add App: " + app + " to Cache as it is new in Server Entry");
            }
            force_refresh = true;
            this._app_state.put(app, "j2ee.state.stopped");
        }
        if (force_refresh) {
            StringBuffer name = new StringBuffer("WebSphere:type=Application,node=");
            name.append(this._nodeName);
            name.append(",process=");
            name.append(this._serverName);
            name.append(",*");
            Set active = this.getMBeans(name.toString());
            Iterator act = active.iterator();
            while (act.hasNext()) {
                String appname = null;
                try {
                    ObjectName appON = (ObjectName)act.next();
                    appname = (String)AdminServiceFactory.getAdminService().getAttribute(appON, "name");
                    if (EditionHelper.isEditionSupportEnabled()) {
                        appname = appON.getKeyProperty("mbeanIdentifier");
                        String[] tString = appname.split("/");
                        appname = tString[5];
                        try {
                            appname = URLDecoder.decode(appname, "UTF-8");
                        }
                        catch (Exception ex) {
                            Tr.debug(tc, "Error URLDecoding mbean identifier appName: " + appname);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding App: " + appname + " to Cache as it is running");
                    }
                    this._app_state.put(appname, "j2ee.state.running");
                }
                catch (Exception mbe) {
                    FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.AppServerStatusCache.refreshCache", (String)"323", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught MBean Exception - refreshCache", mbe);
                }
            }
        }
        StringBuffer portname = new StringBuffer("WebSphere:type=ListenerPort,node=");
        portname.append(this._nodeName);
        portname.append(",process=");
        portname.append(this._serverName);
        portname.append(",*");
        Set active_port = this.getMBeans(portname.toString());
        Iterator actPort = active_port.iterator();
        while (actPort.hasNext()) {
            String pname = null;
            Boolean status = null;
            try {
                ObjectName port = (ObjectName)actPort.next();
                pname = port.getKeyProperty("name");
                status = (Boolean)AdminServiceFactory.getAdminService().getAttribute(port, "started");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Port: " + pname + " to Cache Running: " + status);
                }
                if (status.booleanValue()) {
                    this._port_state.put(pname, "j2ee.state.running");
                    continue;
                }
                this._port_state.put(pname, "j2ee.state.stopped");
            }
            catch (Exception mbe) {
                FFDCFilter.processException((Throwable)mbe, (String)"com.ibm.ws.management.status.AppServerStatusCacherefreshCache", (String)"354", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Caught MBean Exception - refreshCache", mbe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCache");
        }
    }

    protected void listenForCacheReportNotifications() {
    }

    protected void listenForJ2EEStateNotifications() {
    }

    public void requestReport(String contact, Boolean force) {
        this.sendReport(force);
    }

    public void requestReport(String contact) {
        this.sendReport();
    }

    public void requestReport(Boolean force) {
        this.sendReport(force);
    }

    public synchronized void addToCache(int type, String name, String state) {
        if (type == 2) {
            this._app_state.put(name, state);
            this.refreshCache(false);
            this.sendReport();
        }
    }

    public synchronized void removeFromCache(int type, String name) {
        if (type == 2) {
            this._app_state.remove(name);
            this.refreshCache(false);
            this.sendReport();
        }
    }

    protected void listenForMessageListenerNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForMessageListenerNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer query_name = new StringBuffer("WebSphere:type=ListenerPort,node=");
                query_name.append(this._nodeName);
                query_name.append(",process=");
                query_name.append(this._serverName);
                query_name.append(",*");
                ObjectName app = new ObjectName(query_name.toString());
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("j2ee.state.stopping");
                filter.enableType("j2ee.state.stopped");
                filter.enableType("j2ee.state.starting");
                filter.enableType("j2ee.state.running");
                filter.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(app, this, filter, MESSAGE_PORT_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AppServerStatusCache.listenForMessageListenerNotifications", (String)"432", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught JMX Exception - listenForMessageListenerNotifications", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForMessageListenerNotifications");
        }
    }

    protected void listenForLocalApplicationNotifications() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listenForLocalApplicationNotifications");
            }
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                StringBuffer query_name = new StringBuffer("WebSphere:type=Application,node=");
                query_name.append(this._nodeName);
                query_name.append(",process=");
                query_name.append(this._serverName);
                query_name.append(",*");
                ObjectName app = new ObjectName(query_name.toString());
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("j2ee.state.stopping");
                filter.enableType("j2ee.state.stopped");
                filter.enableType("j2ee.state.starting");
                filter.enableType("j2ee.state.running");
                filter.enableType("j2ee.state.failed");
                adminService.addNotificationListenerExtended(app, this, filter, LOCAL_APP_LISTENER);
            }
            catch (JMException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AppServerStatusCache.listenForLocalApplicationNotifications", (String)"463", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught JMX Exception - listenForLocalApplicationNotifications", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listenForLocalApplicationNotifications");
        }
    }

    public synchronized void parentAdded(ServerInfo info) {
        String parent = info.getName();
        if (info.getNode().equals(this._nodeName) && info.getCell().equals(this._cellName) && parent.equals("nodeagent")) {
            this.sendReport();
        }
    }
}

