/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStatusReport
implements StatusReport,
Serializable {
    private static final long serialVersionUID = 31678516957423590L;
    protected static final TraceComponent tc = Tr.register(AbstractStatusReport.class.getName(), null, null);
    protected int type = -1;
    protected String cell = null;
    protected List nodes = new LinkedList();
    protected Map servers = new HashMap();
    protected Date timestamp = new Date();
    protected Map total_app_state = new HashMap();
    protected String _server;
    protected Set _back_level_nodes = new HashSet();
    protected Set _back_level_apps = new HashSet();
    protected Map _server_types = new HashMap();
    private static ManagedObjectMetadataHelper metaObjectHelper = null;
    protected transient Map deployments = null;
    protected transient Map cluster_xml;

    public Date getTimeStamp() {
        return this.timestamp;
    }

    public void setServer(String server) {
        this._server = server;
    }

    public String getServer() {
        return this._server;
    }

    public void setDeployments(Map dep) {
        this.deployments = dep;
    }

    public Map getDeployments() {
        return this.deployments;
    }

    public void setClusterInfo(Map clust) {
        this.cluster_xml = clust;
    }

    public Map getClusterInfo() {
        return this.cluster_xml;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String c) {
        this.cell = c;
    }

    public String getApplicationState(String appName) {
        String state;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState", appName);
        }
        Tr.debug(tc, "Back level apps: ", this._back_level_apps);
        boolean back_level = this._back_level_apps.contains(appName);
        if (back_level) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App is on Backlevel Node");
            }
            state = this.getAppState(appName, false);
        } else {
            state = (String)this.total_app_state.get(appName);
            if (state == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "State was NULL for app: " + appName);
                }
                state = "ExecutionState.UNAVAILABLE";
            }
            if (EditionHelper.isEditionSupportEnabled() && state.equalsIgnoreCase("ExecutionState.STOPPED")) {
                try {
                    String appState = EditionHelper.getEditionState((String)appName);
                    if (appState.equalsIgnoreCase("INACTIVE")) {
                        state = "ExecutionState.UNAVAILABLE";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationState", state);
        }
        return state;
    }

    public void generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generate");
        }
        if (metaObjectHelper == null) {
            try {
                ManagedObjectMetadataAccessor metaObjectAccess = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                metaObjectHelper = new ManagedObjectMetadataHelper(metaObjectAccess);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusReport.generate", (String)"150", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate Exception", e);
                }
                metaObjectHelper = null;
            }
        }
        this.generateAppState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generate");
        }
    }

    public void generateAppState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationState");
        }
        HashSet apps = new HashSet(this.deployments.keySet());
        for (String app : apps) {
            String state = this.getAppState(app, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App Name: " + app);
                Tr.debug(tc, "App State: " + state);
            }
            this.total_app_state.put(app, state);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateAppState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getServerType(String nodeName, String server) {
        boolean oldWay;
        String serverType;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_getServerType", new Object[]{nodeName, server});
            }
            serverType = "";
            oldWay = true;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "metaObjectHelper", metaObjectHelper);
                }
                if (metaObjectHelper != null) {
                    String ver;
                    if (metaObjectHelper.isNodeZOS(nodeName)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "isNodeZOS", nodeName);
                        }
                        ver = metaObjectHelper.getNodeMajorVersion(nodeName);
                        int version = Integer.parseInt(ver);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "version " + version);
                        }
                        if (version < 6) {
                            serverType = "APPLICATION_SERVER";
                            oldWay = false;
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Distributed Node", nodeName);
                        }
                        ver = metaObjectHelper.getNodeMajorVersion(nodeName);
                        int version = Integer.parseInt(ver);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "version " + version);
                        }
                        if (version < 6) {
                            serverType = "BACK_LEVEL";
                            oldWay = false;
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "Exception caught - 1 ", ex);
            }
        }
        if (oldWay) {
            try {
                try {
                    serverType = this.getServerType(nodeName, server);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught - 2", e);
                    }
                    serverType = "APPLICATION_SERVER";
                    Object var8_11 = null;
                    if (serverType == null) {
                        serverType = "";
                    }
                }
                Object var8_10 = null;
                if (serverType == null) {
                    serverType = "";
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (serverType == null) {
                    serverType = "";
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getServerType", new Object[]{serverType});
        }
        return serverType;
    }

    protected String getAppState(String appName) {
        return this.getAppState(appName, false);
    }

    public String getAppState(String appName, boolean fast) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppState - " + appName + "  " + fast);
        }
        ConfigObject deployment = this.deployments == null ? null : (ConfigObject)this.deployments.get(appName);
        List l = deployment == null ? null : deployment.getObjectList("deploymentTargets");
        Iterator serverDeployments = l == null ? null : l.iterator();
        String status = "ExecutionState.UNAVAILABLE";
        if (serverDeployments != null && serverDeployments.hasNext()) {
            int targetCount = 0;
            int startedCount = 0;
            int stoppedCount = 0;
            while (serverDeployments.hasNext()) {
                try {
                    ConfigObject target = (ConfigObject)serverDeployments.next();
                    String deploymentTargetName = target.getString("name", "__null__");
                    if (deploymentTargetName == null) continue;
                    if (target.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi", "ClusteredTarget")) {
                        if (AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "target is Clustered_Target. Not applicable on a Standalone process");
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cluster Target - " + deploymentTargetName);
                        }
                        ConfigObject serverCluster = (ConfigObject)this.cluster_xml.get(deploymentTargetName);
                        List serverClusterMembers = serverCluster.getObjectList("members");
                        for (ConfigObject clusterMember : serverClusterMembers) {
                            String clusterMemberNodeName = clusterMember.getString("nodeName", "__null__");
                            String clusterMemberMemberName = clusterMember.getString("memberName", "__null__");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "BackLevel", new Object[]{clusterMemberNodeName, this._back_level_nodes});
                            }
                            if (this._back_level_nodes.contains(clusterMemberNodeName)) {
                                this._back_level_apps.add(appName);
                            }
                            String serverType = this._getServerType(clusterMemberNodeName, clusterMemberMemberName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server Type - " + serverType);
                            }
                            if ("BACK_LEVEL".equals(serverType)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "BackLevel Node, increasing target");
                                }
                                ++targetCount;
                                ++stoppedCount;
                            } else if (serverType.equals("APPLICATION_SERVER") || serverType.equals("DEPLOYMENT_MANAGER") || serverType.equals("PROXY_SERVER") || serverType.equals("ONDEMAND_ROUTER")) {
                                ++targetCount;
                            }
                            if (fast && "BACK_LEVEL".equals(serverType)) continue;
                            String serverState = this.getServerState(clusterMemberNodeName, clusterMemberMemberName);
                            if (serverState.equals("ExecutionState.STARTED")) {
                                if (this.getApplicationState(appName, clusterMemberNodeName, clusterMemberMemberName).equals("ExecutionState.STARTED")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Application Started - " + appName);
                                    }
                                    ++startedCount;
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Stopped - " + appName);
                                }
                                ++stoppedCount;
                                continue;
                            }
                            if (!serverState.equals("ExecutionState.STOPPED")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server Stopped implies Application Stopped - " + appName);
                            }
                            ++stoppedCount;
                        }
                        continue;
                    }
                    String serverTargetNodeName = target.getString("nodeName", "__null__");
                    String serverTargetName = target.getString("name", "__null__");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "BackLevel", new Object[]{serverTargetNodeName, this._back_level_nodes});
                    }
                    if (this._back_level_nodes.contains(serverTargetNodeName)) {
                        this._back_level_apps.add(appName);
                    }
                    String serverType = this._getServerType(serverTargetNodeName, serverTargetName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Type - " + serverType);
                    }
                    if ("BACK_LEVEL".equals(serverType)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "BackLevel Node, increasing target");
                        }
                        ++targetCount;
                        ++stoppedCount;
                    } else {
                        if (!serverType.equals("APPLICATION_SERVER") && !serverType.equals("DEPLOYMENT_MANAGER") && !serverType.equals("PROXY_SERVER") && !serverType.equals("ONDEMAND_ROUTER")) continue;
                        ++targetCount;
                    }
                    if (!fast || !"BACK_LEVEL".equals(serverType)) {
                        String serverState = this.getServerState(serverTargetNodeName, deploymentTargetName);
                        if (serverState.equals("ExecutionState.STARTED")) {
                            Tr.debug(tc, "Server is Started: " + deploymentTargetName);
                            if (this.getApplicationState(appName, serverTargetNodeName, deploymentTargetName).equals("ExecutionState.STARTED")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Started - " + appName);
                                }
                                ++startedCount;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Stopped - " + appName);
                                }
                                ++stoppedCount;
                            }
                        } else if (serverState.equals("ExecutionState.STOPPED")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Server Stopped implies Application Stopped - " + appName);
                            }
                            ++stoppedCount;
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Server Target - " + serverTargetName);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AbstractStatusReport.getAppState", (String)"336", (Object)this);
                    Tr.debug(tc, "Failed to load cluster context while determining application status: {0}", ex);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server Target Count: " + targetCount);
                Tr.debug(tc, "Application Started Count: " + startedCount);
                Tr.debug(tc, "Application Stopped Count: " + stoppedCount);
            }
            status = targetCount == 0 ? "ExecutionState.UNAVAILABLE" : (targetCount == startedCount ? "ExecutionState.STARTED" : (startedCount == 0 ? (stoppedCount == 0 ? "ExecutionState.UNAVAILABLE" : "ExecutionState.STOPPED") : "ExecutionState.PARTIAL_START"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppState - " + status);
        }
        return status;
    }

    public abstract String[] getNodes();

    public abstract String[] getServers(String var1);

    public abstract String getApplicationState(String var1, String var2, String var3);

    public abstract String getServerState(String var1, String var2);

    public abstract String getServerType(String var1, String var2);

    public abstract String getNodeState(String var1);

    public abstract String getMessageListenerState(String var1, String var2, String var3);
}

