/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.AsyncListenerWrapper;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheExtension;
import com.ibm.ws.management.status.StatusReport;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

public abstract class AbstractStatusCache
extends RuntimeCollaborator
implements NotificationListener,
ConfigRepositoryListener,
RoutingListener,
StatusCache,
ConfigChangeListener {
    private static final String CLASS_NAME = "com.ibm.ws.management.status.AbstractStatusCache";
    protected static final TraceComponent tc = Tr.register(AbstractStatusCache.class.getName(), null, null);
    private static String resourceBundleName = "com.ibm.ws.management.resources.event";
    private TraceNLS nls = TraceNLS.getTraceNLS(resourceBundleName);
    protected String _process_type = "";
    public static String REPORT_TYPE = "websphere.status.report";
    protected String _cellName;
    protected String _nodeName;
    protected String _serverName;
    protected String _serverindexURI;
    protected Set _servers = null;
    protected Set _nodes = null;
    protected Set _clusters = null;
    protected Map _cluster_xml = null;
    protected Map _serverIndexes = null;
    protected Map _app_state = null;
    protected Map _port_state = Collections.synchronizedMap(new HashMap());
    protected Map _app_deployments = null;
    protected static Repository _static_repository = null;
    protected static ConfigService _static_configService = null;
    protected Repository _repository = null;
    protected ConfigService _configService = null;
    protected static String _repositoryURI = null;
    protected long _notif_num = 0L;
    protected boolean _servant_up = false;
    protected boolean _repository_init = false;
    protected static final Integer LOCAL_APP_LISTENER = new Integer(0);
    protected static final Integer CONTROL_ADMIN_LISTENER = new Integer(1);
    protected static final Integer NODE_AGENT_LISTENER = new Integer(2);
    protected static final Integer STATUS_CACHE_LISTENER = new Integer(3);
    protected static final Integer SERVER_LISTENER = new Integer(4);
    protected static final Integer CLUSTER_LISTENER = new Integer(5);
    protected static final Integer MESSAGE_PORT_LISTENER = new Integer(6);
    private static final String ABSTRACT_STATUS_CACHE_REPOSITORY = "com.ibm.ws.management.status.AbstractStatusCache.Repository";
    private static final String ABSTRACT_STATUS_CACHE_CONFIGSERVICE = "com.ibm.ws.management.status.AbstractStatusCache.ConfigService";
    protected String originalUUID;
    protected String[] _statusCacheExtensionClasses = null;
    protected StatusCacheExtension[] _statusCacheExtensions = null;
    private StatusCacheRefreshThreadDispatcher sendReportWithRefreshDispatcher = new StatusCacheRefreshThreadDispatcher(true);
    private StatusCacheRefreshThreadDispatcher sendReportNoRefreshDispatcher = new StatusCacheRefreshThreadDispatcher(false);

    protected AbstractStatusCache() {
        this.originalUUID = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractStatusCache, uuid:" + this.originalUUID);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        this._repository = this.originalUUID == null ? _static_repository : (Repository)AdminSubsystemServiceRegistry.getService((String)ABSTRACT_STATUS_CACHE_REPOSITORY);
        this._cellName = adminService.getCellName();
        this._nodeName = adminService.getNodeName();
        this._serverName = adminService.getProcessName();
        this._process_type = adminService.getProcessType();
        _repositoryURI = this._repository.getRootURI();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "\nIn AbstractStatusCache(), classname = " + this.getClass().getName() + "\ncellName = " + this._cellName + "\nnodeName = " + this._nodeName + "\nserverName = " + this._serverName + "\nprocess_type = " + this._process_type + "\nrepositoryURI = " + _repositoryURI + "\nuuid: " + this.originalUUID);
        }
        RoutingTable.getInstance().addRoutingListener(this);
        this.createStatusCacheExtensions();
        this.registerEvents();
        boolean error = false;
        Exception lastError = null;
        try {
            if (this.originalUUID == null) {
                this._configService = _static_configService != null ? _static_configService : (ConfigService)WsServiceRegistry.getService((Object)this, ConfigService.class);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating a new subsystem ConfigService");
                }
                this._configService = ConfigServiceFactory.createConfigService((String)_repositoryURI, (String)this._cellName, (String)this._nodeName, (String)this._serverName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"306", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unabled to get configservice", e);
            }
            error = true;
            lastError = e;
        }
        if (this.isNodeAgentOrAdminSubsystem()) {
            try {
                this._servers = this.getServers();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"319", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of servers", e);
                }
                error = true;
                lastError = e;
                this._servers = Collections.synchronizedSet(new HashSet());
            }
        }
        if ("DeploymentManager".equals(this._process_type)) {
            try {
                this._nodes = this.getNodes();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"332", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of node", e);
                }
                error = true;
                lastError = e;
                this._nodes = Collections.synchronizedSet(new HashSet());
            }
        }
        if (!this._process_type.equals("UnManagedProcess") && !this.isAdminAgentProcess()) {
            try {
                this._clusters = this.getClusters();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"347", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of clusters", e);
                }
                error = true;
                lastError = e;
                this._clusters = Collections.synchronizedSet(new HashSet());
            }
        }
        if (!this.isNodeAgentProcess()) {
            try {
                this._app_state = this.getApplications();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"362", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of applications / states", e);
                }
                error = true;
                lastError = e;
                this._app_state = Collections.synchronizedMap(new HashMap());
            }
        }
        if (!this.isNodeAgentProcess()) {
            try {
                this._app_deployments = this.getDeployments();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"378", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of applications / deployments", e);
                }
                error = true;
                lastError = e;
                this._app_deployments = Collections.synchronizedMap(new HashMap());
            }
        }
        if ("DeploymentManager".equals(this._process_type) && !this._process_type.equals("UnManagedProcess")) {
            try {
                this._cluster_xml = this.getClusterXML();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"394", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get Cluster Objects", e);
                }
                error = true;
                lastError = e;
                this._cluster_xml = Collections.synchronizedMap(new HashMap());
            }
        }
        if (this.isNodeAgentOrAdminSubsystem() || "UnManagedProcess".equals(this._process_type)) {
            try {
                this._serverIndexes = this.getServerIndexes(this._nodeName);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.AbstractStatusCache", (String)"410", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get ServerIndex", e);
                }
                error = true;
                lastError = e;
                this._serverIndexes = Collections.synchronizedMap(new HashMap());
            }
        }
        if (error) {
            Tr.debug(tc, "Error Starting StatusCache, check FFDC");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractStatusCache");
        }
    }

    protected String getCacheType() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type: " + this._process_type);
        }
        return this._process_type;
    }

    protected static void setRepository(Repository rep) {
        String uuid = AdminContext.peek();
        if (uuid == null) {
            _static_repository = rep;
        } else {
            AdminSubsystemServiceRegistry.addService((String)ABSTRACT_STATUS_CACHE_REPOSITORY, (Object)rep);
        }
    }

    protected static void setConfigService(ConfigService cfgService) {
        String uuid = AdminContext.peek();
        if (uuid == null) {
            _static_configService = cfgService;
        } else {
            AdminSubsystemServiceRegistry.addService((String)ABSTRACT_STATUS_CACHE_CONFIGSERVICE, (Object)cfgService);
        }
    }

    protected void sendReportNotification(Notification notif) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendNotification");
            }
            try {
                super.sendNotification(notif);
            }
            catch (MBeanException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.status.AbstractStatusCache.sendReportNotification", (String)"466", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "MBeanException on sendReportNotification - ", exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    public void sendReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReport");
        }
        if ("DeploymentManager".equals(this._process_type)) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this._sendReport(new Boolean(false));
            } else {
                this.refreshStatus(false);
            }
        } else if (this.isNodeAgentProcess()) {
            this._sendReport(new Boolean(false));
        } else {
            this.refreshStatus(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendReport");
        }
    }

    public void sendReport(Boolean force) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReport");
        }
        if ("DeploymentManager".equals(this._process_type)) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this._sendReport(force);
            } else {
                this.refreshStatus(false);
            }
        } else if ("NodeAgent".equals(this._process_type)) {
            this._sendReport(force);
        } else {
            this.refreshStatus(force);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendReport");
        }
    }

    public abstract void _sendReport();

    public abstract void _sendReport(Boolean var1);

    public abstract void refreshCache(boolean var1);

    public abstract void requestReport(String var1, Boolean var2);

    public abstract void requestReport(String var1);

    public abstract void requestReport(Boolean var1);

    public abstract String dumpCache();

    public abstract void handleNotification(Notification var1, Object var2);

    protected abstract void createStatusCacheExtensions();

    public abstract void registerEvents();

    protected abstract void listenForJ2EEStateNotifications();

    protected abstract void listenForCacheReportNotifications();

    protected abstract void listenForLocalApplicationNotifications();

    protected abstract void listenForMessageListenerNotifications();

    public abstract void addToCache(int var1, String var2, String var3);

    public abstract void removeFromCache(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invoke(ObjectName name, String operation, Object[] params, String[] signature) throws MBeanException {
        Subject ownSubject;
        Subject savedSubject;
        block20: {
            Object object;
            block19: {
                Object var7_7;
                block18: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "invoke", new Object[]{name, operation, params, signature});
                    }
                    savedSubject = null;
                    ownSubject = null;
                    ownSubject = SecurityHelper.getServerSubject();
                    try {
                        try {
                            if (ownSubject != null) {
                                savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                            }
                            if (name == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Can not perform operation invoke on a null object name", operation);
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invoke", null);
                                }
                                var7_7 = null;
                                Object var10_13 = null;
                                if (ownSubject == null) return var7_7;
                                break block18;
                            }
                            try {
                                Object ret = AdminServiceFactory.getAdminService().invoke(name, operation, params, signature);
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invoke", ret);
                                }
                                object = ret;
                                break block19;
                            }
                            catch (InstanceNotFoundException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AbstractStatusCache.invoke", (String)"607", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Could not invoke an operation on object: " + name.toString() + ". The instance does not exist.");
                                }
                                break block20;
                            }
                            catch (ReflectionException rex) {
                                FFDCFilter.processException((Throwable)rex, (String)"com.ibm.ws.management.status.AbstractStatusCache.invoke", (String)"610", (Object)this);
                                if (!tc.isDebugEnabled()) break block20;
                                Tr.debug(tc, "Could not invoke an operation on object: " + name.toString() + " because of a reflection error.");
                                break block20;
                            }
                        }
                        catch (MBeanException mbex) {
                            FFDCFilter.processException((Throwable)mbex, (String)"com.ibm.ws.management.status.AbstractStatusCache.invoke", (String)"614", (Object)this);
                            if (!tc.isDebugEnabled()) throw mbex;
                            Tr.debug(tc, "Caught an mbean exception..printing stacktrace and rethrowing", mbex);
                            throw mbex;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.invoke", (String)"618", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception in AbstractStatusCache:" + e);
                            }
                            Object var10_16 = null;
                            if (ownSubject == null) return null;
                            SecurityHelper.popInvocationSubject(savedSubject);
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        if (ownSubject == null) throw throwable;
                        SecurityHelper.popInvocationSubject(savedSubject);
                        throw throwable;
                    }
                }
                SecurityHelper.popInvocationSubject(savedSubject);
                return var7_7;
            }
            Object var10_14 = null;
            if (ownSubject == null) return object;
            SecurityHelper.popInvocationSubject(savedSubject);
            return object;
        }
        Object var10_15 = null;
        if (ownSubject == null) return null;
        SecurityHelper.popInvocationSubject(savedSubject);
        return null;
    }

    public Set getMBeans(String filterString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeans", new Object[]{filterString});
        }
        HashSet retVal = null;
        try {
            ObjectName name = new ObjectName(filterString);
            retVal = AdminServiceFactory.getAdminService().queryNames(name, null);
        }
        catch (MalformedObjectNameException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AbstractStatusCache.getMBeans", (String)"648", (Object)this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + filterString);
            retVal = new HashSet();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean", new Object[]{retVal});
        }
        return retVal;
    }

    public ObjectName getMBean(String filterString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean", new Object[]{filterString});
        }
        try {
            ObjectName name = new ObjectName(filterString);
            Iterator iter = AdminServiceFactory.getAdminService().queryNames(name, null).iterator();
            if (iter.hasNext()) {
                ObjectName objectName = (ObjectName)iter.next();
                if (iter.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Multiple MBeans found when only one was expected");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean", new Object[]{objectName});
                }
                return objectName;
            }
        }
        catch (MalformedObjectNameException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.AbstractStatusCache.getMBean", (String)"679", (Object)this);
            Tr.error(tc, "Invalid MBean filter passed to getMBean: " + filterString);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return null;
    }

    protected ConfigObject findServerEntry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findServerEntry");
        }
        List l = this._configService.getDocumentObjects(this._configService.createScope(3), "serverindex.xml");
        ConfigObject doc = (ConfigObject)l.get(0);
        List servers = doc.getObjectList("serverEntries");
        for (ConfigObject serverEntry : servers) {
            String servername = serverEntry.getString("serverName", "__null__");
            if (!this._serverName.equals(servername)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findServerEntry");
            }
            return serverEntry;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findServerEntry - null");
        }
        return null;
    }

    protected Set buildAppList(ConfigObject myentry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAppList");
        }
        HashSet<String> fin = new HashSet<String>();
        List apps = myentry.getStringList("deployedApplications");
        for (int i = 0; i < apps.size(); ++i) {
            String longName = (String)apps.get(i);
            StringTokenizer st = new StringTokenizer(longName, "/");
            LinkedList<String> list = new LinkedList<String>();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] tokens = list.toArray(new String[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding App: " + tokens[tokens.length - 1]);
            }
            fin.add(tokens[tokens.length - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAppList");
        }
        return fin;
    }

    public void registerServantStartup() {
        block5: {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName queryName = new ObjectName(adminService.getDomainName() + ":" + "type=ControlAdminService,node=" + this._nodeName + ",process=" + this._serverName + ",*");
                MBeanServer mbServer = adminService.getMBeanFactory().getMBeanServer();
                Set names = mbServer.queryNames(queryName, null);
                if (names.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService MBean not registered");
                    }
                } else {
                    Iterator iterator = names.iterator();
                    ObjectName controlAdmin = (ObjectName)iterator.next();
                    AdminServiceFactory.getAdminService().getMBeanFactory().getMBeanServer().addNotificationListener(controlAdmin, new AsyncListenerWrapper(this), (NotificationFilter)new ControlAdminServiceFilter(), (Object)CONTROL_ADMIN_LISTENER);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.registerServantStartup", (String)"793", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception on registerServerStartup ", e);
            }
        }
    }

    protected Map getApplications() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplications");
        }
        ConfigObject myentry = null;
        Map<String, String> map = Collections.synchronizedMap(new HashMap());
        myentry = this.findServerEntry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using ServerEntry: " + myentry);
        }
        if (myentry == null) {
            return map;
        }
        List apps = myentry.getStringList("deployedApplications");
        for (int i = 0; i < apps.size(); ++i) {
            String longName = (String)apps.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "longName=" + longName);
            }
            StringTokenizer st = new StringTokenizer(longName, "/");
            LinkedList<String> list = new LinkedList<String>();
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] tokens = list.toArray(new String[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding App: " + tokens[tokens.length - 1] + "  STOPPED");
            }
            map.put(tokens[tokens.length - 1], "j2ee.state.stopped");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplications");
        }
        return map;
    }

    protected Set getServers() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServers");
        }
        Set<String> v = Collections.synchronizedSet(new HashSet());
        String sdir = _repositoryURI + "/cells/" + this._cellName + "/nodes/" + this._nodeName + "/servers";
        File serverContexts = new File(sdir);
        File[] servers = serverContexts.listFiles();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].isDirectory()) continue;
            String serverName = servers[i].getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found server: " + serverName);
            }
            v.add(serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers");
        }
        return v;
    }

    protected Set getNodes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodes");
        }
        Set<String> v = Collections.synchronizedSet(new HashSet());
        String ndir = _repositoryURI + "/cells/" + this._cellName + "/nodes";
        File nodeContexts = new File(ndir);
        File[] nodes = nodeContexts.listFiles();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].isDirectory()) continue;
            String nodeName = nodes[i].getName();
            v.add(nodeName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodes");
        }
        return v;
    }

    protected Set getClusters() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusters");
        }
        Set<String> v = Collections.synchronizedSet(new HashSet());
        String ndir = _repositoryURI + "/cells/" + this._cellName + "/clusters";
        File clustContexts = new File(ndir);
        if (clustContexts.exists() && clustContexts.isDirectory()) {
            File[] clust = clustContexts.listFiles();
            for (int i = 0; i < clust.length; ++i) {
                if (!clust[i].isDirectory()) continue;
                String clustName = clust[i].getName();
                v.add(clustName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusters");
            }
        }
        return v;
    }

    protected Map getDeployments() throws Exception {
        ConfigObject serverIndex;
        Map<String, ConfigObject> v;
        String uuid;
        block18: {
            uuid = AdminContext.peek();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDeployments(), uuid=" + uuid);
            }
            v = Collections.synchronizedMap(new HashMap());
            ConfigScope configScope = this._configService.createScope(1);
            configScope.set(3, this._nodeName);
            configScope.set(0, this._cellName);
            String[] appsArray = configScope.list(null);
            if (appsArray != null) {
                for (int i = 0; i < appsArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App Name: ", appsArray[i]);
                    }
                    try {
                        configScope.set(1, appsArray[i]);
                        String[] deployments = configScope.list("deployments");
                        if (deployments == null) continue;
                        for (int j = 0; j < deployments.length; ++j) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Deployment Name: ", deployments[j]);
                            }
                            ConfigObject deployment = this.getDeploymentXML("deployments" + File.separator + deployments[j], configScope);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding deployment: " + deployments[j], deployment.getID());
                            }
                            v.put(deployments[j], deployment);
                        }
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.status.AbstractStatusCache.getDeployments", (String)"950", (Object)this);
                    }
                }
            }
            configScope.setDepth(3);
            serverIndex = null;
            try {
                serverIndex = (ConfigObject)this._configService.getDocumentObjects(configScope, "systemapps.xml").get(0);
            }
            catch (FileNotFoundException fnfe) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "systemapps.xml does not exist " + fnfe);
            }
        }
        List servers = null;
        if (serverIndex != null) {
            servers = serverIndex.getObjectList("serverEntries");
        }
        if (servers != null) {
            ConfigObject serverEntry = null;
            ConfigObject deployment2 = null;
            for (int i = 0; i < servers.size(); ++i) {
                serverEntry = (ConfigObject)servers.get(i);
                if (!this._serverName.equals(serverEntry.getString("serverName", "__null__"))) continue;
                List apps = serverEntry.getStringList("deployedApplications");
                for (int a = 0; a < apps.size(); ++a) {
                    String appName = (String)apps.get(a);
                    VariableMap variableMap = uuid == null ? (VariableMap)WsServiceRegistry.getService((Object)this, VariableMap.class) : (VariableMap)AdminSubsystemServiceRegistry.getService((String)VariableMap.class.getName());
                    appName = variableMap.expand(appName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App Name (after var expansion): ", appName);
                    }
                    deployment2 = this.getDeploymentXML(appName, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding system app deployment: " + appName, deployment2.getID());
                    }
                    v.put(appName, deployment2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployments", v);
        }
        return v;
    }

    private ConfigObject getDeploymentXML(String relativePath, ConfigScope scope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentXML", relativePath);
        }
        ConfigObject deployment = (ConfigObject)this._configService.getDocumentObjects(scope, relativePath + File.separator + "deployment.xml", false).get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentXML", deployment.getID());
        }
        return deployment;
    }

    protected Map getServerIndexes(String _nodeName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexes", _nodeName);
        }
        Map<String, ConfigObject> v = Collections.synchronizedMap(new HashMap());
        String ndir = _repositoryURI + "/cells/" + this._cellName + "/nodes/" + _nodeName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Root Dir: " + ndir);
        }
        ConfigObject serverIndex = null;
        List l = this._configService.getDocumentObjects(this._configService.getScope(3), "serverindex.xml", false);
        serverIndex = (ConfigObject)l.get(0);
        v.put(_nodeName, serverIndex);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexes", v);
        }
        return v;
    }

    protected Map getClusterXML() throws Exception {
        File clusterRoot;
        File[] clusterRootList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterXML");
        }
        Map<String, Object> v = Collections.synchronizedMap(new HashMap());
        String clusterRootdir = _repositoryURI + "/cells/" + this._cellName + "/clusters";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Root Dir: " + clusterRootdir);
        }
        if ((clusterRootList = (clusterRoot = new File(clusterRootdir)).listFiles()) == null) {
            return v;
        }
        for (int i = 0; i < clusterRootList.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClusterName: " + clusterRootList[i]);
            }
            Object serverCluster = null;
            if (clusterRootList[i] != null) {
                List l = this._configService.getDocumentObjects(null, clusterRootList[i] + "/cluster.xml", false);
                serverCluster = (ConfigObject)l.get(0);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster.xml: " + serverCluster.toString());
            }
            v.put(clusterRootList[i].getName(), serverCluster);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterXML");
        }
        return v;
    }

    private String[] tokenizeConfigURI(String configURI) {
        StringTokenizer st = new StringTokenizer(configURI, "/");
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] tokens = list.toArray(new String[0]);
        return tokens;
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onRepositoryEpochRefresh() {
    }

    public void onChangeStart(ConfigRepositoryEvent event2) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion", event2);
        }
        StatusCacheRefreshThread sct = new StatusCacheRefreshThread(event2);
        sct.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    public void _onChangeCompletion(final ConfigRepositoryEvent event2) {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        AbstractStatusCache.this._onChangeCompletion2(event2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                FFDCFilter.processException((Throwable)paex, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion", (String)"1108", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in doPriv() " + paex + " cause  = " + paex.getCause());
                }
                FFDCFilter.processException((Throwable)paex, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion", (String)"1110", (Object)this);
                if (paex.getCause() == null) break block3;
                paex.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion2(ConfigRepositoryEvent event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_onChangeCompletion2", event2);
        }
        ConfigChangeNotifier[] ccn = event2.getChanges();
        for (int i = 0; i < ccn.length; ++i) {
            String[] tokens = this.tokenizeConfigURI(ccn[i].getUri());
            if (tokens[0].equals("xformed")) {
                if (!tc.isEntryEnabled()) continue;
                Tr.entry(tc, "Skipping because its xformed", tokens);
                continue;
            }
            if (tokens[tokens.length - 1].equals("node.xml")) {
                if (!this._process_type.equals("DeploymentManager")) continue;
                String nodeName = tokens[tokens.length - 2];
                if (ccn[i].getChangeType() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Added to Cell: " + nodeName);
                    }
                    try {
                        this._nodes = this.getNodes();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1137", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of node", e);
                        }
                        this._nodes = Collections.synchronizedSet(new HashSet());
                    }
                    this.addToCache(1, nodeName, "j2ee.state.stopped");
                    continue;
                }
                if (ccn[i].getChangeType() != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node Removed from Cell: " + nodeName);
                }
                try {
                    this._nodes = this.getNodes();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1148", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unabled to get list of node", e);
                    }
                    this._nodes = Collections.synchronizedSet(new HashSet());
                }
                this.removeFromCache(1, nodeName);
                continue;
            }
            if (tokens[tokens.length - 1].equals("server.xml")) {
                if (!this.isNodeAgentOrAdminSubsystem()) continue;
                String serverName = tokens[tokens.length - 2];
                if (ccn[i].getChangeType() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server Added to Node: " + serverName);
                    }
                    try {
                        this._servers = this.getServers();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1165", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of servers", e);
                        }
                        this._servers = Collections.synchronizedSet(new HashSet());
                    }
                    this.addToCache(0, serverName, "j2ee.state.stopped");
                    continue;
                }
                if (ccn[i].getChangeType() != 1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Removed from Node: " + serverName);
                }
                try {
                    this._servers = this.getServers();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1176", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unabled to get list of servers", e);
                    }
                    this._servers = Collections.synchronizedSet(new HashSet());
                }
                this.removeFromCache(0, serverName);
                continue;
            }
            if (tokens[tokens.length - 1].equals("deployment.xml")) {
                block66: {
                    if (this._process_type.equals("UnManagedProcess") || this.isAdminAgentProcess() || this.isNodeAgentProcess() || this._process_type.equals("DeploymentManager")) {
                        String appName = tokens[tokens.length - 2];
                        if (ccn[i].getChangeType() == 0) {
                            block64: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Added: " + appName);
                                }
                                try {
                                    if (!this.isNodeAgentProcess()) {
                                        this._app_state = this.getApplications();
                                        this._app_deployments = this.getDeployments();
                                    }
                                    this.requestReport(Boolean.TRUE);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1201", (Object)this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unabled to get list of applications / states", e);
                                    }
                                    if (this.isNodeAgentProcess()) break block64;
                                    this._app_state = Collections.synchronizedMap(new HashMap());
                                    this._app_deployments = Collections.synchronizedMap(new HashMap());
                                }
                            }
                            if (!this.isNodeAgentProcess()) {
                                this.addToCache(2, appName, "j2ee.state.stopped");
                            }
                        } else if (ccn[i].getChangeType() == 1) {
                            block65: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Application Removed: " + appName);
                                }
                                try {
                                    if (!this.isNodeAgentProcess()) {
                                        this._app_state = this.getApplications();
                                        this._app_deployments = this.getDeployments();
                                    }
                                    this.requestReport(Boolean.TRUE);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1221", (Object)this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unabled to get list of applications / states", e);
                                    }
                                    if (this.isNodeAgentProcess()) break block65;
                                    this._app_state = Collections.synchronizedMap(new HashMap());
                                    this._app_deployments = Collections.synchronizedMap(new HashMap());
                                }
                            }
                            if (!this.isNodeAgentProcess()) {
                                this.removeFromCache(2, appName);
                            }
                        } else if (ccn[i].getChangeType() == 2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Application Modifed: " + appName);
                            }
                            try {
                                if (!this.isNodeAgentProcess()) {
                                    this._app_state = this.getApplications();
                                    this._app_deployments = this.getDeployments();
                                }
                                this.requestReport(Boolean.TRUE);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1240", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Unabled to get list of applications / states", e);
                                }
                                if (this.isNodeAgentProcess()) break block66;
                                this._app_state = Collections.synchronizedMap(new HashMap());
                                this._app_deployments = Collections.synchronizedMap(new HashMap());
                            }
                        }
                    }
                }
                this.sendReport();
                continue;
            }
            if (tokens[tokens.length - 1].equals("serverindex.xml")) {
                if (this.isNodeAgentProcess() && ccn[i].getChangeType() == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServerIndex Modifed: ");
                    }
                    try {
                        this._app_state = this.getApplications();
                        this._app_deployments = this.getDeployments();
                        this._serverIndexes = this.getServerIndexes(this._nodeName);
                        this.requestReport(Boolean.TRUE);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1262", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unabled to get list of applications / states", e);
                        }
                        this._app_state = Collections.synchronizedMap(new HashMap());
                        this._app_deployments = Collections.synchronizedMap(new HashMap());
                        this._serverIndexes = Collections.synchronizedMap(new HashMap());
                    }
                }
                this.sendReport();
                continue;
            }
            if (!tokens[tokens.length - 1].equals("cluster.xml") || !this._process_type.equals("DeploymentManager")) continue;
            String clusterName = tokens[tokens.length - 2];
            try {
                this._clusters = this.getClusters();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1278", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get list of servers", e);
                }
                this._clusters = Collections.synchronizedSet(new HashSet());
            }
            try {
                this._cluster_xml = this.getClusterXML();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache._onChangeCompletion2", (String)"1286", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unabled to get Cluster Objects", e);
                }
                this._cluster_xml = Collections.synchronizedMap(new HashMap());
            }
            if (ccn[i].getChangeType() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Added to Cell: " + clusterName);
                }
                this.addToCache(3, clusterName, "j2ee.state.stopped");
                continue;
            }
            if (ccn[i].getChangeType() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Removed from Cell: " + clusterName);
                }
                this.removeFromCache(3, clusterName);
                continue;
            }
            if (ccn[i].getChangeType() != 2 || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Cluster Modifed: " + clusterName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_onChangeCompletion2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map generateServerTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateServerTypes");
        }
        HashMap<String, String> v = new HashMap<String, String>();
        Map map = this._serverIndexes;
        synchronized (map) {
            ConfigObject serverIndex = (ConfigObject)this._serverIndexes.get(this._nodeName);
            if (serverIndex != null) {
                List list = serverIndex.getObjectList("serverEntries");
                for (ConfigObject serverEntry : list) {
                    String name = serverEntry.getString("serverName", "__null__");
                    String type = serverEntry.getString("serverType", "__null__");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Name - Type", new Object[]{name, type});
                    }
                    v.put(name, type);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateServerTypes", v);
        }
        return v;
    }

    public void placeReport(StatusReport report) {
    }

    public void childAdded(ServerInfo info) {
    }

    public void childRemoved(ServerInfo info) {
    }

    public void parentAdded(ServerInfo info) {
    }

    public void parentRemoved(ServerInfo info) {
    }

    private synchronized void refreshStatus(boolean refresh) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshStatus: " + refresh);
        }
        if (refresh) {
            this.sendReportWithRefreshDispatcher.refreshStatus();
        } else {
            this.sendReportNoRefreshDispatcher.refreshStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshStatus: " + refresh);
        }
    }

    public void configChanged(ConfigRepositoryEvent event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractStatusCache.configChanged()", event2);
        }
        try {
            this.onChangeCompletion(event2);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.management.status.AbstractStatusCacheconfigChanged()", (String)"1598", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractStatusCache.configChanged()");
        }
    }

    private boolean isNodeAgentOrAdminSubsystem() {
        String uuid = AdminContext.peek();
        return "NodeAgent".equals(this._process_type) || uuid != null && "AdminAgent".equals(this._process_type);
    }

    private boolean isNodeAgentProcess() {
        return "NodeAgent".equals(this._process_type);
    }

    private boolean isAdminAgentProcess() {
        return "AdminAgent".equals(this._process_type);
    }

    protected void checkAdminContext() {
        String uuid = AdminContext.peek();
        if (uuid == this.originalUUID || uuid != null && uuid.equals(this.originalUUID)) {
            return;
        }
        IllegalStateException ex = new IllegalStateException(this.getClass().getName() + " was created with uuuid: " + this.originalUUID + " but AdminContext is : " + uuid);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.status.NodeAgentStatusCache.checkAdminContext", (String)"1627", (Object)this);
        throw ex;
    }

    private class ControlAdminServiceFilter
    implements NotificationFilter {
        private static final long serialVersionUID = 7189930528471819230L;

        private ControlAdminServiceFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ControlAdminServiceFilter.isNotificationEnabled", notification.getType());
            }
            boolean enabled = false;
            if (notification.getType().equals("websphere.ws390.servant.started")) {
                enabled = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ControlAdminServiceFilter.isNotificationEnabled", new Boolean(enabled));
            }
            return enabled;
        }
    }

    class StatusCacheRefreshThread
    extends Thread {
        private boolean refresh = false;
        private StatusCacheRefreshThreadDispatcher dispatcher = null;
        private boolean send = false;
        private String contact = null;
        private ConfigRepositoryEvent event = null;
        private String uuid;

        public StatusCacheRefreshThread(ConfigRepositoryEvent e) {
            Tr.debug(tc, "Creating StatusCacheRefreshThread", e);
            this.send = false;
            this.event = e;
            this.uuid = AdminContext.peek();
        }

        public StatusCacheRefreshThread(boolean r) {
            Tr.debug(tc, "Creating StatusCacheRefreshThread", new Boolean(r));
            this.refresh = r;
            this.send = true;
            this.uuid = AdminContext.peek();
        }

        public StatusCacheRefreshThread(boolean r, StatusCacheRefreshThreadDispatcher dispatcher) {
            Tr.debug(tc, "Creating StatusCacheRefreshThread with dispatcher", new Boolean(r));
            this.refresh = r;
            this.send = true;
            this.uuid = AdminContext.peek();
            this.dispatcher = dispatcher;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "StatusCacheRefreshThread run:" + this.uuid + ", dispatcher: " + this.dispatcher);
            }
            if (this.dispatcher != null) {
                boolean hasWork = this.dispatcher.hasWork();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "first call to dispatcher.hasWork(),refresh=" + this.refresh + ",hasWork: " + hasWork);
                }
                while (hasWork) {
                    block8: {
                        try {
                            this.runPrivate();
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.status.AbstractStatusCache.run", (String)"1483", (Object)this);
                            if (!tc.isDebugEnabled()) break block8;
                            Tr.debug(tc, "problem calling runPrivate ", t);
                        }
                    }
                    hasWork = this.dispatcher.hasWork();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "subsequent call to dispatcher.hasWork(),refresh=" + this.refresh + ",hasWork: " + hasWork);
                }
            } else {
                this.runPrivate();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatusCacheRefreshThread run:" + this.uuid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runPrivate() {
            boolean pushed;
            block26: {
                block24: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "StatusCacheRefreshThread runPrivate:" + this.uuid);
                    }
                    pushed = false;
                    try {
                        pushed = AdminContext.push((String)this.uuid);
                        if (!AbstractStatusCache.this._repository_init) {
                            ConfigRepository rep = ConfigRepositoryFactory.getConfigRepository();
                            if (rep != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Repository init init, allow thread to continue");
                                }
                                AbstractStatusCache.this._repository_init = true;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Repository is not init yet, do not continue thread");
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "StatusCacheRefreshThread run");
                                }
                                Object var8_3 = null;
                                if (!pushed) {
                                    return;
                                }
                                break block24;
                            }
                        }
                        Subject savedSubject = null;
                        Subject ownSubject = null;
                        ownSubject = SecurityHelper.getServerSubject();
                        try {
                            try {
                                if (ownSubject != null) {
                                    savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
                                }
                                if (this.send) {
                                    AbstractStatusCache.this._sendReport(new Boolean(this.refresh));
                                } else {
                                    AbstractStatusCache.this._onChangeCompletion(this.event);
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.status.AbstractStatusCache.run", (String)"1533", (Object)this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception in AbstractStatusCache:" + e);
                                }
                                Object var6_8 = null;
                                if (ownSubject != null) {
                                    SecurityHelper.popInvocationSubject(savedSubject);
                                }
                                break block26;
                            }
                            Object var6_7 = null;
                            if (ownSubject == null) break block26;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            if (ownSubject == null) throw throwable;
                            SecurityHelper.popInvocationSubject(savedSubject);
                            throw throwable;
                        }
                        SecurityHelper.popInvocationSubject(savedSubject);
                        break block26;
                    }
                    catch (Throwable throwable) {
                        Object var8_5 = null;
                        if (!pushed) throw throwable;
                        AdminContext.pop();
                        throw throwable;
                    }
                }
                AdminContext.pop();
                return;
            }
            Object var8_4 = null;
            if (pushed) {
                AdminContext.pop();
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "StatusCacheRefreshThread runPrivate");
        }
    }

    class StatusCacheRefreshThreadDispatcher {
        private StatusCacheRefreshThread refreshThread = null;
        private boolean refresh;
        private boolean hasWork;

        StatusCacheRefreshThreadDispatcher(boolean refresh) {
            this.refresh = refresh;
        }

        public synchronized void refreshStatus() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshStatus");
            }
            this.hasWork = true;
            if (this.refreshThread == null) {
                this.refreshThread = new StatusCacheRefreshThread(this.refresh, this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "created new StatusCacheRefreshThread(" + this.refresh + "," + this.refreshThread + ")");
                }
                this.refreshThread.start();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "waking up possibly blocked StatusCacheRefreshThread:" + this.refreshThread);
                }
                this.notifyAll();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshStatus");
            }
        }

        public synchronized boolean hasWork() {
            boolean ret;
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "hasWork(), refreshThread:" + this.refreshThread);
                }
                if (!this.hasWork) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "hasWork: waiting for work");
                        }
                        this.wait(300000L);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "hasWork: now awake");
                        }
                    }
                    catch (Throwable t) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "hasWork: got exception while waiting", t);
                    }
                }
            }
            if (this.hasWork) {
                this.hasWork = false;
                ret = true;
            } else {
                this.refreshThread = null;
                ret = false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "hasWork(): " + ret + ",refreshThread: " + this.refreshThread);
            }
            return ret;
        }
    }
}

