/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository.client;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import java.util.HashMap;
import java.util.Properties;

public class LocalConfigRepositoryClient
implements ConfigRepositoryClient {
    ConfigRepository repository;

    public void connect(Properties connectInfo) throws ConnectorException {
        try {
            this.repository = ConfigRepositoryFactory.getConfigRepository();
            if (this.repository == null) {
                this.repository = ConfigRepositoryFactory.createConfigRepository((boolean)true);
                System.setProperty("com.ibm.ws.management.standalone", "true");
                this.repository.initialize(connectInfo);
            }
        }
        catch (AdminException e) {
            throw new ConnectorException(e);
        }
    }

    public void initialize(Properties p) throws AdminException {
        this.repository.initialize(p);
    }

    public DocumentDigest create(DocumentContentSource contents) throws RepositoryException {
        return this.repository.create(contents);
    }

    public DocumentDigest[] create(DocumentContentSource[] contents) throws RepositoryException {
        return this.repository.create(contents);
    }

    public void delete(String docURI) throws RepositoryException {
        this.repository.delete(docURI);
    }

    public void delete(Document doc) throws RepositoryException {
        this.repository.delete(doc);
    }

    public void delete(String[] docURIs) throws RepositoryException {
        this.repository.delete(docURIs);
    }

    public void delete(Document[] docs) throws RepositoryException {
        this.repository.delete(docs);
    }

    public void rename(String docURI, String newDocURI) throws RepositoryException {
        this.repository.rename(docURI, newDocURI);
    }

    public void rename(Document doc, Document newDoc) throws RepositoryException {
        this.repository.rename(doc, newDoc);
    }

    public DocumentContentSource extract(String docURI) throws RepositoryException {
        return this.repository.extract(docURI);
    }

    public DocumentContentSource extract(Document doc) throws RepositoryException {
        return this.repository.extract(doc);
    }

    public DocumentContentSource[] extract(String[] docURIs) throws RepositoryException {
        return this.repository.extract(docURIs);
    }

    public DocumentContentSource[] extract(Document[] docs) throws RepositoryException {
        return this.repository.extract(docs);
    }

    public DocumentDigest modify(DocumentContentSource contents) throws RepositoryException {
        return this.repository.modify(contents);
    }

    public DocumentDigest[] modify(DocumentContentSource[] contents) throws RepositoryException {
        return this.repository.modify(contents);
    }

    public HashMap update(DocumentContentSource[] create, DocumentContentSource[] modify, Document[] delete) throws RepositoryException {
        return this.repository.update(create, modify, delete);
    }

    public DocumentDigest getDigest(String docPath) throws RepositoryException {
        return this.repository.getDigest(docPath);
    }

    public DocumentDigest[] getDigest(String[] docURIs) throws RepositoryException {
        return this.repository.getDigest(docURIs);
    }

    public Boolean lockRepository(String reason) throws RepositoryException {
        return this.repository.lockRepository(reason);
    }

    public Boolean unlockRepository(String reason) throws RepositoryException {
        return this.repository.unlockRepository(reason);
    }

    public String[] listResourceNames(String parent, int type, int depth, ResourceNameFilter filter) {
        return this.repository.listResourceNames(parent, type, depth, filter);
    }

    public String[] listResourceNames(String parent, int type, int depth) {
        return this.repository.listResourceNames(parent, type, depth);
    }

    public Properties getConfig() {
        return this.repository.getConfig();
    }

    public void addListener(ConfigRepositoryListener listener) {
        this.repository.addListener(listener);
    }

    public void removeListener(ConfigRepositoryListener listener) {
        this.repository.removeListener(listener);
    }

    public ConfigEpoch getRepositoryEpoch() {
        return this.repository.getRepositoryEpoch();
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        return this.repository.refreshRepositoryEpoch();
    }

    public void createDigestFile(String docURI, boolean delete) throws RepositoryException {
        this.repository.createDigestFile(docURI, delete);
    }
}

