/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.DocumentUnavailableException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.FileUploadInputStream;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.ServantFileDocument;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ServantFileRepository
implements ConfigRepository,
ResourceNameFilter,
NotificationListener {
    private static TraceComponent tc = Tr.register(ServantFileRepository.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private Properties configProperties = null;
    private AdminService adminService = null;
    private ObjectName repositoryObjectName = null;
    private String repositoryDir;
    private String backupDir;
    private String tempDir;
    private static final int AVAILABLE = 0;
    private static final int UNAVAILABLE = 1;
    private static final int INVALID = 2;
    private File backupDirectory;
    private File tempDirectory;
    private FileTransferOptions ftOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
    private FileTransferConfig ftConfig = null;
    private ArrayList listeners;
    private Object[] listenersCopy;
    private boolean listenersUpdated = false;
    private static ServantFileRepository repository = new ServantFileRepository();
    private ServantFileDocument document;
    private String profileKey = null;
    private boolean initialized = false;

    public ServantFileRepository() {
    }

    public ServantFileRepository(String pKey) {
        this.profileKey = pKey;
    }

    public static ServantFileRepository getRepository() {
        return repository;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    private boolean exists(String docURI) {
        File f = new File(this.getRepositoryDir() + "/" + docURI.replace('\\', '/'));
        return f.exists();
    }

    private void fixURIs(DocumentContentSource[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            contents[i].getDocument().setURI(contents[i].getDocument().getURI().replace('\\', '/'));
        }
    }

    private void fixURIs(Document[] docs) {
        for (int i = 0; i < docs.length; ++i) {
            docs[i].setURI(docs[i].getURI().replace('\\', '/'));
        }
    }

    private int status(String docURI) {
        int result = 2;
        if (this.exists(docURI)) {
            result = 0;
        } else if (this.exists(docURI + ".digest")) {
            result = 1;
        }
        return result;
    }

    public DocumentContentSource extract(String docURI) throws RepositoryException {
        return this.extract(new Document(docURI));
    }

    public DocumentContentSource extract(Document doc) throws RepositoryException {
        Document[] d = new Document[]{doc};
        DocumentContentSource[] dcs = this.extract(d);
        return dcs[0];
    }

    public DocumentContentSource[] extract(String[] docURIs) throws RepositoryException {
        Document[] docs = new Document[docURIs.length];
        for (int i = 0; i < docs.length; ++i) {
            docs[i] = new Document(docURIs[i]);
        }
        return this.extract(docs);
    }

    public DocumentContentSource[] extract(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract[]");
        }
        if (docs == null) {
            return new DocumentContentSource[0];
        }
        this.fixURIs(docs);
        DocumentContentSource[] contents = this.extractInternal(docs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract[]");
        }
        return contents;
    }

    private DocumentContentSource[] extractInternal(Document[] docs) throws RepositoryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractInternal");
        }
        DocumentContentSource[] contents = new DocumentContentSource[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            int docStatus = this.status(docs[i].getURI());
            if (docStatus == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: invalid URI; " + docs[i].getURI());
                }
                throw new DocumentNotFoundException(docs[i].getURI());
            }
            if (docStatus == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "extract: unavailable URI; " + docs[i].getURI());
                }
                throw new DocumentUnavailableException(docs[i].getURI());
            }
            contents[i] = this.document.read(docs[i].getURI());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractInternal");
        }
        return contents;
    }

    public String[] listResourceNames(String parent, int type, int depth, ResourceNameFilter flt) {
        ResourceNameFilter filter;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "listResourceNames", parent);
        }
        if ((filter = flt) == null) {
            filter = this;
        }
        File pf = new File(this.getRepositoryDir() + "/" + parent);
        if (this.status(parent) == 2) {
            return new String[0];
        }
        if (depth == 0) {
            if (filter == this) {
                if (filter.accept(parent, "") && this.isMatchingType(pf, type)) {
                    return new String[]{parent};
                }
                return new String[0];
            }
            if (this.accept(parent, "") && filter.accept(parent, "") && this.isMatchingType(pf, type)) {
                return new String[]{parent};
            }
            return new String[0];
        }
        ArrayList list = new ArrayList();
        if (pf.list() != null) {
            this.addResourceNames(list, pf, type, depth - 1, filter);
        }
        if (list.size() > 0) {
            String[] ret = new String[list.size()];
            list.toArray(ret);
            return ret;
        }
        return new String[0];
    }

    public DocumentDigest getDigest(String docURI) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest: " + docURI);
        }
        if (this.status(docURI) == 2) {
            throw new DocumentNotFoundException(docURI);
        }
        DocumentDigestImpl d = this.document.getDigest(docURI);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest");
        }
        return d;
    }

    public DocumentDigest[] getDigest(String[] docURIs) throws DocumentNotFoundException, DocumentIOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigest[]");
        }
        DocumentDigest[] digests = new DocumentDigest[docURIs.length];
        for (int i = 0; i < docURIs.length; ++i) {
            digests[i] = this.getDigest(docURIs[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigest[]");
        }
        return digests;
    }

    private void addResourceNames(ArrayList list, File dir, int type, int depth, ResourceNameFilter filter) {
        File[] files = this.getFiles(dir);
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (filter == this) {
                    if (filter.accept(this.getUri(dir), files[i].getName()) && this.isMatchingType(files[i], type)) {
                        list.add(this.getUri(files[i]));
                    }
                } else if (this.accept(this.getUri(dir), files[i].getName()) && filter.accept(this.getUri(dir), files[i].getName()) && this.isMatchingType(files[i], type)) {
                    list.add(this.getUri(files[i]));
                }
                if (depth <= 0 || !files[i].isDirectory()) continue;
                this.addResourceNames(list, files[i], type, depth - 1, filter);
            }
        }
    }

    private File[] getFiles(File dir) {
        File[] origFiles = dir.listFiles();
        HashMap<String, File> files = new HashMap<String, File>();
        for (int i = 0; i < origFiles.length; ++i) {
            String name = origFiles[i].getName();
            if (name.endsWith(".digest")) {
                String docName = name.substring(0, name.lastIndexOf(".digest"));
                files.put(docName, new File(dir, docName));
                continue;
            }
            files.put(name, origFiles[i]);
        }
        File[] newFiles = new File[files.size()];
        int i = 0;
        for (Map.Entry e : files.entrySet()) {
            newFiles[i++] = (File)e.getValue();
        }
        return newFiles;
    }

    public String[] listResourceNames(String parent, int type, int depth) {
        return this.listResourceNames(parent, type, depth, this);
    }

    protected int getType(File file) {
        if (file.isDirectory()) {
            return 2;
        }
        return 1;
    }

    protected boolean isMatchingType(int type, int typeOptions) {
        return (type & typeOptions) != 0;
    }

    protected boolean isMatchingType(File file, int typeOptions) {
        int type = this.getType(file);
        return (type & typeOptions) != 0;
    }

    protected String getUri(File file) {
        String ap = file.getAbsolutePath();
        if (ap.length() <= this.getRepositoryDir().length()) {
            return "/";
        }
        return ap.substring(this.getRepositoryDir().length() + 1).replace('\\', '/');
    }

    public boolean accept(String parent, String name) {
        boolean result = true;
        if (parent.equals("/")) {
            result = !name.equals("backup") && !name.equals("temp");
        } else if (parent.equals("backup") || parent.startsWith("backup/") || parent.equals("temp") || parent.startsWith("temp/")) {
            result = false;
        }
        return result;
    }

    protected Object invoke(String opName, String[] signature, Object[] params) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "invoke");
        }
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
        }
        try {
            if (this.repositoryObjectName == null) {
                this.repositoryObjectName = this.getRepositoryName();
            }
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invoke", (String)"414", (Object)this);
            Tr.debug(tc, "MalformedObjectName Exception", e);
            throw new RepositoryException(e);
        }
        catch (ConnectorException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invoke", (String)"417", (Object)this);
            Tr.debug(tc, "Connector Error ", e);
            throw new RepositoryException(e);
        }
        catch (AdminException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invoke", (String)"420", (Object)this);
            Tr.debug(tc, "Admin Error", e);
            throw new RepositoryException(e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke: repositoryObjectName= " + this.repositoryObjectName);
        }
        return this.invokeMBean(this.repositoryObjectName, opName, signature, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeMBean(ObjectName objectName, String opName, String[] signature, Object[] params) throws RepositoryException {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " invokeMBean:" + opName + ",objectName= " + objectName);
        }
        Subject savedSubject = null;
        Subject ownSubject = null;
        ownSubject = SecurityHelper.getInvocationSubject();
        if (ownSubject == null) {
            ownSubject = SecurityHelper.getReceivedSubject();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject", ownSubject);
        }
        if (ownSubject != null) {
            savedSubject = SecurityHelper.pushInvocationSubject(ownSubject);
            System.out.println(ownSubject.toString());
        }
        try {
            try {
                object = this.adminService.invoke(objectName, opName, params, signature);
                Object var10_11 = null;
                if (ownSubject == null) return object;
            }
            catch (InstanceNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", (String)"448", (Object)this);
                throw new RepositoryException(e);
            }
            catch (MBeanException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", (String)"451", (Object)this);
                Exception t = e.getTargetException();
                if (!(t instanceof RepositoryException)) throw new RepositoryException(e);
                throw (RepositoryException)t;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.invokeMBean", (String)"458", (Object)this);
                throw new RepositoryException(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (ownSubject == null) throw throwable;
            SecurityHelper.popInvocationSubject(savedSubject);
            throw throwable;
        }
        SecurityHelper.popInvocationSubject(savedSubject);
        return object;
    }

    public void initialize(Properties props) throws AdminException {
        block45: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "initialize()", props);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "profileKey is: " + this.profileKey);
            }
            if (this.initialized) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Config repository already initialized");
                }
                return;
            }
            props = props == null ? new Properties() : (Properties)props.clone();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repository props:", props);
            }
            this.configProperties = props;
            this.listeners = new ArrayList();
            this.listenersUpdated = true;
            this.document = new ServantFileDocument();
            this.repositoryDir = System.getProperty("was.repository.root");
            if (this.repositoryDir == null || this.profileKey != null) {
                this.repositoryDir = props.getProperty("was.repository.root");
                if (this.repositoryDir == null) {
                    String installRoot = System.getProperty("user.install.root");
                    if (installRoot != null && !installRoot.equals("")) {
                        this.repositoryDir = installRoot + File.separator + "config";
                    } else {
                        installRoot = props.getProperty("user.install.root");
                        if (installRoot != null && !installRoot.equals("")) {
                            this.repositoryDir = installRoot + File.separator + "config";
                        }
                    }
                    if (this.repositoryDir == null) {
                        installRoot = System.getProperty("was.install.root");
                        if (installRoot != null && !installRoot.equals("")) {
                            this.repositoryDir = installRoot + File.separator + "config";
                        } else {
                            installRoot = props.getProperty("was.install.root");
                            if (installRoot != null && !installRoot.equals("")) {
                                this.repositoryDir = installRoot + File.separator + "config";
                            }
                        }
                    }
                }
            }
            if (this.repositoryDir == null) {
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("Neither was.repository.root nor was.install.root are set");
            }
            File f = new File(this.repositoryDir);
            if (!f.isDirectory()) {
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
            }
            try {
                this.repositoryDir = f.getCanonicalPath();
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"538", (Object)this);
                Tr.error(tc, "ADMR0001E");
                throw new AdminException("repositoryDir " + this.repositoryDir + " is not a valid directory");
            }
            String tempDirProp = System.getProperty("was.repository.temp");
            if (tempDirProp == null || this.profileKey != null) {
                tempDirProp = props.getProperty("was.repository.temp");
            }
            if (tempDirProp != null) {
                f = new File(tempDirProp);
                try {
                    String tempPath = f.getCanonicalPath();
                    if (tempPath.startsWith(this.repositoryDir + File.separator) && !tempPath.equals(this.repositoryDir + File.separator + "temp")) {
                        Tr.warning(tc, "ADMR0014W", tempDirProp);
                        tempDirProp = null;
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"560", (Object)this);
                    Tr.warning(tc, "ADMR0014W", tempDirProp);
                    tempDirProp = null;
                }
            }
            this.tempDir = tempDirProp != null ? tempDirProp : this.repositoryDir + File.separator + "temp";
            f = new File(this.tempDir);
            if (f.exists()) {
                if (!f.isDirectory()) {
                    Tr.warning(tc, "ADMR0014W", this.tempDir);
                    this.tempDir = this.repositoryDir + File.separator + "temp";
                }
            } else if (!f.mkdirs()) {
                Tr.warning(tc, "ADMR0014W", this.tempDir);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
            try {
                f = new File(this.tempDir);
                this.tempDir = f.getCanonicalPath();
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"594", (Object)this);
                this.tempDir = this.repositoryDir + File.separator + "temp";
            }
            String backupDirProp = System.getProperty("was.repository.backup");
            if (backupDirProp == null || this.profileKey != null) {
                backupDirProp = props.getProperty("was.repository.backup");
            }
            if (backupDirProp != null) {
                f = new File(backupDirProp);
                try {
                    String backupPath = f.getCanonicalPath();
                    if (backupPath.startsWith(this.repositoryDir + File.separator) && !backupPath.equals(this.repositoryDir + File.separator + "backup")) {
                        Tr.warning(tc, "ADMR0013W", backupDirProp);
                        backupDirProp = null;
                    }
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"615", (Object)this);
                    Tr.warning(tc, "ADMR0013W", backupDirProp);
                    backupDirProp = null;
                }
            }
            this.backupDir = backupDirProp != null ? backupDirProp : this.repositoryDir + File.separator + "backup";
            f = new File(this.backupDir);
            if (f.exists()) {
                if (!f.isDirectory()) {
                    this.backupDir = this.repositoryDir + File.separator + "backup";
                }
            } else if (!f.mkdirs()) {
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
            try {
                f = new File(this.backupDir);
                this.backupDir = f.getCanonicalPath();
            }
            catch (IOException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"649", (Object)this);
                this.backupDir = this.repositoryDir + File.separator + "backup";
            }
            this.tempDirectory = new File(this.tempDir);
            this.backupDirectory = new File(this.backupDir);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repositoryDir = " + this.repositoryDir);
                Tr.debug(tc, "tempDir = " + this.tempDir);
                Tr.debug(tc, "backupDir = " + this.backupDir);
            }
            this.tempDir = this.tempDir + File.separator;
            if (this.profileKey == null) {
                System.setProperty("was.repository.temp", this.tempDir);
            }
            this.configProperties.setProperty("was.repository.root", this.repositoryDir);
            this.configProperties.setProperty("was.repository.temp", this.tempDir);
            this.configProperties.setProperty("was.repository.backup", this.backupDir);
            this.ftOptions.setDeleteSourceOnCompletion(true);
            this.ftOptions.setOverwrite(true);
            this.ftConfig = new FileTransferConfigImpl();
            this.ftConfig.setSecurityEnabled(false);
            this.document.setRepository(this);
            try {
                this.adminService = AdminServiceFactory.getAdminService();
                String cellName = this.adminService.getCellName();
                String nodeName = this.adminService.getNodeName();
                String processName = this.adminService.getProcessName();
                String query = "WebSphere:process=" + processName + ",type=" + "ConfigRepository" + ",cell=" + cellName + ",node=" + nodeName + ",*";
                ObjectName queryName = new ObjectName(query);
                this.adminService.addNotificationListenerExtended(queryName, this, null, null);
            }
            catch (MalformedObjectNameException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.initialize", (String)"687", (Object)this);
                if (!tc.isDebugEnabled()) break block45;
                Tr.debug(tc, "MalformedObjectName Error", e);
            }
        }
        this.initialized = true;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public FileTransferOptions getFileTransferOptions() {
        return this.ftOptions;
    }

    public void setFileTransferConfig(FileTransferConfig config) {
        this.ftConfig = config;
        this.document.setRepository(this);
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public DocumentDigest create(DocumentContentSource contents) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " create()", contents);
        }
        this.fixContentForTransport(contents);
        String opName = "create";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest)this.invoke(opName, signature, params);
    }

    public DocumentDigest[] create(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "create()", contents);
        }
        for (int i = 0; i < contents.length; ++i) {
            this.fixContentForTransport(contents[i]);
        }
        String opName = "create";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest[])this.invoke(opName, signature, params);
    }

    public void delete(String docURI) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", docURI);
        }
        String opName = "delete";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{docURI};
        this.invoke(opName, signature, params);
    }

    public void delete(Document doc) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", doc);
        }
        String opName = "delete";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] params = new Object[]{doc};
        this.invoke(opName, signature, params);
    }

    public void delete(String[] docURIs) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", docURIs);
        }
        String opName = "delete";
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{docURIs};
        this.invoke(opName, signature, params);
    }

    public void delete(Document[] docs) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "delete()", docs);
        }
        String opName = "delete";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] params = new Object[]{docs};
        this.invoke(opName, signature, params);
    }

    public void rename(String docURI, String newDocURI) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "rename()", newDocURI);
        }
        String opName = "rename";
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{docURI, newDocURI};
        this.invoke(opName, signature, params);
    }

    public void rename(Document doc, Document newDoc) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "rename()", newDoc);
        }
        String opName = "rename";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource", "com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{doc, newDoc};
        this.invoke(opName, signature, params);
    }

    public DocumentDigest modify(DocumentContentSource contents) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "modify()");
        }
        this.fixContentForTransport(contents);
        String opName = "modify";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest)this.invoke(opName, signature, params);
    }

    public DocumentDigest[] modify(DocumentContentSource[] contents) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "modify");
        }
        for (int i = 0; i < contents.length; ++i) {
            this.fixContentForTransport(contents[i]);
        }
        String opName = "modify";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest[])this.invoke(opName, signature, params);
    }

    public HashMap update(DocumentContentSource[] create, DocumentContentSource[] modify, Document[] delete) throws RepositoryException {
        int i;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "update()");
        }
        for (i = 0; i < create.length; ++i) {
            this.fixContentForTransport(create[i]);
        }
        for (i = 0; i < modify.length; ++i) {
            this.fixContentForTransport(modify[i]);
        }
        String opName = "update";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] params = new Object[]{create, modify, delete};
        return (HashMap)this.invoke(opName, signature, params);
    }

    public Boolean lockRepository(String reason) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "lockRepository");
        }
        String opName = "lockRepository";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{reason};
        return (Boolean)this.invoke(opName, signature, params);
    }

    public Boolean unlockRepository(String reason) throws RepositoryException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "unlockRepository");
        }
        String opName = "unlockRepository";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{reason};
        return (Boolean)this.invoke(opName, signature, params);
    }

    public Properties getConfig() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " getConfig()");
        }
        return (Properties)this.configProperties.clone();
    }

    private ObjectName getRepositoryName() throws MalformedObjectNameException, ConnectorException, AdminException {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, " getRepositoryName()");
        }
        String processName = AdminServiceFactory.getAdminService().getProcessName();
        String cellName = AdminServiceFactory.getAdminService().getCellName();
        String nodeName = AdminServiceFactory.getAdminService().getNodeName();
        String query = "WebSphere:process=" + processName + ",type=" + "ConfigRepository" + ",cell=" + cellName + ",node=" + nodeName + ",*";
        ObjectName queryName = new ObjectName(query);
        Set s = this.adminService.queryNames(queryName, null);
        if (s.size() != 1) {
            throw new AdminException("There are " + s.size() + " repositories!");
        }
        Object[] o = s.toArray();
        return (ObjectName)o[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigRepositoryListener listener) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding listener: " + listener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        this.listenersUpdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigRepositoryListener listener) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "Removing listener: " + listener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public ConfigEpoch getRepositoryEpoch() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getRepositoryEpoch()");
        }
        String opName = "getRepositoryEpoch";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] params = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.getRepositoryEpoch", (String)"958", (Object)this);
            return null;
        }
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        String opName = "refreshRepositoryEpoch";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] params = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.ServantFileRepository.refreshRepositoryEpoch", (String)"971", (Object)this);
            return null;
        }
    }

    public void createDigestFile(String docURI, boolean delete) throws RepositoryException {
        String opName = "createDigestFile";
        String[] signature = new String[]{"java.lang.String", "boolean"};
        Object[] params = new Object[]{docURI, delete ? Boolean.TRUE : Boolean.FALSE};
        this.invoke(opName, signature, params);
    }

    public void handleNotification(Notification notif, Object handback) {
        Object userData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notif);
        }
        if ((userData = notif.getUserData()) != null) {
            ConfigRepositoryEvent event2 = (ConfigRepositoryEvent)userData;
            Object[] copy = this.getListenersCopy();
            if (notif.getType().equals("websphere.repository.change")) {
                for (int i = 0; i < copy.length; ++i) {
                    ConfigRepositoryListener listener = (ConfigRepositoryListener)copy[i];
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling listener onChangeCompletion: " + listener);
                        }
                        listener.onChangeCompletion(event2);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from listener onChangeCompletion: " + listener);
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.ServantFileRepository.handleNotification", (String)"1007", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, " Error occured while calling listener", t);
                    }
                }
            } else if (notif.getType().equals("websphere.repository.epoch.refresh")) {
                for (int i = 0; i < copy.length; ++i) {
                    ConfigRepositoryListener listener = (ConfigRepositoryListener)copy[i];
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling listener onRepositoryEpochRefresh: " + listener);
                        }
                        listener.onRepositoryEpochRefresh();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Back from listener onRepositoryEpochRefresh: " + listener);
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.ServantFileRepository.handleNotification", (String)"1026", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, " Error occured while calling listener", t);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object[] getListenersCopy() {
        if (this.listenersUpdated) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listenersCopy = this.listeners.toArray();
                this.listenersUpdated = false;
            }
        }
        return this.listenersCopy;
    }

    private void fixContentForTransport(DocumentContentSource dcs) throws RepositoryException {
        InputStream source;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "fixContentForTransport", dcs.getDocument().getURI());
        }
        if (!((source = dcs.getSource()) instanceof FileInputStream)) {
            try {
                File temp = new File(this.tempDir);
                String tempDocName = this.getTempDocName(dcs);
                File f = File.createTempFile(tempDocName, null, temp);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created temp file: " + f.getName());
                }
                this.writeData(source, f);
                FileUploadInputStream newSource = new FileUploadInputStream();
                newSource.setDelete(true);
                newSource.setSrcPath(f.getName());
                dcs.setSource((InputStream)newSource);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Source was replaced");
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.ServantFileRepository.fixContentForTransport", (String)"1061", ServantFileRepository.class);
                throw this.getRepositoryException(t);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "fixContentForTransport", dcs.getDocument().getURI());
        }
    }

    private String getTempDocName(DocumentContentSource dcs) {
        String uri = dcs.getDocument().getURI();
        String docName = null;
        if (uri.indexOf(47) != -1) {
            int i = uri.lastIndexOf(47);
            docName = uri.substring(i + 1);
        } else {
            docName = uri;
        }
        return "sr_" + docName;
    }

    /*
     * Loose catch block
     */
    private void writeData(InputStream in, File f) throws RepositoryException {
        block19: {
            Exception e2;
            FileOutputStream out;
            block18: {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "writeData");
                }
                out = null;
                byte[] data = new byte[4096];
                out = new FileOutputStream(f);
                int bytesRead = in.read(data);
                while (bytesRead != -1) {
                    out.write(data, 0, bytesRead);
                    bytesRead = in.read(data);
                }
                Object var7_7 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.ServantFileRepository.writeData", (String)"1092", ServantFileRepository.class);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error while closing output stream: " + e2);
                }
            }
            try {
                if (in != null) {
                    in.close();
                }
                break block19;
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.ServantFileRepository.writeData", (String)"1100", ServantFileRepository.class);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while closing input stream: " + e2);
                }
                break block19;
            }
            {
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.ServantFileRepository.writeData", (String)"1086", ServantFileRepository.class);
                    throw this.getRepositoryException(t);
                }
            }
            catch (Throwable throwable) {
                block21: {
                    block20: {
                        Object var7_8 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.ServantFileRepository.writeData", (String)"1092", ServantFileRepository.class);
                            if (!tc.isDebugEnabled()) break block20;
                            Tr.debug(tc, "Error while closing output stream: " + e2);
                        }
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.ServantFileRepository.writeData", (String)"1100", ServantFileRepository.class);
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Error while closing input stream: " + e2);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "writeData");
        }
    }

    private RepositoryException getRepositoryException(Throwable t) {
        RepositoryException e = t instanceof RepositoryException ? (RepositoryException)t : new RepositoryException(t);
        return e;
    }
}

