/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentIOException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileDownloadInputStream;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.repository.DocumentDigestImpl;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class FileDocument {
    private String repositoryRoot;
    private String repositoryTemp;
    private String repositoryBackup;
    private String downloadDir;
    private FileTransferConfig repositoryFTConfig;
    private FileTransferOptions repositoryFTOptions;
    private HashMap locks = new HashMap();
    private Integer mkdirsLock = new Integer(0);
    private static TraceComponent tc = Tr.register(FileDocument.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");
    private HashMap references = new HashMap();

    FileDocument() {
    }

    protected Object getDirLock() {
        return this.mkdirsLock;
    }

    protected void setRepository(FileRepository r) {
        this.repositoryRoot = r.getRepositoryDir();
        this.repositoryTemp = r.getTempDir();
        this.repositoryBackup = r.getBackupDir();
        this.repositoryFTOptions = r.getFileTransferOptions();
        this.repositoryFTConfig = r.getFileTransferConfig();
        this.downloadDir = this.repositoryTemp + "/download/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentDigest create(DocumentContentSource contents) throws DocumentIOException {
        DocumentDigestImpl digest = null;
        boolean locked = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating " + contents.getDocument().getURI());
        }
        try {
            try {
                this.lockForWriting(contents.getDocument().getURI());
                locked = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lock acquired");
                }
                File f = this.getFileForURI(contents.getDocument().getURI());
                Integer n = this.mkdirsLock;
                synchronized (n) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(f);
                digest = this.copyDocument(contents.getSource(), out, true);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.create", (String)"88", FileDocument.class);
                Tr.error(tc, "ADMR0100E", new Object[]{contents.getDocument().getURI(), e});
                throw this.getDocumentIOException(e, contents.getDocument().getURI());
            }
            Object var8_8 = null;
            if (locked) {
                this.unlockForWriting(contents.getDocument().getURI());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (locked) {
                this.unlockForWriting(contents.getDocument().getURI());
            }
            throw throwable;
        }
        return digest;
    }

    protected void delete(String docURI) throws DocumentIOException {
        this.delete(docURI, false);
    }

    private void delete(String docURI, boolean docOnly) throws DocumentIOException {
        boolean locked = false;
        if (!docOnly) {
            String digestURI = docURI + ".digest";
            File digestFile = this.getFileForURI(digestURI);
            try {
                try {
                    this.lockForWriting(digestURI);
                    locked = true;
                    if (digestFile.exists() && !digestFile.delete()) {
                        throw new DocumentIOException(digestURI);
                    }
                    Object var8_7 = null;
                    if (locked) {
                        this.unlockForWriting(digestURI);
                    }
                }
                catch (Throwable t) {
                    Tr.error(tc, "ADMR0111E", digestURI);
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.delete", (String)"139", FileDocument.class);
                    throw this.getDocumentIOException(t, "");
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (locked) {
                    this.unlockForWriting(digestURI);
                }
                throw throwable;
            }
        }
        File f = this.getFileForURI(docURI);
        locked = false;
        try {
            try {
                this.lockForWriting(docURI);
                locked = true;
                if (f.exists() && !f.delete()) {
                    throw new DocumentIOException(docURI);
                }
                this.deleteEmptyParents(f, this.repositoryRoot);
            }
            catch (Throwable t) {
                Tr.error(tc, "ADMR0111E", docURI);
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.delete", (String)"159", FileDocument.class);
                throw this.getDocumentIOException(t, "");
            }
            Object var10_11 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyParents(File f, String limit) {
        File parent = f.getParentFile();
        Integer n = this.mkdirsLock;
        synchronized (n) {
            if (parent.getPath().length() > limit.length() && parent.delete()) {
                this.deleteEmptyParents(parent, limit);
            }
        }
    }

    protected DocumentDigestImpl getDigest(String docURI) throws DocumentIOException {
        DocumentDigestImpl digest = null;
        File digestFile = this.getFileForURI(docURI + ".digest");
        digest = digestFile.exists() ? this.readDigest(docURI + ".digest", digestFile) : this.calcDigest(docURI);
        return digest;
    }

    protected DocumentDigestImpl calcDigest(String docURI) throws DocumentIOException {
        DocumentDigestImpl digest;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "calcDigest: " + docURI);
        }
        File f = this.getFileForURI(docURI);
        boolean locked = false;
        try {
            try {
                digest = new DocumentDigestImpl();
                this.lockForReading(docURI);
                locked = true;
                digest.calc(new FileInputStream(f));
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"146", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, ioe});
                throw new DocumentIOException(ioe, docURI);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, docURI);
            }
            Object var7_5 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
            throw throwable;
        }
        return digest;
    }

    /*
     * Loose catch block
     */
    private DocumentDigestImpl readDigest(String digestURI, File digestFile) throws DocumentIOException {
        DocumentDigestImpl digest;
        block17: {
            boolean locked;
            ObjectInputStream objIn;
            FileInputStream in;
            block14: {
                IOException e22;
                block13: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readDigest: " + digestURI);
                    }
                    digest = null;
                    in = null;
                    objIn = null;
                    locked = true;
                    this.lockForReading(digestURI);
                    locked = true;
                    in = new FileInputStream(this.repositoryRoot + File.separator + digestURI);
                    objIn = new ObjectInputStream(in);
                    digest = (DocumentDigestImpl)objIn.readObject();
                    Object var9_7 = null;
                    try {
                        objIn.close();
                    }
                    catch (IOException e22) {
                        FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Error while closing object stream: " + e22);
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e22) {
                    FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "Error while closing file input stream: " + e22);
                }
            }
            if (locked) {
                this.unlockForReading(digestURI);
            }
            break block17;
            {
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.getDigest", (String)"152", FileDocument.class);
                    Tr.error(tc, "ADMR0104E", new Object[]{digestURI, t});
                    throw this.getDocumentIOException(t, digestURI);
                }
            }
            catch (Throwable throwable) {
                block16: {
                    IOException e22;
                    block15: {
                        Object var9_8 = null;
                        try {
                            objIn.close();
                        }
                        catch (IOException e22) {
                            FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"214", null);
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Error while closing object stream: " + e22);
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.readDigest", (String)"223", null);
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Error while closing file input stream: " + e22);
                    }
                }
                if (locked) {
                    this.unlockForReading(digestURI);
                }
                throw throwable;
            }
        }
        return digest;
    }

    protected DocumentDigestImpl write(DocumentContentSource contents) throws DocumentIOException {
        DocumentDigestImpl digest = null;
        String docURI = contents.getDocument().getURI();
        boolean locked = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writing " + docURI);
        }
        try {
            try {
                File f = this.getFileForURI(docURI);
                this.lockForWriting(docURI);
                locked = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lock acquired");
                }
                FileOutputStream out = new FileOutputStream(f);
                digest = this.copyDocument(contents.getSource(), out, true);
                long lastModified = contents.getLastModified();
                if (lastModified > 0L && !AdminHelper.getPlatformHelper().isZOS()) {
                    f.setLastModified(lastModified);
                }
                this.writeDigest(docURI, digest);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.write", (String)"175", FileDocument.class);
                Tr.error(tc, "ADMR0105E", new Object[]{contents.getDocument().getURI(), e});
                throw this.getDocumentIOException(e, contents.getDocument().getURI());
            }
            Object var10_9 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
            throw throwable;
        }
        return digest;
    }

    protected void backup(String docURI) throws DocumentIOException {
        String digestURI;
        File digestFile;
        boolean found = false;
        File docFile = this.getFileForURI(docURI);
        if (docFile.exists()) {
            this.backup(docURI, docFile);
            found = true;
        }
        if ((digestFile = this.getFileForURI(digestURI = docURI + ".digest")).exists()) {
            this.backup(digestURI, digestFile);
            found = true;
        }
        if (!found) {
            DocumentIOException e = new DocumentIOException("Document does not exist: " + docURI);
            Tr.error(tc, "ADMR0108E", new Object[]{docURI, e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backup(String docURI, File docFile) throws DocumentIOException {
        boolean locked = false;
        try {
            try {
                File backupFile = new File(this.repositoryBackup + File.separator + docURI);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "backupFile: " + backupFile.getPath());
                }
                Integer n = this.mkdirsLock;
                synchronized (n) {
                    backupFile.getParentFile().mkdirs();
                    this.lockForReading(docURI);
                    locked = true;
                    this.copyDocument(new FileInputStream(docFile), new FileOutputStream(backupFile), false);
                }
                backupFile.setLastModified(docFile.lastModified());
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.backup", (String)"211", FileDocument.class);
                Tr.error(tc, "ADMR0108E", new Object[]{docURI, e});
                throw new DocumentIOException(e, "Unable to backup document: " + docURI);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.backup", (String)"212", FileDocument.class);
                Tr.error(tc, "ADMR0108E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, "Unable to backup document: " + docURI);
            }
            Object var8_9 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
            throw throwable;
        }
    }

    protected void removeBackup(String docURI) {
        File backupFile = new File(this.repositoryBackup + File.separator + docURI);
        if (!backupFile.delete() && backupFile.exists()) {
            Tr.warning(tc, "ADMR0110W", new Object[]{docURI, ""});
        }
        if ((backupFile = new File(this.repositoryBackup + File.separator + docURI + ".digest")).exists() && !backupFile.delete()) {
            Tr.warning(tc, "ADMR0110W", new Object[]{docURI + ".digest", ""});
        }
        this.deleteEmptyParents(backupFile, this.repositoryBackup);
    }

    protected void restore(String docURI) throws DocumentIOException {
        boolean found = false;
        File backupFile = new File(this.repositoryBackup + File.separator + docURI);
        if (backupFile.exists()) {
            this.restore(docURI, backupFile);
            found = true;
        }
        String digestURI = docURI + ".digest";
        backupFile = new File(this.repositoryBackup + File.separator + digestURI);
        if (backupFile.exists()) {
            this.restore(digestURI, backupFile);
            found = true;
        }
        if (!found) {
            DocumentIOException e = new DocumentIOException("Document backup does not exist: " + docURI);
            Tr.error(tc, "ADMR0109E", new Object[]{docURI, e});
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(String docURI, File backupFile) throws DocumentIOException {
        boolean locked = false;
        try {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "restoring " + docURI);
                }
                File docFile = this.getFileForURI(docURI);
                this.lockForWriting(docURI);
                locked = true;
                FileOutputStream out = null;
                if (!docFile.getParentFile().exists()) {
                    Integer n = this.mkdirsLock;
                    synchronized (n) {
                        docFile.getParentFile().mkdirs();
                        out = new FileOutputStream(docFile);
                    }
                } else {
                    out = new FileOutputStream(docFile);
                }
                this.copyDocument(new FileInputStream(backupFile), out, false);
                docFile.setLastModified(backupFile.lastModified());
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.restore", (String)"428", FileDocument.class);
                Tr.error(tc, "ADMR0109E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, "Unable to restore document from backup: " + docURI);
            }
            Object var9_9 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (locked) {
                this.unlockForWriting(docURI);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private DocumentDigestImpl copyDocument(InputStream from, OutputStream to, boolean getDigest) throws IOException {
        DocumentDigestImpl digest;
        block18: {
            Exception e2;
            block17: {
                block16: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "copyDocument");
                    }
                    InputStream fromFilter = null;
                    digest = null;
                    if (getDigest) {
                        digest = new DocumentDigestImpl();
                        fromFilter = digest.startInputFilter(from);
                    } else {
                        fromFilter = from;
                    }
                    byte[] data = new byte[4096];
                    int bytesRead = fromFilter.read(data);
                    while (bytesRead != -1) {
                        to.write(data, 0, bytesRead);
                        bytesRead = fromFilter.read(data);
                    }
                    if (!getDigest) break block16;
                    digest.stopInputFilter();
                }
                Object var9_9 = null;
                try {
                    to.close();
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "Error while closing to stream: " + e2);
                }
            }
            try {
                from.close();
            }
            catch (Exception e2) {
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error while closing from stream: " + e2);
                }
                break block18;
            }
            {
                catch (IOException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"851", FileDocument.class);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                block20: {
                    block19: {
                        Object var9_10 = null;
                        try {
                            to.close();
                        }
                        catch (Exception e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug(tc, "Error while closing to stream: " + e2);
                        }
                    }
                    try {
                        from.close();
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.management.repository.FileDocument.copyDocument", (String)"866", null);
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "Error while closing from stream: " + e2);
                    }
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDocument");
        }
        return digest;
    }

    protected DocumentContentSource read(String docURI) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reading " + docURI);
        }
        FileInputStream data = null;
        FileOutputStream out = null;
        FileDownloadInputStream source = null;
        DocumentDigestImpl digest = null;
        File documentFile = this.getFileForURI(docURI);
        File tempFile = this.createTempFile(docURI);
        try {
            data = new FileInputStream(documentFile);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"351", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
            throw new DocumentIOException(e, "Unable to create input stream on document file: " + docURI);
        }
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"363", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
            throw new DocumentIOException(e, "Unable to create output stream on temp file: " + tempFile.getPath());
        }
        long lastModified = 0L;
        boolean locked = false;
        try {
            try {
                this.lockForReading(docURI);
                locked = true;
                digest = this.copyDocument(data, out, true);
                lastModified = documentFile.lastModified();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.read", (String)"375", FileDocument.class);
                Tr.error(tc, "ADMR0104E", new Object[]{docURI, e});
                throw this.getDocumentIOException(e, "Unable to copy document to temp file: " + docURI);
            }
            Object var13_12 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (locked) {
                this.unlockForReading(docURI);
            }
            throw throwable;
        }
        source = new FileDownloadInputStream(tempFile);
        source.setFileTransferConfig(this.repositoryFTConfig);
        source.setOptions(this.repositoryFTOptions);
        source.setSrcPath(tempFile.getAbsolutePath().substring(this.repositoryTemp.length()));
        Document doc = new Document(docURI, (DocumentDigest)digest);
        DocumentContentSource dcs = new DocumentContentSource(doc, (InputStream)source);
        dcs.setLastModified(lastModified);
        return dcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(String docURI) throws DocumentIOException {
        File baseFile = new File(this.downloadDir + docURI);
        String tempFileName = baseFile.getName().replace('%', '_');
        if (tempFileName.length() < 3) {
            tempFileName = new String(tempFileName + "__");
        }
        File tempFileDir = baseFile.getParentFile();
        File tempFile = null;
        try {
            Integer n = this.mkdirsLock;
            synchronized (n) {
                tempFileDir.mkdirs();
                tempFile = File.createTempFile(tempFileName, null, tempFileDir);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.management.repository.FileDocument.createTempFile", (String)"404", FileDocument.class);
            Tr.error(tc, "ADMR0104E", new Object[]{docURI, t});
            throw new DocumentIOException(t, "Unable to create temp file for document: " + docURI);
        }
        return tempFile;
    }

    private void lockForReading(String docURI) throws DocumentIOException {
        try {
            this.getLock(docURI, true).startReading();
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.lockForWriting", (String)"640", FileDocument.class);
            throw new DocumentIOException(e, "Unable to get read lock for document " + docURI);
        }
    }

    private void unlockForReading(String docURI) {
        WriterPriorityReadersWriterLock lock = this.getLock(docURI, false);
        lock.stopReading();
        this.releaseLock(docURI, lock);
    }

    private void lockForWriting(String docURI) throws DocumentIOException {
        try {
            this.getLock(docURI, true).startWriting();
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.lockForWriting", (String)"640", FileDocument.class);
            throw new DocumentIOException(e, "Unable to get write lock for document " + docURI);
        }
    }

    private void unlockForWriting(String docURI) {
        WriterPriorityReadersWriterLock lock = this.getLock(docURI, false);
        lock.stopWriting();
        this.releaseLock(docURI, lock);
    }

    private synchronized WriterPriorityReadersWriterLock getLock(String docURI) {
        WriterPriorityReadersWriterLock lock = (WriterPriorityReadersWriterLock)this.locks.get(docURI);
        if (lock == null) {
            lock = new WriterPriorityReadersWriterLock();
            this.locks.put(docURI, lock);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New lock is " + lock);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Lock already exists " + lock);
        }
        return lock;
    }

    private synchronized WriterPriorityReadersWriterLock getLock(String docURI, boolean toLock) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLock " + toLock);
        }
        WriterPriorityReadersWriterLock lock = this.getLock(docURI);
        if (toLock) {
            Object obj = this.references.get(lock);
            if (obj == null) {
                this.references.put(lock, new Integer(1));
            } else {
                int c = (Integer)obj;
                this.references.put(lock, new Integer(++c));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLock " + toLock);
        }
        return lock;
    }

    private synchronized void releaseLock(String docURI, WriterPriorityReadersWriterLock lock) {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseLock ");
        }
        if ((obj = this.references.get(lock)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is a bug " + lock);
            }
            return;
        }
        int c = (Integer)obj;
        --c;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "reference count " + c);
        }
        if (c == 0) {
            this.references.remove(lock);
            this.locks.remove(docURI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lock removed " + lock);
            }
        } else {
            this.references.put(lock, new Integer(c));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLock ");
        }
    }

    protected void createDigestFile(String docURI, boolean deleteDoc) throws DocumentIOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating digest file for " + docURI + "; deleteDoc = " + deleteDoc);
        }
        DocumentDigestImpl digest = this.getDigest(docURI);
        File digestFile = this.getFileForURI(docURI + ".digest");
        try {
            digestFile.createNewFile();
            this.writeDigest(docURI, digest);
            if (deleteDoc) {
                this.delete(docURI, true);
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.createDigestFile", (String)"524", FileDocument.class);
            throw new DocumentIOException(e, "Unable to create digest file for document " + docURI);
        }
    }

    /*
     * Loose catch block
     */
    protected void writeDigest(String docURI, DocumentDigestImpl digest) throws DocumentIOException {
        block18: {
            String digestURI = docURI + ".digest";
            File digestFile = this.getFileForURI(digestURI);
            if (digestFile.exists()) {
                boolean locked;
                ObjectOutputStream objOut;
                FileOutputStream out;
                block15: {
                    IOException e22;
                    block14: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Updating digest file for " + docURI);
                        }
                        out = null;
                        objOut = null;
                        locked = false;
                        this.lockForWriting(digestURI);
                        locked = true;
                        out = new FileOutputStream(digestFile);
                        objOut = new ObjectOutputStream(out);
                        objOut.writeObject(digest);
                        Object var10_8 = null;
                        try {
                            objOut.close();
                        }
                        catch (IOException e22) {
                            FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"605", null);
                            if (!tc.isDebugEnabled()) break block14;
                            Tr.debug(tc, "Error while closing object stream: " + e22);
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e22) {
                        FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"615", null);
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "Error while closing file output stream: " + e22);
                    }
                }
                if (locked) {
                    this.unlockForWriting(digestURI);
                }
                break block18;
                {
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"478", FileDocument.class);
                        throw this.getDocumentIOException(e, "Unable to write digest file for document " + docURI);
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        IOException e22;
                        block16: {
                            Object var10_9 = null;
                            try {
                                objOut.close();
                            }
                            catch (IOException e22) {
                                FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"605", null);
                                if (!tc.isDebugEnabled()) break block16;
                                Tr.debug(tc, "Error while closing object stream: " + e22);
                            }
                        }
                        try {
                            out.close();
                        }
                        catch (IOException e22) {
                            FFDCFilter.processException((Throwable)e22, (String)"com.ibm.ws.management.repository.FileDocument.writeDigest", (String)"615", null);
                            if (!tc.isDebugEnabled()) break block17;
                            Tr.debug(tc, "Error while closing file output stream: " + e22);
                        }
                    }
                    if (locked) {
                        this.unlockForWriting(digestURI);
                    }
                    throw throwable;
                }
            }
        }
    }

    private File getFileForURI(String uri) {
        return new File(this.repositoryRoot + File.separator + uri);
    }

    private DocumentIOException getDocumentIOException(Throwable t, String msg) {
        if (t instanceof DocumentIOException) {
            return (DocumentIOException)t;
        }
        return new DocumentIOException(t, msg);
    }
}

